package com.instabug.chat.annotation.recognition;

import android.graphics.Path;

import androidx.annotation.Nullable;

/**
 * Created by Tarek360 on 12/29/16.
 */

public class PathRecognizer {

    private final static float NONE_THRESHOLD = 0.5f;

    public Recognition recognize(Path path) {

        Recognition recognition = new Recognition();

        PathMatcher pathMatcher = new PathMatcher(path);
        Weight weightOval = pathMatcher.getFineWeightRect(ShapeSpecs.Type.OVAL);
        Weight weightArrow = pathMatcher.getFineWeightArrow();

        Weight weightRect = pathMatcher.getFineWeightRect(ShapeSpecs.Type.RECT);

        if (weightArrow.probability > weightRect.probability
                && weightArrow.probability > weightOval.probability) {
            if (weightArrow.pathNotConsumedPercent > NONE_THRESHOLD
                    || weightArrow.originalPathNotConsumedPercent > NONE_THRESHOLD) {
                recognition.shapeType = ShapeSpecs.Type.NONE;
            } else {
                if (weightArrow.pathLength < 100) {
                    if (Math.abs(weightArrow.topWeight - weightArrow.bottomWeight) < 10 &&
                            Math.abs(weightArrow.rightWeight - weightArrow.leftWeight) < 10) {
                        recognition.shapeType = ShapeSpecs.Type.LINE;
                    } else {
                        recognition.shapeType = ShapeSpecs.Type.ARROW;
                    }
                    recognition.angle = weightArrow.angle;
                } else {
                    recognition.shapeType = ShapeSpecs.Type.NONE;
                }

            }
        } else {
            if (weightRect.probability > weightOval.probability) {
                if (weightRect.pathNotConsumedPercent > NONE_THRESHOLD
                        || weightRect.originalPathNotConsumedPercent > NONE_THRESHOLD) {
                    recognition.shapeType = ShapeSpecs.Type.NONE;
                } else {
                    recognition.shapeType = ShapeSpecs.Type.RECT;
                    recognition.angle = weightRect.angle;
                    recognition.paddingPercent = weightRect.rectPaddingPercent;
                }
            } else {
                if (weightOval.pathNotConsumedPercent > NONE_THRESHOLD
                        || weightOval.originalPathNotConsumedPercent > NONE_THRESHOLD) {
                    recognition.shapeType = ShapeSpecs.Type.NONE;
                } else {
                    recognition.shapeType = ShapeSpecs.Type.OVAL;
                    recognition.angle = weightOval.angle;
                    recognition.paddingPercent = weightOval.rectPaddingPercent;
                }
            }
        }

        return recognition;
    }

    public static class Recognition {
        @Nullable
        public ShapeSpecs.Type shapeType;
        public int angle;
        public float paddingPercent;
    }
}
