package com.instabug.bug.utils;

import androidx.annotation.NonNull;

import com.instabug.library.Instabug;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtils {
    public static boolean isValidUSPhoneNumber(@NonNull String number) {
        if (number == null) return false;
        String regex = "^[+]*([0-1]{0,3}\\s?)?([0-9]{1}[\\s\\-])?((\\([0-9]{3}\\))|[0-9]{3})[\\s\\-]?[0-9]{3}[\\s\\-]?[0-9]{4}$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(number.trim());
        return matcher.matches();
    }

    public static String reformatMarkdownText(String textToReformat, String replacement) {
        String regex = "\\[([^\\]]+)\\]\\((https?[^\\]]+)\\)";
        return textToReformat.replaceAll(regex, replacement);
    }
}
