package com.instabug.bug;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;

import androidx.annotation.Nullable;

import com.instabug.bug.view.reporting.ReportingContainerActivity;

import static android.content.Intent.FLAG_ACTIVITY_NEW_TASK;
import static com.instabug.bug.Constants.EXTRA_BITMAP_URI;
import static com.instabug.bug.Constants.EXTRA_PROCESS;
import static com.instabug.bug.Constants.ReportingProcess.PROCESS_ASK_QUESTION;
import static com.instabug.bug.Constants.ReportingProcess.PROCESS_BUG;
import static com.instabug.bug.Constants.ReportingProcess.PROCESS_FEEDBACK;
import static com.instabug.bug.Constants.ReportingProcess.PROCESS_FRUSTRATING_EXPERIENCE;
import static com.instabug.bug.Constants.ReportingProcess.PROCESS_HANGING_BUG;


/**
 * Created by mNagy on 4/26/16.
 */
public class ReportingActivityLauncher {

    public static Intent newBugProcessIntent(Context context) {
        Intent intent = new Intent(context, ReportingContainerActivity.class);
        intent.putExtra(EXTRA_PROCESS, PROCESS_BUG);
        intent.setFlags(FLAG_ACTIVITY_NEW_TASK);
        intent.addFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION);
        return intent;
    }


    public static Intent newFeedbackProcessIntent(Context context) {
        Intent intent = new Intent(context, ReportingContainerActivity.class);
        intent.putExtra(EXTRA_PROCESS, PROCESS_FEEDBACK);
        intent.setFlags(FLAG_ACTIVITY_NEW_TASK);
        intent.addFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION);
        return intent;
    }

    public static Intent newAskAQuestionIntent(Context context) {
        Intent intent = new Intent(context, ReportingContainerActivity.class);
        intent.putExtra(EXTRA_PROCESS, PROCESS_ASK_QUESTION);
        intent.setFlags(FLAG_ACTIVITY_NEW_TASK);
        intent.addFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION);
        return intent;
    }

    public static Intent newFrustratingExperienceIntent(Context context) {
        Intent intent = new Intent(context, ReportingContainerActivity.class);
        intent.putExtra(EXTRA_PROCESS, PROCESS_FRUSTRATING_EXPERIENCE);
        intent.setFlags(FLAG_ACTIVITY_NEW_TASK);
        intent.addFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION);
        return intent;
    }

    public static Intent newHangingBugIntent(Context context) {
        Intent intent = new Intent(context, ReportingContainerActivity.class);
        intent.putExtra(EXTRA_PROCESS, PROCESS_HANGING_BUG);
        intent.addFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        return intent;
    }

    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public static Intent newHangingBugIntent(Context context, @Nullable Uri bitmapUri) {
        Intent intent = newHangingBugIntent(context);
        intent.putExtra(EXTRA_BITMAP_URI, bitmapUri);
        return intent;
    }
}
