package com.instabug.bug

import java.util.concurrent.TimeUnit

class ProactiveReportingConfigs private constructor(
    private val enabled: Boolean,
    private val detectionGap: Long,
    private val modalsGap: Long
) {

    fun isEnabled() = enabled

    fun getDetectionGap() = detectionGap

    fun getModalsGap() = modalsGap

    /**
     * Builds a [ProactiveReportingConfigs] object with the following parameters
     * [enabled] controls the state of the feature
     * [detectionGap] controls the time gap between detecting a frustrating experience and showing the proactive reporting dialog in seconds
     * [modalsGap] controls the time gap between showing 2 proactive reporting dialogs in seconds
     **/
    class Builder {

        private var enabled: Boolean = false
        private var detectionGap: Long = 0
        private var modalsGap: Long = 0

        fun isEnabled(enabled: Boolean): Builder {
            this.enabled = enabled
            return this
        }

        fun setGapBetweenModals(modalsGap: Long): Builder {
            this.modalsGap = modalsGap;
            return this
        }

        fun setModalDelayAfterDetection(detectionGap: Long): Builder {
            this.detectionGap = detectionGap
            return this
        }

        fun build() = ProactiveReportingConfigs(enabled, detectionGap, modalsGap)
    }
}