package com.instabug.chat.util;

import android.annotation.SuppressLint;
import android.content.Context;

import com.instabug.library.Instabug;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.util.InstabugAppData;
import com.instabug.library.util.PlaceHolderUtils;

public final class PlaceHolderResolver {

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    public static String getTeamTitleResolved() {
        Context context = Instabug.getApplicationContext();
        String fallback = context == null ? "" : String.format(
                context.getString(com.instabug.library.R.string.instabug_str_notification_title),
                new InstabugAppData(context).getAppName());
        return PlaceHolderUtils.getPlaceHolder(
                InstabugCustomTextPlaceHolder.Key.CHATS_TEAM_STRING_NAME, fallback);
    }
}
