package com.instabug.chat.annotation.shape;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;

import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;

import com.instabug.chat.annotation.ControlButton;
import com.instabug.chat.annotation.DirectionRectF;

import java.io.Serializable;

/**
 * Created by Tarek360 on 11/24/16.
 */

public abstract class Shape implements Serializable {

    @NonNull
    protected final transient Paint borderPaint;
    @NonNull
    protected final transient Paint paint;
    private boolean recognized = false;

    @SuppressLint("ERADICATE_INCONSISTENT_SUBCLASS_PARAMETER_ANNOTATION")
    Shape(@ColorInt int color, float strokeWidth) {
        paint = new Paint(Paint.ANTI_ALIAS_FLAG);
        paint.setColor(color);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(strokeWidth);
        paint.setStrokeCap(Paint.Cap.ROUND);

        borderPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        borderPaint.setColor(0X80000000);
    }

    public float getStrokeWidth() {
        return paint.getStrokeWidth();
    }

    public abstract void draw(Canvas canvas, DirectionRectF bounds, DirectionRectF lastBounds);

    public abstract boolean isTouched(PointF touchedPoint, DirectionRectF bounds);

    public abstract void adjustBounds(DirectionRectF newBounds, DirectionRectF bounds,
                                      boolean isUndo);

    public void drawControlButtons(Canvas canvas, DirectionRectF bounds,
                                   ControlButton[] controlButtons) {
        int color = paint.getColor();

        PointF[] controlPoints = bounds.getCornersPoints();
        for (int i = 0; i < controlButtons.length; i++) {
            controlButtons[i].setCenterPoint(controlPoints[i]);
            controlButtons[i].setColor(color);
            controlButtons[i].draw(canvas);
        }
    }

    public abstract void drawBorder(Canvas canvas, PointF topLeftPoint, PointF topRightPoint,
                                    PointF bottomRightPoint, PointF bottomLeftPoint);

    public void setColor(@ColorInt int color) {
        paint.setColor(color);
    }

    public abstract void translateBy(DirectionRectF newBounds, DirectionRectF bounds, int dx, int dy);

    public abstract Path getPath(DirectionRectF bounds);

    public boolean isRecognized() {
        return recognized;
    }

    public void setRecognized(boolean recognized) {
        this.recognized = recognized;
    }
}
