package com.instabug.bug.view.reporting;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Spanned;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.fragment.app.Fragment;

import com.instabug.bug.userConsent.UserConsent;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.model.Attachment;

import java.util.List;

/**
 * @author Hossam
 */

public interface IBaseReportingView {

    interface View extends BaseContract.View<Fragment> {

        Context getContext();

        Activity getActivity();

        void showToast(CharSequence text);

        void showToast(@StringRes int resId);

        void setAttachments(List<Attachment> attachments);

        boolean isVideoProgressBarVisible();

        boolean isVideoPlayImageViewVisible();

        void setVideoProgressBarVisibility(boolean visibility);

        void setVideoPlayImageViewVisibility(boolean visibility);

        boolean isVideoPlayButtonClicked();

        void openActivityForResult(Intent intent, int requestCode);

        void notifyFragmentVisibilityChanged(boolean isVisible);

        void startVideo(Attachment attachment);

        void navigateToSuccessFragment();

        void navigateToExtraFieldsFragment();

        void startGalleryPicker();

        void showPreparingDialog();

        void showMediaFileSizeAlert();

        void showVideoLengthAlert();

        void dismissPreparingDialog();

        void notifyAttachmentRemoved(Attachment attachment);

        void showEmailError(String message);

        void showCommentError(String message);

        String getEnteredEmail();

        void setEnteredEmail(String enteredEmail);

        void showVisualUserStepDisclaimer(Spanned disclaimer, String body);

        void hideVisualUserStepDisclaimer();

        void showInstabugDisclaimer(Spanned spanned);

        void hideInstabugDisclaimer();

        void requestMediaProjectionPermission();

        String provideDefaultHintMessage();

        String provideDefaultTitle();

        String getLocalizedString(@StringRes int resourceId);

        void showUserConsents(List<UserConsent> consents);
    }

    interface Presenter extends BaseContract.Presenter {

        void onStart();

        void onStop();

        void onSaveInstanceState(Bundle state);

        void onRestoreInstanceState(@Nullable Bundle state);

        void onEmailChanged(String email);

        void onMessageChanged(String message);

        void refreshAttachments();

        void openVideoRecorder();

        void takeScreenshot();

        void pickPhotoFromGallery();

        void removeAttachment(@NonNull Attachment fileToRemove);

        void onSendClicked();

        @Nullable
        Attachment getLastVideoAttachment(List<Attachment> attachments);

        void updateLastVideoAttachment(List<Attachment> attachments, String videoFilePath);

        void onActivityResult(int requestCode, int resultCode, Intent data);

        void notifyAttachmentRemoved(Attachment fileToRemove);

        void handleVisualUserStepsDisclaimer(String body, String link);

        void handleInstabugDisclaimer();

        String getTitle();

        String getMessageHint();

        boolean hasExtendedReport();

        boolean isAttachmentBeingRemoved(Attachment attachment);

        boolean hasValidConsents();

        boolean shouldShowScreenRecording();

        boolean shouldShowExtraScreenshot();
    }
}
