package com.instabug.bug.view.disclaimer;

import android.content.Context;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;

import com.instabug.bug.view.BugReportingActivityCallback;
import com.instabug.bug.R;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.util.SystemServiceUtils;

import androidx.annotation.Nullable;

/**
 * Created by tarek on 8/10/17.
 */

public class DisclaimerFragment extends InstabugBaseFragment {

    @Nullable
    BugReportingActivityCallback activityCallback;
    @Nullable
    DisclaimerListAdapter disclaimerListAdapter;
    @Nullable
    ListView listView;
    @Nullable
    Callbacks listener;
    CharSequence currentTitle = "";

    public static final String TAG = "disclaimer";

    public static DisclaimerFragment newInstance() {
        return new DisclaimerFragment();
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (getActivity() instanceof BugReportingActivityCallback) {
            try {
                listener = (Callbacks) context;
                activityCallback = (BugReportingActivityCallback) getContext();
            } catch (ClassCastException e) {
                throw new ClassCastException(context.toString()
                        + " must implement DisclaimerFragment.Callbacks");
            }
        }
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);
    }

    @Override
    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        menu.clear();
        super.onCreateOptionsMenu(menu, inflater);
    }

    @Override
    public void onDetach() {
        super.onDetach();
        activityCallback = null;
    }

    private void openDisclaimerDetails(Disclaimer disclaimer) {
        if (listener != null)
            listener.openDisclaimerDetails(disclaimer);
    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_lyt_disclaimer;
    }

    @Override
    protected void initViews(View rootView, @Nullable Bundle savedInstanceState) {
        if (getActivity() != null) {
            SystemServiceUtils.hideInputMethod(getActivity());
        }

        if (getContext() != null) {
            disclaimerListAdapter = new DisclaimerListAdapter(getContext(), DisclaimerHelper.getDisclaimers());
        }

        listView = (ListView) findViewById(R.id.instabug_disclaimer_list);
        if (listView != null && disclaimerListAdapter != null) {
            listView.setAdapter(disclaimerListAdapter);
            listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                @Override
                public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                    if (disclaimerListAdapter != null) {
                        Disclaimer disclaimer = disclaimerListAdapter.getItem(position);
                        if (disclaimer.isLog()) {
                            openDisclaimerDetails(disclaimer);
                        }
                    }
                }
            });
        }


        if (activityCallback != null) {
            currentTitle = activityCallback.getToolbarTitle();
            activityCallback.setToolbarTitle(getLocalizedString(R.string.ib_str_report_data));
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (activityCallback != null) {
            activityCallback.setToolbarTitle(String.valueOf(currentTitle));
        }
    }

    public interface Callbacks {
        void openDisclaimerDetails(Disclaimer disclaimer);
    }
}
