package com.instabug.bug.view.disclaimer;

import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.instabug.bug.R;
import com.instabug.library.core.ui.InstabugBaseFragment;

/**
 * Created by tarek on 8/10/17.
 */

public class DisclaimerDetailsFragment extends InstabugBaseFragment {

    private final static String KEY_DISCLAIMER = "disclaimer";
    public static final String TAG = "disclaimer_details";
    @Nullable
    Disclaimer disclaimer;
    @Nullable
    TextView disclaimerDetails;

    public static DisclaimerDetailsFragment newInstance(Disclaimer disclaimer) {
        Bundle bundle = new Bundle();
        bundle.putSerializable(KEY_DISCLAIMER, disclaimer);
        DisclaimerDetailsFragment fragment = new DisclaimerDetailsFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_lyt_disclaimer_details;
    }

    @Override
    protected void initViews(View rootView, @Nullable Bundle savedInstanceState) {
        disclaimerDetails = (TextView) findViewById(R.id.instabug_disclaimer_details);
        if (getArguments() != null) {
            disclaimer = (Disclaimer) getArguments().getSerializable(KEY_DISCLAIMER);
            if (disclaimer != null && disclaimerDetails != null) {
                disclaimerDetails.setText(String.valueOf(disclaimer.getValue()));
            }
        }
    }
}
