/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.ui.chat;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.instabug.bug.R;
import com.instabug.chat.model.FlatMessage;
import com.instabug.chat.model.MessageAction;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.media.AudioPlayer;
import com.instabug.library.internal.storage.cache.AssetsCacheManager;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.ui.custom.CircularImageView;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.OnVideoFrameReady;
import com.instabug.library.util.ThemeApplier;
import com.instabug.library.util.VideoManipulationUtils;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.view.ViewUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MessagesListAdapter
extends BaseAdapter {
    private final AudioPlayer audioPlayer;
    private List<FlatMessage> flatMessages;
    private ColorFilter colorFilter;
    private Context context;
    private ListView listView;
    private OnMessageItemClickListener listener;
    private boolean isFirstImage = true;
    @Nullable
    private final IBGTheme ibgTheme;

    public MessagesListAdapter(List<FlatMessage> list, Context context, ListView listView, OnMessageItemClickListener onMessageItemClickListener, @Nullable IBGTheme iBGTheme) {
        PorterDuffColorFilter porterDuffColorFilter;
        AudioPlayer audioPlayer;
        messagesListAdapter.flatMessages = list;
        messagesListAdapter.listView = listView;
        messagesListAdapter.context = context;
        messagesListAdapter.listener = onMessageItemClickListener;
        messagesListAdapter.ibgTheme = iBGTheme;
        MessagesListAdapter messagesListAdapter = audioPlayer;
        audioPlayer = new AudioPlayer();
        v1.audioPlayer = messagesListAdapter;
        messagesListAdapter = porterDuffColorFilter;
        porterDuffColorFilter = new PorterDuffColorFilter(InstabugCore.getPrimaryColor(), PorterDuff.Mode.SRC_IN);
        v1.colorFilter = messagesListAdapter;
    }

    private static int getLayoutId(int n) {
        int n2;
        switch (n) {
            default: {
                n2 = R.layout.instabug_message_list_item_me;
                break;
            }
            case 7: {
                n2 = R.layout.instabug_message_list_item_video;
                break;
            }
            case 6: {
                n2 = R.layout.instabug_message_list_item_video_me;
                break;
            }
            case 5: {
                n2 = R.layout.instabug_message_list_item_voice;
                break;
            }
            case 4: {
                n2 = R.layout.instabug_message_list_item_voice_me;
                break;
            }
            case 3: {
                n2 = R.layout.instabug_message_list_item_img;
                break;
            }
            case 2: {
                n2 = R.layout.instabug_message_list_item_img_me;
                break;
            }
            case 1: {
                n2 = R.layout.instabug_message_list_item;
                break;
            }
            case 0: {
                n2 = R.layout.instabug_message_list_item_me;
            }
        }
        return n2;
    }

    private void bind(ViewHolder viewHolder, FlatMessage flatMessage) {
        if (viewHolder == null) {
            return;
        }
        if (flatMessage.getType() != null) {
            switch (7.$SwitchMap$com$instabug$chat$model$FlatMessage$Type[flatMessage.getType().ordinal()]) {
                default: {
                    break;
                }
                case 4: {
                    this.renderVideoItem(viewHolder, flatMessage);
                    break;
                }
                case 3: {
                    this.renderAudioItem(viewHolder, flatMessage);
                    break;
                }
                case 2: {
                    this.renderImageItem(viewHolder, flatMessage);
                    break;
                }
                case 1: {
                    this.renderMessageItem(viewHolder, flatMessage);
                }
            }
        }
        ThemeApplier.applySecondaryTextStyle((TextView)viewHolder.messageTimeTextView, (IBGTheme)this.ibgTheme);
    }

    private void renderMessageItem(ViewHolder viewHolder, FlatMessage object) {
        TextView textView;
        if (((FlatMessage)object).isInbound()) {
            textView = viewHolder.messageSnippetTextView;
            if (textView != null) {
                ThemeApplier.setViewBackground((View)textView, (Drawable)this.getInboundBubbleDrawable((View)textView));
            }
        } else {
            textView = viewHolder.messageActionContainer;
            if (textView != null) {
                textView.removeAllViews();
            }
            if (((FlatMessage)object).hasActions()) {
                this.bindMessageActions((FlatMessage)object, viewHolder);
            }
        }
        if ((textView = viewHolder.messageTimeTextView) != null) {
            textView.setText((CharSequence)InstabugDateFormatter.formatMessageDate((Context)this.context, (long)((FlatMessage)object).getMessagedAt()));
        }
        if (((FlatMessage)object).getBody() != null && (textView = viewHolder.messageSnippetTextView) != null) {
            textView.setText((CharSequence)((FlatMessage)object).getBody());
        }
        if (viewHolder.senderImageView != null && ((FlatMessage)object).getSenderAvatarUrl() != null) {
            object = ((FlatMessage)object).getSenderAvatarUrl();
            this.loadImage((String)object, (ImageView)viewHolder.senderImageView, false);
        }
        ThemeApplier.applyPrimaryTextStyle((TextView)viewHolder.messageSnippetTextView, (IBGTheme)this.ibgTheme);
    }

    private Drawable getInboundBubbleDrawable(View view) {
        return Colorizer.getTintedDrawable((int)InstabugCore.getPrimaryColor(), (Drawable)view.getBackground());
    }

    private void renderImageItem(ViewHolder viewHolder, FlatMessage flatMessage) {
        ImageView imageView;
        if (flatMessage.isInbound() && (imageView = viewHolder.messageImageView) != null) {
            ThemeApplier.setViewBackground((View)imageView, (Drawable)object.getInboundBubbleDrawable((View)imageView));
        }
        if ((imageView = viewHolder.messageTimeTextView) != null) {
            imageView.setText((CharSequence)InstabugDateFormatter.formatMessageDate((Context)object.context, (long)flatMessage.getMessagedAt()));
        }
        object.bindImageAttachments(flatMessage, viewHolder);
        if (viewHolder.senderImageView != null && flatMessage.getSenderAvatarUrl() != null) {
            MessagesListAdapter messagesListAdapter = object;
            Object object = flatMessage.getSenderAvatarUrl();
            messagesListAdapter.loadImage((String)object, (ImageView)viewHolder.senderImageView, false);
        }
    }

    private void renderAudioItem(ViewHolder viewHolder, FlatMessage flatMessage) {
        FrameLayout frameLayout;
        if (flatMessage.isInbound()) {
            frameLayout = viewHolder.messageAudioAttachmentBackground;
            if (frameLayout != null) {
                ThemeApplier.setViewBackground((View)frameLayout, (Drawable)object.getInboundBubbleDrawable((View)frameLayout));
            }
            if ((frameLayout = viewHolder.messageAudioPlayImageView) != null) {
                frameLayout.setColorFilter(object.colorFilter);
            }
        }
        if ((frameLayout = viewHolder.messageTimeTextView) != null) {
            frameLayout.setText((CharSequence)InstabugDateFormatter.formatMessageDate((Context)object.context, (long)flatMessage.getMessagedAt()));
        }
        object.bindVoiceAttachments(flatMessage, viewHolder);
        if (viewHolder.senderImageView != null && flatMessage.getSenderAvatarUrl() != null) {
            MessagesListAdapter messagesListAdapter = object;
            Object object = flatMessage.getSenderAvatarUrl();
            messagesListAdapter.loadImage((String)object, (ImageView)viewHolder.senderImageView, false);
        }
    }

    private void renderVideoItem(ViewHolder viewHolder, FlatMessage flatMessage) {
        ImageView imageView;
        if (flatMessage.isInbound()) {
            imageView = viewHolder.messageVideoFrameHolderBackground;
            if (imageView != null) {
                ThemeApplier.setViewBackground((View)imageView, (Drawable)object.getInboundBubbleDrawable((View)imageView));
            }
            if ((imageView = viewHolder.messageVideoPlayImageView) != null) {
                imageView.setColorFilter(object.colorFilter);
            }
        }
        if ((imageView = viewHolder.messageTimeTextView) != null) {
            imageView.setText((CharSequence)InstabugDateFormatter.formatMessageDate((Context)object.context, (long)flatMessage.getMessagedAt()));
        }
        object.bindVideoAttachments(flatMessage, viewHolder);
        if (viewHolder.senderImageView != null && flatMessage.getUrl() != null) {
            MessagesListAdapter messagesListAdapter = object;
            Object object = flatMessage.getUrl();
            messagesListAdapter.loadImage((String)object, (ImageView)viewHolder.senderImageView, false);
        }
    }

    private void bindMessageActions(FlatMessage object, ViewHolder viewHolder) {
        if ((object = ((FlatMessage)object).getMessageActions()) != null && ((ArrayList)object).size() > 0) {
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                Button button;
                Button button2;
                MessageAction messageAction = (MessageAction)((ArrayList)object).get(i);
                Button button3 = button2 = button;
                Button button4 = button2;
                button4(this.context);
                button4.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
                button2.setPadding(ViewUtils.convertDpToPx((Context)this.context, (float)8.0f), 0, ViewUtils.convertDpToPx((Context)this.context, (float)8.0f), 0);
                button2.setText((CharSequence)messageAction.getTitle());
                button3.setTextColor(ContextCompat.getColor((Context)this.context, (int)17170443));
                button3.setBackgroundColor(InstabugCore.getPrimaryColor());
                button3.setMaxEms(30);
                button3.setMaxLines(1);
                button2.setId(i);
                button.setOnClickListener(view -> this.listener.onMessageActionClicked(messageAction.getUrl()));
                messageAction = viewHolder.messageActionContainer;
                if (messageAction != null) {
                    messageAction.addView((View)button2);
                }
                ThemeApplier.applyCtaStyle((Button)button2, (IBGTheme)this.ibgTheme);
            }
        }
    }

    private void bindImageAttachments(final FlatMessage flatMessage, ViewHolder object) {
        if (flatMessage.getPath() != null && ((ViewHolder)object).messageImageView != null) {
            BitmapUtils.loadBitmap((String)flatMessage.getPath(), (ImageView)((ViewHolder)object).messageImageView);
        } else if (flatMessage.getUrl() != null && ((ViewHolder)object).messageImageView != null) {
            String string2 = flatMessage.getUrl();
            this.loadImage(string2, ((ViewHolder)object).messageImageView, true);
        }
        object = ((ViewHolder)object).messageImageView;
        if (object != null) {
            View.OnClickListener onClickListener;
            ViewHolder viewHolder = object;
            object = onClickListener;
            onClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    if (MessagesListAdapter.this.listener != null) {
                        if (flatMessage.getPath() != null) {
                            MessagesListAdapter.this.listener.onImageAttachmentClicked(flatMessage.getPath());
                        } else if (flatMessage.getUrl() != null) {
                            MessagesListAdapter.this.listener.onImageAttachmentClicked(flatMessage.getUrl());
                        }
                    }
                }
            };
            viewHolder.setOnClickListener((View.OnClickListener)object);
        }
    }

    private void bindVoiceAttachments(final FlatMessage flatMessage, final ViewHolder viewHolder) {
        String string2 = flatMessage.getUrl() != null ? flatMessage.getUrl() : flatMessage.getPath();
        ProgressBar progressBar = viewHolder.messageAudioAttachmentProgressBar;
        if (progressBar != null && progressBar.getVisibility() == 0) {
            viewHolder.messageAudioAttachmentProgressBar.setVisibility(8);
        }
        if ((progressBar = viewHolder.messageAudioPlayImageView) != null && progressBar.getVisibility() == 8) {
            viewHolder.messageAudioPlayImageView.setVisibility(0);
        }
        if ((progressBar = viewHolder.messageAudioAttachmentBackground) != null) {
            progressBar.setOnClickListener(object -> {
                MessagesListAdapter messagesListAdapter;
                object = FlatMessage.Mode.NONE;
                if (flatMessage.getMode() == object) {
                    messagesListAdapter.audioPlayer.start(string2);
                    flatMessage.setMode(FlatMessage.Mode.PLAYING);
                    messagesListAdapter = viewHolder.messageAudioPlayImageView;
                    if (messagesListAdapter != null) {
                        messagesListAdapter.setImageResource(R.drawable.ibg_chat_ic_pause);
                    }
                } else {
                    messagesListAdapter.audioPlayer.pause();
                    flatMessage.setMode((FlatMessage.Mode)((Object)((Object)object)));
                    messagesListAdapter = viewHolder.messageAudioPlayImageView;
                    if (messagesListAdapter != null) {
                        messagesListAdapter.setImageResource(R.drawable.ibg_chat_ic_play);
                    }
                }
            });
        }
        this.audioPlayer.addOnStopListener(new AudioPlayer.OnStopListener(string2){

            public void onStop() {
                2 v0 = this_;
                v0.flatMessage.setMode(FlatMessage.Mode.NONE);
                2 this_ = v0.viewHolder.messageAudioPlayImageView;
                if (this_ != null) {
                    this_.setImageResource(R.drawable.ibg_chat_ic_play);
                }
            }
        });
    }

    private void bindVideoAttachments(FlatMessage flatMessage, ViewHolder viewHolder) {
        if (flatMessage.getPath() != null) {
            this.bindLocalVideoAttachment(flatMessage, viewHolder);
        } else {
            this.bindRemoteVideoAttachments(flatMessage, viewHolder);
        }
    }

    private void bindLocalVideoAttachment(final FlatMessage flatMessage, final ViewHolder viewHolder) {
        Object object = viewHolder.messageVideoAttachmentProgressBar;
        if (object != null) {
            object.setVisibility(8);
        }
        if ((object = viewHolder.messageVideoPlayImageView) != null) {
            object.setVisibility(0);
        }
        if ((object = viewHolder.messageVideoAttachmentBackground) != null) {
            View.OnClickListener onClickListener;
            ProgressBar progressBar = object;
            object = onClickListener;
            onClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    if (MessagesListAdapter.this.listener != null && flatMessage.getPath() != null) {
                        MessagesListAdapter.this.listener.onVideoAttachmentClicked(flatMessage.getPath());
                    }
                }
            };
            progressBar.setOnClickListener((View.OnClickListener)object);
        }
        if (flatMessage.getPath() != null) {
            VideoManipulationUtils.extractFirstVideoFrame((String)flatMessage.getPath(), (OnVideoFrameReady)new OnVideoFrameReady(){

                public void onReady(@Nullable Bitmap bitmap) {
                    if (bitmap != null && (this = viewHolder.messageVideoFrameHolderBackground) != null) {
                        this.setImageBitmap(bitmap);
                    }
                }
            });
        }
    }

    private void bindRemoteVideoAttachments(final FlatMessage flatMessage, final ViewHolder viewHolder) {
        if (flatMessage.getUrl() != null) {
            PoolProvider.postIOTask((Runnable)new Runnable(){

                @Override
                public void run() {
                    String string2 = flatMessage.getUrl();
                    if (string2 != null) {
                        AssetsCacheManager.getAssetEntity((AssetEntity)AssetsCacheManager.createEmptyEntity((Context)MessagesListAdapter.this.context, (String)string2, (AssetEntity.AssetType)AssetEntity.AssetType.VIDEO), (AssetsCacheManager.OnDownloadFinished)new AssetsCacheManager.OnDownloadFinished(){

                            public void onSuccess(final AssetEntity assetEntity) {
                                InstabugSDKLogger.v((String)"IBG-BR", (String)"Asset Entity download succeeded: ");
                                PoolProvider.postMainThreadTask((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        Object object = viewHolder.messageVideoAttachmentProgressBar;
                                        if (object != null) {
                                            object.setVisibility(8);
                                        }
                                        if ((object = viewHolder.messageVideoPlayImageView) != null) {
                                            object.setVisibility(0);
                                        }
                                        1 v0 = this;
                                        VideoManipulationUtils.extractFirstVideoFrame((String)v0.assetEntity.getFile().getPath(), (OnVideoFrameReady)new OnVideoFrameReady(){

                                            public void onReady(@Nullable Bitmap bitmap) {
                                                if (bitmap != null && (this = viewHolder.messageVideoFrameHolderBackground) != null) {
                                                    this.setImageBitmap(bitmap);
                                                }
                                            }
                                        });
                                        object = v0.viewHolder.messageVideoAttachmentBackground;
                                        if (object != null) {
                                            View.OnClickListener onClickListener;
                                            ProgressBar progressBar = object;
                                            object = onClickListener;
                                            onClickListener = new View.OnClickListener(){

                                                public void onClick(View view) {
                                                    MessagesListAdapter.this.listener.onVideoAttachmentClicked(assetEntity.getFile().getPath());
                                                }
                                            };
                                            progressBar.setOnClickListener((View.OnClickListener)object);
                                        }
                                    }
                                });
                            }

                            public void onFailed(Throwable throwable) {
                                InstabugSDKLogger.e((String)"IBG-BR", (String)("Asset Entity downloading got error: " + throwable.getMessage()));
                            }
                        });
                    }
                }
            });
        }
    }

    private void loadImage(final String string2, final ImageView imageView, final boolean bl) {
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                BitmapUtils.loadBitmapForAsset((Context)MessagesListAdapter.this.context, (String)string2, (AssetEntity.AssetType)AssetEntity.AssetType.IMAGE, (BitmapUtils.OnBitmapReady)new BitmapUtils.OnBitmapReady(){

                    public void onBitmapReady(final @Nullable Bitmap bitmap) {
                        PoolProvider.postMainThreadTask((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                1 v0 = this;
                                v0.imageView.setImageBitmap(bitmap);
                                6 var1_1 = v0.this;
                                if (var1_1.bl && var1_1.MessagesListAdapter.this.isFirstImage) {
                                    1 v1 = this;
                                    v1.MessagesListAdapter.this.listView.setSelection(MessagesListAdapter.this.getCount() - 1);
                                    MessagesListAdapter.access$202(v1.MessagesListAdapter.this, false);
                                }
                            }
                        });
                    }

                    public void onBitmapFailedToLoad() {
                    }
                });
            }
        });
    }

    static /* synthetic */ boolean access$202(MessagesListAdapter messagesListAdapter, boolean bl) {
        messagesListAdapter.isFirstImage = bl;
        return bl;
    }

    public int getViewTypeCount() {
        return 8;
    }

    public int getCount() {
        return this.flatMessages.size();
    }

    public int getItemViewType(int n) {
        if (((FlatMessage)(this = ((MessagesListAdapter)((Object)this)).getItem(n))).getType() != null) {
            switch (7.$SwitchMap$com$instabug$chat$model$FlatMessage$Type[((FlatMessage)this).getType().ordinal()]) {
                default: {
                    return -1;
                }
                case 4: {
                    return ((FlatMessage)this).isInbound() ? 6 : 7;
                }
                case 3: {
                    return ((FlatMessage)this).isInbound() ? 4 : 5;
                }
                case 2: {
                    return ((FlatMessage)this).isInbound() ? 2 : 3;
                }
                case 1: 
            }
            return ((FlatMessage)this).isInbound() ^ 1;
        }
        return -1;
    }

    public FlatMessage getItem(int n) {
        return this.flatMessages.get(n);
    }

    public long getItemId(int n) {
        return n;
    }

    public View getView(int n, View view, ViewGroup object) {
        if (object == null) {
            return view;
        }
        int n2 = this.getItemViewType(n);
        if (view == null) {
            ViewHolder viewHolder;
            int n3 = MessagesListAdapter.getLayoutId(n2);
            view = LayoutInflater.from((Context)object.getContext()).inflate(n3, object, false);
            object = viewHolder;
            view.setTag((Object)new ViewHolder(view));
        } else {
            object = (ViewHolder)view.getTag();
        }
        try {
            MessagesListAdapter messagesListAdapter = this;
            messagesListAdapter.bind((ViewHolder)object, messagesListAdapter.getItem(n));
        }
        catch (Exception exception) {}
        return view;
    }

    public void setFlatMessageItems(List<FlatMessage> list) {
        Iterator<FlatMessage> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getType() != null) continue;
            iterator.remove();
        }
        this.flatMessages = list;
    }

    public static interface OnMessageItemClickListener {
        public void onVideoAttachmentClicked(String var1);

        public void onImageAttachmentClicked(String var1);

        public void onMessageActionClicked(String var1);
    }

    public static class ViewHolder {
        @Nullable
        public CircularImageView senderImageView;
        @Nullable
        public TextView messageTimeTextView;
        @Nullable
        public TextView messageSnippetTextView;
        @Nullable
        public LinearLayout receivedBubble;
        @Nullable
        public ImageView messageImageView;
        @Nullable
        public FrameLayout messageAudioAttachmentBackground;
        @Nullable
        public ImageView messageAudioPlayImageView;
        @Nullable
        public ProgressBar messageAudioAttachmentProgressBar;
        @Nullable
        public ImageView messageVideoPlayImageView;
        @Nullable
        public ImageView messageVideoFrameHolderBackground;
        @Nullable
        public FrameLayout messageVideoAttachmentBackground;
        @Nullable
        public ProgressBar messageVideoAttachmentProgressBar;
        @Nullable
        public LinearLayout messageActionContainer;

        public ViewHolder(View view) {
            this.senderImageView = (CircularImageView)view.findViewById(R.id.instabug_img_message_sender);
            this.messageTimeTextView = (TextView)view.findViewById(R.id.instabug_txt_message_time);
            this.messageSnippetTextView = (TextView)view.findViewById(R.id.instabug_txt_message_body);
            this.messageImageView = (ImageView)view.findViewById(R.id.instabug_img_attachment);
            this.messageAudioPlayImageView = (ImageView)view.findViewById(R.id.instabug_btn_play_audio);
            this.messageAudioAttachmentBackground = (FrameLayout)view.findViewById(R.id.instabug_audio_attachment);
            this.messageAudioAttachmentProgressBar = (ProgressBar)view.findViewById(R.id.instabug_audio_attachment_progress_bar);
            this.messageVideoFrameHolderBackground = (ImageView)view.findViewById(R.id.instabug_img_video_attachment);
            this.messageVideoPlayImageView = (ImageView)view.findViewById(R.id.instabug_btn_play_video);
            this.messageVideoAttachmentBackground = (FrameLayout)view.findViewById(R.id.instabug_video_attachment);
            this.messageVideoAttachmentProgressBar = (ProgressBar)view.findViewById(R.id.instabug_video_attachment_progress_bar);
            this.messageActionContainer = (LinearLayout)view.findViewById(R.id.instabug_message_actions_container);
            this.receivedBubble = (LinearLayout)view.findViewById(R.id.bubble_received_container);
        }
    }
}

