/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.ui.chat;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PorterDuff;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.fragment.app.Fragment;
import com.instabug.bug.R;
import com.instabug.bug.settings.BugSettings;
import com.instabug.chat.settings.ChatSettings;
import com.instabug.chat.util.ViewUtilsKt;
import com.instabug.library.FragmentVisibilityChangedListener;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugBaseFragment;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.video.MediaProjectionHelper;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.ResourcesUtils;
import com.instabug.library.util.ThemeApplier;
import java.util.Locale;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public class AttachmentsBottomSheetFragment
extends InstabugBaseFragment
implements View.OnClickListener,
FragmentVisibilityChangedListener {
    @Nullable
    private AppCompatImageView attachScreenshotIV;
    @Nullable
    private AppCompatImageView attachVideoIV;
    @Nullable
    private AppCompatImageView attachFromGalleryIV;
    Callbacks callbacks;
    private Runnable action;

    public static AttachmentsBottomSheetFragment newInstance(Callbacks callbacks) {
        new AttachmentsBottomSheetFragment().callbacks = callbacks;
        return new AttachmentsBottomSheetFragment();
    }

    @Nullable
    private static IBGTheme getIbgTheme() {
        return SettingsManager.getInstance().getIBGTheme();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void inflateViews() {
        Exception exception2;
        block8: {
            AppCompatImageView appCompatImageView;
            block7: {
                int n;
                try {
                    AttachmentsBottomSheetFragment attachmentsBottomSheetFragment = this;
                    appCompatImageView = attachmentsBottomSheetFragment.attachScreenshotIV;
                    if (attachmentsBottomSheetFragment.getContext() == null) return;
                    n = Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeDark ? R.color.instabug_theme_tinting_color_dark : R.color.instabug_theme_tinting_color_light;
                    n = this.getThemeColor(n);
                    if (appCompatImageView != null) {
                        appCompatImageView.setImageDrawable(ResourcesUtils.getDrawable((int)R.drawable.ibg_chat_ic_capture_screenshot, (Context)this.getContext()));
                        appCompatImageView.setColorFilter(n, PorterDuff.Mode.SRC_IN);
                    }
                    this.attachScreenshotIV = appCompatImageView;
                    appCompatImageView = this.attachVideoIV;
                    if (appCompatImageView != null) {
                        appCompatImageView.setImageDrawable(ResourcesUtils.getDrawable((int)R.drawable.ibg_core_ic_record_video, (Context)this.getContext()));
                        appCompatImageView.setColorFilter(n, PorterDuff.Mode.SRC_IN);
                    }
                    this.attachVideoIV = appCompatImageView;
                    appCompatImageView = this.attachFromGalleryIV;
                    if (appCompatImageView == null) break block7;
                }
                catch (Exception exception2) {
                    break block8;
                }
                appCompatImageView.setImageDrawable(ResourcesUtils.getVectorDrawable((int)R.drawable.ibg_core_ic_attach_gallery_media, (Context)this.getContext()));
                appCompatImageView.setColorFilter(n, PorterDuff.Mode.SRC_IN);
            }
            this.attachFromGalleryIV = appCompatImageView;
            return;
        }
        InstabugSDKLogger.e((String)"IBG-BR", (String)("Failed to inflate view with exception: " + exception2.getMessage()), (Throwable)exception2);
    }

    private int getThemeColor(int n) {
        IBGTheme iBGTheme = AttachmentsBottomSheetFragment.getIbgTheme();
        return iBGTheme != null && iBGTheme.getPrimaryColor() != 0 ? iBGTheme.getPrimaryColor() : ContextCompat.getColor((Context)this.requireContext(), (int)n);
    }

    private void animateBottomSheet(View view) {
        if ((view = view.findViewById(R.id.instabug_attachments_actions_bottom_sheet)) != null) {
            AttachmentsBottomSheetFragment attachmentsBottomSheetFragment = object;
            View view2 = view;
            view2.setAlpha(0.0f);
            Object object = () -> {
                View view2 = view2;
                int n = view2.getHeight();
                view2.setTranslationY((float)n);
                view2.setAlpha(1.0f);
                view2.animate().setDuration(100L).translationYBy((float)(-n));
            };
            attachmentsBottomSheetFragment.action = object;
            view.post((Runnable)object);
        }
    }

    private void removeCurrentFragment() {
        if (this.getActivity() != null) {
            AttachmentsBottomSheetFragment attachmentsBottomSheetFragment = this;
            attachmentsBottomSheetFragment.getActivity().getSupportFragmentManager().beginTransaction().remove((Fragment)this).commit();
            attachmentsBottomSheetFragment.getActivity().getSupportFragmentManager().popBackStack("attachments_bottom_sheet_fragment", 1);
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private void addCustomPlaceHolders(View view) {
        if ((this = this.getContext()) != null) {
            TextView textView = (TextView)view.findViewById(R.id.instabug_attach_gallery_image_text);
            if (textView != null) {
                TextView textView2 = textView;
                textView2.setText((CharSequence)PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.ADD_IMAGE_FROM_GALLERY, (String)LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)this), (int)R.string.instabug_str_pick_media_from_gallery, (Context)this)));
                AttachmentsBottomSheetFragment.applyPrimaryTextStyle(textView2);
            }
            if ((textView = (TextView)view.findViewById(R.id.instabug_attach_screenshot_text)) != null) {
                TextView textView3 = textView;
                textView3.setText((CharSequence)PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.ADD_EXTRA_SCREENSHOT, (String)LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)this), (int)R.string.instabug_str_take_screenshot, (Context)this)));
                AttachmentsBottomSheetFragment.applyPrimaryTextStyle(textView3);
            }
            if ((view = (TextView)view.findViewById(R.id.instabug_attach_video_text)) != null) {
                View view2 = view;
                view2.setText((CharSequence)PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.ADD_VIDEO, (String)LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)this), (int)R.string.instabug_str_record_video, (Context)this)));
                AttachmentsBottomSheetFragment.applyPrimaryTextStyle((TextView)view2);
            }
        }
    }

    private static void applyPrimaryTextStyle(TextView textView) {
        ThemeApplier.applyPrimaryTextStyle((TextView)textView, (IBGTheme)AttachmentsBottomSheetFragment.getIbgTheme());
    }

    private boolean shouldShowScreenRecording() {
        if ((this = this.getContext()) != null) {
            return ChatSettings.getAttachmentTypesState().isScreenRecordingEnabled() && MediaProjectionHelper.INSTANCE.isMediaProjectionServiceAvailable((Context)this);
        }
        return false;
    }

    @SuppressLint(value={"STARVATION"})
    public void onViewCreated(@NonNull View view, @Nullable Bundle object) {
        super.onViewCreated(view, object);
        if (AccessibilityUtils.isTalkbackEnabled() && (object = (LinearLayout)view.findViewById(R.id.instabug_attach_gallery_image)) != null) {
            AccessibilityDelegateCompat accessibilityDelegateCompat;
            Bundle bundle = object;
            object = accessibilityDelegateCompat;
            accessibilityDelegateCompat = new AccessibilityDelegateCompat(){

                public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                    super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                    accessibilityNodeInfoCompat.setImportantForAccessibility(true);
                }
            };
            ViewCompat.setAccessibilityDelegate((View)bundle, (AccessibilityDelegateCompat)object);
        }
        if (Build.VERSION.SDK_INT > 34) {
            ViewUtilsKt.addSystemWindowInsetToPadding(view, true, true, true, true);
        }
        this.attachScreenshotIV = (AppCompatImageView)view.findViewById(R.id.instabug_attach_screenshot_image_view);
        this.attachVideoIV = (AppCompatImageView)view.findViewById(R.id.instabug_attach_video_image_view);
        this.attachFromGalleryIV = (AppCompatImageView)view.findViewById(R.id.instabug_attach_gallery_image_view);
        object = (LinearLayout)view.findViewById(R.id.instabug_attach_screenshot);
        if (object != null) {
            if (this.shouldShowExtraScreenshot()) {
                object.setOnClickListener((View.OnClickListener)this);
            } else {
                object.setVisibility(8);
            }
        }
        if ((object = (LinearLayout)view.findViewById(R.id.instabug_attach_gallery_image)) != null) {
            if (ChatSettings.getAttachmentTypesState().isImageFromGalleryEnabled()) {
                object.setOnClickListener((View.OnClickListener)this);
            } else {
                object.setVisibility(8);
            }
        }
        if ((object = (LinearLayout)view.findViewById(R.id.instabug_attach_video)) != null) {
            if (this.shouldShowScreenRecording()) {
                object.setOnClickListener((View.OnClickListener)this);
            } else {
                object.setVisibility(8);
            }
        }
        if ((object = view.findViewById(R.id.instabug_attachments_bottom_sheet_dim_view)) != null) {
            object.setOnClickListener((View.OnClickListener)this);
        }
        AttachmentsBottomSheetFragment attachmentsBottomSheetFragment = this;
        this.addCustomPlaceHolders(view);
        attachmentsBottomSheetFragment.animateBottomSheet(view);
        attachmentsBottomSheetFragment.inflateViews();
        ThemeApplier.setScreenBackground((View)((LinearLayout)view.findViewById(R.id.instabug_attachments_actions_bottom_sheet)), (IBGTheme)AttachmentsBottomSheetFragment.getIbgTheme());
    }

    public void onDestroy() {
        this.action = null;
        super.onDestroy();
    }

    protected void saveState(Bundle bundle) {
    }

    protected void restoreState(Bundle bundle) {
    }

    protected int getLayout() {
        return R.layout.instabug_fragment_attachments_bottom_sheet;
    }

    protected String getTitle() {
        return this.getString(R.string.instabug_str_empty);
    }

    protected void consumeNewInstanceSavedArguments() {
    }

    public void onClick(View view) {
        int n = view.getId();
        if (n == R.id.instabug_attach_screenshot) {
            AttachmentsBottomSheetFragment attachmentsBottomSheetFragment = this;
            attachmentsBottomSheetFragment.removeCurrentFragment();
            attachmentsBottomSheetFragment.callbacks.attachScreenshot();
        } else if (n == R.id.instabug_attach_gallery_image) {
            AttachmentsBottomSheetFragment attachmentsBottomSheetFragment = this;
            attachmentsBottomSheetFragment.removeCurrentFragment();
            attachmentsBottomSheetFragment.callbacks.attachImageFromGallery();
        } else if (n == R.id.instabug_attach_video) {
            AttachmentsBottomSheetFragment attachmentsBottomSheetFragment = this;
            attachmentsBottomSheetFragment.removeCurrentFragment();
            attachmentsBottomSheetFragment.callbacks.attachVideo();
        } else if (n == R.id.instabug_attachments_bottom_sheet_dim_view) {
            this.removeCurrentFragment();
        }
    }

    public void onVisibilityChanged(boolean bl) {
    }

    public boolean shouldShowExtraScreenshot() {
        AttachmentsBottomSheetFragment attachmentsBottomSheetFragment = attachmentsBottomSheetFragment.getContext();
        boolean bl = BugSettings.getInstance().getAttachmentsTypesParams().isAllowTakeExtraScreenshot();
        if (bl && SettingsManager.getInstance().isScreenshotByMediaProjectionEnabled()) {
            return attachmentsBottomSheetFragment != null && MediaProjectionHelper.INSTANCE.isMediaProjectionServiceAvailable((Context)attachmentsBottomSheetFragment);
        }
        return bl;
    }

    public static interface Callbacks {
        public void attachScreenshot();

        public void attachImageFromGallery();

        public void attachVideo();
    }
}

