/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.settings;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import com.instabug.chat.settings.ChatSettings;
import com.instabug.library.Instabug;

public class PersistableSettings {
    private static PersistableSettings persistableSettings;
    @Nullable
    private SharedPreferences sharedPreferences;

    private PersistableSettings(@Nullable SharedPreferences sharedPreferences) {
        this.sharedPreferences = sharedPreferences;
    }

    static void init(@Nullable SharedPreferences sharedPreferences) {
        persistableSettings = new PersistableSettings(sharedPreferences);
    }

    static PersistableSettings getInstance() {
        if (persistableSettings == null && Instabug.getApplicationContext() != null) {
            PersistableSettings.init(ChatSettings.getChatSharedPreferences(Instabug.getApplicationContext()));
        }
        return persistableSettings;
    }

    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    public static void release() {
        persistableSettings = null;
    }

    long getLastChatTime() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return System.currentTimeMillis();
        }
        long l = System.currentTimeMillis();
        return persistableSettings.getLong("ibc_last_chat_time", l);
    }

    void setLastChatTime(long l) {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return;
        }
        persistableSettings.edit().putLong("ibc_last_chat_time", l).apply();
    }

    long getTTL() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return 60L;
        }
        return persistableSettings.getLong("ibc_ttl", 60L);
    }

    void setTTL(long l) {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return;
        }
        persistableSettings.edit().putLong("ibc_ttl", l).apply();
    }

    void enableConversationSound(boolean bl) {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return;
        }
        persistableSettings.edit().putBoolean("ibc_conversation_sounds", bl).apply();
    }

    boolean isSystemNotificationSoundEnabled() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return false;
        }
        return persistableSettings.getBoolean("ibc_notification_sound", false);
    }

    void enableSystemNotificationSound(boolean bl) {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return;
        }
        persistableSettings.edit().putBoolean("ibc_notification_sound", bl).apply();
    }

    boolean isInAppNotificationSoundEnabled() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return false;
        }
        return persistableSettings.getBoolean("ibc_in_app_notification_sound", false);
    }

    void enableInAppNotificationSound(boolean bl) {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return;
        }
        persistableSettings.edit().putBoolean("ibc_in_app_notification_sound", bl).apply();
    }

    @DrawableRes
    int getNotificationIcon() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return -1;
        }
        return persistableSettings.getInt("ibc_push_notification_icon", -1);
    }

    void setNotificationIcon(@DrawableRes int n) {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return;
        }
        persistableSettings.edit().putInt("ibc_push_notification_icon", n).apply();
    }

    boolean isNotificationEnable() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return true;
        }
        return persistableSettings.getBoolean("ibc__notifications_state", true);
    }

    void enableNotification(boolean bl) {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return;
        }
        persistableSettings.edit().putBoolean("ibc__notifications_state", bl).apply();
    }
}

