/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.model;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.chat.model.Message;
import com.instabug.chat.util.PlaceHolderResolver;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.encryption.EncryptionManager;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.model.BaseReport;
import com.instabug.library.model.State;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.json.JSONObject;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public class Chat
extends BaseReport
implements Cacheable,
Serializable {
    private String id;
    @Nullable
    private State state;
    private ArrayList<Message> messages;
    @Nullable
    private ChatState chatState;

    public Chat(@NonNull String string2) {
        this.id = string2;
        this.messages = new ArrayList();
        this.setChatState(ChatState.SENT);
    }

    public Chat() {
        this.chatState = ChatState.NOT_AVAILABLE;
        this.messages = new ArrayList();
    }

    @Nullable
    private Message getLastOutboundMessage() {
        Message message2 = ((Chat)this).getLastSyncedMessage();
        if (message2 != null && message2.isInbound()) {
            for (Message message2 : ((Chat)this).messages) {
                if (message2.isInbound()) continue;
                return message2;
            }
            return null;
        }
        return message2;
    }

    private void updateMessagesWithChatId() {
        for (int i = 0; i < this.getMessages().size(); ++i) {
            this.getMessages().get(i).setChatId(this.id);
        }
    }

    public String getId() {
        return this.id;
    }

    @SuppressLint(value={"ERADICATE_INCONSISTENT_SUBCLASS_PARAMETER_ANNOTATION"})
    public Chat setId(String string2) {
        Chat chat = this;
        chat.id = string2;
        chat.updateMessagesWithChatId();
        return chat;
    }

    public ArrayList<Message> getMessages() {
        return this.messages;
    }

    public Chat setMessages(ArrayList<Message> arrayList) {
        ArrayList<Object> arrayList2;
        Chat chat = serializable;
        serializable.messages = arrayList;
        Serializable serializable = arrayList2;
        new ArrayList<Object>().add(null);
        arrayList.removeAll((Collection<?>)((Object)serializable));
        chat.updateMessagesWithChatId();
        return chat;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    public Chat setState(@Nullable State state) {
        this.state = state;
        return this;
    }

    @Nullable
    public ChatState getChatState() {
        return this.chatState;
    }

    public Chat setChatState(@Nullable ChatState chatState) {
        this.chatState = chatState;
        return this;
    }

    public int getUnreadCount() {
        int n = 0;
        Iterator<Message> iterator = this.messages.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isRead()) continue;
            ++n;
        }
        return n;
    }

    public void markRead() {
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            this.messages.get(i).setRead(true);
        }
    }

    @Nullable
    public String getSenderAvatarUrl() {
        if ((this = this.getLastOutboundMessage()) != null) {
            return this.getSenderAvatarUrl();
        }
        return null;
    }

    @Nullable
    public String getSenderName() {
        Message message = this.getLastOutboundMessage();
        if (message != null) {
            return message.getSenderName();
        }
        if (this.messages.size() != 0) {
            ArrayList<Message> arrayList = this.messages;
            return arrayList.get(arrayList.size() - 1).getSenderName();
        }
        return "";
    }

    public long getLastMessageDate() {
        if (this.getLastMessage() != null) {
            return this.getLastMessage().getMessagedAt();
        }
        return 0L;
    }

    @Nullable
    public Message getLastMessage() {
        ArrayList<Message> arrayList = this.messages;
        if (arrayList != null && arrayList.size() != 0) {
            Chat chat = this;
            Collections.sort(chat.messages, new Message.Comparator(2));
            ArrayList<Message> arrayList2 = chat.messages;
            return arrayList2.get(arrayList2.size() - 1);
        }
        return null;
    }

    @Nullable
    public Message getLastSyncedMessage() {
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            if (this.messages.get(i).getMessageState() != Message.MessageState.SYNCED) continue;
            return this.messages.get(i);
        }
        return null;
    }

    public String getTitle() {
        String string2 = this.getSenderName();
        if (!(string2 == null || string2.equals("") || string2.equals(" ") || string2.equals("null") || this.getLastMessage() == null || this.getLastMessage().isInbound())) {
            return string2;
        }
        return PlaceHolderResolver.getTeamTitleResolved();
    }

    public String toJson() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        jSONObject.put("id", (Object)((Chat)object).getId()).put("messages", (Object)Message.toJson(((Chat)object).getMessages()));
        if (((Chat)object).getChatState() != null) {
            jSONObject2.put("chat_state", (Object)((Object)((Object)((Chat)object).getChatState())).toString());
        }
        if (((Chat)object).getState() != null) {
            jSONObject2.put("state", (Object)((Chat)object).getState().toJson());
        }
        if (InstabugCore.getEncryptionState() == Feature.State.ENABLED) {
            Object object = EncryptionManager.encrypt((String)jSONObject2.toString());
            if (object == null) {
                object = jSONObject2.toString();
            }
            return object;
        }
        return jSONObject2.toString();
    }

    public void fromJson(String string2) {
        if ((string2 = EncryptionManager.decrypt((String)string2)) != null) {
            JSONObject jSONObject;
            JSONObject jSONObject2 = jSONObject;
            if (new JSONObject(string2).has("id")) {
                this.setId(jSONObject2.getString("id"));
            }
            if (jSONObject2.has("messages")) {
                this.setMessages(Message.fromJson(jSONObject2.getJSONArray("messages")));
            }
            if (jSONObject2.has("chat_state")) {
                this.setChatState(ChatState.valueOf(jSONObject2.getString("chat_state")));
            }
            if (jSONObject2.has("state")) {
                State state = new State();
                state.fromJson(jSONObject2.getString("state"));
                this.setState(state);
            }
        }
    }

    @NonNull
    public String toString() {
        return "Chat:[" + this.id + " chatState: " + (Object)((Object)this.getChatState()) + "]";
    }

    @SuppressLint(value={"ERADICATE_INCONSISTENT_SUBCLASS_PARAMETER_ANNOTATION"})
    public boolean equals(Object object) {
        if (object instanceof Chat) {
            if (String.valueOf(((Chat)(object = (Chat)object)).getId()).equals(this.getId()) && ((Chat)object).getChatState() == this.getChatState() && (((Chat)object).getState() == null && this.getState() == null || this.getState() != null && ((Chat)object).getState() != null && ((Chat)object).getState().equals((Object)this.getState()))) {
                for (int i = 0; i < ((Chat)object).getMessages().size(); ++i) {
                    if (((Chat)object).getMessages().get(i).equals(this.getMessages().get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().hashCode();
        }
        return -1;
    }

    public static enum ChatState {
        WAITING_ATTACHMENT_MESSAGE,
        READY_TO_BE_SENT,
        LOGS_READY_TO_BE_UPLOADED,
        SENT,
        NOT_AVAILABLE;

    }

    public static class Comparator
    implements java.util.Comparator<Chat>,
    Serializable {
        @Override
        public int compare(Chat chat, Chat chat2) {
            return new Date(chat.getLastMessageDate()).compareTo(new Date(chat2.getLastMessageDate()));
        }
    }
}

