/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.cache;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.chat.model.Attachment;
import com.instabug.chat.model.Chat;
import com.instabug.chat.model.Message;
import com.instabug.library.apichecker.ReturnableRunnable;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.cache.AssetsCacheManager;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class ChatsCacheManager {
    @Nullable
    public static synchronized InMemoryCache<String, Chat> getCache() {
        return (InMemoryCache)PoolProvider.getChatsCacheExecutor().executeAndGet((ReturnableRunnable)new ReturnableRunnable<InMemoryCache<String, Chat>>(){

            @Nullable
            public InMemoryCache<String, Chat> run() {
                if (!CacheManager.getInstance().cacheExists("chats_memory_cache")) {
                    CacheManager.KeyExtractor<String, Chat> keyExtractor;
                    CacheManager.KeyExtractor<String, Chat> keyExtractor2 = keyExtractor;
                    keyExtractor = new CacheManager.KeyExtractor<String, Chat>(){

                        public String extractKey(Chat chat) {
                            return chat.getId();
                        }
                    };
                    CacheManager.getInstance().migrateCache("chats_disk_cache", "chats_memory_cache", (CacheManager.KeyExtractor)keyExtractor2);
                }
                return (InMemoryCache)CacheManager.getInstance().getCache("chats_memory_cache");
            }
        });
    }

    public static void saveCacheToDisk() {
        InstabugSDKLogger.d((String)"IBG-BR", (String)"Persisting chats to disk");
        PoolProvider.getChatsCacheExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Object object = CacheManager.getInstance().getCache("chats_memory_cache");
                Cache cache = CacheManager.getInstance().getCache("chats_disk_cache");
                if (object != null && cache != null) {
                    CacheManager.KeyExtractor<String, Chat> keyExtractor;
                    Cache cache2 = object;
                    object = keyExtractor;
                    keyExtractor = new CacheManager.KeyExtractor<String, Chat>(){

                        public String extractKey(Chat chat) {
                            return chat.getId();
                        }
                    };
                    CacheManager.getInstance().migrateCache(cache2, cache, (CacheManager.KeyExtractor)object);
                    InstabugSDKLogger.d((String)"IBG-BR", (String)"Chats memory cache had been persisted on-disk");
                } else {
                    InstabugSDKLogger.d((String)"IBG-BR", (String)"Chats memory cache was null");
                }
            }
        });
    }

    @Nullable
    public static Chat getChat(@Nullable String string2) {
        if (string2 == null) {
            return null;
        }
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            for (Chat chat : inMemoryCache.getValues()) {
                if (chat.getId() == null || !chat.getId().equals(string2)) continue;
                return chat;
            }
        }
        InstabugSDKLogger.e((String)"IBG-BR", (String)("No chat with id: " + string2 + " found, returning null"));
        return null;
    }

    public static List<Chat> getValidChats() {
        ArrayList<Chat> arrayList;
        ArrayList<Chat> arrayList2 = arrayList;
        arrayList = new ArrayList<Chat>();
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            for (Chat chat : inMemoryCache.getValues()) {
                if (chat.getMessages().size() <= 0) continue;
                arrayList2.add(chat);
            }
        }
        return arrayList2;
    }

    public static synchronized List<Chat> getOfflineChats() {
        ArrayList<Chat> arrayList;
        ArrayList<Chat> arrayList2 = arrayList;
        arrayList = new ArrayList<Chat>();
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            for (Chat chat : inMemoryCache.getValues()) {
                if (chat.getChatState() == null || !((Object)((Object)chat.getChatState())).equals((Object)Chat.ChatState.READY_TO_BE_SENT) && !((Object)((Object)chat.getChatState())).equals((Object)Chat.ChatState.LOGS_READY_TO_BE_UPLOADED) || chat.getMessages().size() <= 0) continue;
                arrayList2.add(chat);
            }
        }
        return arrayList2;
    }

    public static void updateLocalMessageWithSyncedMessage(@NonNull Context context, @NonNull Message message) {
        Chat chat;
        InstabugSDKLogger.v((String)"IBG-BR", (String)"Updating local messages after sync");
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null && message.getChatId() != null && (chat = (Chat)inMemoryCache.get((Object)message.getChatId())) != null) {
            ArrayList<Message> arrayList = chat.getMessages();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!((Message)arrayList.get(i)).getId().equals(message.getId()) || !((Object)((Object)((Message)arrayList.get(i)).getMessageState())).equals((Object)Message.MessageState.READY_TO_BE_SYNCED) || ((Message)arrayList.get(i)).getAttachments().size() != message.getAttachments().size()) continue;
                for (int j = 0; j < ((Message)arrayList.get(i)).getAttachments().size(); ++j) {
                    File file;
                    Attachment attachment = message.getAttachments().get(j);
                    if (attachment == null || attachment.getType() == null || attachment.getUrl() == null) continue;
                    String string2 = attachment.getType();
                    string2.hashCode();
                    int n = -1;
                    switch (string2.hashCode()) {
                        default: {
                            break;
                        }
                        case 1830389646: {
                            if (!string2.equals("video_gallery")) break;
                            n = 2;
                            break;
                        }
                        case 1710800780: {
                            if (!string2.equals("extra_video")) break;
                            n = 1;
                            break;
                        }
                        case 93166550: {
                            if (!string2.equals("audio")) break;
                            n = 0;
                        }
                    }
                    switch (n) {
                        default: {
                            attachment = AssetsCacheManager.createEmptyEntity((Context)context, (String)attachment.getUrl(), (AssetEntity.AssetType)AssetEntity.AssetType.IMAGE);
                            break;
                        }
                        case 1: 
                        case 2: {
                            attachment = AssetsCacheManager.createEmptyEntity((Context)context, (String)attachment.getUrl(), (AssetEntity.AssetType)AssetEntity.AssetType.VIDEO);
                            break;
                        }
                        case 0: {
                            attachment = AssetsCacheManager.createEmptyEntity((Context)context, (String)attachment.getUrl(), (AssetEntity.AssetType)AssetEntity.AssetType.AUDIO);
                        }
                    }
                    string2 = ((Message)arrayList.get(i)).getAttachments().get(j).getLocalPath();
                    if (string2 == null) continue;
                    File file2 = file;
                    Attachment attachment2 = attachment;
                    Attachment attachment3 = attachment;
                    File file3 = file2;
                    file3(string2);
                    attachment = Uri.fromFile((File)file3);
                    DiskUtils.copyFromUriIntoFile((Context)context, (Uri)attachment, (File)attachment3.getFile());
                    AssetsCacheManager.addAssetEntity((AssetEntity)attachment2);
                    file.delete();
                }
                Chat chat2 = chat;
                chat2.getMessages().set(i, message);
                inMemoryCache.put((Object)chat2.getId(), (Object)chat);
                break;
            }
        }
    }

    public static int getTotalMessagesCount() {
        int n = 0;
        Object object = ChatsCacheManager.getCache();
        if (object != null) {
            object = object.getValues().iterator();
            while (object.hasNext()) {
                Iterator<Message> iterator = ((Chat)object.next()).getMessages().iterator();
                while (iterator.hasNext()) {
                    if (!((Object)((Object)iterator.next().getMessageState())).equals((Object)Message.MessageState.SYNCED)) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public static List<Message> getOfflineMessages() {
        ArrayList<Message> arrayList;
        ArrayList<Message> arrayList2 = arrayList;
        arrayList = new ArrayList<Message>();
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            for (Object object : inMemoryCache.getValues()) {
                if (((Chat)object).getChatState() == null || !((Object)((Object)((Chat)object).getChatState())).equals((Object)Chat.ChatState.SENT)) continue;
                object = ((Chat)object).getMessages().iterator();
                while (object.hasNext()) {
                    Message message = (Message)object.next();
                    if (!((Object)((Object)message.getMessageState())).equals((Object)Message.MessageState.READY_TO_BE_SENT) && !((Object)((Object)message.getMessageState())).equals((Object)Message.MessageState.SENT)) continue;
                    arrayList2.add(message);
                }
            }
        }
        return arrayList2;
    }

    public static long getLastMessageMessagedAt() {
        ArrayList<Message> arrayList;
        ArrayList<Message> arrayList2 = arrayList;
        arrayList = new ArrayList<Message>();
        Object object = ChatsCacheManager.getCache();
        if (object != null) {
            object = object.getValues().iterator();
            while (object.hasNext()) {
                for (Message message : ((Chat)object.next()).getMessages()) {
                    if (message.getMessageState() != Message.MessageState.SYNCED) continue;
                    arrayList2.add(message);
                }
            }
        }
        Collections.sort(arrayList2, new Message.Comparator());
        for (int i = (v66219).size() - 1; i >= 0; --i) {
            Message message = (Message)arrayList2.get(i);
            if (message.getId().equals("0")) continue;
            return message.getMessagedAt();
        }
        return 0L;
    }

    public static int getUnreadCount() {
        int n = 0;
        Object object = ChatsCacheManager.getCache();
        if (object != null) {
            object = object.getValues().iterator();
            while (object.hasNext()) {
                n += ((Chat)object.next()).getUnreadCount();
            }
        }
        return n;
    }

    public static List<Message> getNotSentMessages() {
        ArrayList<Message> arrayList;
        ArrayList<Message> arrayList2 = arrayList;
        arrayList = new ArrayList<Message>();
        Object object = ChatsCacheManager.getCache();
        if (object != null) {
            object = object.getValues().iterator();
            while (object.hasNext()) {
                for (Message message : ((Chat)object.next()).getMessages()) {
                    if (message.getMessageState() != Message.MessageState.SENT && message.getMessageState() != Message.MessageState.READY_TO_BE_SENT) continue;
                    arrayList2.add(message);
                }
            }
        }
        InstabugSDKLogger.v((String)"IBG-BR", (String)("not sent messages count: " + arrayList2.size()));
        return arrayList2;
    }

    public static void cleanupChats() {
        InstabugSDKLogger.v((String)"IBG-BR", (String)"cleanupChats");
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            ArrayList<Chat> arrayList;
            ArrayList<Chat> arrayList2 = arrayList;
            arrayList = new ArrayList<Chat>();
            for (Chat chat : inMemoryCache.getValues()) {
                if (chat.getChatState() != Chat.ChatState.WAITING_ATTACHMENT_MESSAGE) continue;
                arrayList2.add(chat);
            }
            ChatsCacheManager.deleteChatsFromCache(arrayList2, inMemoryCache);
        }
        ChatsCacheManager.saveCacheToDisk();
    }

    public static void clearChats() {
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            ChatsCacheManager.deleteChatsFromCache(inMemoryCache.getValues(), inMemoryCache);
        }
        ChatsCacheManager.saveCacheToDisk();
    }

    private static void deleteChatsFromCache(List<Chat> object, InMemoryCache<String, Chat> inMemoryCache) {
        if (inMemoryCache != null) {
            object = object.iterator();
            while (object.hasNext()) {
                inMemoryCache.delete((Object)((Chat)object.next()).getId());
            }
        }
    }

    public static void migrateOnEncryptionStateChange() {
        PoolProvider.getChatsCacheExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Cache cache = CacheManager.getInstance().getCache("chats_disk_cache");
                if (cache != null) {
                    CacheManager.KeyExtractor<String, Chat> keyExtractor;
                    List list = cache.getValues();
                    CacheManager.KeyExtractor<String, Chat> keyExtractor2 = keyExtractor;
                    keyExtractor = new CacheManager.KeyExtractor<String, Chat>(this){
                        final /* synthetic */ 3 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public String extractKey(Chat chat) {
                            return chat.getId();
                        }
                    };
                    cache.invalidate();
                    for (Chat chat : list) {
                        cache.put(keyExtractor2.extractKey((Object)chat), (Object)chat);
                    }
                }
            }
        });
    }
}

