/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.annotation.shape;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import androidx.annotation.Nullable;
import com.instabug.chat.annotation.ControlButton;
import com.instabug.chat.annotation.DirectionRectF;
import com.instabug.chat.annotation.shape.CroppedRectShape;
import com.instabug.chat.annotation.utility.BitmapUtility;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.DrawingUtility;

public class ZoomedShape
extends CroppedRectShape {
    @Nullable
    private PointF controlPoint;
    private float cx;
    private float cy;
    private float r;

    public ZoomedShape(@Nullable Bitmap bitmap) {
        ZoomedShape zoomedShape = this;
        super(-65536);
        zoomedShape.background = bitmap;
        zoomedShape.setRecognized(true);
    }

    public void setBackground(@Nullable Bitmap bitmap) {
        this.background = bitmap;
    }

    @Override
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void drawCroppedRect(Canvas canvas, Bitmap bitmap, float f, float f2) {
        PointF pointF;
        Canvas canvas2 = canvas;
        this.r = Math.min(bitmap.getWidth() / 2, bitmap.getHeight() / 2);
        this.cx = f + (float)bitmap.getWidth() / 2.0f;
        this.cy = f2 + (float)bitmap.getHeight() / 2.0f;
        canvas = pointF;
        ZoomedShape zoomedShape = this;
        float f3 = zoomedShape.cx;
        pointF = new PointF(f3, zoomedShape.cy);
        this.controlPoint = DrawingUtility.pointOnCircle((float)this.r, (float)45.0f, (PointF)canvas);
        canvas2.drawBitmap(BitmapUtility.getCroppedCircleBitmap(BitmapUtility.zoom(bitmap, 200)), f, f2, null);
    }

    @Override
    public boolean isTouched(PointF pointF, DirectionRectF directionRectF) {
        Path path;
        RectF rectF;
        Region region = new Region();
        directionRectF = rectF;
        rectF = new RectF();
        Path path2 = path;
        ZoomedShape zoomedShape = this;
        path2();
        float f = zoomedShape.cx;
        float f2 = zoomedShape.cy;
        float f3 = zoomedShape.r;
        path2.addCircle(f, f2, f3, Path.Direction.CW);
        path.computeBounds((RectF)directionRectF, true);
        DirectionRectF directionRectF2 = directionRectF;
        int n = (int)directionRectF2.top;
        int n2 = (int)directionRectF2.right;
        int n3 = (int)directionRectF2.bottom;
        region.setPath(path, new Region((int)directionRectF.left, n, n2, n3));
        return region.contains((int)pointF.x, (int)pointF.y);
    }

    @Override
    public void adjustBounds(DirectionRectF directionRectF, DirectionRectF directionRectF2, boolean bl) {
        if (Math.abs(directionRectF2.width() - directionRectF.width()) < 1.0f && Math.abs(directionRectF2.height() - directionRectF.height()) < 1.0f) {
            directionRectF2.set(directionRectF);
        } else {
            Matrix matrix;
            float f = Math.max(directionRectF.width() / directionRectF2.width(), directionRectF.height() / directionRectF2.height());
            directionRectF = matrix;
            DirectionRectF directionRectF3 = directionRectF2;
            directionRectF();
            float f2 = directionRectF3.centerX();
            float f3 = directionRectF3.centerY();
            directionRectF.postScale(f, f, f2, f3);
            matrix.mapRect((RectF)directionRectF2);
        }
    }

    @Override
    public void drawControlButtons(Canvas canvas, DirectionRectF directionRectF, ControlButton[] controlButtonArray) {
        ZoomedShape zoomedShape = zoomedShape.controlPoint;
        if (zoomedShape == null) {
            zoomedShape = directionRectF.getBottomRightPoint();
        }
        ControlButton[] controlButtonArray2 = controlButtonArray;
        controlButtonArray2[2].setCenterPoint((PointF)zoomedShape);
        controlButtonArray2[2].setColor(SettingsManager.getInstance().getPrimaryColor());
        controlButtonArray[2].draw(canvas);
    }

    @Override
    public void drawBorder(Canvas canvas, PointF pointF, PointF pointF2, PointF pointF3, PointF pointF4) {
    }

    @Override
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public Path getPath(DirectionRectF directionRectF) {
        return null;
    }
}

