/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.annotation.recognition;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import com.instabug.chat.annotation.recognition.PathFactory;
import com.instabug.chat.annotation.recognition.RectPath;
import com.instabug.chat.annotation.recognition.ShapeSpecs$Type;
import com.instabug.chat.annotation.recognition.Utility;
import com.instabug.chat.annotation.recognition.Weight;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PathMatcher {
    private int userPathPixelsCount;
    private int userPathLeftWeight;
    private int userPathTopWeight;
    private int userPathRightWeight;
    private int userPathBottomWeight;
    private float pathLength;
    private final Path userPath;
    private Paint paint;

    public PathMatcher(Path path) {
        PathMatcher pathMatcher = pathMatcher3;
        PathMatcher pathMatcher2 = pathMatcher3;
        pathMatcher3.paint = new Paint();
        pathMatcher3.paint.setStyle(Paint.Style.STROKE);
        pathMatcher2.paint.setStrokeWidth(2.0f);
        PathMatcher pathMatcher3 = Utility.resizePath(path);
        pathMatcher.userPath = pathMatcher3;
        pathMatcher.analyzePath((Path)pathMatcher3);
    }

    private void analyzePath(Path path) {
        Canvas canvas;
        this.pathLength = new PathMeasure(path, false).getLength();
        Object object = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = Bitmap.createBitmap((int)28, (int)28, (Bitmap.Config)object);
        object = bitmap;
        Canvas canvas2 = canvas;
        PathMatcher pathMatcher = this;
        canvas2((Bitmap)object);
        pathMatcher.paint.setColor(-65536);
        canvas.drawPath(path, pathMatcher.paint);
        int n = 784;
        int[] nArray = new int[784];
        object = nArray;
        bitmap.getPixels(nArray, 0, 28, 0, 0, 28, 28);
        for (int i = 0; i < n; ++i) {
            if (object[i] != -65536) continue;
            ++this.userPathPixelsCount;
            if (i < 392) {
                ++this.userPathTopWeight;
            } else {
                ++this.userPathBottomWeight;
            }
            if (i % 28 < 14) {
                ++this.userPathLeftWeight;
                continue;
            }
            ++this.userPathRightWeight;
        }
    }

    private Weight matchPaths(Path path, Path object) {
        float f;
        float f2;
        Weight weight;
        Canvas canvas;
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        config = Bitmap.createBitmap((int)28, (int)28, (Bitmap.Config)config);
        Canvas canvas2 = canvas;
        PathMatcher pathMatcher = this;
        canvas2((Bitmap)config);
        pathMatcher.paint.setColor(-16777216);
        canvas.drawPath(path, pathMatcher.paint);
        int n = 784;
        int[] nArray = new int[784];
        int n2 = 0;
        config.getPixels(nArray, 0, 28, 0, 0, 28, 28);
        for (int i = 0; i < n; ++i) {
            if (nArray[i] != -16777216) continue;
            ++n2;
        }
        Bitmap.Config config2 = config;
        PathMatcher pathMatcher2 = this;
        pathMatcher2.paint.setColor(-2130706433);
        canvas2.drawPath(object, pathMatcher2.paint);
        n = 784;
        object = new int[784];
        int n3 = config2.getWidth();
        config2.getPixels((int[])object, 0, n3, 0, 0, 28, 28);
        n3 = 0;
        float f3 = 0.0f;
        float f4 = 0.0f;
        Weight weight2 = weight;
        weight = new Weight();
        for (int i = 0; i < n; ++i) {
            Path path2 = object[i];
            if (path2 == -8355712) {
                ++n3;
                continue;
            }
            if (path2 == -2130706433) {
                f4 += 1.0f;
                continue;
            }
            if (path2 != -16777216) continue;
            f3 += 1.0f;
        }
        Weight weight3 = weight2;
        weight2.value = n3;
        weight2.pathNotConsumedPercent = f2 = f4 / (float)this.userPathPixelsCount;
        float f5 = n2;
        weight3.originalPathNotConsumedPercent = f = f3 / f5;
        weight3.probability = (1.0f - f + 1.0f - f2 + (float)n3 / f5) / 3.0f;
        weight2.leftWeight = this.userPathLeftWeight;
        weight2.topWeight = this.userPathTopWeight;
        weight2.rightWeight = this.userPathRightWeight;
        weight2.bottomWeight = this.userPathBottomWeight;
        weight2.pathLength = this.pathLength;
        return weight2;
    }

    private List<Weight> getArrowWeights(Path path) {
        ArrayList<Weight> arrayList;
        ArrayList<Weight> arrayList2 = arrayList;
        arrayList = new ArrayList<Weight>();
        Path path2 = PathFactory.getArrowPath();
        for (int i = 0; i < 36; ++i) {
            int n;
            this.matchPaths(Utility.rotatePath(path2, n), path).angle = n = i * 10;
            arrayList2.add(this.matchPaths(Utility.rotatePath(path2, n), path));
        }
        return arrayList2;
    }

    private List<Weight> getRectWeights(ShapeSpecs$Type shapeSpecs$Type, int n, int n2, int n3) {
        ArrayList<Weight> arrayList;
        ArrayList<Weight> arrayList2 = arrayList;
        arrayList = new ArrayList<Weight>();
        List<RectPath> list = PathFactory.getRectPaths(shapeSpecs$Type);
        if (list != null && !list.isEmpty()) {
            block0: for (RectPath rectPath : list) {
                for (int i = n; i < n2; ++i) {
                    PathMatcher pathMatcher = this;
                    int n4 = i * n3;
                    Path path = Utility.rotatePath(rectPath.path, n4);
                    pathMatcher.matchPaths(path, pathMatcher.userPath).angle = n4;
                    pathMatcher.matchPaths(path, pathMatcher.userPath).rectPaddingPercent = rectPath.paddingPercent;
                    arrayList2.add(pathMatcher.matchPaths(path, pathMatcher.userPath));
                    if (shapeSpecs$Type == ShapeSpecs$Type.OVAL && rectPath.paddingPercent == 0.0f) continue block0;
                }
            }
        }
        return arrayList2;
    }

    private float getAverageProbability(List<Weight> list) {
        float f = 0.0f;
        Iterator<Weight> iterator = list.iterator();
        while (iterator.hasNext()) {
            f += iterator.next().probability;
        }
        return f / (float)list.size();
    }

    public Weight getFineWeightRect(ShapeSpecs$Type object) {
        object = this.getRectWeights((ShapeSpecs$Type)((Object)object), 0, 18, 10);
        Collections.max(object).averageProbability = this.getAverageProbability((List<Weight>)object);
        return Collections.max(object);
    }

    public Weight getFineWeightArrow() {
        PathMatcher pathMatcher = this;
        List<Weight> list = pathMatcher.getArrowWeights(pathMatcher.userPath);
        Weight weight = Collections.max(list);
        int n = weight.angle;
        if (n >= 0 && n <= 20 || n <= 360 && n >= 340 || n >= 160 && n <= 200 || n > 180 && weight.getVerticalWeight() == Weight.DIRECTION.TOP || weight.angle < 180 && weight.getVerticalWeight() == Weight.DIRECTION.BOTTOM) {
            return weight;
        }
        (n2 < 180 ? list.get((n2 + 180) / 10) : list.get((n2 - 180) / 10)).averageProbability = this.getAverageProbability(list);
        int n2 = weight.angle;
        return n2 < 180 ? list.get((n2 + 180) / 10) : list.get((n2 - 180) / 10);
    }
}

