/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.chat.ChatCoreEventHandler;
import com.instabug.chat.ChatPluginWrapper;
import com.instabug.chat.cache.ChatsCacheManager;
import com.instabug.chat.model.Message;
import com.instabug.chat.notification.NotificationManager;
import com.instabug.chat.synchronization.NewMessagesHandler;
import com.instabug.chat.synchronization.OnNewMessagesReceivedListener;
import com.instabug.chat.synchronization.SynchronizationManager;
import com.instabug.library.PresentationManager;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventSubscriber;
import com.instabug.library.core.eventbus.eventpublisher.IBGCompositeDisposable;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.tokenmapping.MappedTokenChangedEventBus;
import com.instabug.library.util.threading.PoolProvider;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public class ChatPlugin
extends Plugin
implements OnNewMessagesReceivedListener {
    @Nullable
    IBGCompositeDisposable disposables;
    @VisibleForTesting
    @Nullable
    IBGDisposable mappedTokenChangedDisposable;

    @NonNull
    private IBGDisposable subscribeToCoreEvents() {
        return IBGCoreEventSubscriber.subscribe(iBGSdkCoreEvent -> {
            WeakReference weakReference = ((Plugin)weakReference).contextWeakReference;
            if (weakReference != null) {
                ChatCoreEventHandler.handleCoreEvents((Context)weakReference.get(), iBGSdkCoreEvent);
            }
        });
    }

    private void unSubscribeFromCoreEvents() {
        ChatPlugin chatPlugin = chatPlugin.disposables;
        if (chatPlugin != null) {
            chatPlugin.dispose();
        }
    }

    private void subscribeToMappedTokenChangeEvent() {
        if (this.mappedTokenChangedDisposable == null) {
            this.mappedTokenChangedDisposable = MappedTokenChangedEventBus.INSTANCE.subscribe(bl -> {
                ChatsCacheManager.clearChats();
                ((ChatPlugin)((Object)synchronizationManager)).sendPushNotificationToken(true);
                SynchronizationManager synchronizationManager = SynchronizationManager.getInstance();
                if (synchronizationManager != null) {
                    synchronizationManager.sync(true);
                }
            });
        }
    }

    private void unsubscribeFromMappedTokenChangeEvent() {
        IBGDisposable iBGDisposable = this.mappedTokenChangedDisposable;
        if (iBGDisposable != null) {
            iBGDisposable.dispose();
            this.mappedTokenChangedDisposable = null;
        }
    }

    @SuppressLint(value={"NULL_DEREFERENCE"})
    private void sendPushNotificationToken(boolean bl) {
        ChatPluginWrapper.sendPushNotificationToken(bl);
    }

    private IBGCompositeDisposable getOrCreateCompositeDisposables() {
        IBGCompositeDisposable iBGCompositeDisposable = this.disposables;
        if (iBGCompositeDisposable == null) {
            IBGCompositeDisposable iBGCompositeDisposable2;
            iBGCompositeDisposable = iBGCompositeDisposable2;
            iBGCompositeDisposable2 = new IBGCompositeDisposable();
            this.disposables = iBGCompositeDisposable;
        }
        return iBGCompositeDisposable;
    }

    private static /* synthetic */ void lambda$onNewMessagesReceived$1(Context context, List list) {
        NotificationManager.getInstance().showNotification(context, list);
    }

    public void init(Context context) {
        super.init(context);
    }

    public void wake() {
    }

    public void sleep() {
    }

    public void stop() {
        ChatPlugin chatPlugin = this;
        chatPlugin.unSubscribeFromCoreEvents();
        chatPlugin.unsubscribeFromMappedTokenChangeEvent();
        ChatPluginWrapper.release();
        NewMessagesHandler.getInstance().removeOnNewMessagesReceivedListener(this);
    }

    public void start(Context context) {
        PoolProvider.postIOTaskWithCheck(() -> {
            ChatPlugin chatPlugin = this;
            chatPlugin.subscribeOnCoreEvents();
            chatPlugin.subscribeToMappedTokenChangeEvent();
            NewMessagesHandler.getInstance().addOnNewMessagesReceivedListener(this);
            ChatPluginWrapper.wake(context);
            this.sendPushNotificationToken(false);
        });
    }

    public long getLastActivityTime() {
        return ChatPluginWrapper.getLastActivityTime();
    }

    public void initDefaultPromptOptionAvailabilityState() {
        ChatPluginWrapper.initDefaultPromptOptionAvailabilityState();
    }

    @Nullable
    public ArrayList<PluginPromptOption> getPromptOptions() {
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            return ChatPluginWrapper.getPromptOptions((Context)this.contextWeakReference.get());
        }
        return null;
    }

    @Nullable
    public ArrayList<PluginPromptOption> getPluginOptions(boolean bl) {
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            return ChatPluginWrapper.getPromptOptions((Context)this.contextWeakReference.get());
        }
        return null;
    }

    public boolean isFeatureEnabled() {
        return InstabugCore.isFeatureEnabled((String)"REPLIES") && InstabugCore.isFeatureEnabled((String)"IN_APP_MESSAGING");
    }

    @Override
    @Nullable
    @SuppressLint(value={"ERADICATE_INCONSISTENT_SUBCLASS_RETURN_ANNOTATION"})
    public List<Message> onNewMessagesReceived(@NonNull List<Message> list) {
        Object object = ((Plugin)object).contextWeakReference;
        if (object != null && (object = (Context)((Reference)object).get()) != null) {
            if (InstabugCore.isAppOnForeground()) {
                PresentationManager.getInstance().show(() -> ChatPlugin.lambda$onNewMessagesReceived$1((Context)object, list));
            } else {
                NotificationManager.getInstance().showNotification((Context)object, list);
            }
        }
        return null;
    }

    @VisibleForTesting
    void subscribeOnCoreEvents() {
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            this.getOrCreateCompositeDisposables().add(this.subscribeToCoreEvents());
        }
    }
}

