/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view.reporting;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.instabug.bug.BugPlugin;
import com.instabug.bug.BugsCoreEventsHandler;
import com.instabug.bug.LiveBugManager;
import com.instabug.bug.OnSdkDismissedCallback$DismissType;
import com.instabug.bug.R;
import com.instabug.bug.utils.BugReportingThemeResolver;
import com.instabug.bug.view.BugReportingActivityCallback;
import com.instabug.bug.view.BugReportingContract$View;
import com.instabug.bug.view.annotation.BugAnnotationFragment;
import com.instabug.bug.view.disclaimer.Disclaimer;
import com.instabug.bug.view.disclaimer.DisclaimerFragment;
import com.instabug.bug.view.disclaimer.DisclaimerHelper;
import com.instabug.bug.view.reporting.BaseReportingContainerPresenter;
import com.instabug.bug.view.reporting.BaseReportingFragment;
import com.instabug.bug.view.reporting.ReportingNavigator;
import com.instabug.bug.view.reporting.feedback.FeedbackFragment;
import com.instabug.bug.view.visualusersteps.steppreview.VisualUserStepArgs;
import com.instabug.chat.util.ViewUtilsKt;
import com.instabug.library.FragmentVisibilityChangedListener;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library.R;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BaseToolbarActivity;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.ui.custom.InstabugAlertDialog;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.BitmapWorkerTask;
import com.instabug.library.util.DrawableUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.KeyboardUtils;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.OrientationUtils;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.StatusBarUtils;
import com.instabug.library.util.ThemeApplier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public class ReportingContainerActivity
extends BaseToolbarActivity<BaseReportingContainerPresenter>
implements _InstabugActivity,
BugReportingContract$View,
View.OnClickListener,
BugAnnotationFragment.Callbacks,
FragmentManager.OnBackStackChangedListener,
DisclaimerFragment.Callbacks,
BaseReportingFragment.Callbacks,
BugReportingActivityCallback {
    private boolean shouldAnimateCapturedScreen = true;
    @Nullable
    private AlertDialog confirmationDialog;

    private void notifyFragmentVisibilityChanged(boolean bl, int n) {
        if (this.getSupportFragmentManager().findFragmentById(n) instanceof FragmentVisibilityChangedListener) {
            ((FragmentVisibilityChangedListener)this.getSupportFragmentManager().findFragmentById(n)).onVisibilityChanged(bl);
        }
    }

    private void popFragment() {
        if (!this.isFinishing() && !this.getSupportFragmentManager().isStateSaved()) {
            this.getSupportFragmentManager().popBackStackImmediate();
        }
    }

    private void openDisclaimerFragment() {
        ReportingContainerActivity reportingContainerActivity = this;
        reportingContainerActivity.notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);
        ReportingNavigator.navigateToDisclaimerFragment(reportingContainerActivity.getSupportFragmentManager(), true);
    }

    private void openDisclaimerDetailsFragment(Disclaimer disclaimer) {
        ReportingContainerActivity reportingContainerActivity = this;
        reportingContainerActivity.notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);
        ReportingNavigator.navigateToDisclaimerDetailsFragment(reportingContainerActivity.getSupportFragmentManager(), disclaimer);
    }

    private String getReproStepsListTitle() {
        return PlaceHolderUtils.getPlaceHolder((Context)this, (InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.REPRO_STEPS_LIST_HEADER, (int)R.string.IBGReproStepsListTitle);
    }

    private void applyThemeToTitle() {
        ReportingContainerActivity reportingContainerActivity = reportingContainerActivity.toolbar;
        if (reportingContainerActivity != null && (reportingContainerActivity = reportingContainerActivity.getChildAt(0)) instanceof TextView) {
            ThemeApplier.applyTitleStyle((TextView)((TextView)reportingContainerActivity), (IBGTheme)SettingsManager.getInstance().getIBGTheme());
        }
    }

    private void showConfirmationDialog() {
        ReportingContainerActivity reportingContainerActivity = this;
        String string2 = reportingContainerActivity.getConfirmationDialogPositiveAction();
        this.confirmationDialog = new InstabugAlertDialog.Builder((Activity)this).setTitle(this.getConfirmationDialogTitle()).setMessage(this.getConfirmationDialogMessage()).setPositiveButtonAccessibilityContentDescription(this.getConfirmationDialogPositiveAction()).setNegativeButtonAccessibilityContentDescription(this.getConfirmationDialogNegativeAction()).setPositiveButton(string2, (dialogInterface, n) -> {
            dialogInterface.dismiss();
            this.dismissReport();
            this.confirmationDialog = null;
        }).setNegativeButton(this.getConfirmationDialogNegativeAction(), null).show();
    }

    private String getConfirmationDialogTitle() {
        return PlaceHolderUtils.getPlaceHolder((Context)this, (InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.REPORT_DISCARD_DIALOG_TITLE, (int)R.string.instabug_str_bugreport_dismiss_warning_title);
    }

    private String getConfirmationDialogMessage() {
        return PlaceHolderUtils.getPlaceHolder((Context)this, (InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.REPORT_DISCARD_DIALOG_BODY, (int)R.string.instabug_str_bugreport_dismiss_warning_message);
    }

    private String getConfirmationDialogPositiveAction() {
        return PlaceHolderUtils.getPlaceHolder((Context)this, (InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.REPORT_DISCARD_DIALOG_POSITIVE_ACTION, (int)R.string.instabug_str_bugreport_dismiss_discard);
    }

    private String getConfirmationDialogNegativeAction() {
        return PlaceHolderUtils.getPlaceHolder((Context)this, (InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.REPORT_DISCARD_DIALOG_NEGATIVE_ACTION, (int)R.string.instabug_str_bugreport_dismiss_cancel);
    }

    protected void onNewIntent(Intent intent) {
        BaseReportingContainerPresenter baseReportingContainerPresenter;
        super.onNewIntent(intent);
        BaseReportingContainerPresenter baseReportingContainerPresenter2 = baseReportingContainerPresenter;
        this.presenter = new BaseReportingContainerPresenter(this);
        if (DisclaimerHelper.isDisclaimerUri(intent.getData())) {
            this.openDisclaimerFragment();
        }
        baseReportingContainerPresenter2.handleBugProcess(intent.getIntExtra("com.instabug.library.process", 162));
    }

    public void onCreate(@Nullable Bundle object) {
        BaseReportingContainerPresenter baseReportingContainerPresenter;
        AppCompatDelegate.setCompatVectorFromResourcesEnabled((boolean)true);
        super.onCreate((Bundle)object);
        if (!InstabugCore.isFullScreen()) {
            StatusBarUtils.darkenStatusBarColor((Activity)this, (int)InstabugCore.getPrimaryColor());
        }
        if (InstabugCore.getTheme() != null) {
            this.setTheme(BugReportingThemeResolver.resolveTheme(InstabugCore.getTheme()));
        }
        this.overridePendingTransition(0x10A0000, 0x10A0001);
        if (LiveBugManager.getInstance().getBug() == null) {
            InstabugSDKLogger.e((String)"IBG-BR", (String)"Bug is null, closing reporting activity and back to launch the app");
            this.finishActivity();
            return;
        }
        Bundle bundle = object;
        this.getSupportFragmentManager().addOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)this);
        object = baseReportingContainerPresenter;
        ((BaseReportingContainerPresenter)((Object)object))(this);
        int n = this.getIntent().getIntExtra("com.instabug.library.process", 162);
        this.presenter = baseReportingContainerPresenter;
        if (bundle == null) {
            ((BaseReportingContainerPresenter)((Object)object)).handleBugProcess(n);
        }
        this.getWindow().setSoftInputMode(3);
    }

    public void setToolbarNavigationContentDescription(@StringRes int n) {
        ReportingContainerActivity reportingContainerActivity = reportingContainerActivity.toolbar;
        if (reportingContainerActivity != null) {
            reportingContainerActivity.setNavigationContentDescription(n);
        }
    }

    public void onStart() {
        super.onStart();
        Object object = (BugPlugin)InstabugCore.getXPlugin(BugPlugin.class);
        if (object != null) {
            object.setState(1);
        }
        InstabugSDKLogger.d((String)"IBG-BR", (String)"Reporting activity started, SDK Invoking State Changed: true");
    }

    protected void onPause() {
        ReportingContainerActivity reportingContainerActivity = this;
        super.onPause();
        AlertDialog alertDialog = reportingContainerActivity.confirmationDialog;
        if (alertDialog != null && alertDialog.isShowing()) {
            this.confirmationDialog.dismiss();
        }
    }

    public void onStop() {
        BugPlugin bugPlugin = (BugPlugin)InstabugCore.getXPlugin(BugPlugin.class);
        if (bugPlugin != null && bugPlugin.getState() != 2) {
            bugPlugin.setState(0);
        }
        InstabugSDKLogger.d((String)"IBG-BR", (String)"Reporting activity paused, SDK Invoking State Changed: false");
        super.onStop();
    }

    protected void onDestroy() {
        BaseContract.Presenter presenter = this.presenter;
        if (presenter != null) {
            ((BaseReportingContainerPresenter)presenter).onDestroy();
        }
        if (!LiveBugManager.getInstance().isInBackground() && LiveBugManager.getInstance().getDismissType() == OnSdkDismissedCallback$DismissType.ADD_ATTACHMENT) {
            LiveBugManager.getInstance().setDismissType(OnSdkDismissedCallback$DismissType.CANCEL);
        }
        ReportingContainerActivity reportingContainerActivity = this;
        OrientationUtils.unlockOrientation((Context)reportingContainerActivity);
        super.onDestroy();
    }

    protected void initContentViews() {
        Toolbar toolbar;
        int n = Build.VERSION.SDK_INT;
        if (n > 34 && (toolbar = this.findViewById(R.id.reporting_container_main_layout)) != null) {
            ViewUtilsKt.addSystemWindowInsetToPadding((View)toolbar, true, false, true, true);
        }
        if ((toolbar = this.toolbar) != null) {
            if (n > 34) {
                ViewUtilsKt.addSystemWindowInsetToPadding((View)toolbar, true, true, true, false);
            }
            if (LiveBugManager.getInstance().getBug() == null) {
                this.toolbar.setNavigationIcon(null);
            }
            if (InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                this.toolbar.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
            } else {
                this.toolbar.setBackgroundColor(ContextCompat.getColor((Context)this, (int)R.color.instabug_attachment_bar_color_dark));
            }
        }
    }

    protected int getContentLayout() {
        return R.layout.ibg_bug_activity_bug_reporting;
    }

    public void onClick(View view) {
        ArrayList arrayList = new ArrayList(this.getSupportFragmentManager().getFragments());
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(null);
        arrayList.removeAll(arrayList2);
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() >= 1) {
            ReportingContainerActivity reportingContainerActivity = this;
            reportingContainerActivity.overridePendingTransition(0x10A0000, 0x10A0001);
            super.onBackPressed();
        } else {
            ReportingContainerActivity reportingContainerActivity = this;
            KeyboardUtils.hide((Activity)reportingContainerActivity);
            reportingContainerActivity.showConfirmationDialog();
        }
    }

    public void finish() {
        ReportingContainerActivity reportingContainerActivity = this;
        super.finish();
        reportingContainerActivity.overridePendingTransition(0x10A0000, 0x10A0001);
    }

    @Override
    @VisibleForTesting
    public void dismissReport() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() < 1) {
            LiveBugManager.getInstance().setDismissType(OnSdkDismissedCallback$DismissType.CANCEL);
            InstabugSDKLogger.d((String)"IBG-BR", (String)"Reporting bug canceled. Deleting attachments");
            Cache cache = CacheManager.getInstance().getCache("DEFAULT_IN_MEMORY_CACHE_KEY");
            if (cache != null) {
                cache.delete((Object)"video.path");
            }
            BugsCoreEventsHandler.handleSDKDismissing();
            this.finish();
        }
        if ((InstabugStateProvider.getInstance().getState() == InstabugState.TAKING_SCREENSHOT_FOR_CHAT || InstabugStateProvider.getInstance().getState() == InstabugState.IMPORTING_IMAGE_FROM_GALLERY_FOR_CHAT) && this.getSupportFragmentManager().findFragmentById(R.id.instabug_fragment_container) instanceof BugAnnotationFragment) {
            InstabugStateProvider.getInstance().setState(InstabugState.ENABLED);
        }
        this.notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);
    }

    public void onBackStackChanged() {
        this.notifyFragmentVisibilityChanged(true, R.id.instabug_fragment_container);
    }

    @Override
    public void startBugReporter() {
        if (LiveBugManager.getInstance().getBug() == null) {
            return;
        }
        LiveBugManager.getInstance().getBug().setType("bug");
        String string2 = LiveBugManager.getInstance().getBug().getInitialScreenshotPath();
        if (!LiveBugManager.getInstance().getBug().hasMainScreenshot() && string2 != null) {
            LiveBugManager.getInstance().getBug().addAttachment(Uri.parse((String)string2), Attachment.Type.MAIN_SCREENSHOT);
        }
        ReportingContainerActivity reportingContainerActivity = reportingContainerActivity2;
        reportingContainerActivity.notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);
        ReportingNavigator.navigateToBugReportingFragment(reportingContainerActivity.getSupportFragmentManager(), LiveBugManager.getInstance().getBug().getMessage(), false);
        ReportingContainerActivity reportingContainerActivity2 = reportingContainerActivity.presenter;
        if (reportingContainerActivity2 != null) {
            ((BaseReportingContainerPresenter)((Object)reportingContainerActivity2)).handlePoweredByFooter();
        }
    }

    @Override
    public void startFeedbackSender() {
        if (LiveBugManager.getInstance().getBug() == null) {
            return;
        }
        LiveBugManager.getInstance().getBug().setType("feedback");
        String string2 = LiveBugManager.getInstance().getBug().getInitialScreenshotPath();
        if (!LiveBugManager.getInstance().getBug().hasMainScreenshot() && string2 != null) {
            LiveBugManager.getInstance().getBug().addAttachment(Uri.parse((String)string2), Attachment.Type.MAIN_SCREENSHOT);
        }
        ReportingContainerActivity reportingContainerActivity = reportingContainerActivity2;
        reportingContainerActivity.notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);
        ReportingNavigator.navigateToFeedbackReportingFragment(reportingContainerActivity.getSupportFragmentManager(), LiveBugManager.getInstance().getBug().getMessage(), false);
        ReportingContainerActivity reportingContainerActivity2 = reportingContainerActivity.presenter;
        if (reportingContainerActivity2 != null) {
            ((BaseReportingContainerPresenter)((Object)reportingContainerActivity2)).handlePoweredByFooter();
        }
    }

    @Override
    public void onImageEditingDone(@Nullable Bitmap object, Uri uri) {
        InstabugSDKLogger.d((String)"IBG-BR", (String)"onImageEditingDone");
        if (object != null) {
            BitmapUtils.OnSaveBitmapCallback onSaveBitmapCallback;
            Bitmap bitmap = object;
            object = onSaveBitmapCallback;
            onSaveBitmapCallback = new BitmapUtils.OnSaveBitmapCallback(){

                public void onSuccess(Uri uri) {
                    LiveBugManager.getInstance().refreshAttachments((Context)ReportingContainerActivity.this);
                }

                public void onError(Throwable throwable) {
                }
            };
            BitmapUtils.saveBitmap((Bitmap)bitmap, (Uri)uri, (Context)this, (BitmapUtils.OnSaveBitmapCallback)object);
        }
        ReportingContainerActivity reportingContainerActivity = this;
        reportingContainerActivity.notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);
        reportingContainerActivity.popFragment();
        if (reportingContainerActivity.getSupportFragmentManager().findFragmentByTag(FeedbackFragment.TAG) == null && (this = this.presenter) != null) {
            ((BaseReportingContainerPresenter)((Object)this)).startNavigation();
        }
    }

    @Override
    public void startWithHangingBug() {
        InstabugSDKLogger.d((String)"IBG-BR", (String)"startWithHangingBug");
        if (LiveBugManager.getInstance().getBug() != null) {
            InstabugSDKLogger.d((String)"IBG-BR", (String)("bug attachment size: " + LiveBugManager.getInstance().getBug().getAttachments().size()));
        }
        LiveBugManager.getInstance().setIsInBackground(false);
        if (reportingContainerActivity.getSupportFragmentManager().findFragmentByTag(FeedbackFragment.TAG) == null) {
            ReportingContainerActivity reportingContainerActivity = reportingContainerActivity;
            reportingContainerActivity.notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);
            BaseContract.Presenter presenter = reportingContainerActivity.presenter;
            if (presenter != null) {
                ((BaseReportingContainerPresenter)presenter).startNavigation();
            }
        }
        LiveBugManager.getInstance().refreshAttachments((Context)reportingContainerActivity);
        ReportingContainerActivity reportingContainerActivity = reportingContainerActivity.presenter;
        if (reportingContainerActivity != null) {
            ((BaseReportingContainerPresenter)((Object)reportingContainerActivity)).handlePoweredByFooter();
        }
    }

    @Override
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void loadBitmapAnimation(final float f, final float f2) {
        if (this.getIntent().getParcelableExtra("screenshot_uri") != null && this.shouldAnimateCapturedScreen) {
            FrameLayout.LayoutParams layoutParams;
            ImageView imageView;
            ReportingContainerActivity reportingContainerActivity = this;
            reportingContainerActivity.shouldAnimateCapturedScreen = false;
            ViewGroup viewGroup = (ViewGroup)reportingContainerActivity.getWindow().getDecorView().getRootView();
            final ImageView imageView2 = imageView;
            imageView2((Context)this);
            imageView.setBackgroundColor(ContextCompat.getColor((Context)this, (int)17170443));
            Object object = layoutParams;
            layoutParams = new FrameLayout.LayoutParams(-1, -1);
            viewGroup.addView((View)imageView, (ViewGroup.LayoutParams)object);
            object = (Uri)reportingContainerActivity.getIntent().getParcelableExtra("screenshot_uri");
            if (object != null && object.getPath() != null) {
                BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener;
                String string2 = object.getPath();
                object = onImageLoadedListener;
                onImageLoadedListener = new BitmapWorkerTask.OnImageLoadedListener(){

                    public void onImageLoaded() {
                        ScaleAnimation scaleAnimation;
                        ScaleAnimation scaleAnimation2 = scaleAnimation;
                        2 v1 = this;
                        float f3 = v1.f;
                        float f22 = v1.f2;
                        new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f, 1, f3, 1, f22).setDuration(500L);
                        scaleAnimation2.setFillAfter(false);
                        scaleAnimation2.setAnimationListener(new Animation.AnimationListener(){

                            public void onAnimationStart(Animation animation) {
                            }

                            public void onAnimationEnd(Animation animation) {
                                imageView2.setVisibility(8);
                            }

                            public void onAnimationRepeat(Animation animation) {
                            }
                        });
                        imageView2.startAnimation((Animation)scaleAnimation2);
                    }
                };
                BitmapUtils.loadBitmap((String)string2, (ImageView)imageView2, (BitmapWorkerTask.OnImageLoadedListener)object);
                this.getIntent().putExtra("screenshot_uri", null);
            }
        }
    }

    @Override
    public void handlePoweredByFooter() {
        View view = this.findViewById(R.id.instabug_pbi_container);
        InstabugCore.handlePbiFooter((View)view);
        InstabugCore.setPbiFooterThemeColor((View)view, (int)AttrResolver.resolveAttributeColor((Context)this.getViewContext(), (int)R.attr.instabug_foreground_color));
        view.setBackgroundColor(AttrResolver.getColor((Context)this.getViewContext(), (int)R.attr.ibg_bug_color_bg_pbi));
        if (AccessibilityUtils.isTalkbackEnabled()) {
            ViewCompat.setImportantForAccessibility((View)this.findViewById(R.id.instabug_pbi_container), (int)4);
        }
    }

    @Override
    public void navigateToFeedback() {
        String string2 = LiveBugManager.getInstance().getBug() != null ? LiveBugManager.getInstance().getBug().getMessage() : null;
        ReportingNavigator.navigateToFeedbackReportingFragment(this.getSupportFragmentManager(), string2, false);
    }

    @Override
    public void startAskQuestion() {
        this.notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);
        String string2 = LiveBugManager.getInstance().getBug() != null ? LiveBugManager.getInstance().getBug().getMessage() : null;
        ReportingNavigator.navigateToAskQuestion(this.getSupportFragmentManager(), string2, false);
    }

    @Override
    public void startFrustratingExperience() {
        this.notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);
        String string2 = LiveBugManager.getInstance().getBug() != null ? LiveBugManager.getInstance().getBug().getMessage() : null;
        ReportingNavigator.navigateToFrustratingExperience(this.getSupportFragmentManager(), string2, false);
    }

    @Override
    public void navigateToBugReporting() {
        String string2 = LiveBugManager.getInstance().getBug() != null ? LiveBugManager.getInstance().getBug().getMessage() : null;
        ReportingNavigator.navigateToBugReportingFragment(this.getSupportFragmentManager(), string2, false);
    }

    @Override
    public void onFeedbackFragmentDismissed() {
        Cache cache = CacheManager.getInstance().getCache("DEFAULT_IN_MEMORY_CACHE_KEY");
        if (cache != null) {
            cache.delete((Object)"video.path");
        }
        this.finish();
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    protected void onActivityResult(int n, int n2, @Nullable Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (n == 3940) {
            ReportingContainerActivity reportingContainerActivity = iterator;
            reportingContainerActivity.overridePendingTransition(0x10A0000, 0x10A0001);
            reportingContainerActivity.finishActivity();
            return;
        }
        Iterator iterator = iterator.getSupportFragmentManager().getFragments().iterator();
        while (iterator.hasNext()) {
            ((Fragment)iterator.next()).onActivityResult(n, n2, intent);
        }
    }

    @Override
    public void openVisualUserStepsDisclaimerFragment() {
        ReportingContainerActivity reportingContainerActivity = this;
        reportingContainerActivity.notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);
        ReportingNavigator.navigateToVisualUserStepListFragment(reportingContainerActivity.getSupportFragmentManager(), this.getReproStepsListTitle());
    }

    @Override
    public void openStepPreviewFragment(@NonNull VisualUserStepArgs visualUserStepArgs) {
        ReportingContainerActivity reportingContainerActivity = this;
        reportingContainerActivity.notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);
        ReportingNavigator.navigateToVisualUserStepPreview(reportingContainerActivity.getSupportFragmentManager(), visualUserStepArgs);
    }

    @Override
    public void openDisclaimerDetails(Disclaimer disclaimer) {
        this.openDisclaimerDetailsFragment(disclaimer);
    }

    @Override
    public void setToolbarUpIconBack() {
        Toolbar toolbar = this.toolbar;
        if (toolbar != null) {
            if (LocaleUtils.isRTL((Locale)InstabugCore.getLocale((Context)this))) {
                Drawable drawable2 = ContextCompat.getDrawable((Context)this, (int)R.drawable.ibg_core_ic_back);
                if (drawable2 != null) {
                    toolbar.setNavigationIcon(DrawableUtils.getRotateDrawable((Drawable)drawable2, (float)180.0f));
                }
            } else {
                toolbar.setNavigationIcon(R.drawable.ibg_core_ic_back);
            }
        }
        this.toolbar = toolbar;
    }

    @Override
    public void setToolbarTitle(String string2) {
        ReportingContainerActivity reportingContainerActivity = this;
        reportingContainerActivity.setTitle(string2);
        reportingContainerActivity.applyThemeToTitle();
    }

    @Override
    public String getToolbarTitle() {
        return String.valueOf(this.getTitle());
    }

    @Override
    public void setToolbarUpIconClose() {
        ReportingContainerActivity reportingContainerActivity = reportingContainerActivity.toolbar;
        if (reportingContainerActivity != null) {
            reportingContainerActivity.setNavigationIcon(R.drawable.ibg_core_ic_close);
        }
    }
}

