/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.utils;

import android.content.Context;
import com.instabug.library.internal.storage.AttachmentManager;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.util.FileUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\b\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/instabug/bug/utils/CleanUpUtils;", "", "()V", "cleanupAutoRecordingDirectory", "", "context", "Landroid/content/Context;", "cleanupInitialScreenshots", "cleanupUnsentBugsFiles", "cleanupVideosDirectory", "cleanupViewHierarchyAttachments", "instabug-bug_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nCleanUpUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CleanUpUtils.kt\ncom/instabug/bug/utils/CleanUpUtils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,44:1\n1295#2,2:45\n1295#2,2:47\n*S KotlinDebug\n*F\n+ 1 CleanUpUtils.kt\ncom/instabug/bug/utils/CleanUpUtils\n*L\n33#1:45,2\n42#1:47,2\n*E\n"})
public final class CleanUpUtils {
    @NotNull
    public static final CleanUpUtils INSTANCE = new CleanUpUtils();

    private CleanUpUtils() {
    }

    @JvmStatic
    public static final void cleanupUnsentBugsFiles(@Nullable Context context) {
        if (context != null) {
            CleanUpUtils cleanUpUtils = INSTANCE;
            cleanUpUtils.cleanupAutoRecordingDirectory(context);
            cleanUpUtils.cleanupVideosDirectory(context);
            cleanUpUtils.cleanupInitialScreenshots(context);
            cleanUpUtils.cleanupViewHierarchyAttachments(context);
        }
    }

    private final void cleanupAutoRecordingDirectory(Context context) {
        FileUtils.deleteDirectory((File)AttachmentManager.getAutoScreenRecordingVideosDirectory((Context)context));
    }

    private final void cleanupVideosDirectory(Context context) {
        FileUtils.deleteDirectory((File)AttachmentManager.getNewInternalDirectory((Context)context, (String)"videos"));
    }

    private final void cleanupInitialScreenshots(Context context) {
        Object object = DiskUtils.getInstabugInternalDirectory((Context)context).listFiles(CleanUpUtils::cleanupInitialScreenshots$lambda$1);
        if (object != null && (object = ArraysKt.asSequence((Object[])object)) != null) {
            object = object.iterator();
            while (object.hasNext()) {
                ((File)object.next()).delete();
            }
        }
    }

    private final void cleanupViewHierarchyAttachments(Context context) {
        Object object = DiskUtils.getInstabugInternalDirectory((Context)context).listFiles(CleanUpUtils::cleanupViewHierarchyAttachments$lambda$3);
        if (object != null && (object = ArraysKt.asSequence((Object[])object)) != null) {
            object = object.iterator();
            while (object.hasNext()) {
                ((File)object.next()).delete();
            }
        }
    }

    private static final boolean cleanupInitialScreenshots$lambda$1(File file, String string2) {
        return string2 != null ? StringsKt.startsWith$default((String)string2, (String)"bug_", (boolean)false, (int)2, null) : false;
    }

    private static final boolean cleanupViewHierarchyAttachments$lambda$3(File file, String string2) {
        return string2 != null ? StringsKt.startsWith$default((String)string2, (String)"view_hierarchy_attachment", (boolean)false, (int)2, null) : false;
    }
}

