/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.userConsent;

import com.instabug.bug.model.Bug;
import com.instabug.bug.userConsent.ConsentsActionHandler;
import com.instabug.bug.utils.DeleteBugsUtilKt;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.util.StateKtxKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0013\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/instabug/bug/userConsent/ConsentsActionHandlerImpl;", "Lcom/instabug/bug/userConsent/ConsentsActionHandler;", "()V", "clearViewHierarchy", "", "bug", "Lcom/instabug/bug/model/Bug;", "clearVisualUserSteps", "dropAutoCapturedMedia", "dropAutoCapturedMediaAttachments", "dropLogs", "handle", "removeFileAttachments", "", "(Lcom/instabug/bug/model/Bug;)Ljava/lang/Boolean;", "instabug-bug_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nConsentsActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsentsActionHandler.kt\ncom/instabug/bug/userConsent/ConsentsActionHandlerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1855#2,2:73\n1855#2,2:75\n766#2:77\n857#2,2:78\n2634#2:80\n1#3:81\n1#3:82\n*S KotlinDebug\n*F\n+ 1 ConsentsActionHandler.kt\ncom/instabug/bug/userConsent/ConsentsActionHandlerImpl\n*L\n17#1:73,2\n35#1:75,2\n66#1:77\n66#1:78,2\n67#1:80\n67#1:81\n*E\n"})
public final class ConsentsActionHandlerImpl
implements ConsentsActionHandler {
    private final void dropAutoCapturedMedia(Bug bug) {
        ConsentsActionHandlerImpl consentsActionHandlerImpl = this;
        consentsActionHandlerImpl.dropAutoCapturedMediaAttachments(bug);
        consentsActionHandlerImpl.clearViewHierarchy(bug);
        consentsActionHandlerImpl.clearVisualUserSteps(bug);
    }

    private final void dropAutoCapturedMediaAttachments(Bug bug) {
        ArrayList<Attachment> arrayList;
        List<Attachment> list = bug.getAttachments();
        ArrayList<Attachment> arrayList2 = arrayList;
        arrayList = new ArrayList<Attachment>();
        if (list != null && list.isEmpty() ^ true) {
            List<Attachment> list2 = list;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"attachments");
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Attachment attachment = (Attachment)iterator.next();
                if (!CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])new Attachment.Type[]{Attachment.Type.VIEW_HIERARCHY, Attachment.Type.MAIN_SCREENSHOT, Attachment.Type.AUTO_SCREEN_RECORDING_VIDEO, Attachment.Type.VISUAL_USER_STEPS}), (Object)attachment.getType())) continue;
                Attachment attachment2 = attachment;
                Intrinsics.checkNotNullExpressionValue((Object)attachment2, (String)"attachment");
                arrayList2.add(attachment2);
                DeleteBugsUtilKt.deleteAttachment(attachment, bug.getId());
            }
            list.removeAll(arrayList2);
        }
    }

    private final void clearViewHierarchy(Bug bug) {
        bug.setViewHierarchy(null);
    }

    private final void clearVisualUserSteps(Bug bug) {
        ConsentsActionHandlerImpl consentsActionHandlerImpl = bug.getState();
        if (consentsActionHandlerImpl != null) {
            consentsActionHandlerImpl.setVisualUserSteps(null);
        }
    }

    private final void dropLogs(Bug bug) {
        State state = bug.getState();
        if (state != null) {
            StateKtxKt.dropLogs((State)state);
        }
        this.removeFileAttachments(bug);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Boolean removeFileAttachments(Bug bug) {
        ArrayList arrayList;
        List<Attachment> list = bug.getAttachments();
        if (list == null) return null;
        List<Attachment> list2 = list;
        list = arrayList;
        arrayList = new ArrayList();
        for (Object t : list2) {
            if (((Attachment)t).getType() != Attachment.Type.ATTACHMENT_FILE) continue;
            list.add((Attachment)t);
        }
        for (Attachment attachment : list) {
            Intrinsics.checkNotNullExpressionValue((Object)attachment, (String)"it");
            DeleteBugsUtilKt.deleteAttachment(attachment, bug.getId());
        }
        if ((list = CollectionsKt.toList((Iterable)list)) == null) return null;
        List<Attachment> list3 = bug.getAttachments();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"attachments");
        Boolean bl = list3.removeAll(list);
        return bl;
    }

    @Override
    public void handle(@NotNull Bug bug) {
        Bug bug2 = bug;
        Intrinsics.checkNotNullParameter((Object)bug2, (String)"bug");
        Object object = bug2.getActionableConsents();
        if (object != null) {
            if (object.isEmpty()) {
                object = null;
            }
            if (object != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    String string2 = (String)object.next();
                    if (Intrinsics.areEqual((Object)string2, (Object)"drop_auto_captured_media")) {
                        this.dropAutoCapturedMedia(bug);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)string2, (Object)"drop_logs")) continue;
                    this.dropLogs(bug);
                }
            }
        }
    }
}

