/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.screenshot.viewhierarchy.utilities;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.instabug.bug.screenshot.viewhierarchy.ViewHierarchy;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.InstabugSDKLogger;

public abstract class BitmapUtils {
    public static ViewHierarchy captureViewHierarchy(ViewHierarchy viewHierarchy) {
        return BitmapUtils.captureViewWithoutChildren(viewHierarchy);
    }

    private static ViewHierarchy captureViewWithoutChildren(ViewHierarchy viewHierarchy) {
        Bitmap bitmap;
        InstabugSDKLogger.v((String)"IBG-BR", (String)("staring capture viewHierarchy: " + viewHierarchy.getId()));
        if (viewHierarchy.getView() instanceof ViewGroup) {
            ViewHierarchy viewHierarchy2 = viewHierarchy;
            boolean[] blArray = BitmapUtils.hideViewChildren((ViewGroup)viewHierarchy2.getView());
            bitmap = BitmapUtils.captureView(viewHierarchy2);
            BitmapUtils.showViewChildren((ViewGroup)viewHierarchy2.getView(), blArray);
        } else {
            bitmap = BitmapUtils.captureView(viewHierarchy);
        }
        ViewHierarchy viewHierarchy3 = viewHierarchy;
        viewHierarchy3.setImage(bitmap);
        InstabugSDKLogger.v((String)"IBG-BR", (String)("capture viewHierarchy done successfully: " + viewHierarchy.getId()));
        return viewHierarchy3;
    }

    private static boolean[] hideViewChildren(ViewGroup viewGroup) {
        boolean[] blArray = new boolean[viewGroup.getChildCount()];
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            if (viewGroup.getChildAt(i).getVisibility() == 0) {
                blArray[i] = true;
                viewGroup.getChildAt(i).setVisibility(4);
                continue;
            }
            blArray[i] = false;
        }
        return blArray;
    }

    private static void showViewChildren(ViewGroup viewGroup, boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            viewGroup.getChildAt(i).setVisibility(0);
        }
    }

    @Nullable
    private static Bitmap captureView(ViewHierarchy viewHierarchy) {
        View view = viewHierarchy.getView();
        if (view != null && viewHierarchy.getVisibleRect() != null && view.getHeight() > 0 && view.getWidth() > 0 && viewHierarchy.getVisibleRect().height() > 0 && viewHierarchy.getVisibleRect().width() > 0 && (view = BitmapUtils.captureView(view)) != null && viewHierarchy.getOriginalRect() != null) {
            View view2 = view;
            ViewHierarchy viewHierarchy2 = viewHierarchy;
            view = viewHierarchy2.getVisibleRect();
            if ((view = BitmapUtils.cropImageToVisiblyArea((Bitmap)view2, (Rect)view, viewHierarchy2.getOriginalRect())) != null) {
                return BitmapUtils.scaleBitmap((Bitmap)view, viewHierarchy.getScale());
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private static Bitmap captureView(@Nullable View var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 84->98)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private static Bitmap cropImageToVisiblyArea(Bitmap bitmap, Rect rect, Rect rect2) {
        if (bitmap != null && rect != null && rect.width() > 0 && rect.height() > 0) {
            int n = rect.left - rect2.left;
            int n2 = rect.top - rect2.top;
            if (n >= 0 && n2 >= 0 && rect.width() <= bitmap.getWidth() && rect.height() <= bitmap.getHeight()) {
                Bitmap bitmap2 = bitmap;
                Rect rect3 = rect;
                Rect rect4 = rect3;
                int n3 = rect3.width();
                int n4 = rect4.height();
                try {
                    bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)n, (int)n2, (int)n3, (int)n4);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugCore.reportError((Throwable)outOfMemoryError, (String)"Cropping bitmap throws an OOM");
                    bitmap = null;
                }
                return bitmap;
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static Bitmap scaleBitmap(Bitmap bitmap, int n) {
        if (bitmap != null && bitmap.getWidth() > n && bitmap.getHeight() > n) {
            Bitmap bitmap2 = bitmap;
            return Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)(bitmap2.getWidth() / n), (int)(bitmap.getHeight() / n), (boolean)false);
        }
        return null;
    }
}

