/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.network;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.bug.cache.BugTable;
import com.instabug.bug.configurations.BugReportingConfigurationsProvider;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.model.Bug;
import com.instabug.bug.network.BugsService;
import com.instabug.bug.testingreport.ReportUploadingStateEventBus;
import com.instabug.bug.utils.DeleteBugsUtilKt;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugNetworkJob;
import com.instabug.library.internal.storage.cache.dbv2.IBGContentValues;
import com.instabug.library.networkv2.RateLimitedException;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.IOException;
import java.util.List;
import kotlin.Pair;

public abstract class InstabugBugsUploaderJob
extends InstabugNetworkJob {
    private static final BugReportingConfigurationsProvider configurationProvider = ServiceLocator.getConfigurationsProvider();
    private static boolean continueUploadBugs;

    private void uploadBugs(final Context context) {
        continueUploadBugs = true;
        List<Bug> list = this.getBugs(context);
        InstabugSDKLogger.d((String)"IBG-BR", (String)("Found " + list.size() + " bugs in cache"));
        for (final Bug bug : list) {
            if (!continueUploadBugs) break;
            if (((Object)((Object)bug.getBugState())).equals((Object)Bug.BugState.READY_TO_BE_SENT)) {
                Request.Callbacks<String, Throwable> callbacks;
                InstabugSDKLogger.d((String)"IBG-BR", (String)("Uploading bug: " + bug));
                Object object = configurationProvider;
                if (object.isBugReportingRateLimited()) {
                    DeleteBugsUtilKt.deleteBug(bug, context);
                    InstabugBugsUploaderJob.logRateIsLimited();
                    continue;
                }
                object.setLastBugRequestStartedAt(System.currentTimeMillis());
                object = callbacks;
                callbacks = new Request.Callbacks<String, Throwable>(){

                    public void onSucceeded(@Nullable String pair) {
                        Object object;
                        IBGContentValues iBGContentValues;
                        1 v0 = bug2;
                        InstabugSDKLogger.d((String)"IBG-BR", (String)("Bug uploaded successfully, setting bug TemporaryServerToken equal " + (String)pair));
                        v0.bug.setTemporaryServerToken((String)pair);
                        Object object2 = Bug.BugState.LOGS_READY_TO_BE_UPLOADED;
                        v0.bug.setBugState((Bug.BugState)((Object)object2));
                        IBGContentValues iBGContentValues2 = iBGContentValues;
                        iBGContentValues = new IBGContentValues();
                        if (pair != null) {
                            object = BugTable.getCOLUMN_TEMPORARY_SERVER_TOKEN();
                            iBGContentValues2.put((String)object.component1(), pair, ((Boolean)object.component2()).booleanValue());
                        }
                        Bug.BugState bugState = object2;
                        pair = BugTable.getCOLUMN_BUG_STATE();
                        object2 = (String)pair.component1();
                        object = bugState.name();
                        iBGContentValues2.put((String)object2, object, ((Boolean)pair.component2()).booleanValue());
                        if (bug2.bug.getId() != null) {
                            ServiceLocator.getBugReportsDbHelper().update(bug2.bug.getId(), iBGContentValues2);
                        }
                        1 v3 = bug2;
                        configurationProvider.setLastBugRequestStartedAt(0L);
                        1 v4 = bug2;
                        Bug bug2 = v4.bug;
                        v3.InstabugBugsUploaderJob.this.uploadBugLogs(bug2, v4.context);
                        v3.InstabugBugsUploaderJob.this.onBugUploaded();
                    }

                    public void onFailed(Throwable throwable) {
                        if (throwable instanceof RateLimitedException) {
                            1 v0 = this;
                            Bug bug2 = v0.bug;
                            InstabugBugsUploaderJob.handleRateLimitedException((RateLimitedException)throwable, bug2, v0.context);
                        } else {
                            InstabugSDKLogger.e((String)"IBG-BR", (String)"Something went wrong while uploading bug");
                        }
                        ReportUploadingStateEventBus.INSTANCE.postError(throwable);
                        InstabugBugsUploaderJob.handleNetworkFailure(throwable);
                        InstabugBugsUploaderJob.updateBugConnectionErrorIfNeeded(bug, throwable);
                    }

                    public void onDisconnected() {
                        ServiceLocator.getBugReportsDbHelper().updateConnectionError(bug.getId(), "Disconnected");
                    }

                    public void onRetrying(Throwable throwable) {
                        InstabugBugsUploaderJob.updateBugConnectionErrorIfNeeded(bug, throwable);
                    }
                };
                BugsService.getInstance().reportBug(context, bug, (Request.Callbacks<String, Throwable>)object);
                continue;
            }
            if (((Object)((Object)bug.getBugState())).equals((Object)Bug.BugState.LOGS_READY_TO_BE_UPLOADED)) {
                InstabugSDKLogger.v((String)"IBG-BR", (String)("Bug: " + bug + " already uploaded but has unsent logs, uploading now"));
                this.uploadBugLogs(bug, context);
                continue;
            }
            if (!((Object)((Object)bug.getBugState())).equals((Object)Bug.BugState.ATTACHMENTS_READY_TO_BE_UPLOADED)) continue;
            InstabugSDKLogger.v((String)"IBG-BR", (String)("Bug: " + bug + " already uploaded but has unsent attachments, uploading now"));
            this.uploadAttachments(bug, context);
        }
    }

    private static void handleRateLimitedException(RateLimitedException rateLimitedException, @NonNull Bug bug, Context context) {
        configurationProvider.setBugReportingLimitedUntil(rateLimitedException.getPeriod());
        InstabugBugsUploaderJob.logRateIsLimited();
        DeleteBugsUtilKt.deleteBug(bug, context);
    }

    private static void logRateIsLimited() {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "Bug Reporting";
        InstabugSDKLogger.d((String)"IBG-BR", (String)String.format("You've reached the maximum number of requests in %s. You can read more about our rate limiting policy at this link: https://docs.instabug.com/docs/rate-limits", objectArray2));
    }

    private void uploadBugLogs(final Bug bug, final Context context) {
        Request.Callbacks<Boolean, Throwable> callbacks;
        InstabugSDKLogger.v((String)"IBG-BR", (String)("START uploading all logs related to this bug id = " + bug.getId()));
        Request.Callbacks<Boolean, Throwable> callbacks2 = callbacks;
        callbacks = new Request.Callbacks<Boolean, Throwable>(){

            public void onSucceeded(@Nullable Boolean object) {
                IBGContentValues iBGContentValues;
                InstabugSDKLogger.v((String)"IBG-BR", (String)"Bug logs uploaded successfully, change its state");
                if (bug2.bug.getId() == null) {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)"Couldn't update the bug's state because its ID is null");
                    return;
                }
                2 v0 = bug2;
                object = Bug.BugState.ATTACHMENTS_READY_TO_BE_UPLOADED;
                v0.bug.setBugState((Bug.BugState)((Object)object));
                Pair<String, Boolean> pair = BugTable.getCOLUMN_BUG_STATE();
                IBGContentValues iBGContentValues2 = iBGContentValues;
                Boolean bl = object;
                iBGContentValues2();
                object = (String)pair.component1();
                String string2 = ((Enum)((Object)bl)).name();
                iBGContentValues.put((String)object, string2, ((Boolean)pair.component2()).booleanValue());
                ServiceLocator.getBugReportsDbHelper().update(bug2.bug.getId(), iBGContentValues2);
                InstabugBugsUploaderJob instabugBugsUploaderJob = v0.InstabugBugsUploaderJob.this;
                2 v4 = bug2;
                2 v5 = v4;
                Bug bug2 = v4.bug;
                try {
                    instabugBugsUploaderJob.uploadAttachments(bug2, v5.context);
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)("Something went wrong while uploading bug attachments e: " + exception.getMessage()));
                    InstabugBugsUploaderJob.handleNetworkFailure(exception);
                }
            }

            public void onFailed(Throwable throwable) {
                InstabugSDKLogger.d((String)"IBG-BR", (String)"Something went wrong while uploading bug logs");
                ReportUploadingStateEventBus.INSTANCE.postError(new Exception("Something went wrong while uploading bug logs"));
                InstabugBugsUploaderJob.handleNetworkFailure(throwable);
            }
        };
        BugsService.getInstance().uploadBugLogs(bug, callbacks2);
    }

    private static void updateBugConnectionErrorIfNeeded(Bug bug, Throwable object) {
        if (bug.getConnectionError() == null && object instanceof IOException) {
            object = object.getClass().getName();
            ServiceLocator.getBugReportsDbHelper().updateConnectionError(bug.getId(), (String)object);
            bug.setConnectionError((String)object);
        }
    }

    private void uploadAttachments(final Bug bug, final Context context) {
        Request.Callbacks<Boolean, Throwable> callbacks;
        InstabugSDKLogger.v((String)"IBG-BR", (String)("Found " + bug.getAttachments().size() + " attachments related to bug: " + bug.getMessage()));
        Request.Callbacks<Boolean, Throwable> callbacks2 = callbacks;
        callbacks = new Request.Callbacks<Boolean, Throwable>(){

            public void onSucceeded(@Nullable Boolean bl) {
                InstabugSDKLogger.d((String)"IBG-BR", (String)"Bug attachments uploaded successfully");
                bl = context;
                if (bl != null) {
                    DeleteBugsUtilKt.deleteBugAndStateFile(bug, (Context)bl);
                } else {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)("unable to delete state file for Bug with id: " + bug.getId() + "due to null context reference"));
                }
            }

            public void onFailed(Throwable throwable) {
                InstabugSDKLogger.d((String)"IBG-BR", (String)"Something went wrong while uploading bug attachments");
                ReportUploadingStateEventBus.INSTANCE.postError(new Exception("Something went wrong while uploading bug attachments"));
                InstabugBugsUploaderJob.handleNetworkFailure(throwable);
            }
        };
        BugsService.getInstance().uploadBugAttachments(bug, callbacks2);
    }

    public static void handleNetworkFailure(Throwable throwable) {
        if (throwable instanceof IOException) {
            continueUploadBugs = false;
        }
    }

    protected abstract List<Bug> getBugs(Context var1);

    protected abstract void onBugUploaded();

    public void start() {
        InstabugBugsUploaderJob instabugBugsUploaderJob = instabugBugsUploaderJob2;
        InstabugBugsUploaderJob instabugBugsUploaderJob2 = exception -> InstabugSDKLogger.e((String)"IBG-BR", (String)"Error occurred while uploading bugs", (Throwable)exception);
        instabugBugsUploaderJob.enqueueRetryingJob("InstabugBugsUploaderJob", () -> {
            if (Instabug.getApplicationContext() != null) {
                this.uploadBugs(Instabug.getApplicationContext());
            } else {
                InstabugSDKLogger.d((String)"IBG-BR", (String)"Context was null during Bugs syncing");
            }
        }, (InstabugNetworkJob.JobErrorCallback)instabugBugsUploaderJob2);
    }
}

