/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.invocation.invocationdialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.instabug.bug.R;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogAction;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogActivityContract$AnimationProvider;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogAdapter;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogFragmentContract$View;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogFragmentPresenter;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogItem;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.DrawableUtils;
import com.instabug.library.util.ListUtils;
import com.instabug.library.util.ThemeApplier;
import com.instabug.library.view.ViewUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InstabugDialogFragment
extends InstabugBaseFragment<InstabugDialogFragmentPresenter>
implements InstabugDialogFragmentContract$View,
AdapterView.OnItemClickListener {
    @Nullable
    private TextView titleTextView;
    @Nullable
    private InstabugDialogAdapter promptOptionsAdapter;
    @Nullable
    private ArrayList<InstabugDialogItem> dialogItems;
    @Nullable
    private InstabugDialogAction chatsListAction = null;
    @Nullable
    private Callbacks listener;
    @Nullable
    private InstabugDialogActivityContract$AnimationProvider animationProvider;
    @Nullable
    private ListView promptOptionsListView;

    public static InstabugDialogFragment newInstance(@Nullable String string2, boolean bl, @Nullable ArrayList<InstabugDialogItem> arrayList) {
        Bundle bundle;
        InstabugDialogFragment instabugDialogFragment = new InstabugDialogFragment();
        Bundle bundle2 = bundle;
        new Bundle().putString("dialog_title", string2);
        bundle2.putBoolean("dialog_should_override_title_desc", bl);
        bundle2.putSerializable("dialog_items", arrayList);
        instabugDialogFragment.setArguments(bundle2);
        return instabugDialogFragment;
    }

    private void setChatsListAction(@NonNull List<InstabugDialogItem> list) {
        ArrayList<InstabugDialogItem> arrayList;
        ArrayList<InstabugDialogItem> arrayList2 = arrayList;
        arrayList2(list);
        this.dialogItems = arrayList2;
        Collections.copy(arrayList, list);
        int n = -1;
        for (int i = 0; i < this.dialogItems.size(); ++i) {
            if (!(this.dialogItems.get(i) instanceof InstabugDialogAction)) continue;
            n = i;
            break;
        }
        if (n != -1) {
            this.chatsListAction = (InstabugDialogAction)this.dialogItems.remove(n);
        }
    }

    private void resizeDialog(View view) {
        if (this.getActivity() != null) {
            DisplayMetrics displayMetrics;
            WindowManager windowManager = (WindowManager)this.getActivity().getSystemService("window");
            DisplayMetrics displayMetrics2 = displayMetrics;
            displayMetrics = new DisplayMetrics();
            if (windowManager != null) {
                windowManager.getDefaultDisplay().getMetrics(displayMetrics2);
            }
            windowManager = Instabug.getApplicationContext();
            if (this.dialogItems != null && windowManager != null && ViewUtils.convertDpToPx((Context)windowManager, (float)56.0f) * this.dialogItems.size() + ViewUtils.convertDpToPx((Context)windowManager, (float)200.0f) > displayMetrics2.heightPixels) {
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, displayMetrics2.heightPixels - ViewUtils.convertDpToPx((Context)windowManager, (float)110.0f));
                layoutParams.addRule(13);
                view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
    }

    private InstabugDialogFragmentPresenter createPresenter() {
        return new InstabugDialogFragmentPresenter(this);
    }

    public void onCreate(@Nullable Bundle object) {
        InstabugDialogFragment instabugDialogFragment = this;
        this.setRetainInstance(true);
        super.onCreate(object);
        if (instabugDialogFragment.presenter == null) {
            this.presenter = this.createPresenter();
        }
        object = null;
        if (this.getArguments() != null) {
            object = (ArrayList)this.getArguments().getSerializable("dialog_items");
        }
        if (object != null) {
            this.setChatsListAction((List<InstabugDialogItem>)object);
        }
    }

    public void onDestroyView() {
        InstabugDialogFragment instabugDialogFragment = this;
        instabugDialogFragment.playExitAnimation();
        instabugDialogFragment.titleTextView = null;
        instabugDialogFragment.promptOptionsListView = null;
        instabugDialogFragment.promptOptionsAdapter = null;
        super.onDestroyView();
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof Callbacks && context instanceof InstabugDialogActivityContract$AnimationProvider) {
            this.listener = (Callbacks)context;
            this.animationProvider = (InstabugDialogActivityContract$AnimationProvider)context;
            return;
        }
        throw new RuntimeException(context.toString() + " must implement InstabugDialogFragment.Callbacks and AnimationProvider");
    }

    public void onDetach() {
        super.onDetach();
        this.listener = null;
        this.animationProvider = null;
    }

    protected int getLayout() {
        return R.layout.ib_core_lyt_dialog_fragment;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    protected void initViews(View view2, @Nullable Bundle object2) {
        view2 = this.findViewById(R.id.instabug_main_prompt_container);
        if (view2 != null && this.getContext() != null) {
            this.resizeDialog(view2);
            DrawableUtils.setColor((View)view2, (int)AttrResolver.resolveAttributeColor((Context)this.getContext(), (int)R.attr.instabug_background_color));
        }
        object2 = (TextView)this.findViewById(R.id.instabug_fragment_title);
        this.titleTextView = object2;
        if (object2 != null) {
            ViewCompat.setTransitionName((View)object2, (String)"title");
            if (AccessibilityUtils.isTalkbackEnabled() && this.getArguments() != null && this.getArguments().getBoolean("dialog_should_override_title_desc")) {
                object2.setContentDescription((CharSequence)this.getLocalizedString(R.string.ibg_prompt_options_title_content_description));
            }
        }
        if (this.chatsListAction != null) {
            object2 = this.findViewById(R.id.instabug_chats_list_icon_container);
            if (object2 != null) {
                object2.setVisibility(0);
                if (this.listener != null) {
                    object2.setOnClickListener(object -> {
                        Callbacks callbacks;
                        object = viewArray.chatsListAction;
                        if (object != null && (callbacks = viewArray.listener) != null) {
                            callbacks.removeScreenshotIfNeeded((InstabugDialogItem)object);
                            InstabugDialogFragment instabugDialogFragment = viewArray;
                            View[] viewArray = instabugDialogFragment.chatsListAction;
                            object = instabugDialogFragment.findViewById(R.id.instabug_main_prompt_container);
                            callbacks = instabugDialogFragment.findViewById(R.id.instabug_pbi_container);
                            View[] viewArray2 = viewArray;
                            View[] viewArray3 = new View[2];
                            viewArray = viewArray3;
                            viewArray3[0] = object;
                            viewArray3[1] = callbacks;
                            viewArray.listener.onDialogItemClicked((InstabugDialogItem)viewArray2, viewArray);
                        }
                    });
                }
            }
            if ((object2 = (ImageView)this.findViewById(R.id.instabug_chats_list_icon)) != null) {
                object2.getDrawable().setColorFilter(SettingsManager.getInstance().getPrimaryColor(), PorterDuff.Mode.SRC_IN);
            }
            object2 = (TextView)this.findViewById(R.id.instabug_notification_count);
            if (this.chatsListAction.getBadgeCount() > 0) {
                Drawable drawable2;
                if (object2 != null) {
                    Bundle bundle = object2;
                    bundle.setVisibility(0);
                    Integer n = this.chatsListAction.getBadgeCount();
                    Drawable drawable3 = new Object[1];
                    drawable2 = drawable3;
                    drawable3[0] = n;
                    bundle.setContentDescription((CharSequence)this.getLocalizedString(R.string.ibg_prompt_options_notification_count_content_description, (Object[])drawable2));
                }
                int n = this.getResources().getColor(R.color.ib_core_notification_dot_color);
                if (object2 != null && this.getContext() != null) {
                    drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ibg_core_bg_white_oval);
                    Drawable drawable4 = null;
                    if (drawable2 != null) {
                        drawable4 = Colorizer.getTintedDrawable((int)n, (Drawable)drawable2);
                    }
                    object2.setBackgroundDrawable(drawable4);
                }
                if (object2 != null) {
                    object2.setText((CharSequence)String.valueOf(this.chatsListAction.getBadgeCount()));
                }
            } else if (object2 != null) {
                object2.setVisibility(8);
            }
        }
        object2 = (ListView)this.findViewById(R.id.instabug_prompt_options_list_view);
        this.promptOptionsListView = object2;
        if (object2 != null) {
            InstabugDialogAdapter instabugDialogAdapter;
            InstabugDialogAdapter instabugDialogAdapter2;
            Bundle bundle = object2;
            bundle.setOnItemClickListener((AdapterView.OnItemClickListener)this);
            this.promptOptionsAdapter = instabugDialogAdapter2 = instabugDialogAdapter;
            bundle.setAdapter((ListAdapter)new InstabugDialogAdapter(this.theme));
            if (AccessibilityUtils.isTalkbackEnabled()) {
                AccessibilityDelegateCompat accessibilityDelegateCompat;
                Bundle bundle2 = object2;
                object2 = accessibilityDelegateCompat;
                accessibilityDelegateCompat = new AccessibilityDelegateCompat(){

                    public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                        super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                        accessibilityNodeInfoCompat.addAction(new AccessibilityNodeInfoCompat.AccessibilityActionCompat(4096, (CharSequence)InstabugDialogFragment.this.getLocalizedString(R.string.ibg_prompt_options_list_view_scroll_description)));
                    }
                };
                ViewCompat.setAccessibilityDelegate((View)bundle2, (AccessibilityDelegateCompat)object2);
            }
        }
        object2 = (Button)this.findViewById(R.id.instabug_prompt_cancel_btn);
        object2.setTextColor(SettingsManager.getInstance().getPrimaryColor());
        object2.setOnClickListener(view -> this.finishActivity());
        this.showPromptOptions();
        this.playEnterAnimation();
        this.applyTheme(this.titleTextView, (Button)object2, view2);
    }

    @VisibleForTesting
    void applyTheme(@Nullable TextView textView, @Nullable Button button, View view) {
        IBGTheme iBGTheme = this.theme;
        if (iBGTheme != null) {
            ThemeApplier.applyTitleStyle((TextView)textView, (IBGTheme)iBGTheme);
            ThemeApplier.applyCtaStyle((Button)button, (IBGTheme)this.theme);
            int n = this.theme.getBackgroundColor();
            if (n != 0) {
                view.setBackgroundColor(n);
            }
        }
    }

    public void onStart() {
        InstabugDialogFragment instabugDialogFragment = instabugDialogFragment2;
        super.onStart();
        InstabugDialogFragment instabugDialogFragment2 = instabugDialogFragment.presenter;
        if (instabugDialogFragment2 != null) {
            ((InstabugDialogFragmentPresenter)((Object)instabugDialogFragment2)).onViewStarted();
        }
    }

    public void onStop() {
        InstabugDialogFragment instabugDialogFragment = instabugDialogFragment2;
        super.onStop();
        InstabugDialogFragment instabugDialogFragment2 = instabugDialogFragment.presenter;
        if (instabugDialogFragment2 != null) {
            ((InstabugDialogFragmentPresenter)((Object)instabugDialogFragment2)).onViewStopped();
        }
    }

    @Override
    public void handlePoweredByFooter() {
        InstabugDialogFragment instabugDialogFragment = instabugDialogFragment2;
        InstabugCore.handlePbiFooter((View)instabugDialogFragment.rootView);
        InstabugDialogFragment instabugDialogFragment2 = instabugDialogFragment.findViewById(R.id.instabug_pbi_container);
        if (instabugDialogFragment2 != null && instabugDialogFragment2.getVisibility() == 0 && AccessibilityUtils.isTalkbackEnabled()) {
            ViewCompat.setImportantForAccessibility((View)instabugDialogFragment2, (int)4);
        }
    }

    @Override
    public void showTitle() {
        TextView textView = this.titleTextView;
        if (textView != null && this.getArguments() != null && this.getArguments().getString("dialog_title") != null) {
            textView.setText((CharSequence)this.getArguments().getString("dialog_title"));
        }
    }

    public void showPromptOptions() {
        ArrayList<InstabugDialogItem> arrayList = this.dialogItems;
        if (arrayList != null && this.promptOptionsAdapter != null && arrayList.size() > 0) {
            InstabugDialogFragment instabugDialogFragment = this;
            instabugDialogFragment.promptOptionsAdapter.setPluginPromptOptions(this.dialogItems);
            instabugDialogFragment.promptOptionsAdapter.notifyDataSetChanged();
        }
    }

    public void playEnterAnimation() {
        Context context = this.getContext();
        if (context != null && this.animationProvider != null) {
            View view = this.findViewById(R.id.layout_title_container);
            if (view != null) {
                Animation animation = AnimationUtils.loadAnimation((Context)context, (int)this.animationProvider.getEnterAnimation());
                animation.setStartOffset(100L);
                view.setAnimation(animation);
            }
            if ((view = this.promptOptionsListView) != null) {
                context = AnimationUtils.loadAnimation((Context)context, (int)this.animationProvider.getEnterAnimation());
                context.setStartOffset(100L);
                context.setAnimationListener(new Animation.AnimationListener(){
                    final /* synthetic */ ListView val$listView;
                    {
                        this.val$listView = listView;
                    }

                    public void onAnimationStart(Animation animation) {
                        this.val$listView.setVerticalScrollBarEnabled(false);
                    }

                    public void onAnimationEnd(Animation animation) {
                        this.val$listView.setVerticalScrollBarEnabled(true);
                    }

                    public void onAnimationRepeat(Animation animation) {
                    }
                });
                if (Build.VERSION.SDK_INT >= 16) {
                    view.setScrollBarDefaultDelayBeforeFade(0);
                }
                view.setAnimation((Animation)context);
            }
        }
    }

    public void playExitAnimation() {
        Context context = this.getContext();
        if (context != null && this.animationProvider != null) {
            View view = this.findViewById(R.id.layout_title_container);
            if (view != null) {
                view.setAnimation(AnimationUtils.loadAnimation((Context)context, (int)this.animationProvider.getExitAnimation()));
            }
            if ((view = this.promptOptionsListView) != null) {
                Animation animation = AnimationUtils.loadAnimation((Context)context, (int)this.animationProvider.getExitAnimation());
                animation.setAnimationListener(new Animation.AnimationListener(){
                    final /* synthetic */ ListView val$listView;
                    {
                        this.val$listView = listView;
                    }

                    public void onAnimationStart(Animation animation) {
                        this.val$listView.setVerticalScrollBarEnabled(false);
                    }

                    public void onAnimationEnd(Animation animation) {
                        this.val$listView.setVerticalScrollBarEnabled(true);
                    }

                    public void onAnimationRepeat(Animation animation) {
                    }
                });
                view.setAnimation(animation);
            }
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void onItemClick(AdapterView<?> object, View view, int n, long l) {
        object = viewArray.promptOptionsListView;
        if (object != null) {
            object.setOnItemClickListener(null);
        }
        if ((object = viewArray.listener) != null) {
            Object object2 = object;
            InstabugDialogFragment instabugDialogFragment = viewArray;
            View[] viewArray = (InstabugDialogItem)ListUtils.safeGet(instabugDialogFragment.dialogItems, (int)n);
            object = instabugDialogFragment.findViewById(R.id.instabug_main_prompt_container);
            view = instabugDialogFragment.findViewById(R.id.instabug_pbi_container);
            View[] viewArray2 = viewArray;
            View[] viewArray3 = new View[2];
            viewArray = viewArray3;
            viewArray3[0] = object;
            viewArray3[1] = view;
            object2.onDialogItemClicked((InstabugDialogItem)viewArray2, viewArray);
        }
    }

    static interface Callbacks {
        public void onDialogItemClicked(@Nullable InstabugDialogItem var1, View ... var2);

        public void removeScreenshotIfNeeded(InstabugDialogItem var1);
    }
}

