/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.invocation;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.invocation.InvocationManagerSubscribers;
import com.instabug.bug.invocation.InvocationManagerSubscribersImpl;
import com.instabug.bug.invocation.InvocationRequestListenerImp;
import com.instabug.bug.invocation.InvocationSettings;
import com.instabug.bug.invocation.invoker.AbstractInvoker;
import com.instabug.bug.invocation.invoker.FloatingButtonInvoker;
import com.instabug.bug.invocation.invoker.ScreenshotCaptorRegistry;
import com.instabug.bug.invocation.invoker.ScreenshotGestureInvoker;
import com.instabug.bug.invocation.invoker.ShakeInvoker;
import com.instabug.bug.invocation.invoker.ThreeFingerSwipeLeftInvoker;
import com.instabug.bug.invocation.invoker.TwoFingerSwipeLeftInvoker;
import com.instabug.bug.invocation.util.AtomicArray;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.ActivityLifecycleSubscriber;
import com.instabug.library.core.eventbus.DefaultActivityLifeCycleEventHandler;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationManagerContract;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class InvocationManager
implements DefaultActivityLifeCycleEventHandler,
InvocationManagerContract {
    private static InvocationManager INSTANCE;
    private InvocationSettings currentInvocationSettings;
    private AtomicReferenceArray<InstabugInvocationEvent> currentInstabugInvocationEvents;
    private List<AbstractInvoker> currentInvokersList;
    @Nullable
    private AtomicReferenceArray<AbstractInvoker> currentInvokers;
    @Nullable
    private AtomicReference<AbstractInvoker> lastUsedInvoker;
    @VisibleForTesting
    @Nullable
    ActivityLifecycleSubscriber currentActivityLifeCycleSubscriber;
    private final InvocationManagerSubscribers invocationManagerSubscribers;
    private AtomicBoolean isInvocationAvailable;
    @Nullable
    private AtomicReference<InvocationRequestListenerImp> invocationRequestListenerImp;
    private boolean hasSwipeGestureRegistered;

    private InvocationManager() {
        InvocationManager invocationManager = this;
        invocationManager.currentInvokersList = new ArrayList<AbstractInvoker>();
        invocationManager.lastUsedInvoker = new AtomicReference();
        invocationManager.currentActivityLifeCycleSubscriber = null;
        invocationManager.isInvocationAvailable = new AtomicBoolean(true);
        invocationManager.hasSwipeGestureRegistered = false;
        invocationManager.currentInvocationSettings = new InvocationSettings();
        this.currentInstabugInvocationEvents = new AtomicReferenceArray<InstabugInvocationEvent>(1);
        this.currentInstabugInvocationEvents.set(0, InstabugInvocationEvent.SHAKE);
        invocationManager.currentInvokers = new AtomicReferenceArray<AbstractInvoker>(this.createInvokersList());
        this.invocationManagerSubscribers = new InvocationManagerSubscribersImpl(this);
        this.invocationManagerSubscribers.subscribe();
        invocationManager.subscribeToCurrentActivityLifeCycle();
        invocationManager.invocationRequestListenerImp = new AtomicReference<InvocationRequestListenerImp>(new InvocationRequestListenerImp());
    }

    @NonNull
    private AbstractInvoker[] createInvokersList() {
        this.currentInvokersList = new ArrayList<AbstractInvoker>();
        return this.currentInvokersList.toArray(new AbstractInvoker[this.currentInvokersList.size()]);
    }

    public static synchronized void init() {
        if (INSTANCE == null) {
            INSTANCE = new InvocationManager();
        } else if (!SettingsManager.getInstance().isInBackground()) {
            INSTANCE.listen();
        }
    }

    public static synchronized InvocationManager getInstance() {
        if (INSTANCE == null) {
            InvocationManager.init();
        }
        return INSTANCE;
    }

    private void registerScreenshotCaptor() {
        ScreenshotCaptorRegistry screenshotCaptorRegistry = ServiceLocator.getScreenshotCaptorRegistry();
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (screenshotCaptorRegistry != null && activity != null) {
            screenshotCaptorRegistry.startSdkCaptureScreenShot(activity);
        }
    }

    private void handleSwipeEvents(MotionEvent motionEvent) {
        if (this.currentInvokers == null) {
            return;
        }
        for (int i = 0; i < this.currentInvokers.length(); ++i) {
            AbstractInvoker abstractInvoker = this.currentInvokers.get(i);
            if (!(abstractInvoker instanceof TwoFingerSwipeLeftInvoker) && !(abstractInvoker instanceof ThreeFingerSwipeLeftInvoker)) {
                continue;
            }
            abstractInvoker.handle(motionEvent);
            break;
        }
    }

    private void subscribeToCurrentActivityLifeCycle() {
        if (this.currentActivityLifeCycleSubscriber == null) {
            this.currentActivityLifeCycleSubscriber = CoreServiceLocator.createActivityLifecycleSubscriber((DefaultActivityLifeCycleEventHandler)this);
            this.currentActivityLifeCycleSubscriber.subscribe();
        }
    }

    private boolean isNotInstabugActivity(Activity activity) {
        return activity instanceof _InstabugActivity ^ true;
    }

    private boolean isPromptOptionsAvailable() {
        return this.getAvailablePromptOptions().size() > 0;
    }

    @Nullable
    private FloatingButtonInvoker getFloatingButtonInvoker() {
        FloatingButtonInvoker floatingButtonInvoker = null;
        if (this.currentInvokers != null) {
            for (int i = 0; i < this.currentInvokers.length(); ++i) {
                AbstractInvoker abstractInvoker = this.currentInvokers.get(i);
                if (!(abstractInvoker instanceof FloatingButtonInvoker)) continue;
                floatingButtonInvoker = (FloatingButtonInvoker)abstractInvoker;
                break;
            }
        }
        return floatingButtonInvoker;
    }

    public void getInvocationRequested() {
        AtomicReference<InvocationRequestListenerImp> atomicReference = this.invocationRequestListenerImp;
        if (atomicReference != null && atomicReference.get() != null) {
            this.invocationRequestListenerImp.get().onInvocationRequested();
        } else {
            InstabugSDKLogger.e((String)"IBG-Core", (String)"invocationRequestListenerImp == null ");
        }
    }

    @VisibleForTesting
    void addToCurrentInvokers(AbstractInvoker abstractInvoker) {
        this.currentInvokersList.add(abstractInvoker);
        List<AbstractInvoker> list = this.currentInvokersList;
        this.currentInvokers = new AtomicReferenceArray<AbstractInvoker>(list.toArray(new AbstractInvoker[list.size()]));
    }

    public void setInstabugInvocationEvent(InstabugInvocationEvent ... instabugInvocationEventArray) {
        if (instabugInvocationEventArray == null) {
            InstabugSDKLogger.e((String)"IBG-Core", (String)"Passed invocation events has null value, no change will take effect to the previous set invocation events");
            return;
        }
        this.currentInstabugInvocationEvents = this.removeDuplicates(instabugInvocationEventArray);
        if (this.currentInvokers != null) {
            AtomicReferenceArray<AbstractInvoker> atomicReferenceArray;
            for (int i = 0; i < this.currentInvokers.length(); ++i) {
                this.currentInvokers.get(i).sleep();
            }
            AtomicReferenceArray<AbstractInvoker> atomicReferenceArray2 = atomicReferenceArray;
            atomicReferenceArray = new AtomicReferenceArray<AbstractInvoker>(this.createInvokersList());
            this.currentInvokers = atomicReferenceArray2;
        }
        this.hasSwipeGestureRegistered = false;
        block8: for (int i = 0; i < this.currentInstabugInvocationEvents.length(); ++i) {
            Object object;
            Object object2 = this.currentInstabugInvocationEvents.get(i);
            InstabugSDKLogger.v((String)"IBG-Core", (String)("set instabug invocation event: " + object2));
            if (object2 == InstabugInvocationEvent.NONE && instabugInvocationEventArray.length == 1) {
                this.currentInvokers = null;
                break;
            }
            if (this.currentInvokers == null) {
                AtomicReferenceArray<AbstractInvoker> atomicReferenceArray;
                object = atomicReferenceArray;
                atomicReferenceArray = new AtomicReferenceArray<AbstractInvoker>(this.createInvokersList());
                this.currentInvokers = object;
            }
            object = Instabug.getApplicationContext();
            if (this.invocationRequestListenerImp == null) continue;
            switch (2.$SwitchMap$com$instabug$library$invocation$InstabugInvocationEvent[object2.ordinal()]) {
                default: {
                    continue block8;
                }
                case 5: {
                    int n = Build.VERSION.SDK_INT;
                    if (n < 34 && this.currentInvokers != null && this.invocationRequestListenerImp.get() != null) {
                        ScreenshotGestureInvoker screenshotGestureInvoker;
                        ScreenshotGestureInvoker screenshotGestureInvoker2 = screenshotGestureInvoker;
                        screenshotGestureInvoker = new ScreenshotGestureInvoker(this.invocationRequestListenerImp.get());
                        this.addToCurrentInvokers(screenshotGestureInvoker2);
                        continue block8;
                    }
                    if (n < 34) continue block8;
                    this.registerScreenshotCaptor();
                    continue block8;
                }
                case 4: {
                    if (object != null && this.invocationRequestListenerImp.get() != null) {
                        ThreeFingerSwipeLeftInvoker threeFingerSwipeLeftInvoker;
                        object2 = threeFingerSwipeLeftInvoker;
                        threeFingerSwipeLeftInvoker = new ThreeFingerSwipeLeftInvoker((Context)object, this.invocationRequestListenerImp.get());
                        if (this.currentInvokers != null) {
                            this.addToCurrentInvokers((AbstractInvoker)object2);
                        }
                        this.hasSwipeGestureRegistered = true;
                        continue block8;
                    }
                    InstabugSDKLogger.e((String)"IBG-Core", (String)"did not add ThreeFingerSwipeLeftInvoker due to null appContext");
                    continue block8;
                }
                case 3: {
                    if (object != null && this.invocationRequestListenerImp.get() != null) {
                        TwoFingerSwipeLeftInvoker twoFingerSwipeLeftInvoker;
                        object2 = twoFingerSwipeLeftInvoker;
                        twoFingerSwipeLeftInvoker = new TwoFingerSwipeLeftInvoker((Context)object, this.invocationRequestListenerImp.get());
                        if (this.currentInvokers != null) {
                            this.addToCurrentInvokers((AbstractInvoker)object2);
                        }
                        this.hasSwipeGestureRegistered = true;
                        continue block8;
                    }
                    InstabugSDKLogger.e((String)"IBG-Core", (String)"did not add TwoFingerSwipeLeftInvoker due to null appContext");
                    continue block8;
                }
                case 2: {
                    FloatingButtonInvoker floatingButtonInvoker;
                    if (this.currentInvokers == null || this.invocationRequestListenerImp.get() == null) continue block8;
                    object2 = floatingButtonInvoker;
                    floatingButtonInvoker = new FloatingButtonInvoker(this.invocationRequestListenerImp.get());
                    this.addToCurrentInvokers((AbstractInvoker)object2);
                    continue block8;
                }
                case 1: {
                    if (object != null && this.invocationRequestListenerImp.get() != null) {
                        ShakeInvoker shakeInvoker;
                        object2 = shakeInvoker;
                        new ShakeInvoker((Context)object, this.invocationRequestListenerImp.get()).setShakingThreshold(this.currentInvocationSettings.getShakeThreshold());
                        if (this.currentInvokers == null) continue block8;
                        this.addToCurrentInvokers((AbstractInvoker)object2);
                        continue block8;
                    }
                    InstabugSDKLogger.e((String)"IBG-Core", (String)"did not add ShakeInvoker due to null appContext");
                }
            }
        }
        if (this.currentInvokers != null) {
            this.setLastUsedInvoker(null);
            this.listen();
        }
    }

    @VisibleForTesting
    AtomicReferenceArray<InstabugInvocationEvent> removeDuplicates(InstabugInvocationEvent[] instabugInvocationEventArray) {
        HashSet<InstabugInvocationEvent> hashSet;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        HashSet<InstabugInvocationEvent> hashSet2 = hashSet;
        hashSet = new HashSet<InstabugInvocationEvent>();
        for (InstabugInvocationEvent instabugInvocationEvent : instabugInvocationEventArray) {
            if (hashSet2.contains(instabugInvocationEvent)) continue;
            arrayList2.add(instabugInvocationEvent);
            hashSet2.add(instabugInvocationEvent);
        }
        instabugInvocationEventArray = new InstabugInvocationEvent[arrayList2.size()];
        return new AtomicReferenceArray<InstabugInvocationEvent>(arrayList2.toArray(instabugInvocationEventArray));
    }

    @Nullable
    public InstabugInvocationEvent[] getCurrentInstabugInvocationEvents() {
        if (InstabugCore.getFeatureState((String)"BUG_REPORTING") == Feature.State.DISABLED) {
            return null;
        }
        InstabugInvocationEvent[] instabugInvocationEventArray = AtomicArray.toArray(this.currentInstabugInvocationEvents, InstabugInvocationEvent.class);
        if (instabugInvocationEventArray != null) {
            return Arrays.copyOf(instabugInvocationEventArray, this.currentInstabugInvocationEvents.length());
        }
        return null;
    }

    public InvocationSettings getCurrentInvocationSettings() {
        return this.currentInvocationSettings;
    }

    @Nullable
    List<AbstractInvoker> getCurrentInvokers() {
        AbstractInvoker[] abstractInvokerArray = AtomicArray.toArray(abstractInvokerArray.currentInvokers, AbstractInvoker.class);
        if (abstractInvokerArray == null) {
            return null;
        }
        return Arrays.asList(abstractInvokerArray);
    }

    @Nullable
    public AbstractInvoker getLastUsedInvoker() {
        AtomicReference<AbstractInvoker> atomicReference = ((InvocationManager)((Object)atomicReference)).lastUsedInvoker;
        if (atomicReference == null) {
            return null;
        }
        return (AbstractInvoker)atomicReference.get();
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void setLastUsedInvoker(@Nullable AbstractInvoker abstractInvoker) {
        AtomicReference<AbstractInvoker> atomicReference = ((InvocationManager)((Object)atomicReference)).lastUsedInvoker;
        if (atomicReference != null) {
            atomicReference.set(abstractInvoker);
        }
    }

    public void listen() {
        if (Instabug.isEnabled() && this.isInvocationAvailable.get() && this.isPromptOptionsAvailable() && this.currentInvokers != null && InstabugCore.getTargetActivity() != null && InstabugCore.getRunningSession() != null && !SettingsManager.getInstance().isProcessingForeground()) {
            for (int i = 0; i < this.currentInvokers.length(); ++i) {
                AbstractInvoker abstractInvoker = this.currentInvokers.get(i);
                if (abstractInvoker.isActive()) continue;
                abstractInvoker.listen();
            }
        }
    }

    public void handle(MotionEvent motionEvent) {
        if (!this.hasSwipeGestureRegistered) {
            return;
        }
        if (InstabugStateProvider.getInstance().getState().equals(InstabugState.ENABLED) && InstabugCore.isForegroundNotBusy()) {
            this.handleSwipeEvents(motionEvent);
        }
    }

    public void sleep() {
        if (this.currentInvokers != null) {
            for (int i = 0; i < this.currentInvokers.length(); ++i) {
                AbstractInvoker abstractInvoker = this.currentInvokers.get(i);
                if (!abstractInvoker.isActive()) continue;
                abstractInvoker.sleep();
            }
        }
    }

    public void switchOffInvocation() {
        this.isInvocationAvailable.set(false);
    }

    public void switchOnInvocation() {
        this.isInvocationAvailable.set(true);
    }

    public ArrayList<PluginPromptOption> getAvailablePromptOptions() {
        return InstabugCore.getPluginsPromptOptions();
    }

    public void handleActivityStarted() {
        PoolProvider.postOrderedIOTask((String)"invocation_lifecycle_ops_exec", () -> {
            ScreenshotCaptorRegistry screenshotCaptorRegistry = ServiceLocator.getScreenshotCaptorRegistry();
            Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
            if (screenshotCaptorRegistry != null && activity != null && this.isNotInstabugActivity(activity)) {
                screenshotCaptorRegistry.startSdkCaptureScreenShot(activity);
            }
        });
    }

    public void handleActivityResumed() {
        PoolProvider.postOrderedIOTask((String)"invocation_lifecycle_ops_exec", this::listen);
    }

    public void handleActivityPaused() {
        PoolProvider.postOrderedIOTask((String)"invocation_lifecycle_ops_exec", this::sleep);
    }

    public void handleActivityStopped() {
        PoolProvider.postOrderedIOTask((String)"invocation_lifecycle_ops_exec", () -> {
            ScreenshotCaptorRegistry screenshotCaptorRegistry = ServiceLocator.getScreenshotCaptorRegistry();
            Activity activity = InstabugInternalTrackingDelegate.getInstance().getLastStoppedActivity();
            if (screenshotCaptorRegistry != null && activity != null && this.isNotInstabugActivity(activity)) {
                screenshotCaptorRegistry.stopSdkCaptureScreenShot(activity);
            }
        });
    }

    public void notifyPrimaryColorChanged() {
        if (Instabug.isEnabled() && this.currentInvokers != null) {
            for (int i = 0; i < this.currentInvokers.length(); ++i) {
                final AbstractInvoker abstractInvoker = this.currentInvokers.get(i);
                if (InstabugCore.getTargetActivity() == null || !(abstractInvoker instanceof FloatingButtonInvoker)) continue;
                PoolProvider.postMainThreadTask((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        1 v0 = this;
                        v0.abstractInvoker.sleep();
                        v0.abstractInvoker.listen();
                    }
                });
            }
        }
    }

    public void notifyInvocationOptionChanged() {
        InvocationManager invocationManager = this;
        boolean bl = invocationManager.isPromptOptionsAvailable();
        FloatingButtonInvoker floatingButtonInvoker = invocationManager.getFloatingButtonInvoker();
        if (floatingButtonInvoker != null) {
            if (!bl) {
                floatingButtonInvoker.sleep();
            } else {
                floatingButtonInvoker.updateButtonLocation();
            }
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void show() {
        AtomicReference<Object> atomicReference;
        AtomicReference<InvocationRequestListenerImp> atomicReference2 = ((InvocationManager)((Object)atomicReference3)).invocationRequestListenerImp;
        if (atomicReference2 != null && atomicReference2.get() != null) {
            ((InvocationManager)((Object)atomicReference3)).invocationRequestListenerImp.get().onInvocationRequested();
        }
        InvocationManager invocationManager = atomicReference3;
        AtomicReference<Object> atomicReference3 = atomicReference;
        atomicReference = new AtomicReference<Object>(null);
        invocationManager.lastUsedInvoker = atomicReference3;
    }

    public void invoke(int n) {
        InstabugSDKLogger.d((String)"IBG-Core", (String)("[InvocationManager#invoke] Invoking with mode: " + n));
        AtomicReference<InvocationRequestListenerImp> atomicReference = this.invocationRequestListenerImp;
        if (atomicReference != null && atomicReference.get() != null) {
            InstabugSDKLogger.d((String)"IBG-Core", (String)"[InvocationManager#invoke] InvocationRequestListener is not null, proceeding ...");
            this.invocationRequestListenerImp.get().invokeWithMode(n);
        }
    }

    public boolean fabBoundsContain(int n, int n2) {
        if (this.currentInvokers != null) {
            for (int i = 0; i < this.currentInvokers.length(); ++i) {
                AbstractInvoker abstractInvoker = this.currentInvokers.get(i);
                if (!(abstractInvoker instanceof FloatingButtonInvoker)) continue;
                return ((FloatingButtonInvoker)abstractInvoker).getButtonBounds().contains(n, n2);
            }
        }
        return false;
    }

    public boolean isInvocationEventScreenShot() {
        if (this.currentInstabugInvocationEvents == null) {
            return false;
        }
        if (!InstabugStateProvider.getInstance().getState().equals(InstabugState.DISABLED)) {
            for (int i = 0; i < this.currentInstabugInvocationEvents.length(); ++i) {
                if (!InstabugInvocationEvent.SCREENSHOT.equals(this.currentInstabugInvocationEvents.get(i))) continue;
                return true;
            }
        }
        return false;
    }
}

