/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.internal.video.customencoding;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.instabug.bug.internal.video.BugsVideoUtils;
import com.instabug.bug.settings.BugSettings;
import com.instabug.library.internal.video.customencoding.VideoEncoderConfig;
import com.instabug.library.util.InstabugSDKLogger;

@TargetApi(value=21)
public class VideoEncodeConfig {
    private final int width;
    private final int height;
    private final int density;
    private final String codecName;
    @Nullable
    private MediaCodecInfo mVideoCodecInfo;

    public VideoEncodeConfig(int n, int n2, int n3) {
        int n4 = n2;
        int n5 = n;
        n = 0;
        n2 = 0;
        double d = n5;
        double d2 = n4;
        double[] dArray = this.getDimensInBounded(d, d2);
        if (dArray != null && dArray.length >= 2) {
            n = (int)dArray[0];
            n2 = (int)dArray[1];
        } else {
            InstabugSDKLogger.e((String)"IBG-Core", (String)"Invalid dimensions retrieved");
        }
        this.width = n;
        this.height = n2;
        this.density = n3;
        Object object = this.getVideoCodecInfo("video/avc");
        object = object != null ? object.getName() : "";
        this.codecName = object;
    }

    @Nullable
    private MediaCodecInfo getVideoCodecInfo(String string2) {
        if (string2 == null) {
            return null;
        }
        if (this.mVideoCodecInfo == null) {
            this.mVideoCodecInfo = this.findEncodersByType("video/avc");
        }
        return this.mVideoCodecInfo;
    }

    @Nullable
    private MediaCodecInfo findEncodersByType(String string2) {
        for (MediaCodecInfo mediaCodecInfo : new MediaCodecList(1).getCodecInfos()) {
            if (!mediaCodecInfo.isEncoder()) continue;
            try {
                if (mediaCodecInfo.getCapabilitiesForType(string2) == null) continue;
                return mediaCodecInfo;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                InstabugSDKLogger.e((String)"IBG-Core", (String)("IllegalArgumentException" + illegalArgumentException.getMessage()));
            }
        }
        return null;
    }

    @Size(value=2L)
    @Nullable
    private double[] getDimensInBounded(double d, double d2) {
        if ((object = ((VideoEncodeConfig)object).getVideoCodecInfo("video/avc")) != null && (object = object.getCapabilitiesForType("video/avc").getVideoCapabilities()) != null) {
            Integer n = (Integer)object.getSupportedWidths().getUpper();
            Object object = (Integer)object.getSupportedHeights().getUpper();
            if (n != null && object != null) {
                double d3 = n.intValue();
                double d4 = ((Integer)object).intValue();
                return BugsVideoUtils.getDimensInBounded(d, d2, d3, d4);
            }
        }
        return new double[]{0.0, 0.0};
    }

    MediaFormat toFormat() {
        MediaFormat mediaFormat;
        int n;
        VideoEncoderConfig videoEncoderConfig = BugSettings.getVideoEncoderConfig();
        InstabugSDKLogger.d((String)"IBG-Core", (String)("Custom Video Encoder Config: " + videoEncoderConfig));
        if (videoEncoderConfig != null) {
            VideoEncoderConfig videoEncoderConfig2 = videoEncoderConfig;
            int n2 = videoEncoderConfig2.getWidth();
            n = videoEncoderConfig2.getHeight() / 16 * 16;
            mediaFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)n2, (int)n);
        } else {
            VideoEncodeConfig videoEncodeConfig = this;
            int n3 = videoEncodeConfig.width;
            n = videoEncodeConfig.height / 16 * 16;
            mediaFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)n3, (int)n);
        }
        String string2 = "color-format";
        int n4 = videoEncoderConfig != null ? videoEncoderConfig.getColorFormat() : 2130708361;
        mediaFormat.setInteger(string2, n4);
        string2 = "bitrate";
        n4 = videoEncoderConfig != null ? videoEncoderConfig.getBitrate() : 8000000;
        mediaFormat.setInteger(string2, n4);
        string2 = "frame-rate";
        n4 = videoEncoderConfig != null ? videoEncoderConfig.getFrameRate() : 30;
        mediaFormat.setInteger(string2, n4);
        string2 = "i-frame-interval";
        int n5 = videoEncoderConfig != null ? videoEncoderConfig.getIFrameInterval() : 5;
        MediaFormat mediaFormat2 = mediaFormat;
        mediaFormat2.setInteger(string2, n5);
        return mediaFormat2;
    }

    @NonNull
    public String toString() {
        return "VideoEncodeConfig{width=" + this.width + ", height=" + this.height + ", bitrate=" + 8000000 + ", framerate=" + 30 + ", iframeInterval=" + 5 + ", codecName='" + this.getCodecName() + '\'' + ", mimeType='" + "video/avc" + '\'' + '}';
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDensity() {
        return this.density / 4;
    }

    public String getCodecName() {
        VideoEncoderConfig videoEncoderConfig = BugSettings.getVideoEncoderConfig();
        return videoEncoderConfig != null ? videoEncoderConfig.getCodec() : this.codecName;
    }
}

