/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.internal.video;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.os.Parcelable;
import android.widget.Toast;
import androidx.annotation.Nullable;
import com.instabug.bug.internal.video.InternalScreenRecordHelper;
import com.instabug.bug.internal.video.ScreenRecordingSession;
import com.instabug.bug.internal.video.customencoding.ScreenRecorder;
import com.instabug.bug.utils.PermissionsUtils;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library.R;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.core.eventbus.InstabugStateEventBus;
import com.instabug.library.core.eventbus.ScreenRecordingEventBus;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.internal.InstabugMediaProjectionIntent;
import com.instabug.library.internal.video.ScreenRecordingEvent;
import com.instabug.library.internal.video.ScreenRecordingServiceAction;
import com.instabug.library.internal.video.ServiceUtils;
import com.instabug.library.model.session.SessionState;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.NotificationUtils;
import com.instabug.library.util.threading.PoolProvider;
import io.reactivexport.disposables.Disposable;
import io.reactivexport.functions.Consumer;

public class ScreenRecordingService
extends Service
implements ComponentCallbacks2 {
    private Disposable sessionDisposable;
    private Disposable sdkStateDisposable;
    @Nullable
    private ScreenRecordingSession recordingSession;
    private boolean isManualRecording;
    private final ScreenRecordingSession.Listener listener;
    private final ScreenRecorder.Callback startRecordingCallBack;
    @Nullable
    private Disposable manualScreenRecordingDisposable;
    @Nullable
    private Disposable autoScreenRecordingDisposable;

    public ScreenRecordingService() {
        ScreenRecorder.Callback callback;
        ScreenRecordingSession.Listener listener;
        Object object = listener;
        listener = new ScreenRecordingSession.Listener(){

            @Override
            public void onStart() {
            }

            @Override
            public void onStop() {
            }

            @Override
            public void onError() {
                if (ScreenRecordingService.this.isManualRecording) {
                    InternalScreenRecordHelper.getInstance().onRecordingError();
                }
            }

            @Override
            public void onEnd() {
                1 v0 = this;
                v0.ScreenRecordingService.this.stopForeground(true);
                v0.ScreenRecordingService.this.stopSelf();
            }
        };
        this.listener = object;
        object = callback;
        callback = new ScreenRecorder.Callback(){

            @Override
            public void onStop(@Nullable Throwable throwable) {
                if (throwable != null) {
                    InstabugSDKLogger.e((String)"ScreenRecordingService", (String)"Error while stopping screen recorder", (Throwable)throwable);
                }
                if (ScreenRecordingService.this.recordingSession != null && throwable != null) {
                    ScreenRecordingService.this.recordingSession.deleteVideoFile();
                }
                if (ScreenRecordingService.this.isManualRecording) {
                    if (ScreenRecordingService.this.recordingSession != null && throwable == null) {
                        ScreenRecordingService.this.recordingSession.hold();
                    }
                    InternalScreenRecordHelper.getInstance().onRecordingFinished();
                    PoolProvider.postMainThreadTask(() -> {
                        InternalScreenRecordHelper.getInstance().release();
                        if (throwable != null) {
                            Toast.makeText((Context)ScreenRecordingService.this, (int)R.string.instabug_str_recording_video_error, (int)0).show();
                        }
                    });
                }
                2 v0 = this;
                v0.ScreenRecordingService.this.listener.onEnd();
                v0.ScreenRecordingService.this.stopForeground(true);
                v0.ScreenRecordingService.this.stopSelf();
            }

            @Override
            public void onStart() {
            }

            @Override
            public void onRecording(long l) {
            }
        };
        this.startRecordingCallBack = object;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static Intent newIntent(Context context, int n, @Nullable Intent intent, boolean bl) {
        Intent intent2 = new Intent(context, ScreenRecordingService.class);
        intent2.putExtra("result-code", n);
        intent2.putExtra("is.manual.screen.recording", bl);
        intent2.putExtra("data", (Parcelable)intent);
        return intent2;
    }

    public static void startScreenRecordingService(Context context, Intent intent) {
        if (Build.VERSION.SDK_INT < 29) {
            context.startService(intent);
        } else if (PermissionsUtils.isPermissionGranted(context, "android.permission.FOREGROUND_SERVICE") && InstabugMediaProjectionIntent.isMediaProjectionIntentReadyToUse()) {
            context.startForegroundService(intent);
        } else {
            ScreenRecordingEventBus.getInstance().post((Object)new ScreenRecordingEvent(4, null));
        }
    }

    private void subscribeToSessionEvents() {
        Disposable disposable = this.sessionDisposable;
        if (disposable == null || disposable.isDisposed()) {
            this.sessionDisposable = SessionStateEventBus.getInstance().subscribe(sessionState -> {
                if (Instabug.getApplicationContext() != null && sessionState == SessionState.FINISH && ServiceUtils.isServiceRunningInForeground((Context)this.getApplicationContext(), ScreenRecordingService.class)) {
                    InternalScreenRecordHelper.getInstance().stopAndWait();
                }
            });
        }
    }

    private void subscribeToSdkStateEvents() {
        this.sdkStateDisposable = InstabugStateEventBus.getInstance().subscribe((Consumer)new Consumer<InstabugState>(){

            public void accept(InstabugState instabugState) {
                3 this_ = null;
                if (instabugState == InstabugState.DISABLED) {
                    this_ = ScreenRecordingServiceAction.CustomeActions.STOP_DELETE;
                } else if (instabugState == InstabugState.INVOKED) {
                    this_ = ScreenRecordingServiceAction.CustomeActions.STOP_TRIM_KEEP;
                }
                if (this_ != null) {
                    AutoScreenRecordingEventBus.getInstance().post((Object)this_);
                }
            }
        });
    }

    private void registerEventBus() {
        if (this.isManualRecording) {
            this.registerManualScreenRecordingEventBus();
        } else {
            this.registerAutoScreenRecordingEventBus();
        }
    }

    private void registerManualScreenRecordingEventBus() {
        Disposable disposable = this.manualScreenRecordingDisposable;
        if (disposable == null || disposable.isDisposed()) {
            this.manualScreenRecordingDisposable = ScreenRecordingEventBus.getInstance().subscribe(screenRecordingEvent -> {
                if (screenRecordingEvent.getStatus() == 3) {
                    this.cancelManualScreenRecording();
                } else if (SettingsManager.getInstance().isScreenCurrentlyRecorded() || screenRecordingEvent.getStatus() == 1) {
                    SettingsManager.getInstance().setScreenCurrentlyRecorded(false);
                    Object object = this.recordingSession;
                    if (object != null) {
                        ScreenRecorder.Callback callback;
                        ScreenRecordingSession screenRecordingSession = object;
                        object = callback;
                        callback = new ScreenRecorder.Callback(){
                            final /* synthetic */ ScreenRecordingEvent val$event;
                            {
                                this.val$event = screenRecordingEvent;
                            }

                            @Override
                            public void onStop(@Nullable Throwable throwable) {
                                if (this.val$event.getStatus() == 1 && ScreenRecordingService.this.recordingSession != null) {
                                    ScreenRecordingService.this.recordingSession.hold();
                                }
                            }

                            @Override
                            public void onStart() {
                            }

                            @Override
                            public void onRecording(long l) {
                            }
                        };
                        screenRecordingSession.destroy((ScreenRecorder.Callback)object);
                    }
                }
            });
        }
    }

    private void registerAutoScreenRecordingEventBus() {
        Disposable disposable = this.autoScreenRecordingDisposable;
        if (disposable == null || disposable.isDisposed()) {
            this.autoScreenRecordingDisposable = AutoScreenRecordingEventBus.getInstance().subscribe(customeActions -> PoolProvider.postIOTask(() -> {
                if (SettingsManager.getInstance().isScreenCurrentlyRecorded()) {
                    SettingsManager.getInstance().setScreenCurrentlyRecorded(false);
                    Object object = this.recordingSession;
                    if (object != null) {
                        ScreenRecorder.Callback callback;
                        ScreenRecordingSession screenRecordingSession = object;
                        object = callback;
                        callback = new ScreenRecorder.Callback(){
                            final /* synthetic */ ScreenRecordingServiceAction.CustomeActions val$action;
                            {
                                this.val$action = customeActions;
                            }

                            @Override
                            public void onStop(@Nullable Throwable throwable) {
                                if (ScreenRecordingService.this.recordingSession == null) {
                                    5 v0 = this;
                                    v0.ScreenRecordingService.this.stopForeground(true);
                                    v0.ScreenRecordingService.this.stopSelf();
                                    return;
                                }
                                int n = 7.$SwitchMap$com$instabug$library$internal$video$ScreenRecordingServiceAction$CustomeActions[this.val$action.ordinal()];
                                if (n != 1) {
                                    if (n != 2) {
                                        if (n == 3) {
                                            ScreenRecordingService.this.recordingSession.trim(SettingsManager.getInstance().autoScreenRecordingMaxDuration());
                                        }
                                    } else {
                                        ScreenRecordingService.this.recordingSession.hold();
                                    }
                                } else {
                                    ScreenRecordingService.this.recordingSession.deleteVideoFile();
                                }
                            }

                            @Override
                            public void onStart() {
                            }

                            @Override
                            public void onRecording(long l) {
                            }
                        };
                        screenRecordingSession.destroy((ScreenRecorder.Callback)object);
                    }
                }
            }));
        }
    }

    private void cancelManualScreenRecording() {
        if (SettingsManager.getInstance().isScreenCurrentlyRecorded()) {
            SettingsManager.getInstance().setScreenCurrentlyRecorded(false);
            InternalScreenRecordHelper.getInstance().cancel();
            Object object = this.recordingSession;
            if (object != null) {
                ScreenRecorder.Callback callback;
                ScreenRecordingSession screenRecordingSession = object;
                object = callback;
                callback = new ScreenRecorder.Callback(){

                    @Override
                    public void onStop(@Nullable Throwable throwable) {
                        if (ScreenRecordingService.this.recordingSession != null) {
                            ScreenRecordingService.this.recordingSession.deleteVideoFile();
                        }
                        6 v0 = this;
                        v0.ScreenRecordingService.this.stopForeground(true);
                        v0.ScreenRecordingService.this.stopSelf();
                    }

                    @Override
                    public void onStart() {
                    }

                    @Override
                    public void onRecording(long l) {
                    }
                };
                screenRecordingSession.destroy((ScreenRecorder.Callback)object);
            }
        }
    }

    private void unSubscribeToSdkStateEvents() {
        Disposable disposable = this.sdkStateDisposable;
        if (disposable != null && !disposable.isDisposed()) {
            this.sdkStateDisposable.dispose();
        }
    }

    private void unSubscribeToSessionEvents() {
        if (!this.sessionDisposable.isDisposed()) {
            this.sessionDisposable.dispose();
        }
    }

    public void onCreate() {
        ScreenRecordingService screenRecordingService = this;
        super.onCreate();
        screenRecordingService.subscribeToSessionEvents();
        screenRecordingService.subscribeToSdkStateEvents();
        InstabugMediaProjectionIntent.setMediaProjectionIntentUsed((boolean)true);
        if (Build.VERSION.SDK_INT >= 29) {
            NotificationUtils.createAndShowForegroundNotification((Service)this, (int)R.string.ibg_screen_recording_notification_title, (int)8743, (int)32);
        }
    }

    @SuppressLint(value={"STRICT_MODE_VIOLATION"})
    public int onStartCommand(Intent intent, int n, int n2) {
        if (intent == null) {
            ScreenRecordingService screenRecordingService = this;
            screenRecordingService.stopForeground(true);
            screenRecordingService.stopSelf();
        } else {
            int n3 = intent.getIntExtra("result-code", 0);
            Intent intent2 = (Intent)intent.getParcelableExtra("data");
            if (n3 == 0 || intent2 == null) {
                ScreenRecordingService screenRecordingService = this;
                InstabugSDKLogger.w((String)"ScreenRecordingService", (String)("Can't start service. Result code: " + n3 + ", Data: " + intent2));
                Toast.makeText((Context)screenRecordingService, (int)R.string.feature_requests_error_state_title, (int)0).show();
                ScreenRecordingEventBus.getInstance().post((Object)new ScreenRecordingEvent(4, null));
                screenRecordingService.stopForeground(true);
                screenRecordingService.stopSelf();
            }
            this.isManualRecording = intent.getBooleanExtra("is.manual.screen.recording", true);
            this.registerEventBus();
            if (!SettingsManager.getInstance().isScreenCurrentlyRecorded() && Build.VERSION.SDK_INT >= 21) {
                if (intent2 != null) {
                    ScreenRecordingService screenRecordingService = this;
                    Context context = Instabug.getApplicationContext();
                    ScreenRecordingSession.Listener listener = screenRecordingService.listener;
                    ScreenRecorder.Callback callback = screenRecordingService.startRecordingCallBack;
                    this.recordingSession = new ScreenRecordingSession(context, listener, callback, n3, intent2);
                    SettingsManager.getInstance().setScreenCurrentlyRecorded(true);
                }
            } else {
                ScreenRecordingService screenRecordingService = this;
                screenRecordingService.stopForeground(true);
                screenRecordingService.stopSelf();
            }
        }
        return super.onStartCommand(intent, n, n2);
    }

    public void onDestroy() {
        if (SettingsManager.getInstance().isScreenCurrentlyRecorded()) {
            SettingsManager.getInstance().setScreenCurrentlyRecorded(false);
        }
        ScreenRecordingService screenRecordingService = this;
        super.onDestroy();
        Disposable disposable = screenRecordingService.manualScreenRecordingDisposable;
        if (disposable != null && !disposable.isDisposed()) {
            this.manualScreenRecordingDisposable.dispose();
        }
        if ((disposable = this.autoScreenRecordingDisposable) != null && !disposable.isDisposed()) {
            this.autoScreenRecordingDisposable.dispose();
        }
        ScreenRecordingService screenRecordingService2 = this;
        screenRecordingService2.unSubscribeToSessionEvents();
        screenRecordingService2.unSubscribeToSdkStateEvents();
        NotificationUtils.cancelNotification((Context)screenRecordingService2, (int)8743);
    }

    public IBinder onBind(Intent intent) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

