package com.instabug.chat.annotation.shape;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;

import com.instabug.chat.annotation.ColorPickerPopUpView;
import com.instabug.chat.annotation.ControlButton;
import com.instabug.chat.annotation.DirectionRectF;
import com.instabug.chat.annotation.utility.BitmapUtility;
import com.instabug.library.util.DrawingUtility;
import com.instabug.library.settings.SettingsManager;

import androidx.annotation.Nullable;

/**
 * Created by tarek on 11/6/16.
 */

public class ZoomedShape extends CroppedRectShape {

    private static final int ZOOM_PERCENTAGE = 200;

    @Nullable
    private PointF controlPoint;
    private float cx;
    private float cy;
    private float r;

    public ZoomedShape(@Nullable Bitmap background) {
        super(ColorPickerPopUpView.DEFAULT_COLOR);
        this.background = background;
        setRecognized(true);
    }

    public void setBackground(@Nullable Bitmap background) {
        this.background = background;
    }

    @Override
    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public void drawCroppedRect(Canvas canvas, Bitmap croppedBitmap, float drawX, float drawY) {
        r = Math.min(croppedBitmap.getWidth() / 2, croppedBitmap.getHeight() / 2);

        cx = drawX + croppedBitmap.getWidth() / 2f;
        cy = drawY + croppedBitmap.getHeight() / 2f;

        controlPoint = DrawingUtility.pointOnCircle(r, 45, new PointF(cx, cy));

        canvas.drawBitmap(BitmapUtility.getCroppedCircleBitmap(
                BitmapUtility.zoom(croppedBitmap, ZOOM_PERCENTAGE)), drawX, drawY, null);
    }

    @Override
    public boolean isTouched(PointF touchedPoint, DirectionRectF bounds) {

        Region region = new Region();
        RectF rectF = new RectF();

        Path path = new Path();
        path.addCircle(cx, cy, r, Path.Direction.CW);
        path.computeBounds(rectF, true);
        region.setPath(path,
                new Region((int) rectF.left, (int) rectF.top, (int) rectF.right, (int) rectF.bottom));
        return region.contains((int) touchedPoint.x, (int) touchedPoint.y);
    }

    @Override
    public void adjustBounds(DirectionRectF newBounds, DirectionRectF bounds, boolean isUndo) {

        if (Math.abs(bounds.width() - newBounds.width()) < 1
                && Math.abs(bounds.height() - newBounds.height()) < 1) {
            bounds.set(newBounds);
        } else {
            // Resize with aspect ratio
            float factorWidth = newBounds.width() / bounds.width();
            float factorHeight = newBounds.height() / bounds.height();

            float factor = Math.max(factorWidth, factorHeight);

            Matrix resizeMatrix = new Matrix();

            resizeMatrix.postScale(factor, factor, bounds.centerX(), bounds.centerY());

            resizeMatrix.mapRect(bounds);
        }
    }

    @Override
    public void drawControlButtons(Canvas canvas, DirectionRectF bounds, ControlButton[] controlButtons) {
        PointF point = controlPoint == null ? bounds.getBottomRightPoint() : controlPoint;
        controlButtons[2].setCenterPoint(point);
        controlButtons[2].setColor(SettingsManager.getInstance().getPrimaryColor());
        controlButtons[2].draw(canvas);
    }

    @Override
    public void drawBorder(Canvas canvas, PointF topLeftPoint, PointF topRightPoint,
                           PointF bottomRightPoint, PointF bottomLeftPoint) {

    }

    @Override
    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    public Path getPath(DirectionRectF bounds) {
        return null;
    }
}
