package com.instabug.chat.annotation;

import android.graphics.PointF;
import android.graphics.RectF;

import java.io.Serializable;

import androidx.annotation.Nullable;

/**
 * Created by Tarek360 on 12/4/16.
 */

public class DirectionRectF extends RectF implements Serializable {

    @Nullable
    public X firstX;
    @Nullable
    public Y firstY;
    @Nullable
    public X secondX;
    @Nullable
    public Y secondY;

    public PointF point0 = new PointF();
    public PointF point1 = new PointF();
    public PointF point2 = new PointF();
    public PointF point3 = new PointF();
    public boolean hasBounds = false;

    private boolean visible = true;

    public DirectionRectF() {
    }

    public DirectionRectF(DirectionRectF directionRectF) {
        inject(directionRectF);
    }

    public DirectionRectF(float left, float top, float right, float bottom) {
        super(left, top, right, bottom);
    }

    public void set(DirectionRectF src) {
        inject(src);
    }

    private void inject(DirectionRectF src) {

        if (src == null) {
            left = top = right = bottom = 0.0f;
            firstX = secondX = null;
            firstY = secondY = null;
            this.point0.set(0.0f, 0.0f);
            this.point1.set(0.0f, 0.0f);
            this.point2.set(0.0f, 0.0f);
            this.point3.set(0.0f, 0.0f);
            this.hasBounds = false;
            this.visible = true;
        } else {

            this.left = src.left;
            this.top = src.top;
            this.right = src.right;
            this.bottom = src.bottom;
            this.firstX = src.firstX;
            this.firstY = src.firstY;
            this.secondX = src.secondX;
            this.secondY = src.secondY;

            this.point0.set(src.point0);
            this.point1.set(src.point1);
            this.point2.set(src.point2);
            this.point3.set(src.point3);

            this.hasBounds = src.hasBounds;
            this.visible = src.isVisible();
        }
    }

    public PointF getTopLeftPoint() {
        return new PointF(left, top);
    }

    public PointF getTopRightPoint() {
        return new PointF(right, top);
    }

    public PointF getBottomRightPoint() {
        return new PointF(right, bottom);
    }

    public PointF getBottomLeftPoint() {

        return new PointF(left, bottom);
    }

    public PointF[] getCornersPoints() {
        return new PointF[]{
                getTopLeftPoint(), getTopRightPoint(), getBottomRightPoint(), getBottomLeftPoint()
        };
    }

    public boolean isVisible() {
        return visible;
    }

    public void setVisibility(boolean visibility) {
        this.visible = visibility;
    }

    public enum X {
        LEFT, RIGHT
    }

    public enum Y {
        TOP, BOTTOM
    }
}
