package com.instabug.bug.invocation;

import com.instabug.bug.invocation.invoker.AbstractInvoker;
import com.instabug.bug.invocation.invoker.ShakeInvoker;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.bug.invocation.invoker.FloatingButtonInvoker;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author mesbah
 */
public class InvocationSettings {
    public static final int SHAKE_DEFAULT_THRESHOLD = 650;
    private static final Object LOCK = new Object();

    private FloatingButtonInvoker.FloatingButtonParams floatingButtonParams;
    private AtomicInteger shakeThreshold = new AtomicInteger(SHAKE_DEFAULT_THRESHOLD);

    public InvocationSettings() {
        floatingButtonParams = new FloatingButtonInvoker.FloatingButtonParams();
    }


    // Instabug FAB invoker settings
    public void setFloatingButtonEdge(InstabugFloatingButtonEdge floatingButtonEdge) {
        if (Instabug.isEnabled()) {
            floatingButtonParams.edge = floatingButtonEdge;

            if (!InstabugCore.isForegroundBusy())
                refreshButton();
        }
    }

    private void refreshButton() {
        final List<AbstractInvoker> currentInvokers = InvocationManager.getInstance().getCurrentInvokers();
        if (currentInvokers != null) {
            synchronized (LOCK) {
                for (AbstractInvoker abstractInvoker : currentInvokers) {
                    if (abstractInvoker instanceof FloatingButtonInvoker) {
                        ((FloatingButtonInvoker) abstractInvoker).updateButtonLocation();
                        break;
                    }
                }
            }
        }
    }

    public void setFloatingButtonOffsetFromTop(int offsetFromTop) {
        floatingButtonParams.offsetFromTop = offsetFromTop;

        refreshButton();
    }

    public FloatingButtonInvoker.FloatingButtonParams getFloatingButtonParams() {
        return floatingButtonParams;
    }

    // Instabug Shake invoker settings
    public void setShakingThreshold(int shakeThreshold) {
        if (shakeThreshold > 0) {
            final List<AbstractInvoker> currentInvokers = InvocationManager.getInstance().getCurrentInvokers();
            if (currentInvokers != null) {
                synchronized (LOCK) {
                    this.shakeThreshold.set(shakeThreshold);
                    for (AbstractInvoker invoker : currentInvokers) {
                        if (invoker instanceof ShakeInvoker) {
                            ((ShakeInvoker) invoker).setShakingThreshold(shakeThreshold);
                        }
                    }
                }
            }
        }
    }

    int getShakeThreshold() {
        return shakeThreshold.get();
    }



}
