/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.chat.notification;

import android.animation.Animator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.bug.R;
import com.instabug.chat.RepliesWrapper;
import com.instabug.chat.cache.ChatsCacheManager;
import com.instabug.chat.model.NotificationMessage;
import com.instabug.chat.notification.NotificationBarThemeApplierKt;
import com.instabug.chat.notification.NotificationManager;
import com.instabug.chat.settings.ChatSettings;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.InstabugState;
import com.instabug.library.PresentationManager;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.ActivityLifecycleSubscriber;
import com.instabug.library.core.eventbus.DefaultActivityLifeCycleEventHandler;
import com.instabug.library.core.eventbus.InstabugStateEventBus;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventSubscriber;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.eventbus.eventpublisher.IBGCompositeDisposable;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.ui.custom.CircularImageView;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.ScreenUtility;
import com.instabug.library.util.threading.PoolProvider;
import java.lang.ref.WeakReference;
import java.util.Locale;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public class NotificationBarInvoker
implements DefaultActivityLifeCycleEventHandler {
    private WeakReference<View> viewWeakReference;
    private boolean isShown;
    private boolean isKeyboardOpen;
    private boolean shouldShowNotification;
    @Nullable
    private NotificationMessage notificationMessage;
    @Nullable
    private OnButtonsClickListener onButtonsClickListener;
    @Nullable
    private ActivityLifecycleSubscriber activityLifecycleSubscriber;
    @Nullable
    private IBGCompositeDisposable disposables;

    public NotificationBarInvoker() {
        NotificationBarInvoker notificationBarInvoker = this;
        notificationBarInvoker.isShown = false;
        notificationBarInvoker.subscribeToCarenActivityLifeCycle();
        notificationBarInvoker.subscribeToSDKStateEvents();
        notificationBarInvoker.subscribeToSDKCoreEvents();
    }

    private void subscribeToSDKStateEvents() {
        InstabugStateEventBus.getInstance().subscribe(instabugState -> {
            if (instabugState == InstabugState.DISABLED) {
                NotificationBarInvoker notificationBarInvoker = onButtonsClickListener;
                notificationBarInvoker.clearMessage();
                notificationBarInvoker.dismiss();
                OnButtonsClickListener onButtonsClickListener = notificationBarInvoker.onButtonsClickListener;
                if (onButtonsClickListener != null) {
                    onButtonsClickListener.onDismiss();
                }
            }
        });
    }

    private void subscribeToSDKCoreEvents() {
        this.getOrCreateDisposables().add(this.subscribeToCoreEvents());
    }

    @NonNull
    private IBGDisposable subscribeToCoreEvents() {
        return IBGCoreEventSubscriber.subscribe(this::handleCoreEvents);
    }

    private void handleCoreEvents(IBGSdkCoreEvent iBGSdkCoreEvent) {
        boolean bl = iBGSdkCoreEvent instanceof IBGSdkCoreEvent.Features.Updated && !InstabugCore.isFeatureEnabled((String)"REPLIES");
        if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.User.LoggedOut || bl) {
            this.clearMessagesAndDismiss();
        }
    }

    private void clearMessagesAndDismiss() {
        NotificationBarInvoker notificationBarInvoker = this;
        notificationBarInvoker.clearMessage();
        notificationBarInvoker.dismiss(false);
    }

    private IBGCompositeDisposable getOrCreateDisposables() {
        IBGCompositeDisposable iBGCompositeDisposable = this.disposables;
        if (iBGCompositeDisposable == null) {
            IBGCompositeDisposable iBGCompositeDisposable2;
            iBGCompositeDisposable = iBGCompositeDisposable2;
            iBGCompositeDisposable2 = new IBGCompositeDisposable();
            this.disposables = iBGCompositeDisposable;
        }
        return iBGCompositeDisposable;
    }

    private void initView(@NonNull WeakReference<Activity> activity, OnViewAddedListener onViewAddedListener) {
        FrameLayout.LayoutParams layoutParams;
        if ((activity = (Activity)activity.get()) == null) {
            return;
        }
        View view2 = activity.findViewById(R.id.instabug_in_app_notification);
        if (view2 != null) {
            WeakReference<View> weakReference;
            NotificationBarInvoker notificationBarInvoker = weakReference2;
            WeakReference<View> weakReference2 = weakReference;
            weakReference = new WeakReference<View>(view2);
            notificationBarInvoker.viewWeakReference = weakReference2;
            onViewAddedListener.onViewFounded();
            return;
        }
        ((NotificationBarInvoker)((Object)weakReference2)).dismiss(false);
        view2 = (LayoutInflater)activity.getSystemService("layout_inflater");
        if (view2 == null) {
            InstabugSDKLogger.e((String)"IBG-BR", (String)"Unable to inflate the InAppNotifications view due to null Inflater");
            return;
        }
        view2 = view2.inflate(R.layout.instabug_lyt_notification, null);
        ((NotificationBarInvoker)((Object)weakReference2)).viewWeakReference = new WeakReference<View>(view2);
        view2.setVisibility(4);
        view2.setOnClickListener(view -> {});
        FrameLayout.LayoutParams layoutParams2 = layoutParams;
        new FrameLayout.LayoutParams((int)-1, (int)-2).gravity = 80;
        Resources resources = activity.getResources();
        int n = Build.VERSION.SDK_INT;
        if (n >= 21 && ScreenUtility.isLandscape((Activity)activity) && ScreenUtility.hasNavBar((Context)activity.getApplicationContext())) {
            int n2 = activity.getWindowManager().getDefaultDisplay().getRotation();
            if (n2 == 1) {
                layoutParams2.rightMargin = ScreenUtility.getNavigationBarWidth((Resources)resources);
            } else if (n2 == 3) {
                if (n >= 24) {
                    layoutParams2.leftMargin = ScreenUtility.getNavigationBarWidth((Resources)resources);
                } else {
                    layoutParams2.rightMargin = ScreenUtility.getNavigationBarWidth((Resources)resources);
                }
            }
        }
        Activity activity2 = activity;
        view2.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        activity2.runOnUiThread(() -> {
            if (view2.getParent() != null) {
                ((ViewGroup)view2.getParent()).removeView(view2);
            }
            ((ViewGroup)activity.getWindow().getDecorView()).addView(view2, (ViewGroup.LayoutParams)layoutParams2);
            view2.postDelayed((Runnable)onViewAddedListener, 100L);
        });
        activity2.getWindow().getDecorView().getViewTreeObserver().addOnGlobalLayoutListener(() -> {
            int n;
            Rect rect;
            Activity activity2 = activity;
            activity = rect;
            rect = new Rect();
            activity2.getWindow().getDecorView().getWindowVisibleDisplayFrame((Rect)activity);
            int n2 = activity2.getWindow().getDecorView().getRootView().getHeight();
            if ((double)(n - activity.bottom) > (double)n2 * 0.15) {
                this.isKeyboardOpen = true;
            } else {
                this.isKeyboardOpen = false;
                if (this.shouldShowNotification && !this.isShown) {
                    this.showWithAnimation();
                }
            }
        });
    }

    private void setOnButtonsClickListener() {
        Object object = this.viewWeakReference;
        object = object != null ? (View)object.get() : null;
        if (object == null) {
            return;
        }
        Button button = (Button)object.findViewById(R.id.replyButton);
        object = (Button)object.findViewById(R.id.dismissButton);
        if (button != null) {
            button.setOnClickListener(view -> {
                NotificationBarInvoker notificationBarInvoker = onButtonsClickListener;
                notificationBarInvoker.clearMessagesAndDismiss();
                OnButtonsClickListener onButtonsClickListener = notificationBarInvoker.onButtonsClickListener;
                if (onButtonsClickListener != null) {
                    onButtonsClickListener.onReply();
                }
            });
        }
        if (object != null) {
            object.setOnClickListener(view -> {
                NotificationBarInvoker notificationBarInvoker = onButtonsClickListener;
                notificationBarInvoker.clearMessage();
                notificationBarInvoker.dismiss();
                OnButtonsClickListener onButtonsClickListener = notificationBarInvoker.onButtonsClickListener;
                if (onButtonsClickListener != null) {
                    onButtonsClickListener.onDismiss();
                }
            });
        }
    }

    private void clearMessage() {
        this.notificationMessage = null;
    }

    private void showNotification(NotificationMessage notificationMessage) {
        this.setData(notificationMessage);
    }

    private void setData(NotificationMessage notificationMessage) {
        Object object = this.viewWeakReference;
        object = object != null ? (View)object.get() : null;
        if (object == null) {
            return;
        }
        View view = object;
        CircularImageView circularImageView = (CircularImageView)view.findViewById(R.id.senderAvatarImageView);
        PoolProvider.postMainThreadTask(() -> {
            NotificationBarInvoker notificationBarInvoker = notificationBarInvoker2;
            NotificationBarInvoker notificationBarInvoker2 = Instabug.getApplicationContext();
            Object object = notificationBarInvoker.viewWeakReference;
            NotificationBarThemeApplierKt.applyNotificationBarTheme(object != null ? (View)object.get() : null);
            object = (Button)view.findViewById(R.id.replyButton);
            Button button = (Button)view.findViewById(R.id.dismissButton);
            String string2 = PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.REPLIES_NOTIFICATION_REPLY_BUTTON, (String)LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)notificationBarInvoker2), (int)R.string.instabug_str_reply, (Context)notificationBarInvoker2));
            if (object != null) {
                object.setText((CharSequence)string2);
                object.setContentDescription((CharSequence)LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)notificationBarInvoker2), (int)R.string.ibg_notification_reply_btn_content_description, (Context)notificationBarInvoker2));
            }
            object = PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.REPLIES_NOTIFICATION_DISMISS_BUTTON, (String)LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)notificationBarInvoker2), (int)R.string.instabug_str_dismiss, (Context)notificationBarInvoker2));
            if (button != null) {
                button.setText((CharSequence)object);
                button.setContentDescription((CharSequence)LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)notificationBarInvoker2), (int)R.string.ibg_notification_dismiss_btn_content_description, (Context)notificationBarInvoker2));
            }
            View view2 = view;
            circularImageView.setBackgroundResource(R.drawable.ibg_core_ic_avatar);
            notificationBarInvoker2 = (TextView)view2.findViewById(R.id.senderNameTextView);
            view = (TextView)view2.findViewById(R.id.senderMessageTextView);
            if (notificationMessage.getFrom() != null && notificationBarInvoker2 != null) {
                notificationBarInvoker2.setText(notificationMessage.getFrom());
            }
            if (notificationMessage.getBody() != null && view != null) {
                view.setText((CharSequence)notificationMessage.getBody());
            }
        });
        if (notificationMessage.getAvatarURL() != null) {
            PoolProvider.postIOTask(() -> this.lambda$setData$7(notificationMessage, circularImageView, (View)object));
        }
    }

    private void showAvatarImage(CircularImageView circularImageView, @Nullable Bitmap bitmap) {
        if (bitmap != null) {
            CircularImageView circularImageView2 = circularImageView;
            circularImageView2.setBackgroundResource(0);
            circularImageView2.setImageBitmap(bitmap);
        }
    }

    private void dismiss() {
        this.dismiss(true);
    }

    private void dismiss(boolean bl) {
        Object object = this.viewWeakReference;
        object = object != null ? (View)object.get() : null;
        if (this.isShown && object != null) {
            int n = ScreenUtility.getWindowHeight((Activity)((Activity)object.getContext()));
            if (bl) {
                object.animate().y((float)n).setListener((Animator.AnimatorListener)new OnAnimationEndListener((View)object){
                    final /* synthetic */ View val$view;
                    {
                        this.val$view = view;
                    }

                    public void onAnimationEnd(Animator animator) {
                        this.val$view.setVisibility(4);
                    }
                }).start();
            } else {
                View view = object;
                view.setY((float)n);
                view.setVisibility(4);
            }
            NotificationBarInvoker notificationBarInvoker = this;
            notificationBarInvoker.isShown = false;
            notificationBarInvoker.shouldShowNotification = false;
            PresentationManager.getInstance().setNotificationShowing(false);
        }
    }

    private void showWithAnimation() {
        if (this.isKeyboardOpen) {
            this.shouldShowNotification = true;
            return;
        }
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
            public void run() {
                View view = NotificationBarInvoker.this.viewWeakReference != null ? (View)NotificationBarInvoker.this.viewWeakReference.get() : null;
                if (view != null && InstabugCore.getTargetActivity() != null) {
                    View view2 = view;
                    int n = ScreenUtility.getWindowHeight((Activity)InstabugCore.getTargetActivity());
                    int n2 = view2.getHeight() + ScreenUtility.getBottomInsets((Activity)InstabugCore.getTargetActivity());
                    view2.setVisibility(0);
                    view2.animate().y((float)(n - n2)).setListener(null).start();
                    NotificationBarInvoker.access$302(NotificationBarInvoker.this, true);
                    return;
                }
            }
        });
        if (ChatSettings.isInAppNotificationSoundEnabled()) {
            NotificationManager.getInstance().playNotificationSound(Instabug.getApplicationContext());
        }
    }

    private void subscribeToCarenActivityLifeCycle() {
        if (this.activityLifecycleSubscriber != null) {
            return;
        }
        this.activityLifecycleSubscriber = CoreServiceLocator.createActivityLifecycleSubscriber((DefaultActivityLifeCycleEventHandler)this);
        this.activityLifecycleSubscriber.subscribe();
    }

    private void onActivityResumed() {
        PoolProvider.postIOTask(() -> {
            if (ChatsCacheManager.getUnreadCount() > 0 && RepliesWrapper.isMessagingServiceAvailable()) {
                PoolProvider.postMainThreadTask(() -> {
                    if (((NotificationBarInvoker)((Object)weakReference2)).notificationMessage != null && ((NotificationBarInvoker)((Object)weakReference2)).onButtonsClickListener != null && InstabugCore.getTargetActivity() != null) {
                        WeakReference<Activity> weakReference;
                        NotificationBarInvoker notificationBarInvoker = weakReference2;
                        WeakReference<Activity> weakReference2 = weakReference;
                        weakReference = new WeakReference<Activity>(InstabugCore.getTargetActivity());
                        NotificationMessage notificationMessage = notificationBarInvoker.notificationMessage;
                        OnButtonsClickListener onButtonsClickListener = notificationBarInvoker.onButtonsClickListener;
                        notificationBarInvoker.show(weakReference2, notificationMessage, onButtonsClickListener);
                    }
                });
            }
        });
    }

    private void onActivityPaused() {
        this.dismiss(false);
    }

    private /* synthetic */ void lambda$setData$7(NotificationMessage notificationMessage, final CircularImageView circularImageView, final View view) {
        if (notificationMessage.getAvatarURL() != null) {
            BitmapUtils.loadBitmapForAsset((Context)Instabug.getApplicationContext(), (String)notificationMessage.getAvatarURL(), (AssetEntity.AssetType)AssetEntity.AssetType.IMAGE, (BitmapUtils.OnBitmapReady)new BitmapUtils.OnBitmapReady(){

                private /* synthetic */ void lambda$onBitmapReady$0(CircularImageView circularImageView2, Bitmap bitmap, View view2) {
                    2 v0 = this;
                    v0.NotificationBarInvoker.this.showAvatarImage(circularImageView2, bitmap);
                    if (!v0.NotificationBarInvoker.this.isShown) {
                        NotificationBarInvoker.this.showWithAnimation();
                    } else if (view2.getVisibility() != 0) {
                        view2.setVisibility(0);
                    }
                }

                public void onBitmapReady(@Nullable Bitmap bitmap) {
                    2 v0 = this_;
                    2 this_ = v0.circularImageView;
                    View view2 = v0.view;
                    PoolProvider.postMainThreadTask(() -> v0.lambda$onBitmapReady$0((CircularImageView)this_, bitmap, view2));
                }

                public void onBitmapFailedToLoad() {
                    if (!NotificationBarInvoker.this.isShown) {
                        NotificationBarInvoker.this.showWithAnimation();
                    } else if (view.getVisibility() != 0) {
                        view.setVisibility(0);
                    }
                }
            });
        }
    }

    static /* synthetic */ boolean access$302(NotificationBarInvoker notificationBarInvoker, boolean bl) {
        notificationBarInvoker.isShown = bl;
        return bl;
    }

    public void show(@NonNull WeakReference<Activity> weakReference, final NotificationMessage notificationMessage, OnButtonsClickListener object) {
        OnViewAddedListener onViewAddedListener;
        NotificationBarInvoker notificationBarInvoker = this;
        notificationBarInvoker.notificationMessage = notificationMessage;
        notificationBarInvoker.onButtonsClickListener = object;
        object = onViewAddedListener;
        onViewAddedListener = new OnViewAddedListener(){

            @Override
            void onViewInitialized() {
                View view = NotificationBarInvoker.this.viewWeakReference != null ? (View)NotificationBarInvoker.this.viewWeakReference.get() : null;
                if (view != null && InstabugCore.getTargetActivity() != null) {
                    view.setY((float)ScreenUtility.getWindowHeight((Activity)InstabugCore.getTargetActivity()));
                }
                NotificationBarInvoker.this.showNotification(notificationMessage);
            }

            @Override
            public void onViewFounded() {
                NotificationBarInvoker.this.showNotification(notificationMessage);
            }
        };
        notificationBarInvoker.initView(weakReference, (OnViewAddedListener)object);
        notificationBarInvoker.setOnButtonsClickListener();
    }

    @MainThread
    public void handleActivityResumed() {
        this.onActivityResumed();
    }

    @MainThread
    public void handleActivityPaused() {
        this.onActivityPaused();
    }

    public abstract class OnViewAddedListener
    implements Runnable {
        @Override
        public void run() {
            this.onViewInitialized();
        }

        abstract void onViewInitialized();

        abstract void onViewFounded();
    }

    public static interface OnButtonsClickListener {
        public void onReply();

        public void onDismiss();
    }

    private abstract class OnAnimationEndListener
    implements Animator.AnimatorListener {
        private OnAnimationEndListener() {
        }

        public void onAnimationStart(Animator animator) {
        }

        public void onAnimationCancel(Animator animator) {
        }

        public void onAnimationRepeat(Animator animator) {
        }
    }
}

