/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view.visualusersteps.visitedscreens;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.instabug.bug.R;
import com.instabug.bug.model.VisitedScreen;
import com.instabug.bug.view.BugReportingActivityCallback;
import com.instabug.bug.view.reporting.ReportingContainerActivity;
import com.instabug.bug.view.visualusersteps.steppreview.VisualUserStepArgs;
import com.instabug.bug.view.visualusersteps.visitedscreens.VisualUserStepsListAdapter;
import com.instabug.bug.view.visualusersteps.visitedscreens.VisualUserStepsListContract$View;
import com.instabug.bug.view.visualusersteps.visitedscreens.VisualUserStepsListPresenter;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.ThemeApplier;
import com.instabug.library.view.IBGProgressDialog;
import java.util.ArrayList;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public class VisualUserStepsListFragment
extends InstabugBaseFragment<VisualUserStepsListPresenter>
implements VisualUserStepsListContract$View {
    @VisibleForTesting
    @Nullable
    private String title;
    @Nullable
    private BugReportingActivityCallback activityCallback;
    private String currentTitle = "";
    private VisualUserStepsListAdapter adapter;
    private RecyclerView stepsList;
    private TextView emptyView;
    private LinearLayout container;
    private IBGProgressDialog preparingProgressDialog;

    public static VisualUserStepsListFragment newInstance(String string2) {
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putString("title", string2);
        VisualUserStepsListFragment visualUserStepsListFragment = new VisualUserStepsListFragment();
        visualUserStepsListFragment.setArguments(bundle2);
        return visualUserStepsListFragment;
    }

    private String getDescription() {
        return PlaceHolderUtils.getPlaceHolder((Context)this.getContext(), (InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.REPRO_STEPS_LIST_DESCRIPTION, (int)R.string.IBGReproStepsListHeader);
    }

    private String getPreparingMessage() {
        return PlaceHolderUtils.getPlaceHolder((Context)this.getContext(), (InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.REPRO_STEPS_PROGRESS_DIALOG_BODY, (int)R.string.instabug_str_dialog_message_preparing);
    }

    private String getEmptyStateDescription() {
        return PlaceHolderUtils.getPlaceHolder((Context)this.getContext(), (InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.REPRO_STEPS_LIST_EMPTY_STATE_DESCRIPTION, (int)R.string.IBGReproStepsListEmptyStateLabel);
    }

    private void handleInstabugTheme() {
        if (InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
            this.emptyView.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.ibg_bug_vus_empty_view_background_light));
        } else {
            VisualUserStepsListFragment visualUserStepsListFragment = this;
            visualUserStepsListFragment.emptyView.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.ibg_bug_vus_empty_view_background_dark));
            ((ViewGroup.MarginLayoutParams)visualUserStepsListFragment.emptyView.getLayoutParams()).setMargins(0, 0, 0, 0);
        }
    }

    public void onCreate(@Nullable Bundle object) {
        VisualUserStepsListPresenter visualUserStepsListPresenter;
        VisualUserStepsListFragment visualUserStepsListFragment = this;
        super.onCreate(object);
        visualUserStepsListFragment.setHasOptionsMenu(true);
        if (visualUserStepsListFragment.getActivity() != null) {
            this.getActivity().getWindow().setSoftInputMode(2);
        }
        object = this.getArguments() == null ? "" : this.getArguments().getString("title");
        this.title = object;
        object = this.activityCallback;
        if (object != null) {
            this.currentTitle = object.getToolbarTitle();
            object = this.title;
            if (object != null) {
                this.activityCallback.setToolbarTitle((String)object);
            }
            this.activityCallback.setToolbarUpIconBack();
        }
        object = visualUserStepsListPresenter;
        visualUserStepsListPresenter = new VisualUserStepsListPresenter(this);
        this.presenter = object;
    }

    public void onAttach(Context context) {
        VisualUserStepsListFragment visualUserStepsListFragment = this;
        super.onAttach(context);
        if (visualUserStepsListFragment.getActivity() instanceof BugReportingActivityCallback) {
            try {
                this.activityCallback = (BugReportingActivityCallback)this.getActivity();
            }
            catch (Exception exception) {
                throw new RuntimeException("Must implement BugReportingActivityCallBack");
            }
        }
    }

    protected int getLayout() {
        return R.layout.ibg_bug_fragment_repro_steps_list;
    }

    protected void initViews(View view, @Nullable Bundle object) {
        VisualUserStepsListAdapter visualUserStepsListAdapter;
        view = (TextView)this.findViewById(R.id.instabug_vus_list_header);
        if (view != null) {
            view.setText((CharSequence)this.getDescription());
        }
        if (this.getActivity() instanceof ReportingContainerActivity) {
            ((ReportingContainerActivity)this.getActivity()).setToolbarNavigationContentDescription(R.string.ibg_bug_visited_screen_back_btn_content_description);
        }
        this.emptyView = (TextView)this.findViewById(R.id.instabug_vus_empty_label);
        this.stepsList = (RecyclerView)this.findViewById(R.id.instabug_vus_list);
        object = (LinearLayout)this.findViewById(R.id.instabug_vus_list_container);
        this.container = object;
        if (object != null) {
            object.setVisibility(4);
        }
        object = visualUserStepsListAdapter;
        visualUserStepsListAdapter = new VisualUserStepsListAdapter(this, this.theme);
        this.adapter = object;
        if (this.getContext() != null) {
            DividerItemDecoration dividerItemDecoration;
            LinearLayoutManager linearLayoutManager;
            object = linearLayoutManager;
            linearLayoutManager = new LinearLayoutManager(this.getContext());
            RecyclerView recyclerView = this.stepsList;
            if (recyclerView == null) {
                return;
            }
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)object);
            this.stepsList.setAdapter((RecyclerView.Adapter)this.adapter);
            recyclerView = dividerItemDecoration;
            Object object2 = object;
            object = this.stepsList.getContext();
            dividerItemDecoration = new DividerItemDecoration((Context)object, object2.getOrientation());
            this.stepsList.addItemDecoration((RecyclerView.ItemDecoration)recyclerView);
            object = this.presenter;
            if (object != null) {
                ((VisualUserStepsListPresenter)((Object)object)).getVisualUserSteps();
            }
        }
        this.applyTheme(this.container, (TextView)view);
    }

    @VisibleForTesting
    public void applyTheme(@Nullable LinearLayout linearLayout, @Nullable TextView textView) {
        IBGTheme iBGTheme = this.theme;
        if (iBGTheme != null) {
            int n = iBGTheme.getBackgroundColor();
            if (n != 0 && linearLayout != null) {
                linearLayout.setBackgroundColor(n);
            }
            ThemeApplier.applyPrimaryTextStyle((TextView)textView, (IBGTheme)this.theme);
        }
    }

    public void onDestroy() {
        Object object = this.presenter;
        if (object != null) {
            ((VisualUserStepsListPresenter)((Object)object)).release();
        }
        if ((object = this.activityCallback) != null) {
            object.setToolbarUpIconClose();
            this.activityCallback.setToolbarTitle(this.currentTitle);
        }
        super.onDestroy();
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == 16908332 && this.getActivity() != null) {
            this.getActivity().onBackPressed();
        }
        return super.onOptionsItemSelected(menuItem);
    }

    @Override
    public void showPreparingDialog() {
        IBGProgressDialog iBGProgressDialog = this.preparingProgressDialog;
        if (iBGProgressDialog != null) {
            if (!iBGProgressDialog.isShowing()) {
                this.preparingProgressDialog.show();
            }
        } else if (this.getActivity() != null) {
            this.preparingProgressDialog = new IBGProgressDialog.Builder().setMessage(this.getPreparingMessage()).build((Context)this.getActivity());
            this.preparingProgressDialog.show();
        }
    }

    @Override
    public void dismissPreparingDialog() {
        IBGProgressDialog iBGProgressDialog;
        if (this.getActivity() != null && !this.getActivity().isFinishing() && (iBGProgressDialog = this.preparingProgressDialog) != null && iBGProgressDialog.isShowing()) {
            this.preparingProgressDialog.dismiss();
        }
    }

    public void onDestroyView() {
        IBGProgressDialog iBGProgressDialog;
        VisualUserStepsListFragment visualUserStepsListFragment = this;
        super.onDestroyView();
        if (visualUserStepsListFragment.getActivity() != null && !this.getActivity().isFinishing() && (iBGProgressDialog = this.preparingProgressDialog) != null && iBGProgressDialog.isShowing()) {
            this.preparingProgressDialog.dismiss();
        }
        VisualUserStepsListFragment visualUserStepsListFragment2 = this;
        visualUserStepsListFragment2.preparingProgressDialog = null;
        visualUserStepsListFragment2.stepsList = null;
        visualUserStepsListFragment2.container = null;
        visualUserStepsListFragment2.emptyView = null;
        visualUserStepsListFragment2.adapter = null;
    }

    @Override
    public void onStepItemDelete(int n, VisitedScreen visitedScreen) {
        VisualUserStepsListPresenter visualUserStepsListPresenter = (VisualUserStepsListPresenter)this.presenter;
        if (visualUserStepsListPresenter != null && this.getContext() != null) {
            visualUserStepsListPresenter.deleteVisualUserStep(this.getContext(), n, visitedScreen);
        }
        this.presenter = visualUserStepsListPresenter;
    }

    @Override
    public void onStepItemClick(@NonNull VisualUserStepArgs visualUserStepArgs) {
        if (DiskUtils.isFileExist((String)visualUserStepArgs.getScreenShotUri().replace("_e", "")) && (this = ((VisualUserStepsListFragment)this).activityCallback) != null) {
            this.openStepPreviewFragment(visualUserStepArgs);
        }
    }

    @Override
    public void populateVisualUserSteps(ArrayList<VisitedScreen> arrayList) {
        LinearLayout linearLayout = this.container;
        if (linearLayout != null && this.stepsList != null && this.emptyView != null && this.adapter != null) {
            linearLayout.setVisibility(0);
            if (arrayList.isEmpty()) {
                VisualUserStepsListFragment visualUserStepsListFragment = this;
                visualUserStepsListFragment.stepsList.setVisibility(8);
                visualUserStepsListFragment.emptyView.setVisibility(0);
                visualUserStepsListFragment.emptyView.setText((CharSequence)this.getEmptyStateDescription());
                visualUserStepsListFragment.handleInstabugTheme();
            } else {
                VisualUserStepsListFragment visualUserStepsListFragment = this;
                visualUserStepsListFragment.stepsList.setVisibility(0);
                visualUserStepsListFragment.emptyView.setVisibility(8);
                visualUserStepsListFragment.adapter.setData(arrayList);
            }
            return;
        }
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        super.onCreateOptionsMenu(menu2, menuInflater);
        menu2.clear();
    }
}

