/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view.reporting;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.Spanned;
import android.util.Patterns;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import com.instabug.bug.BugPlugin;
import com.instabug.bug.LiveBugManager;
import com.instabug.bug.StateCreatorEventBus;
import com.instabug.bug.model.Bug;
import com.instabug.bug.screenrecording.ExternalScreenRecordHelper;
import com.instabug.bug.screenshot.ScreenshotHelper;
import com.instabug.bug.screenshot.viewhierarchy.ViewHierarchyInspector;
import com.instabug.bug.screenshot.viewhierarchy.utilities.ViewHierarchyInspectorEventBus;
import com.instabug.bug.settings.BugSettings;
import com.instabug.bug.userConsent.UserConsent;
import com.instabug.bug.userConsent.UserConsentsManager;
import com.instabug.bug.view.reporting.IBaseReportingView$Presenter;
import com.instabug.bug.view.reporting.IBaseReportingView$View;
import com.instabug.bug.view.visualusersteps.VisualUserStepsDisclaimerHelper;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.internal.InstabugMediaProjectionIntent;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.video.MediaProjectionHelper;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.FileUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.VideoManipulationUtils;
import com.instabug.library.util.threading.PoolProvider;
import io.reactivexport.disposables.CompositeDisposable;
import io.reactivexport.functions.Consumer;
import java.io.File;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseReportingPresenter
extends BasePresenter<IBaseReportingView$View>
implements IBaseReportingView$Presenter {
    @Nullable
    private CompositeDisposable compositeDisposable;
    private WaitingPreparationAction waitingPreparationAction;
    @Nullable
    private List<UserConsent> consents;
    private int waiting = 0;
    @NonNull
    private final UserConsentsManager userConsentsManager;
    private boolean isCommittingBug = false;
    private final ArrayList<Attachment> beingRemovedAttachments = new ArrayList();
    private boolean shouldShowScreenRecording = false;

    public BaseReportingPresenter(IBaseReportingView$View iBaseReportingView$View, @NonNull UserConsentsManager userConsentsManager) {
        super((BaseContract.View)iBaseReportingView$View);
        this.waitingPreparationAction = WaitingPreparationAction.NONE;
        this.userConsentsManager = userConsentsManager;
        this.evaluateShouldShowScreenRecording(iBaseReportingView$View);
    }

    private void showUserConsents(@Nullable IBaseReportingView$View iBaseReportingView$View) {
        PoolProvider.postOrderedIOTask((String)"bug_reporting_executor", () -> {
            if (iBaseReportingView$View != null && iBaseReportingView$View.getViewContext() != null && ((Fragment)iBaseReportingView$View.getViewContext()).getActivity() != null) {
                List<UserConsent> list;
                if (this.consents == null) {
                    this.consents = this.userConsentsManager.getConsents();
                }
                if ((list = this.consents) != null && !list.isEmpty()) {
                    ((Fragment)iBaseReportingView$View.getViewContext()).getActivity().runOnUiThread(() -> iBaseReportingView$View.showUserConsents(this.consents));
                } else {
                    return;
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void prepareForTakingScreenShot(IBaseReportingView$View iBaseReportingView$View) {
        void var1_2;
        BugPlugin bugPlugin;
        if (LiveBugManager.getInstance().getBug() != null) {
            LiveBugManager.getInstance().getBug().setBugState(Bug.BugState.IN_PROGRESS);
        }
        if ((bugPlugin = (BugPlugin)InstabugCore.getXPlugin(BugPlugin.class)) != null && bugPlugin.getAppContext() != null) {
            bugPlugin.setState(2);
            SettingsManager.getInstance().setProcessingForeground(false);
            ScreenshotHelper.getInstance().startScreenshotCapturing(bugPlugin.getAppContext());
        }
        if (var1_2 != null) {
            var1_2.finishActivity();
        }
        LiveBugManager.getInstance().onSdkDismissedForAttachment();
    }

    private void handleGalleryFileBelow21(IBaseReportingView$View iBaseReportingView$View, @NonNull Intent object) {
        Object object2 = AttachmentsUtility.getGalleryImagePath((Activity)iBaseReportingView$View.getActivity(), (Uri)object.getData());
        if (object2 == null && object.getData() != null) {
            object2 = object.getData().getPath();
        }
        if (object2 == null) {
            InstabugSDKLogger.e((String)"IBG-BR", (String)"Null file path while adding attachment from gallery");
            return;
        }
        object = FileUtils.getExtension((String)object2);
        if (FileUtils.isImageExtension((String)object)) {
            LiveBugManager.getInstance().addImageAttachment(iBaseReportingView$View.getContext(), Uri.fromFile((File)new File((String)object2)), Attachment.Type.GALLERY_IMAGE);
        } else if (FileUtils.isVideoExtension((String)object)) {
            File file;
            object = file;
            if (new File((String)object2).length() / 1024L / 1024L > 50L) {
                iBaseReportingView$View.showMediaFileSizeAlert();
            } else if (VideoManipulationUtils.extractVideoDuration((String)object2) > 60000L) {
                iBaseReportingView$View.showVideoLengthAlert();
            } else {
                object2 = iBaseReportingView$View.getContext();
                iBaseReportingView$View = Uri.fromFile((File)object);
                LiveBugManager.getInstance().addVideoAttachment((Context)object2, (Uri)iBaseReportingView$View, Attachment.Type.GALLERY_VIDEO);
            }
        }
        LiveBugManager.getInstance().setIsInBackground(false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresApi(api=19)
    private void handleGalleryFileAbove21(IBaseReportingView$View var1_2, Intent var2_3) {
        block9: {
            this = AttachmentsUtility.getFileNameAndSize((Context)var1_2.getActivity(), (Uri)var2_3.getData());
            if (this == null) return;
            var3_4 = null;
            var4_5 = "0";
            v0 = this.first;
            var5_6 = (String)v0;
            if (v0 != null) {
                var3_4 = FileUtils.getExtension((String)var5_6);
            }
            if ((this = this.second) != null) {
                var4_5 = (String)this;
            }
            if (var3_4 != null && FileUtils.isImageExtension((String)var3_4)) {
                this = AttachmentsUtility.getFileFromContentProvider((Context)var1_2.getContext(), (Uri)var2_3.getData(), (String)var5_6);
                if (this == null) return;
                LiveBugManager.getInstance().addExternalAttachmentWithoutCopying(var1_2.getContext(), (File)this, Attachment.Type.GALLERY_IMAGE);
                return;
            }
            if (var3_4 == null) return;
            if (FileUtils.isVideoExtension((String)var3_4) == false) return;
            try {
                v1 = Double.parseDouble(var4_5);
            }
            catch (Exception var0_1) {
                break block9;
            }
            if (v1 / 1024.0 / 1024.0 > 50.0) {
                var1_2.showMediaFileSizeAlert();
                InstabugSDKLogger.e((String)"IBG-BR", (String)"Attached video size exceeded the limit");
                return;
            }
            this = AttachmentsUtility.getFileFromContentProvider((Context)var1_2.getContext(), (Uri)var2_3.getData(), (String)var5_6);
            if (this == null) ** GOTO lbl40
            {
                if (VideoManipulationUtils.extractVideoDuration((String)this.getPath()) > 60000L) {
                    var1_2.showVideoLengthAlert();
                    InstabugSDKLogger.e((String)"IBG-BR", (String)"Attached video length exceeded the limit, deleting file");
                    if (this.delete() == false) return;
                    InstabugSDKLogger.v((String)"IBG-BR", (String)"Attachment deleted");
                    return;
                }
                v2 = this;
                this = var1_2.getContext();
                var1_2 = Uri.fromFile((File)v2);
                LiveBugManager.getInstance().addVideoAttachment((Context)this, (Uri)var1_2, Attachment.Type.GALLERY_VIDEO);
                return;
lbl40:
                // 1 sources

                InstabugSDKLogger.e((String)"IBG-BR", (String)"Couldn't get video attachment, file is null");
                return;
            }
        }
        InstabugSDKLogger.e((String)"IBG-BR", (String)("Error: " + var0_1.getMessage() + " while adding video attachment"), (Throwable)var0_1);
    }

    private void fillBugModelWithUserConsentResponses(@Nullable Bug bug) {
        if (bug == null) {
            return;
        }
        if ((this = ((BaseReportingPresenter)this).getUserConsentResponses()) != null && !this.isEmpty()) {
            bug.setUserConsentResponses((Map<String, String>)this);
        }
    }

    private void fillBugModelWithActionableConsents(@Nullable Bug bug) {
        if (bug == null) {
            return;
        }
        if ((this = ((BaseReportingPresenter)this).getActionableConsents()) != null && !this.isEmpty()) {
            bug.setActionableConsents((List<String>)this);
        }
    }

    @Nullable
    private Map<String, String> getUserConsentResponses() {
        List<UserConsent> list = ((BaseReportingPresenter)((Object)hashMap2)).consents;
        if (list != null && !list.isEmpty()) {
            HashMap hashMap;
            BaseReportingPresenter baseReportingPresenter = hashMap2;
            HashMap hashMap2 = hashMap;
            hashMap = new HashMap();
            for (UserConsent userConsent : baseReportingPresenter.consents) {
                if (userConsent.getKey() == null) continue;
                hashMap2.put("IBG_USER_CONSENT_" + userConsent.getKey(), userConsent.isChecked() + "");
            }
            return hashMap2;
        }
        return null;
    }

    @Nullable
    private List<String> getActionableConsents() {
        List<UserConsent> list = ((BaseReportingPresenter)((Object)arrayList2)).consents;
        if (list != null && !list.isEmpty()) {
            ArrayList arrayList;
            BaseReportingPresenter baseReportingPresenter = arrayList2;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            for (UserConsent userConsent : baseReportingPresenter.consents) {
                if (userConsent.getKey() == null || userConsent.getActionType() == null || userConsent.isChecked()) continue;
                arrayList2.add(userConsent.getActionType());
            }
            return arrayList2;
        }
        return null;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private boolean checkCommentValid() {
        IBaseReportingView$View iBaseReportingView$View = (IBaseReportingView$View)this.view.get();
        String string2 = null;
        if (LiveBugManager.getInstance().getBug() != null) {
            string2 = LiveBugManager.getInstance().getBug().getMessage();
        }
        int n = BugSettings.getInstance().getReportTypeCommentMinCharLimit(this.getReportType());
        int n2 = Math.max(2, n);
        if (!(!BugSettings.getInstance().isCommentFieldRequired() && n == 0 || string2 != null && string2.trim().length() >= n2 || iBaseReportingView$View == null)) {
            Object object = n2;
            object = String.format(PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.COMMENT_FIELD_INSUFFICIENT_CONTENT, (String)iBaseReportingView$View.getLocalizedString(R.string.instabug_err_invalid_comment)), object);
            string2 = string2 != null && !string2.isEmpty() ? "non-empty-comment" : "empty-comment";
            InstabugSDKLogger.v((String)"IBG-BR", (String)("checkCommentValid comment field is invalid : " + string2));
            iBaseReportingView$View.showCommentError((String)object);
            return false;
        }
        return true;
    }

    private void subscribeOnViewHierarchyInspectorEventBus() {
        BaseReportingPresenter baseReportingPresenter = this;
        ++baseReportingPresenter.waiting;
        Object object = baseReportingPresenter.compositeDisposable;
        if (object != null) {
            Consumer<Throwable> consumer;
            CompositeDisposable compositeDisposable = object;
            object = consumer;
            consumer = new Consumer<Throwable>(){

                public void accept(Throwable throwable) {
                    2 v0 = iBaseReportingView$View;
                    --v0.BaseReportingPresenter.this.waiting;
                    if (v0.BaseReportingPresenter.this.view != null) {
                        2 v1 = iBaseReportingView$View;
                        IBaseReportingView$View iBaseReportingView$View = (IBaseReportingView$View)v1.BaseReportingPresenter.this.view.get();
                        v1.BaseReportingPresenter.this.executeWaitingPreparationAction(iBaseReportingView$View);
                    }
                }
            };
            compositeDisposable.add(ViewHierarchyInspectorEventBus.getInstance().getEventObservable().subscribe((Consumer)new Consumer<ViewHierarchyInspector.Action>(){

                public void accept(ViewHierarchyInspector.Action action) {
                    --iBaseReportingView$View.BaseReportingPresenter.this.waiting;
                    InstabugSDKLogger.d((String)"IBG-BR", (String)("Received a view hierarchy inspection action, action value: " + (Object)((Object)action)));
                    if ((action == ViewHierarchyInspector.Action.COMPLETED || action == ViewHierarchyInspector.Action.FAILED) && iBaseReportingView$View.BaseReportingPresenter.this.view != null) {
                        1 v0 = iBaseReportingView$View;
                        IBaseReportingView$View iBaseReportingView$View = (IBaseReportingView$View)v0.BaseReportingPresenter.this.view.get();
                        v0.BaseReportingPresenter.this.executeWaitingPreparationAction(iBaseReportingView$View);
                    }
                }
            }, (Consumer)object));
        }
    }

    private void subscribeOnStateBuilt() {
        BaseReportingPresenter baseReportingPresenter = this;
        ++baseReportingPresenter.waiting;
        Object object = baseReportingPresenter.compositeDisposable;
        if (object != null) {
            Consumer<Throwable> consumer;
            CompositeDisposable compositeDisposable = object;
            object = consumer;
            consumer = new Consumer<Throwable>(){

                public void accept(Throwable throwable) {
                    4 v0 = iBaseReportingView$View;
                    --v0.BaseReportingPresenter.this.waiting;
                    if (v0.BaseReportingPresenter.this.view != null) {
                        4 v1 = iBaseReportingView$View;
                        IBaseReportingView$View iBaseReportingView$View = (IBaseReportingView$View)v1.BaseReportingPresenter.this.view.get();
                        v1.BaseReportingPresenter.this.executeWaitingPreparationAction(iBaseReportingView$View);
                    }
                    InstabugSDKLogger.e((String)"IBG-BR", (String)("State Building got error: " + throwable.getMessage()));
                    StateCreatorEventBus.release();
                }
            };
            compositeDisposable.add(StateCreatorEventBus.getInstance().getEventObservable().subscribe((Consumer)new Consumer<State.Action>(){

                public void accept(State.Action action) {
                    3 v0 = iBaseReportingView$View;
                    --v0.BaseReportingPresenter.this.waiting;
                    if (v0.BaseReportingPresenter.this.view != null) {
                        3 v1 = iBaseReportingView$View;
                        IBaseReportingView$View iBaseReportingView$View = (IBaseReportingView$View)v1.BaseReportingPresenter.this.view.get();
                        v1.BaseReportingPresenter.this.executeWaitingPreparationAction(iBaseReportingView$View);
                    }
                    InstabugSDKLogger.v((String)"IBG-BR", (String)"State Building finished action");
                    StateCreatorEventBus.release();
                }
            }, (Consumer)object));
        }
    }

    private void executeWaitingPreparationAction(final @Nullable IBaseReportingView$View iBaseReportingView$View) {
        if (iBaseReportingView$View != null && ((Fragment)iBaseReportingView$View.getViewContext()).getActivity() != null) {
            ((Fragment)iBaseReportingView$View.getViewContext()).getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (BaseReportingPresenter.this.waitingPreparationAction == WaitingPreparationAction.SEND_BUG && BaseReportingPresenter.this.waiting != 0) {
                        return;
                    }
                    iBaseReportingView$View.dismissPreparingDialog();
                    int n = 6.$SwitchMap$com$instabug$bug$view$reporting$BaseReportingPresenter$WaitingPreparationAction[BaseReportingPresenter.this.waitingPreparationAction.ordinal()];
                    if (n != 1) {
                        if (n != 2) {
                            if (n == 3) {
                                BaseReportingPresenter.this.openVideoRecorder();
                            }
                        } else {
                            BaseReportingPresenter.this.takeScreenshot();
                        }
                    } else {
                        BaseReportingPresenter.this.onSendClicked();
                    }
                }
            });
        }
    }

    @VisibleForTesting
    void evaluateShouldShowScreenRecording(IBaseReportingView$View iBaseReportingView$View) {
        if (iBaseReportingView$View != null) {
            if ((iBaseReportingView$View = iBaseReportingView$View.getContext()) != null) {
                boolean bl = BugSettings.getInstance().getAttachmentsTypesParams().isAllowScreenRecording() && MediaProjectionHelper.INSTANCE.isMediaProjectionServiceAvailable((Context)iBaseReportingView$View);
                this.shouldShowScreenRecording = bl;
            } else {
                this.shouldShowScreenRecording = false;
            }
        }
    }

    protected abstract String getReportType();

    @Override
    public void onStart() {
        this.compositeDisposable = new CompositeDisposable();
        Bug bug = LiveBugManager.getInstance().getBug();
        if (bug != null) {
            if (bug.isRequiredViewHierarchy()) {
                this.subscribeOnViewHierarchyInspectorEventBus();
            }
            if (bug.getState() == null) {
                this.subscribeOnStateBuilt();
            }
        }
        if (InstabugCore.isFeatureEnabled((String)"VIEW_HIERARCHY_V2")) {
            this.subscribeOnViewHierarchyInspectorEventBus();
        }
        BaseReportingPresenter baseReportingPresenter = this;
        baseReportingPresenter.showUserConsents((IBaseReportingView$View)baseReportingPresenter.view.get());
    }

    @Override
    public void onStop() {
        BaseReportingPresenter baseReportingPresenter = baseReportingPresenter.compositeDisposable;
        if (baseReportingPresenter != null) {
            baseReportingPresenter.dispose();
        }
    }

    @Override
    public void onEmailChanged(String string2) {
        if (LiveBugManager.getInstance().getBug() != null && LiveBugManager.getInstance().getBug().getState() != null) {
            LiveBugManager.getInstance().getBug().getState().setUserEmail(string2);
        }
    }

    @Override
    public void onMessageChanged(String string2) {
        if (LiveBugManager.getInstance().getBug() != null) {
            LiveBugManager.getInstance().getBug().setMessage(string2);
        }
    }

    @Override
    public void pickPhotoFromGallery() {
        if (((BaseReportingPresenter)object).isCommittingBug) {
            return;
        }
        LiveBugManager.getInstance().setIsInBackground(true);
        Object object = ((BasePresenter)object).view;
        if (object != null) {
            object = (IBaseReportingView$View)((Reference)object).get();
            LiveBugManager.getInstance().onSdkDismissedForAttachment();
            if (object != null) {
                object.startGalleryPicker();
            }
        }
    }

    @Override
    public void takeScreenshot() {
        if (this.isCommittingBug) {
            return;
        }
        Object object = this.view;
        if (object != null) {
            object = (IBaseReportingView$View)((Reference)object).get();
            if (LiveBugManager.getInstance().getBug() != null && LiveBugManager.getInstance().getBug().isRequiredViewHierarchy() && LiveBugManager.getInstance().getBug().getViewHierarchyInspectionState() == Bug.ViewHierarchyInspectionState.IN_PROGRESS) {
                this.waitingPreparationAction = WaitingPreparationAction.TAKE_EXTRA_SCREENSHOT;
                if (object != null) {
                    object.showPreparingDialog();
                }
            } else if (object != null) {
                if (SettingsManager.getInstance().isScreenshotByMediaProjectionEnabled()) {
                    object.requestMediaProjectionPermission();
                } else {
                    this.prepareForTakingScreenShot((IBaseReportingView$View)object);
                }
            }
        }
    }

    @Override
    public void openVideoRecorder() {
        if (this.isCommittingBug) {
            return;
        }
        Object object = this.view;
        if (object != null) {
            object = (IBaseReportingView$View)((Reference)object).get();
            if (LiveBugManager.getInstance().getBug() != null && LiveBugManager.getInstance().getBug().isRequiredViewHierarchy() && LiveBugManager.getInstance().getBug().getViewHierarchyInspectionState() == Bug.ViewHierarchyInspectionState.IN_PROGRESS) {
                this.waitingPreparationAction = WaitingPreparationAction.RECORD_VIDEO;
                if (object != null) {
                    object.showPreparingDialog();
                }
            } else {
                BugPlugin bugPlugin;
                LiveBugManager.getInstance().onSdkDismissedForAttachment();
                ExternalScreenRecordHelper.getInstance().start();
                if (object != null) {
                    object.finishActivity();
                }
                if ((bugPlugin = (BugPlugin)InstabugCore.getXPlugin(BugPlugin.class)) != null) {
                    bugPlugin.setState(2);
                }
            }
        }
    }

    @Override
    public void onSaveInstanceState(Bundle bundle) {
    }

    @Override
    public void onRestoreInstanceState(@Nullable Bundle bundle) {
    }

    @Override
    public void onActivityResult(int n, int n2, Intent intent) {
        if (n == 3862) {
            Object object;
            if (n2 == -1 && intent != null && intent.getData() != null && (object = this.view) != null && (object = (IBaseReportingView$View)((Reference)object).get()) != null) {
                if (Build.VERSION.SDK_INT >= 21) {
                    this.handleGalleryFileAbove21((IBaseReportingView$View)object, intent);
                } else {
                    this.handleGalleryFileBelow21((IBaseReportingView$View)object, intent);
                }
            }
        } else if (n == 3890) {
            if (n2 == -1 && intent != null) {
                InstabugMediaProjectionIntent.setMediaProjectionIntent((Intent)intent);
                InstabugMediaProjectionIntent.setStaticResultCode((int)n2);
                this.openVideoRecorder();
            }
        } else if (n == 2030 && this.view.get() != null && intent != null && intent.getBooleanExtra("isPermissionGranted", false)) {
            BaseReportingPresenter baseReportingPresenter = this;
            baseReportingPresenter.prepareForTakingScreenShot((IBaseReportingView$View)baseReportingPresenter.view.get());
        }
    }

    @Override
    public void removeAttachment(@NonNull Attachment attachment) {
        if (this.isAttachmentBeingRemoved(attachment)) {
            return;
        }
        this.beingRemovedAttachments.add(attachment);
        PoolProvider.postIOTask(() -> {
            InstabugSDKLogger.v((String)"IBG-BR", (String)("Removing attachment: " + attachment.getName()));
            if (LiveBugManager.getInstance().getBug() != null) {
                LiveBugManager.getInstance().getBug().getAttachments().remove(attachment);
            }
            if (attachment.getLocalPath() != null) {
                File file;
                File file2 = file;
                file = new File(attachment.getLocalPath());
                if (Attachment.Type.EXTRA_VIDEO.equals(attachment.getType()) || Attachment.Type.GALLERY_VIDEO.equals(attachment.getType())) {
                    InstabugSDKLogger.v((String)"IBG-BR", (String)"Removing video attachment");
                    Cache cache = CacheManager.getInstance().getCache("DEFAULT_IN_MEMORY_CACHE_KEY");
                    if (cache != null && cache.delete((Object)"video.path") != null) {
                        InstabugSDKLogger.v((String)"IBG-BR", (String)"video attachment removed successfully");
                    }
                    if (LiveBugManager.getInstance().getBug() != null) {
                        LiveBugManager.getInstance().getBug().setHasVideo(false);
                    }
                }
                if (file2.delete()) {
                    InstabugSDKLogger.v((String)"IBG-BR", (String)"attachment removed successfully");
                    this.notifyAttachmentRemoved(attachment);
                }
            }
            attachment.setRemoved(true);
            this.beingRemovedAttachments.remove(attachment);
        });
    }

    @Override
    public void refreshAttachments() {
        Bug bug = LiveBugManager.getInstance().getBug();
        if (bug != null && (this = ((BasePresenter)this).view) != null && (this = (IBaseReportingView$View)((Reference)this).get()) != null) {
            this.setAttachments(bug.getAttachments());
        }
    }

    public void notifyAttachmentRemoved(Attachment attachment) {
        PoolProvider.postMainThreadTask(() -> {
            Object object = ((BasePresenter)object).view;
            if (object != null && (object = (IBaseReportingView$View)((Reference)object).get()) != null) {
                object.notifyAttachmentRemoved(attachment);
            }
        });
    }

    @Override
    public void handleVisualUserStepsDisclaimer(String string2, String object) {
        Object object2;
        if (VisualUserStepsDisclaimerHelper.isDisclaimerAvailable(string2)) {
            if (((BasePresenter)object2).view != null) {
                BaseReportingPresenter baseReportingPresenter = object2;
                object2 = VisualUserStepsDisclaimerHelper.getSpannedDisclaimer(string2, (String)object);
                object = (IBaseReportingView$View)baseReportingPresenter.view.get();
                if (object != null) {
                    object.showVisualUserStepDisclaimer((Spanned)object2, string2);
                }
            }
        } else {
            object2 = ((BasePresenter)object2).view;
            if (object2 != null && (object2 = (IBaseReportingView$View)((Reference)object2).get()) != null) {
                object2.hideVisualUserStepDisclaimer();
            }
        }
    }

    @Override
    public void handleInstabugDisclaimer() {
        Object object;
        if (BugSettings.getInstance().getDisclaimerText() != null && BugSettings.getInstance().getDisclaimerText().length() > 0) {
            object = ((BasePresenter)object).view;
            if (object != null && (object = (IBaseReportingView$View)((Reference)object).get()) != null) {
                object.showInstabugDisclaimer(BugSettings.getInstance().getDisclaimerText());
            }
        } else {
            object = ((BasePresenter)object).view;
            if (object != null && (object = (IBaseReportingView$View)((Reference)object).get()) != null) {
                object.hideInstabugDisclaimer();
            }
        }
    }

    @Override
    public void onSendClicked() {
        if (this.isCommittingBug) {
            return;
        }
        Object object = this.view;
        if (object != null && (object = (IBaseReportingView$View)((Reference)object).get()) != null) {
            if (LiveBugManager.getInstance().getBug() == null) {
                InstabugSDKLogger.e((String)"IBG-BR", (String)"BUG WAS NULL - Recreate a new bug");
                if (((Fragment)object.getViewContext()).getContext() != null) {
                    LiveBugManager.getInstance().createBug(((Fragment)object.getViewContext()).getContext());
                } else {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)"Couldn't create the Bug due to Null context");
                }
            } else if (LiveBugManager.getInstance().getBug() != null && LiveBugManager.getInstance().getBug().getState() != null && !BugSettings.getInstance().isEmailFieldVisible()) {
                LiveBugManager.getInstance().getBug().getState().updateIdentificationAttrs();
            }
            boolean bl = this.checkCommentValid();
            if (this.checkUserEmailValid() && bl) {
                BaseReportingPresenter baseReportingPresenter = this;
                baseReportingPresenter.fillBugModelWithUserConsentResponses(LiveBugManager.getInstance().getBug());
                baseReportingPresenter.fillBugModelWithActionableConsents(LiveBugManager.getInstance().getBug());
                if (LiveBugManager.getInstance().getBug() != null && LiveBugManager.getInstance().getBug().isRequiredViewHierarchy() && LiveBugManager.getInstance().getBug().getViewHierarchyInspectionState() == Bug.ViewHierarchyInspectionState.IN_PROGRESS) {
                    this.waitingPreparationAction = WaitingPreparationAction.SEND_BUG;
                    object.showPreparingDialog();
                    return;
                }
                if (LiveBugManager.getInstance().getBug() != null && LiveBugManager.getInstance().getBug().getState() == null) {
                    this.waitingPreparationAction = WaitingPreparationAction.SEND_BUG;
                    object.showPreparingDialog();
                    return;
                }
                if (BugSettings.getInstance().isEmailFieldVisible()) {
                    SettingsManager.getInstance().setEnteredEmail(object.getEnteredEmail());
                }
                if (!this.hasExtendedReport()) {
                    if (LiveBugManager.getInstance().getBug() != null && LiveBugManager.getInstance().getBug().getState() == null) {
                        object.showPreparingDialog();
                    } else {
                        if (((Fragment)object.getViewContext()).getContext() != null) {
                            LiveBugManager.getInstance().commit();
                            this.isCommittingBug = true;
                        } else {
                            InstabugSDKLogger.e((String)"IBG-BR", (String)"Couldn't commit the Bug due to Null context");
                        }
                        object.navigateToSuccessFragment();
                    }
                } else {
                    object.navigateToExtraFieldsFragment();
                }
                object.notifyFragmentVisibilityChanged(false);
            } else {
                return;
            }
        }
    }

    @VisibleForTesting
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    boolean checkUserEmailValid() {
        IBaseReportingView$View iBaseReportingView$View = (IBaseReportingView$View)this.view.get();
        Object object = LiveBugManager.getInstance().getBug();
        String string2 = null;
        if (object != null && object.getState() != null && (string2 = object.getState().getUserEmail()) != null) {
            object = (string2 = string2.trim()).isEmpty() ? "empty-email" : "non-empty-email";
            InstabugSDKLogger.v((String)"IBG-BR", (String)("checkUserEmailValid :" + (String)object));
        }
        if ((string2 == null || string2.isEmpty()) && iBaseReportingView$View != null) {
            string2 = iBaseReportingView$View.getEnteredEmail().trim();
            this.onEmailChanged(string2);
        }
        boolean bl = true;
        if (BugSettings.getInstance().isEmailFieldVisible()) {
            if (BugSettings.getInstance().isEmailFieldRequired() && (string2 == null || string2.isEmpty())) {
                bl = false;
            }
            if (string2 != null && !string2.isEmpty() && !Patterns.EMAIL_ADDRESS.matcher(string2.trim()).matches()) {
                bl = false;
            }
            if (!bl && iBaseReportingView$View != null) {
                object = PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.INVALID_EMAIL_MESSAGE, (String)iBaseReportingView$View.getLocalizedString(R.string.instabug_err_invalid_email));
                string2 = string2 != null && !string2.isEmpty() ? "non-empty-email" : "empty-email";
                InstabugSDKLogger.v((String)"IBG-BR", (String)("checkUserEmailValid failed with " + string2 + " email"));
                iBaseReportingView$View.showEmailError((String)object);
            }
        }
        return bl;
    }

    @Override
    public boolean hasValidConsents() {
        Object object = ((BaseReportingPresenter)object).consents;
        if (object == null) {
            return true;
        }
        object = object.iterator();
        while (object.hasNext()) {
            UserConsent userConsent = (UserConsent)object.next();
            if (!userConsent.isMandatory() || userConsent.isChecked()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAttachmentBeingRemoved(Attachment attachment) {
        return this.beingRemovedAttachments.contains(attachment) || attachment.isRemoved();
    }

    @Override
    public boolean shouldShowScreenRecording() {
        return this.shouldShowScreenRecording;
    }

    @Override
    public boolean shouldShowExtraScreenshot() {
        boolean bl = BugSettings.getInstance().getAttachmentsTypesParams().isAllowTakeExtraScreenshot();
        boolean bl2 = bl && SettingsManager.getInstance().isScreenshotByMediaProjectionEnabled();
        Object object = (IBaseReportingView$View)((BasePresenter)object).view.get();
        object = object == null ? null : object.getContext();
        if (bl2) {
            return object != null && MediaProjectionHelper.INSTANCE.isMediaProjectionServiceAvailable((Context)object);
        }
        return bl;
    }

    private static enum WaitingPreparationAction {
        NONE,
        SEND_BUG,
        TAKE_EXTRA_SCREENSHOT,
        RECORD_VIDEO;

    }
}

