/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view.reporting;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.projection.MediaProjectionManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.text.Editable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextWatcher;
import android.text.method.LinkMovementMethod;
import android.text.style.StyleSpan;
import android.text.style.TypefaceSpan;
import android.util.DisplayMetrics;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.content.ContextCompat;
import androidx.core.text.TextUtilsCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.instabug.bug.LiveBugManager;
import com.instabug.bug.R;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.internal.video.VideoPlayerFragment;
import com.instabug.bug.screenrecording.ExternalScreenRecordHelper;
import com.instabug.bug.settings.BugSettings;
import com.instabug.bug.userConsent.UserConsent;
import com.instabug.bug.view.AttachmentsAdapter;
import com.instabug.bug.view.BugReportingActivityCallback;
import com.instabug.bug.view.InstabugThanksActivity;
import com.instabug.bug.view.annotation.BugAnnotationFragment;
import com.instabug.bug.view.extrafields.ExtraFieldsFragment;
import com.instabug.bug.view.reporting.ConsentsRecyclerViewAdapter;
import com.instabug.bug.view.reporting.IBaseReportingView$Presenter;
import com.instabug.bug.view.reporting.IBaseReportingView$View;
import com.instabug.bug.view.reporting.OnMandatoryCheckStateChanged;
import com.instabug.bug.view.reporting.ReportingContainerActivity;
import com.instabug.bug.view.reporting.ReportingNavigator;
import com.instabug.bug.view.visualusersteps.steppreview.VisualUserStepArgs;
import com.instabug.library.Feature;
import com.instabug.library.FragmentVisibilityChangedListener;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.internal.video.RequestPermissionActivityLauncher;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.ui.custom.InstabugAlertDialog;
import com.instabug.library.ui.custom.InstabugEditText;
import com.instabug.library.user.UserManagerWrapper;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.DisplayUtils;
import com.instabug.library.util.DrawableUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.OrientationUtils;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.SimpleTextWatcher;
import com.instabug.library.util.SystemServiceUtils;
import com.instabug.library.util.ThemeApplier;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.view.IBGProgressDialog;
import com.instabug.library.view.ViewUtils;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED", "ERADICATE_FIELD_NOT_NULLABLE"})
public abstract class BaseReportingFragment
extends InstabugBaseFragment<IBaseReportingView$Presenter>
implements AttachmentsAdapter.AttachmentOnClickListener,
View.OnClickListener,
IBaseReportingView$View,
View.OnFocusChangeListener {
    private static int lastState = -1;
    private EditText emailEditText;
    private EditText messageEditText;
    private TextView disclaimerTextView;
    protected TextView reproStepsDisclaimerTextView;
    private RecyclerView attachmentsList;
    private LinearLayout addAttachments;
    private LinearLayout bugReportingInputsContainer;
    @VisibleForTesting
    ScrollView scrollView;
    @Nullable
    private String issueMessage;
    private boolean isVideoPlayBtnClicked;
    private BroadcastReceiver refreshAttachmentsBroadcastReceiver;
    @Nullable
    private IBGProgressDialog preparingProgressDialog;
    private AttachmentsAdapter attachmentsAdapter;
    private Callbacks listener;
    @Nullable
    private BugReportingActivityCallback activityCallback;
    @Nullable
    private BottomSheetBehavior<View> attachmentBottomSheetBehavior;
    @Nullable
    private ImageView arrowHandler;
    private int enabledAttachmentCount = 0;
    private boolean isKeyboardOpen = false;
    private boolean isBottomSheetDragDisabled = false;
    private long lastClickTime = 0L;
    @Nullable
    private Runnable attachmentClickRunnable;
    private final Handler attachmentClickHandler;
    @Nullable
    private View focusedView;
    private RecyclerView consentsRecyclerView;
    private MenuItem submitMenuItem;
    private int scrollViewExpandedAttachmentsPadding;
    private final AccessibilityDelegateCompat collapseDelegate;
    private final AccessibilityDelegateCompat expandDelegate;
    ViewTreeObserver.OnGlobalLayoutListener keyboardObserver;

    public BaseReportingFragment() {
        ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener;
        AccessibilityDelegateCompat accessibilityDelegateCompat;
        AccessibilityDelegateCompat accessibilityDelegateCompat2;
        Handler handler;
        Object object = handler;
        handler = new Handler();
        this.attachmentClickHandler = object;
        this.scrollViewExpandedAttachmentsPadding = 170;
        object = accessibilityDelegateCompat2;
        accessibilityDelegateCompat2 = new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                1 v0 = this;
                super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                accessibilityNodeInfoCompat.setText((CharSequence)v0.BaseReportingFragment.this.getLocalizedString(R.string.ibg_bug_report_arrow_handler_collapse_description));
            }
        };
        this.collapseDelegate = object;
        object = accessibilityDelegateCompat;
        accessibilityDelegateCompat = new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                2 v0 = this;
                super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                accessibilityNodeInfoCompat.setText((CharSequence)v0.BaseReportingFragment.this.getLocalizedString(R.string.ibg_bug_report_arrow_handler_expand_description));
            }
        };
        this.expandDelegate = object;
        object = onGlobalLayoutListener;
        onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (BaseReportingFragment.this.getActivity() != null && BaseReportingFragment.this.rootView != null) {
                    int n;
                    Rect rect;
                    3 v0 = this;
                    Rect rect2 = rect;
                    rect = new Rect();
                    v0.BaseReportingFragment.this.getActivity().getWindow().getDecorView().getWindowVisibleDisplayFrame(rect2);
                    int n2 = v0.BaseReportingFragment.this.getActivity().getWindow().getDecorView().getRootView().getHeight();
                    if ((double)(n - rect2.bottom) > (double)n2 * 0.15) {
                        3 v3 = this;
                        BaseReportingFragment.access$102(v3.BaseReportingFragment.this, true);
                        if (v3.BaseReportingFragment.this.attachmentBottomSheetBehavior != null) {
                            BaseReportingFragment.this.attachmentBottomSheetBehavior.setState(4);
                        }
                        3 v4 = this;
                        BaseReportingFragment.access$302(v4.BaseReportingFragment.this, true);
                        if (v4.BaseReportingFragment.this.arrowHandler != null) {
                            BaseReportingFragment.this.arrowHandler.setVisibility(4);
                        }
                    } else {
                        3 v5 = this;
                        BaseReportingFragment.access$302(v5.BaseReportingFragment.this, false);
                        BaseReportingFragment.access$102(v5.BaseReportingFragment.this, false);
                        if (v5.BaseReportingFragment.this.enabledAttachmentCount > 1 && BaseReportingFragment.this.arrowHandler != null) {
                            BaseReportingFragment.this.arrowHandler.setVisibility(0);
                        }
                    }
                }
            }
        };
        this.keyboardObserver = object;
    }

    private void setVideoRecordingStatus(int n) {
        BaseContract.Presenter presenter = baseReportingFragment.presenter;
        if (presenter != null && !((IBaseReportingView$Presenter)presenter).shouldShowScreenRecording()) {
            View view = baseReportingFragment.findViewById(R.id.instabug_attach_video);
            BaseReportingFragment baseReportingFragment = baseReportingFragment.findViewById(R.id.ib_bug_attachment_collapsed_video_icon);
            if (view != null) {
                view.setVisibility(8);
            }
            if (baseReportingFragment != null) {
                baseReportingFragment.setVisibility(8);
            }
        } else if ((baseReportingFragment = baseReportingFragment.findViewById(R.id.instabug_attach_video)) != null) {
            baseReportingFragment.setVisibility(n);
        }
    }

    private void restrictEditTextActions(EditText object) {
        ActionMode.Callback callback;
        EditText editText = object;
        object = callback;
        callback = new ActionMode.Callback(){

            public boolean onCreateActionMode(ActionMode actionMode, Menu menu2) {
                return true;
            }

            public boolean onPrepareActionMode(ActionMode actionMode, Menu menu2) {
                for (int i = menu2.size() - 1; i >= 0; --i) {
                    actionMode = menu2.getItem(i);
                    if (actionMode.getItemId() == 0x1020021 || actionMode.getItemId() == 0x1020022 || actionMode.getItemId() == 0x1020020) continue;
                    menu2.removeItem(actionMode.getItemId());
                }
                return true;
            }

            public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
                return false;
            }

            public void onDestroyActionMode(ActionMode actionMode) {
            }
        };
        editText.setCustomSelectionActionModeCallback((ActionMode.Callback)object);
    }

    private void addEmailTextWatcher() {
        PoolProvider.postMainThreadTask(() -> {
            Object object = this.emailEditText;
            if (object != null) {
                SimpleTextWatcher simpleTextWatcher;
                EditText editText = object;
                object = simpleTextWatcher;
                simpleTextWatcher = new SimpleTextWatcher(){

                    public void afterTextChanged(Editable object) {
                        if (BaseReportingFragment.this.emailEditText != null) {
                            9 v0 = this;
                            object = v0.BaseReportingFragment.this.emailEditText.getText().toString();
                            if (v0.BaseReportingFragment.this.presenter != null) {
                                ((IBaseReportingView$Presenter)BaseReportingFragment.this.presenter).onEmailChanged((String)object);
                            }
                        }
                    }
                };
                editText.addTextChangedListener((TextWatcher)object);
            }
        });
    }

    private void setEmailEditTextOnMainThread(String string2) {
        PoolProvider.postMainThreadTask(() -> {
            BaseReportingFragment baseReportingFragment = baseReportingFragment.emailEditText;
            if (baseReportingFragment != null) {
                baseReportingFragment.setText(string2);
            }
        });
    }

    private boolean shouldAdjustViewsHeights() {
        return DisplayUtils.isSmallDevice() && BugSettings.getInstance().getDisclaimerText() != null && !BugSettings.getInstance().getDisclaimerText().toString().equals("");
    }

    private String getDisclaimer() {
        return PlaceHolderUtils.getPlaceHolder((Context)this.getContext(), (InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.REPORT_REPRO_STEPS_DISCLAIMER_BODY, (int)R.string.IBGReproStepsDisclaimerBody);
    }

    private String getDisclaimerLink() {
        return PlaceHolderUtils.getPlaceHolder((Context)this.getContext(), (InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.REPORT_REPRO_STEPS_DISCLAIMER_LINK, (int)R.string.IBGReproStepsDisclaimerLink);
    }

    private void collapseAttachmentBar() {
        BaseContract.Presenter presenter;
        if (this.rootView == null) {
            return;
        }
        if (this.findViewById(R.id.instabug_add_attachment) != null) {
            this.findViewById(R.id.instabug_add_attachment).setVisibility(0);
        }
        if ((presenter = this.presenter) != null && ((IBaseReportingView$Presenter)presenter).shouldShowScreenRecording()) {
            this.setVideoRecordingStatus(4);
        } else {
            this.setVideoRecordingStatus(8);
        }
    }

    private void expandAttachmentBar() {
        if (this.rootView == null) {
            return;
        }
        BaseContract.Presenter presenter = this.presenter;
        if (presenter != null && ((IBaseReportingView$Presenter)presenter).shouldShowScreenRecording()) {
            if (this.findViewById(R.id.instabug_add_attachment) != null) {
                this.findViewById(R.id.instabug_add_attachment).setVisibility(4);
            }
            this.setVideoRecordingStatus(0);
        } else {
            if (this.findViewById(R.id.instabug_add_attachment) != null) {
                this.findViewById(R.id.instabug_add_attachment).setVisibility(8);
            }
            this.setVideoRecordingStatus(8);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"WrongConstant"})
    private void initAttachmentsActionBar() {
        block28: {
            block27: {
                block26: {
                    var1_2 = 0;
                    try {
                        var2_4 = this.theme;
                        if (var2_4 != null) {
                            var1_2 = var2_4.getBackgroundColor();
                        }
                        if ((var2_4 = this.findViewById(R.id.instabug_attachment_bottom_sheet)) != null && var1_2 != 0) {
                            var2_4.setBackgroundColor(var1_2);
                        }
                        v0 = var2_4;
                        ThemeApplier.applyPrimaryTextStyle((TextView)((TextView)this.findViewById(R.id.instabug_add_attachment_label)), (IBGTheme)this.theme);
                        this.handleBottomSheetArrow();
                        var2_4 = (ImageView)this.findViewById(R.id.instabug_add_attachment_icon);
                        v1 = BottomSheetBehavior.from((View)v0);
                    }
                    catch (Exception var0_1) {}
                    this.attachmentBottomSheetBehavior = v1;
                    v1.setPeekHeight(ViewUtils.convertDpToPx((Context)Instabug.getApplicationContext(), (float)100.0f));
                    var3_6 = (LinearLayout)this.findViewById(R.id.instabug_add_attachment);
                    if (var3_6 == null) ** GOTO lbl21
                    var3_6.setOnClickListener((View.OnClickListener)this);
lbl21:
                    // 2 sources

                    if ((var4_7 = (LinearLayout)this.findViewById(R.id.ib_bottomsheet_arrow_layout)) == null) ** GOTO lbl26
                    var4_7.setOnClickListener((View.OnClickListener)this);
                    if (var1_2 != 0) {
                        var4_7.setBackgroundColor(var1_2);
                    }
lbl26:
                    // 4 sources

                    if (var2_4 != null) {
                        var1_2 = SettingsManager.getInstance().getPrimaryColor();
                        this.colorizeImg((ImageView)var2_4, var1_2);
                    }
                    ThemeApplier.applyPrimaryTextStyle((TextView)((TextView)this.findViewById(R.id.instabug_attach_video_label)), (IBGTheme)this.theme);
                    ThemeApplier.applyPrimaryTextStyle((TextView)((TextView)this.findViewById(R.id.instabug_attach_screenshot_label)), (IBGTheme)this.theme);
                    ThemeApplier.applyPrimaryTextStyle((TextView)((TextView)this.findViewById(R.id.instabug_attach_gallery_image_label)), (IBGTheme)this.theme);
                    this.setListenersAndIconColors();
                    if (var3_6 != null) {
                        var3_6.setVisibility(4);
                    }
                    if (this.enabledAttachmentCount <= 1) ** GOTO lbl53
                    v2 = this.scrollView;
                    v3 = 0;
                    v4 = 0;
                    v5 = 0;
                    v6 = Instabug.getApplicationContext();
                    v7 = this.scrollViewExpandedAttachmentsPadding;
                    v2.setPadding(v3, v4, v5, ViewUtils.convertDpToPx((Context)v6, (float)v7));
                    var1_3 = this.attachmentBottomSheetBehavior;
                    if (var1_3 == null) ** GOTO lbl62
                    v8 = var1_3;
                    var1_3 = v9;
                    v9 = new BottomSheetBehavior.BottomSheetCallback(){

                        public void onStateChanged(@NonNull View view, int n) {
                            if (BaseReportingFragment.this.scrollView != null && n != 2) {
                                int n2 = n;
                                lastState = n2;
                                if (n2 == 4 && !BaseReportingFragment.this.isKeyboardOpen) {
                                    int n3 = ViewUtils.convertDpToPx((Context)Instabug.getApplicationContext(), (float)20.0f);
                                    BaseReportingFragment.this.scrollView.setPadding(0, 0, 0, n3);
                                } else if (n == 3) {
                                    int n4 = ViewUtils.convertDpToPx((Context)Instabug.getApplicationContext(), (float)BaseReportingFragment.this.scrollViewExpandedAttachmentsPadding);
                                    BaseReportingFragment.this.scrollView.setPadding(0, 0, 0, n4);
                                }
                                if (n == 1 && BaseReportingFragment.this.isBottomSheetDragDisabled || BaseReportingFragment.this.isKeyboardOpen) {
                                    BaseReportingFragment.this.collapseAttachmentBar();
                                    return;
                                }
                                if (n == 4) {
                                    BaseReportingFragment.this.collapseAttachmentBar();
                                } else {
                                    BaseReportingFragment.this.expandAttachmentBar();
                                }
                                return;
                            }
                        }

                        public void onSlide(@NonNull View view, float f) {
                            if (BaseReportingFragment.this.arrowHandler != null) {
                                BaseReportingFragment.this.arrowHandler.setRotation((1.0f - f) * 180.0f);
                                if (AccessibilityUtils.isTalkbackEnabled()) {
                                    if (f == 0.0f) {
                                        ViewCompat.setAccessibilityDelegate((View)BaseReportingFragment.this.arrowHandler, (AccessibilityDelegateCompat)BaseReportingFragment.this.expandDelegate);
                                    } else if (f == 1.0f) {
                                        ViewCompat.setAccessibilityDelegate((View)BaseReportingFragment.this.arrowHandler, (AccessibilityDelegateCompat)BaseReportingFragment.this.collapseDelegate);
                                    }
                                }
                            }
                        }
                    };
                    v8.setBottomSheetCallback(var1_3);
                    ** GOTO lbl62
lbl53:
                    // 1 sources

                    this.scrollView.setPadding(0, 0, 0, ViewUtils.convertDpToPx((Context)Instabug.getApplicationContext(), (float)0.0f));
                    var1_3 = this.attachmentBottomSheetBehavior;
                    if (var1_3 == null) ** GOTO lbl62
                    v10 = var1_3;
                    var1_3 = v11;
                    v11 = new BottomSheetBehavior.BottomSheetCallback(){

                        public void onStateChanged(@NonNull View view, int n) {
                            if (BaseReportingFragment.this.attachmentBottomSheetBehavior != null) {
                                BaseReportingFragment.this.attachmentBottomSheetBehavior.setState(4);
                            }
                        }

                        public void onSlide(@NonNull View view, float f) {
                        }
                    };
                    v10.setBottomSheetCallback(var1_3);
lbl62:
                    // 4 sources

                    if ((var1_3 = this.attachmentBottomSheetBehavior) == null) ** GOTO lbl70
                    var2_5 = BaseReportingFragment.lastState;
                    if (var2_5 != -1) break block26;
                    var2_5 = 3;
                }
                var1_3.setState(var2_5);
lbl70:
                // 2 sources

                if (BaseReportingFragment.lastState != 4) ** GOTO lbl82
                this.collapseAttachmentBar();
                var1_3 = this.attachmentBottomSheetBehavior;
                if (var1_3 == null) ** GOTO lbl76
                var1_3.setState(4);
lbl76:
                // 2 sources

                if ((var1_3 = this.arrowHandler) == null) ** GOTO lbl89
                var1_3.setRotation(180.0f);
                if (AccessibilityUtils.isTalkbackEnabled()) {
                    ViewCompat.setAccessibilityDelegate((View)this.arrowHandler, (AccessibilityDelegateCompat)this.expandDelegate);
                }
                ** GOTO lbl89
lbl82:
                // 1 sources

                this.expandAttachmentBar();
                var1_3 = this.arrowHandler;
                if (var1_3 == null) ** GOTO lbl89
                var1_3.setRotation(0.0f);
                if (AccessibilityUtils.isTalkbackEnabled()) {
                    ViewCompat.setAccessibilityDelegate((View)this.arrowHandler, (AccessibilityDelegateCompat)this.collapseDelegate);
                }
lbl89:
                // 6 sources

                this.addCustomPlaceHolders();
                if (this.getActivity() == null || !OrientationUtils.isInLandscape((Context)this.getActivity())) break block27;
                this.collapseAttachmentBar();
                var1_3 = this.attachmentBottomSheetBehavior;
                if (var1_3 == null) ** GOTO lbl96
                var1_3.setState(4);
lbl96:
                // 2 sources

                if ((var1_3 = this.arrowHandler) == null) break block27;
                var1_3.setRotation(180.0f);
                break block28;
            }
            this.handleAttachmentsDragging();
            this.arrowHandler = this.arrowHandler;
            return;
        }
        InstabugSDKLogger.e((String)"IBG-BR", (String)"Error in initAttachmentsActionBar", (Throwable)var0_1);
    }

    private void handleBottomSheetArrow() {
        ImageView imageView = (ImageView)this.findViewById(R.id.arrow_handler);
        if (imageView != null) {
            imageView.setRotation(0.0f);
            imageView.setOnClickListener((View.OnClickListener)this);
            if (AccessibilityUtils.isTalkbackEnabled()) {
                ViewCompat.setAccessibilityDelegate((View)imageView, (AccessibilityDelegateCompat)this.collapseDelegate);
            }
        }
    }

    private void handleAttachmentsDragging() {
        ImageView imageView = this.arrowHandler;
        if (imageView != null && this.enabledAttachmentCount == 1) {
            imageView.setVisibility(8);
            if (this.findViewById(R.id.instabug_add_attachment) != null) {
                this.findViewById(R.id.instabug_add_attachment).setVisibility(8);
            }
        }
    }

    private void announceScreenVideoDuration() {
        long l = LiveBugManager.getInstance().getAndResetRecordingDuration();
        if (l != -1L && AccessibilityUtils.isTalkbackEnabled()) {
            int n = R.string.ibg_screen_recording_duration_ended_for_accessibility;
            Long l2 = l;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = l2;
            AccessibilityUtils.sendTextEvent((String)this.getLocalizedString(n, objectArray2));
        }
    }

    private void setListenersAndIconColors() {
        BaseReportingFragment baseReportingFragment = this;
        baseReportingFragment.initScreenRecordViews();
        baseReportingFragment.initExtraScreenShotViews();
        baseReportingFragment.initGalleryAttachmentViews();
    }

    private void initScreenRecordViews() {
        BaseContract.Presenter presenter = this.presenter;
        if (presenter != null && ((IBaseReportingView$Presenter)presenter).shouldShowScreenRecording()) {
            BaseReportingFragment baseReportingFragment = this;
            ++baseReportingFragment.enabledAttachmentCount;
            if (baseReportingFragment.findViewById(R.id.instabug_attach_video) != null) {
                this.findViewById(R.id.instabug_attach_video).setOnClickListener((View.OnClickListener)this);
            }
            BaseReportingFragment baseReportingFragment2 = this;
            presenter = (ImageView)baseReportingFragment2.findViewById(R.id.instabug_attach_video_icon);
            ImageView imageView = (ImageView)baseReportingFragment2.findViewById(R.id.ib_bug_attachment_collapsed_video_icon);
            baseReportingFragment2.colorizeImg((ImageView)presenter, SettingsManager.getInstance().getPrimaryColor());
            if (baseReportingFragment2.getContext() != null) {
                this.colorizeImg(imageView, SettingsManager.getInstance().getPrimaryColor());
            }
        } else {
            BaseReportingFragment baseReportingFragment = this;
            baseReportingFragment.setVideoRecordingStatus(8);
            if (baseReportingFragment.findViewById(R.id.ib_bug_attachment_collapsed_video_icon) != null) {
                this.findViewById(R.id.ib_bug_attachment_collapsed_video_icon).setVisibility(8);
            }
            if (this.findViewById(R.id.ib_bug_videorecording_separator) != null) {
                this.findViewById(R.id.ib_bug_videorecording_separator).setVisibility(8);
            }
        }
    }

    private void initExtraScreenShotViews() {
        BaseContract.Presenter presenter = this.presenter;
        if (presenter != null && ((IBaseReportingView$Presenter)presenter).shouldShowExtraScreenshot()) {
            BaseReportingFragment baseReportingFragment = this;
            ++baseReportingFragment.enabledAttachmentCount;
            if (baseReportingFragment.findViewById(R.id.instabug_attach_screenshot) != null) {
                this.findViewById(R.id.instabug_attach_screenshot).setOnClickListener((View.OnClickListener)this);
            }
            BaseReportingFragment baseReportingFragment2 = this;
            presenter = (ImageView)baseReportingFragment2.findViewById(R.id.instabug_attach_screenshot_icon);
            ImageView imageView = (ImageView)baseReportingFragment2.findViewById(R.id.ib_bug_attachment_collapsed_screenshot_icon);
            baseReportingFragment2.colorizeImg((ImageView)presenter, SettingsManager.getInstance().getPrimaryColor());
            if (baseReportingFragment2.getContext() != null) {
                this.colorizeImg(imageView, SettingsManager.getInstance().getPrimaryColor());
            }
        } else {
            if (this.findViewById(R.id.instabug_attach_screenshot) != null) {
                this.findViewById(R.id.instabug_attach_screenshot).setVisibility(8);
            }
            if (this.findViewById(R.id.ib_bug_attachment_collapsed_screenshot_icon) != null) {
                this.findViewById(R.id.ib_bug_attachment_collapsed_screenshot_icon).setVisibility(8);
            }
            if (this.findViewById(R.id.ib_bug_screenshot_separator) != null) {
                this.findViewById(R.id.ib_bug_screenshot_separator).setVisibility(8);
            }
        }
    }

    private void initGalleryAttachmentViews() {
        if (BugSettings.getInstance().getAttachmentsTypesParams().isAllowAttachImageFromGallery()) {
            BaseReportingFragment baseReportingFragment = baseReportingFragment;
            ++baseReportingFragment.enabledAttachmentCount;
            View view = baseReportingFragment.findViewById(R.id.instabug_attach_gallery_image);
            BaseReportingFragment baseReportingFragment2 = baseReportingFragment;
            ImageView imageView = (ImageView)baseReportingFragment2.findViewById(R.id.instabug_attach_gallery_image_icon);
            ImageView imageView2 = (ImageView)baseReportingFragment2.findViewById(R.id.ib_bug_attachment_collapsed_photo_library_icon);
            if (view != null) {
                view.setOnClickListener((View.OnClickListener)baseReportingFragment);
            }
            if (baseReportingFragment.getContext() != null) {
                baseReportingFragment.colorizeImg(imageView2, SettingsManager.getInstance().getPrimaryColor());
            }
            baseReportingFragment.colorizeImg(imageView, SettingsManager.getInstance().getPrimaryColor());
        } else {
            View view = baseReportingFragment.findViewById(R.id.instabug_attach_gallery_image);
            BaseReportingFragment baseReportingFragment = baseReportingFragment.findViewById(R.id.ib_bug_attachment_collapsed_photo_library_icon);
            if (view != null) {
                view.setVisibility(8);
            }
            if (baseReportingFragment != null) {
                baseReportingFragment.setVisibility(8);
            }
        }
    }

    private void colorizeImg(ImageView imageView, int n) {
        if (imageView == null) {
            return;
        }
        imageView.getDrawable().setColorFilter(n, PorterDuff.Mode.SRC_IN);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private void addCustomPlaceHolders() {
        TextView textView = (TextView)this.findViewById(R.id.instabug_attach_gallery_image_label);
        BaseReportingFragment baseReportingFragment = this;
        TextView textView2 = (TextView)baseReportingFragment.findViewById(R.id.instabug_attach_screenshot_label);
        TextView textView3 = (TextView)baseReportingFragment.findViewById(R.id.instabug_attach_video_label);
        if (textView != null) {
            textView.setText((CharSequence)PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.ADD_IMAGE_FROM_GALLERY, (String)this.getLocalizedString(R.string.instabug_str_pick_media_from_gallery)));
        }
        if (textView2 != null) {
            textView2.setText((CharSequence)PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.ADD_EXTRA_SCREENSHOT, (String)this.getLocalizedString(R.string.instabug_str_take_screenshot)));
        }
        if (textView3 != null) {
            textView3.setText((CharSequence)PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.ADD_VIDEO, (String)this.getLocalizedString(R.string.instabug_str_record_video)));
        }
    }

    private void doIfVideoDoneEncoding(Runnable object) {
        if (ExternalScreenRecordHelper.getInstance().isRecording()) {
            object = this.getLocalizedString(R.string.instabug_str_video_encoder_busy) + ", " + this.getLocalizedString(R.string.instabug_str_please_wait);
            if (this.getContext() != null) {
                Toast.makeText((Context)this.getContext().getApplicationContext(), (CharSequence)object, (int)1).show();
            }
        } else {
            object.run();
        }
    }

    @RequiresApi(api=21)
    private void startScreenRecording() {
        if (!ExternalScreenRecordHelper.getInstance().isRecording()) {
            this.requestAudioRecordingPermissions();
        } else if (this.getContext() != null) {
            Toast.makeText((Context)this.getContext().getApplicationContext(), (int)R.string.instabug_str_video_encoder_busy, (int)0).show();
        }
    }

    private void initAttachmentClickRunnable(final View view, final @NonNull Attachment attachment, final @IdRes int n) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                int n2 = n;
                if (n2 != R.id.instabug_attachment_img_item && n2 != R.id.instabug_btn_image_edit_attachment) {
                    if (n2 == R.id.instabug_btn_remove_attachment) {
                        if (BaseReportingFragment.this.presenter != null) {
                            ((IBaseReportingView$Presenter)BaseReportingFragment.this.presenter).removeAttachment(attachment);
                        }
                    } else if (n2 == R.id.instabug_attachment_video_item && attachment.getLocalPath() != null) {
                        17 v0 = this;
                        BaseReportingFragment.access$2502(v0.BaseReportingFragment.this, true);
                        v0.BaseReportingFragment.this.startVideo(attachment);
                    }
                } else {
                    17 v1 = this;
                    View view2 = v1.view;
                    BaseReportingFragment.this.openAttachment(view2, v1.attachment);
                }
                if (BaseReportingFragment.this.attachmentClickHandler != null && BaseReportingFragment.this.attachmentClickRunnable != null) {
                    BaseReportingFragment.this.attachmentClickHandler.removeCallbacks(BaseReportingFragment.this.attachmentClickRunnable);
                }
                BaseReportingFragment.access$2702(BaseReportingFragment.this, null);
            }
        };
        this.attachmentClickRunnable = runnable2;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private void clearFocusFromEditTexts() {
        EditText editText = this.emailEditText;
        if (editText != null) {
            editText.clearFocus();
            this.emailEditText.setError(null);
        }
        if ((editText = this.messageEditText) != null) {
            editText.clearFocus();
            this.messageEditText.setError(null);
        }
    }

    @RequiresApi(api=21)
    private void requestAudioRecordingPermissions() {
        if (stringArray3.getActivity() == null) {
            return;
        }
        if (ContextCompat.checkSelfPermission((Context)stringArray3.getActivity(), (String)"android.permission.RECORD_AUDIO") == 0) {
            stringArray3.requestVideoRecordingPermissions();
        } else {
            String[] stringArray = stringArray3;
            String[] stringArray2 = new String[1];
            String[] stringArray3 = stringArray2;
            stringArray2[0] = "android.permission.RECORD_AUDIO";
            stringArray.requestPermissions(stringArray3, 177);
        }
    }

    @RequiresApi(api=21)
    private void requestVideoRecordingPermissions() {
        MediaProjectionManager mediaProjectionManager;
        if (Build.VERSION.SDK_INT >= 21 && this.getActivity() != null && (mediaProjectionManager = (MediaProjectionManager)this.getActivity().getSystemService("media_projection")) != null) {
            ReportingNavigator.requestRecordingPermission(mediaProjectionManager, this);
        }
    }

    private void showAlertWhenUserReachMaxAttachmentsLimit() {
        if (this.getActivity() != null) {
            new InstabugAlertDialog.Builder((Activity)this.getActivity()).setTitle(this.getLocalizedString(R.string.instabug_str_alert_title_max_attachments)).setMessage(this.getLocalizedString(R.string.instabug_str_alert_message_max_attachments)).setPositiveButton(PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.BUG_ATTACHMENT_DIALOG_OK_BUTTON, (String)this.getLocalizedString(R.string.instabug_str_ok)), null).show();
        }
    }

    private void openAttachment(View view, @NonNull Attachment attachment) {
        BaseContract.Presenter presenter = ((InstabugBaseFragment)string2).presenter;
        if (presenter != null && !((IBaseReportingView$Presenter)presenter).isAttachmentBeingRemoved(attachment)) {
            ((BaseReportingFragment)((Object)string2)).hidKeyboard();
            if (attachment.getLocalPath() == null) {
                return;
            }
            if ((view = (ImageView)view.findViewById(R.id.instabug_img_attachment)) != null) {
                if (AccessibilityUtils.isTalkbackEnabled()) {
                    BaseReportingFragment baseReportingFragment = string2;
                    String string2 = view.getContentDescription().toString();
                    baseReportingFragment.openStepPreviewFragment(attachment.getLocalPath(), string2);
                } else {
                    presenter = ((InstabugBaseFragment)string2).presenter;
                    if (presenter != null) {
                        super.openAnnotationFragment(attachment, (ImageView)view, ((IBaseReportingView$Presenter)presenter).getTitle());
                    }
                }
            }
        }
    }

    private void openAnnotationFragment(Attachment attachment, ImageView imageView, String string2) {
        if (attachment.getLocalPath() == null) {
            return;
        }
        BaseReportingFragment baseReportingFragment = baseReportingFragment2;
        baseReportingFragment.notifyFragmentVisibilityChanged(false);
        FragmentTransaction fragmentTransaction = null;
        if (baseReportingFragment.getFragmentManager() != null) {
            fragmentTransaction = baseReportingFragment2.getFragmentManager().beginTransaction();
        }
        BaseReportingFragment baseReportingFragment2 = Uri.fromFile((File)new File(attachment.getLocalPath()));
        String string3 = ViewCompat.getTransitionName((View)imageView);
        if (string3 != null && fragmentTransaction != null) {
            fragmentTransaction.addSharedElement((View)imageView, string3);
        }
        if ((BitmapDrawable)imageView.getDrawable() != null && fragmentTransaction != null) {
            int n = R.id.instabug_fragment_container;
            fragmentTransaction.replace(n, (Fragment)BugAnnotationFragment.newInstance(string2, (Uri)baseReportingFragment2, attachment.getName()), "annotation").addToBackStack("annotation").commitAllowingStateLoss();
        }
    }

    private void openStepPreviewFragment(String string2, String string3) {
        Object object = ((InstabugBaseFragment)bugReportingActivityCallback).presenter;
        object = object != null ? ((IBaseReportingView$Presenter)object).getTitle() : string3;
        VisualUserStepArgs visualUserStepArgs = new VisualUserStepArgs((String)object, string2, string3);
        BugReportingActivityCallback bugReportingActivityCallback = ((BaseReportingFragment)((Object)bugReportingActivityCallback)).activityCallback;
        if (bugReportingActivityCallback != null) {
            bugReportingActivityCallback.openStepPreviewFragment(visualUserStepArgs);
        }
    }

    private void hidKeyboard() {
        if (this.getActivity() != null) {
            SystemServiceUtils.hideInputMethod((Activity)this.getActivity(), (View)this.focusedView);
        }
    }

    private void initRefreshAttachmentsReceiver() {
        BroadcastReceiver broadcastReceiver;
        BroadcastReceiver broadcastReceiver2 = broadcastReceiver;
        broadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                InstabugSDKLogger.v((String)"IBG-BR", (String)"Refreshing Attachments");
                if (BaseReportingFragment.this.getActivity() != null && BaseReportingFragment.this.presenter != null) {
                    ((IBaseReportingView$Presenter)BaseReportingFragment.this.presenter).refreshAttachments();
                }
            }
        };
        this.refreshAttachmentsBroadcastReceiver = broadcastReceiver2;
    }

    private static void teardown() {
        lastState = -1;
    }

    private void registerKeyboardObserver() {
        if (this.getActivity() != null) {
            this.getActivity().getWindow().getDecorView().getViewTreeObserver().addOnGlobalLayoutListener(this.keyboardObserver);
        }
    }

    private void unregisterKeyboardObserver() {
        if (Build.VERSION.SDK_INT >= 16 && this.getActivity() != null) {
            this.getActivity().getWindow().getDecorView().getViewTreeObserver().removeOnGlobalLayoutListener(this.keyboardObserver);
        }
    }

    private void setSubmitEnabledState() {
        MenuItem menuItem = this.submitMenuItem;
        if (menuItem != null && (this = this.presenter) != null) {
            menuItem.setEnabled(((IBaseReportingView$Presenter)((Object)this)).hasValidConsents());
        }
    }

    static /* synthetic */ boolean access$102(BaseReportingFragment baseReportingFragment, boolean bl) {
        baseReportingFragment.isKeyboardOpen = bl;
        return bl;
    }

    static /* synthetic */ boolean access$302(BaseReportingFragment baseReportingFragment, boolean bl) {
        baseReportingFragment.isBottomSheetDragDisabled = bl;
        return bl;
    }

    static /* synthetic */ boolean access$2502(BaseReportingFragment baseReportingFragment, boolean bl) {
        baseReportingFragment.isVideoPlayBtnClicked = bl;
        return bl;
    }

    static /* synthetic */ Runnable access$2702(BaseReportingFragment baseReportingFragment, Runnable runnable) {
        baseReportingFragment.attachmentClickRunnable = runnable;
        return runnable;
    }

    public void onCreate(@Nullable Bundle bundle) {
        BaseReportingFragment baseReportingFragment = this;
        this.postponeEnterTransition();
        super.onCreate(bundle);
        if (baseReportingFragment.getArguments() != null) {
            this.issueMessage = this.getArguments().getString("bug_message");
        }
        BaseReportingFragment baseReportingFragment2 = this;
        baseReportingFragment2.setHasOptionsMenu(true);
        baseReportingFragment2.initRefreshAttachmentsReceiver();
        if (baseReportingFragment2.presenter == null) {
            this.presenter = this.createPresenter();
        }
    }

    public void onAttach(Context context) {
        block4: {
            block3: {
                super.onAttach(context);
                try {
                    this.listener = (Callbacks)context;
                    if (!(this.getActivity() instanceof BugReportingActivityCallback)) break block3;
                }
                catch (ClassCastException classCastException) {
                    break block4;
                }
                this.activityCallback = (BugReportingActivityCallback)context;
            }
            return;
        }
        throw new ClassCastException(this.getClass().getSimpleName().toString() + " must implement BaseReportingFragment.Callbacks");
    }

    public void onDetach() {
        super.onDetach();
        this.activityCallback = null;
        this.listener = null;
    }

    protected int getLayout() {
        return R.layout.ibg_bug_frgament_reporting_layout;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    protected void initViews(View view, @Nullable Bundle bundle) {
        Object object;
        if (this.getActivity() instanceof ReportingContainerActivity) {
            ReportingContainerActivity reportingContainerActivity = (ReportingContainerActivity)this.getActivity();
            reportingContainerActivity.setToolbarNavigationContentDescription(this.getCloseButtonContentDescription());
            reportingContainerActivity.setToolbarUpIconClose();
        }
        this.scrollView = (ScrollView)this.findViewById(R.id.ib_bug_scroll_view);
        view = (InstabugEditText)this.findViewById(R.id.instabug_edit_text_message);
        bundle = view.getEditText();
        this.messageEditText = bundle;
        this.restrictEditTextActions((EditText)bundle);
        this.messageEditText.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        bundle = (InstabugEditText)this.findViewById(R.id.instabug_edit_text_email);
        Object object2 = bundle.getEditText();
        this.emailEditText = object2;
        this.restrictEditTextActions((EditText)object2);
        this.emailEditText.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.attachmentsList = (RecyclerView)this.findViewById(R.id.instabug_lyt_attachments_list);
        this.disclaimerTextView = (TextView)this.findViewById(R.id.instabug_text_view_disclaimer);
        this.reproStepsDisclaimerTextView = (TextView)this.findViewById(R.id.instabug_text_view_repro_steps_disclaimer);
        this.addAttachments = (LinearLayout)this.findViewById(R.id.instabug_add_attachment);
        this.consentsRecyclerView = (RecyclerView)this.findViewById(R.id.instabug_lyt_consent_list);
        object2 = (IBaseReportingView$Presenter)this.presenter;
        if (AccessibilityUtils.isTalkbackEnabled()) {
            ViewCompat.setAccessibilityDelegate((View)this.addAttachments, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

                public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                    4 v0 = this;
                    super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                    accessibilityNodeInfoCompat.setContentDescription((CharSequence)v0.BaseReportingFragment.this.getLocalizedString(R.string.ibg_bug_report_add_attachment_content_description));
                }
            });
        }
        this.bugReportingInputsContainer = (LinearLayout)this.findViewById(R.id.instabug_bug_reporting_edit_texts_container);
        this.initAttachmentsActionBar();
        if (this.getContext() != null) {
            AttachmentsAdapter attachmentsAdapter;
            LinearLayoutManager linearLayoutManager;
            object = this.attachmentsList;
            Context context = this.getContext();
            int n = 0;
            boolean bl = TextUtilsCompat.getLayoutDirectionFromLocale((Locale)InstabugCore.getLocale((Context)this.getContext())) == 1;
            LinearLayoutManager linearLayoutManager2 = linearLayoutManager;
            linearLayoutManager2(context, n, bl);
            object.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager2);
            ViewCompat.setLayoutDirection((View)this.attachmentsList, (int)0);
            object = attachmentsAdapter;
            attachmentsAdapter = new AttachmentsAdapter(this.getContext(), null, this);
            this.attachmentsAdapter = object;
        }
        object = PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.EMAIL_FIELD_HINT, (String)this.getLocalizedString(R.string.instabug_str_email_hint));
        this.emailEditText.setHint((CharSequence)object);
        if (AccessibilityUtils.isTalkbackEnabled()) {
            ViewCompat.setAccessibilityDelegate((View)this.emailEditText, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat((String)object){
                final /* synthetic */ String val$emailHint;
                {
                    this.val$emailHint = string2;
                }

                public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                    AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = accessibilityNodeInfoCompat;
                    5 v1 = this;
                    super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                    accessibilityNodeInfoCompat2.setText((CharSequence)v1.val$emailHint);
                    accessibilityNodeInfoCompat2.setShowingHintText(true);
                }
            });
            ViewCompat.setAccessibilityDelegate((View)this.messageEditText, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat((IBaseReportingView$Presenter)object2){
                final /* synthetic */ IBaseReportingView$Presenter val$presenter;
                {
                    this.val$presenter = presenter;
                }

                public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                    6 v0 = iBaseReportingView$Presenter;
                    super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                    IBaseReportingView$Presenter iBaseReportingView$Presenter = v0.val$presenter;
                    if (iBaseReportingView$Presenter != null) {
                        accessibilityNodeInfoCompat.setText((CharSequence)iBaseReportingView$Presenter.getMessageHint());
                    }
                    accessibilityNodeInfoCompat.setShowingHintText(true);
                }
            });
        }
        this.reproStepsDisclaimerTextView.setOnClickListener((View.OnClickListener)this);
        if (!BugSettings.getInstance().isEmailFieldVisible()) {
            bundle.setVisibility(8);
        }
        if (object2 != null && object2.getMessageHint() != null) {
            this.messageEditText.setHint((CharSequence)object2.getMessageHint());
        }
        if ((object = this.issueMessage) != null) {
            this.messageEditText.setText((CharSequence)object);
        }
        if (BugSettings.getInstance().isEmailFieldVisible()) {
            PoolProvider.postIOTask(() -> {
                Object object = UserManagerWrapper.getEmailForBugReport();
                if (LiveBugManager.getInstance().getBug() != null) {
                    Object object2 = LiveBugManager.getInstance().getBug().getState();
                    object2 = object2 != null ? object2.getUserEmail() : null;
                    Object var3_3 = null;
                    if (object2 != null && !((String)object2).isEmpty()) {
                        object = object2;
                    } else if (object == null || ((String)object).isEmpty()) {
                        object = var3_3;
                    }
                    if (object != null) {
                        this.setEmailEditTextOnMainThread((String)object);
                    }
                }
                this.addEmailTextWatcher();
            });
        }
        if (object2 != null) {
            Object object3 = object2;
            object3.handleVisualUserStepsDisclaimer(this.getDisclaimer(), this.getDisclaimerLink());
            object3.handleInstabugDisclaimer();
        }
        this.presenter = object2;
        this.hidKeyboard();
        if (this.shouldAdjustViewsHeights()) {
            float f = DisplayUtils.dpToPx((Resources)this.getResources(), (int)5);
            int n = DisplayUtils.dpToPxIntRounded((Resources)this.getResources(), (int)14);
            this.emailEditText.setTextSize(f);
            int n2 = n;
            this.emailEditText.setPadding(n2, n2, n2, n2);
            this.messageEditText.setTextSize(f);
            int n3 = n;
            this.messageEditText.setPadding(n3, n3, n3, n3);
            this.emailEditText.setMinimumHeight(0);
            this.emailEditText.setLines(1);
        }
        this.messageEditText.addTextChangedListener((TextWatcher)new SimpleTextWatcher((IBaseReportingView$Presenter)object2){
            final /* synthetic */ IBaseReportingView$Presenter val$presenter;
            {
                this.val$presenter = iBaseReportingView$Presenter;
            }

            public void afterTextChanged(Editable editable) {
                if (BaseReportingFragment.this.getActivity() != null && this.val$presenter != null && BaseReportingFragment.this.messageEditText != null) {
                    this.val$presenter.onMessageChanged(BaseReportingFragment.this.messageEditText.getText().toString());
                }
            }
        });
        this.applyTheme((InstabugEditText)bundle, (InstabugEditText)view);
    }

    @VisibleForTesting
    public void applyTheme(@Nullable InstabugEditText instabugEditText, @Nullable InstabugEditText instabugEditText2) {
        IBGTheme iBGTheme = this.theme;
        if (iBGTheme != null) {
            CoordinatorLayout coordinatorLayout;
            int n = iBGTheme.getBackgroundColor();
            if (n != 0 && (coordinatorLayout = (CoordinatorLayout)this.findViewById(R.id.ib_reporting_container)) != null) {
                coordinatorLayout.setBackgroundColor(n);
            }
            if (instabugEditText != null) {
                ThemeApplier.applyPrimaryTextStyle((TextView)instabugEditText.getLabelTextView(), (IBGTheme)this.theme);
            }
            if (instabugEditText2 != null) {
                ThemeApplier.applyPrimaryTextStyle((TextView)instabugEditText2.getLabelTextView(), (IBGTheme)this.theme);
            }
            ThemeApplier.applySecondaryTextStyle((TextView)this.emailEditText, (IBGTheme)this.theme);
            instabugEditText = this.theme;
            if (instabugEditText != null && instabugEditText.getSecondaryTextColor() != 0) {
                this.emailEditText.setHintTextColor(this.theme.getSecondaryTextColor());
                this.messageEditText.setHintTextColor(this.theme.getSecondaryTextColor());
            }
            ThemeApplier.applySecondaryTextStyle((TextView)this.messageEditText, (IBGTheme)this.theme);
            ThemeApplier.applySecondaryTextStyle((TextView)this.reproStepsDisclaimerTextView, (IBGTheme)this.theme);
            instabugEditText = null;
            instabugEditText2 = this.theme;
            if (instabugEditText2 != null) {
                instabugEditText = instabugEditText2.getCtaTextFont();
            }
            if (instabugEditText != null || (instabugEditText2 = this.theme) != null && instabugEditText2.getCtaTextStyle() != 0) {
                SpannableString spannableString;
                instabugEditText2 = spannableString;
                spannableString = new SpannableString(this.reproStepsDisclaimerTextView.getText());
                n = this.reproStepsDisclaimerTextView.getText().toString().indexOf(this.getDisclaimerLink());
                if (n != -1) {
                    StyleSpan styleSpan;
                    if (Build.VERSION.SDK_INT >= 28 && instabugEditText != null) {
                        TypefaceSpan typefaceSpan;
                        InstabugEditText instabugEditText3 = instabugEditText2;
                        coordinatorLayout = typefaceSpan;
                        typefaceSpan = new TypefaceSpan((Typeface)instabugEditText);
                        int n2 = instabugEditText3.length();
                        instabugEditText3.setSpan((Object)coordinatorLayout, n, n2, 18);
                    }
                    InstabugEditText instabugEditText4 = instabugEditText2;
                    StyleSpan styleSpan2 = styleSpan;
                    styleSpan = new StyleSpan(this.theme.getCtaTextStyle());
                    int n3 = instabugEditText4.length();
                    instabugEditText4.setSpan((Object)styleSpan2, n, n3, 18);
                }
                this.reproStepsDisclaimerTextView.setText((CharSequence)instabugEditText2);
            }
        }
    }

    public void onResume() {
        BaseReportingFragment baseReportingFragment = this;
        super.onResume();
        baseReportingFragment.announceScreenVideoDuration();
        baseReportingFragment.registerKeyboardObserver();
    }

    public void onViewCreated(@NotNull View object, @Nullable Bundle bundle) {
        BaseReportingFragment baseReportingFragment = this;
        super.onViewCreated((View)object, bundle);
        if (baseReportingFragment.getActivity() != null) {
            this.getActivity().getWindow().setSoftInputMode(16);
        }
        if ((object = this.activityCallback) != null && (this = this.presenter) != null) {
            object.setToolbarTitle(((IBaseReportingView$Presenter)((Object)this)).getTitle());
        }
    }

    public void onStart() {
        BaseReportingFragment baseReportingFragment = this;
        super.onStart();
        IBaseReportingView$Presenter iBaseReportingView$Presenter = (IBaseReportingView$Presenter)baseReportingFragment.presenter;
        if (baseReportingFragment.getActivity() != null && iBaseReportingView$Presenter != null) {
            iBaseReportingView$Presenter.onStart();
            LocalBroadcastManager.getInstance((Context)this.getActivity()).registerReceiver(this.refreshAttachmentsBroadcastReceiver, new IntentFilter("refresh.attachments"));
            iBaseReportingView$Presenter.refreshAttachments();
        }
        this.presenter = iBaseReportingView$Presenter;
    }

    @StringRes
    protected abstract int getCloseButtonContentDescription();

    public void onStop() {
        BaseContract.Presenter presenter;
        BaseReportingFragment baseReportingFragment = this;
        super.onStop();
        if (baseReportingFragment.getActivity() != null && (presenter = this.presenter) != null) {
            ((IBaseReportingView$Presenter)presenter).onStop();
            LocalBroadcastManager.getInstance((Context)this.getActivity()).unregisterReceiver(this.refreshAttachmentsBroadcastReceiver);
        }
        this.unregisterKeyboardObserver();
    }

    public void onSaveInstanceState(@NotNull Bundle bundle) {
        BaseReportingFragment baseReportingFragment = baseReportingFragment2;
        super.onSaveInstanceState(bundle);
        BaseReportingFragment baseReportingFragment2 = baseReportingFragment.presenter;
        if (baseReportingFragment2 != null) {
            ((IBaseReportingView$Presenter)((Object)baseReportingFragment2)).onSaveInstanceState(bundle);
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        BaseReportingFragment baseReportingFragment = baseReportingFragment2;
        super.onActivityResult(n, n2, intent);
        BaseReportingFragment baseReportingFragment2 = baseReportingFragment.presenter;
        if (baseReportingFragment2 != null) {
            ((IBaseReportingView$Presenter)((Object)baseReportingFragment2)).onActivityResult(n, n2, intent);
        }
    }

    public void onViewStateRestored(@Nullable Bundle bundle) {
        BaseReportingFragment baseReportingFragment = baseReportingFragment2;
        super.onViewStateRestored(bundle);
        BaseReportingFragment baseReportingFragment2 = baseReportingFragment.presenter;
        if (baseReportingFragment2 != null) {
            ((IBaseReportingView$Presenter)((Object)baseReportingFragment2)).onRestoreInstanceState(bundle);
        }
    }

    @Nullable
    protected abstract IBaseReportingView$Presenter createPresenter();

    public void onClick(View view) {
        if (SystemClock.elapsedRealtime() - ((BaseReportingFragment)this).lastClickTime < 1000L) {
            return;
        }
        ((BaseReportingFragment)this).lastClickTime = SystemClock.elapsedRealtime();
        int n = view.getId();
        if (n == R.id.instabug_attach_screenshot) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    if (LiveBugManager.getInstance().getBug() != null) {
                        if (LiveBugManager.getInstance().getBug().getVisibleAttachmentsCount() < 4) {
                            if (BaseReportingFragment.this.presenter != null) {
                                ((IBaseReportingView$Presenter)BaseReportingFragment.this.presenter).takeScreenshot();
                            } else {
                                InstabugSDKLogger.v((String)"IBG-BR", (String)"Presenter is null");
                            }
                        } else {
                            BaseReportingFragment.this.showAlertWhenUserReachMaxAttachmentsLimit();
                        }
                    } else {
                        InstabugSDKLogger.v((String)"IBG-BR", (String)"Bug is null");
                    }
                }
            };
            ((BaseReportingFragment)this).doIfVideoDoneEncoding(runnable2);
        } else if (n == R.id.instabug_attach_gallery_image) {
            Runnable runnable;
            Runnable runnable3 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    if (LiveBugManager.getInstance().getBug() != null) {
                        if (LiveBugManager.getInstance().getBug().getVisibleAttachmentsCount() < 4) {
                            if (BaseReportingFragment.this.presenter != null) {
                                ((IBaseReportingView$Presenter)BaseReportingFragment.this.presenter).pickPhotoFromGallery();
                            } else {
                                InstabugSDKLogger.v((String)"IBG-BR", (String)"Presenter is null");
                            }
                        } else {
                            BaseReportingFragment.this.showAlertWhenUserReachMaxAttachmentsLimit();
                        }
                    } else {
                        InstabugSDKLogger.v((String)"IBG-BR", (String)"Bug is null");
                    }
                }
            };
            ((BaseReportingFragment)this).doIfVideoDoneEncoding(runnable3);
        } else if (n == R.id.instabug_attach_video) {
            Runnable runnable;
            Runnable runnable4 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    if (LiveBugManager.getInstance().getBug() != null) {
                        if (LiveBugManager.getInstance().getBug().getVisibleAttachmentsCount() < 4 && BugSettings.getInstance().getAttachmentsTypesParams().isAllowScreenRecording()) {
                            BaseReportingFragment.this.startScreenRecording();
                        } else {
                            BaseReportingFragment.this.showAlertWhenUserReachMaxAttachmentsLimit();
                        }
                    } else {
                        InstabugSDKLogger.v((String)"IBG-BR", (String)"Bug is null");
                    }
                }
            };
            ((BaseReportingFragment)this).doIfVideoDoneEncoding(runnable4);
        } else if (n != R.id.ib_bottomsheet_arrow_layout && n != R.id.arrow_handler) {
            if (n == R.id.instabug_add_attachment) {
                Object object = ((BaseReportingFragment)this).attachmentBottomSheetBehavior;
                if (object != null && object.getState() == 4) {
                    Runnable runnable;
                    super.hidKeyboard();
                    object = runnable;
                    runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (BaseReportingFragment.this.findViewById(R.id.instabug_add_attachment) != null) {
                                BaseReportingFragment.this.findViewById(R.id.instabug_add_attachment).setVisibility(8);
                            }
                            if (BaseReportingFragment.this.attachmentBottomSheetBehavior != null) {
                                BaseReportingFragment.this.attachmentBottomSheetBehavior.setState(3);
                            }
                        }
                    };
                    new Handler().postDelayed(object, 200L);
                }
            } else if (n == R.id.instabug_text_view_repro_steps_disclaimer && (this = ((BaseReportingFragment)this).activityCallback) != null) {
                this.openVisualUserStepsDisclaimerFragment();
            }
        } else {
            Runnable runnable;
            ((BaseReportingFragment)this).hidKeyboard();
            Runnable runnable5 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    if (BaseReportingFragment.this.addAttachments != null && BaseReportingFragment.this.attachmentBottomSheetBehavior != null) {
                        if (BaseReportingFragment.this.attachmentBottomSheetBehavior.getState() == 4) {
                            15 v0 = this;
                            v0.BaseReportingFragment.this.addAttachments.setVisibility(8);
                            v0.BaseReportingFragment.this.attachmentBottomSheetBehavior.setState(3);
                        } else {
                            BaseReportingFragment.this.attachmentBottomSheetBehavior.setState(4);
                        }
                    }
                }
            };
            new Handler().postDelayed(runnable5, 200L);
        }
    }

    @Override
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void onAttachmentClicked(View view, @NonNull Attachment attachment) {
        BaseReportingFragment baseReportingFragment = this;
        baseReportingFragment.clearFocusFromEditTexts();
        if (baseReportingFragment.getActivity() != null) {
            SystemServiceUtils.hideInputMethod((Activity)this.getActivity(), (View)this.focusedView);
        }
        int n = view.getId();
        if (this.attachmentClickRunnable == null) {
            this.initAttachmentClickRunnable(view, attachment, n);
        }
        this.attachmentClickHandler.postDelayed(this.attachmentClickRunnable, 200L);
    }

    @RequiresApi(api=21)
    public void onRequestPermissionsResult(int n, @NotNull String[] stringArray, @NonNull int[] nArray) {
        if (n == 177) {
            this.requestVideoRecordingPermissions();
        } else {
            super.onRequestPermissionsResult(n, stringArray, nArray);
        }
    }

    @Override
    public void setAttachments(List<Attachment> list) {
        this.attachmentsAdapter.clearAttachments();
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getType() == null) continue;
            if (list.get(i).getType().equals(Attachment.Type.MAIN_SCREENSHOT) || list.get(i).getType().equals(Attachment.Type.EXTRA_IMAGE) || list.get(i).getType().equals(Attachment.Type.GALLERY_IMAGE) || list.get(i).getType().equals(Attachment.Type.AUDIO) || list.get(i).getType().equals(Attachment.Type.EXTRA_VIDEO) || list.get(i).getType().equals(Attachment.Type.GALLERY_VIDEO) || list.get(i).getType().equals(Attachment.Type.AUTO_SCREEN_RECORDING_VIDEO)) {
                if (list.get(i).getType().equals(Attachment.Type.GALLERY_VIDEO)) {
                    list.get(i).setVideoEncoded(true);
                }
                this.attachmentsAdapter.addAttachment(list.get(i));
            }
            if (!list.get(i).getType().equals(Attachment.Type.EXTRA_VIDEO) && !list.get(i).getType().equals(Attachment.Type.GALLERY_VIDEO) || LiveBugManager.getInstance().getBug() == null) continue;
            LiveBugManager.getInstance().getBug().setHasVideo(true);
        }
        for (int i = 0; i < this.attachmentsAdapter.getDataset().size(); ++i) {
            if (this.attachmentsAdapter.getDataset().get(i).getType() == null || !this.attachmentsAdapter.getDataset().get(i).getType().equals(Attachment.Type.MAIN_SCREENSHOT) && !this.attachmentsAdapter.getDataset().get(i).getType().equals(Attachment.Type.GALLERY_IMAGE) && !this.attachmentsAdapter.getDataset().get(i).getType().equals(Attachment.Type.EXTRA_IMAGE)) continue;
            n = i;
        }
        BaseReportingFragment baseReportingFragment = this;
        baseReportingFragment.attachmentsAdapter.setLastImageIndex(n);
        baseReportingFragment.attachmentsList.setAdapter((RecyclerView.Adapter)this.attachmentsAdapter);
        baseReportingFragment.attachmentsAdapter.notifyDataSetChanged();
        if (InstabugCore.getFeatureState((String)"MULTIPLE_ATTACHMENTS") == Feature.State.ENABLED && BugSettings.getInstance().isAddAttachmentsButtonEnable()) {
            if (this.findViewById(R.id.instabug_attachment_bottom_sheet) != null) {
                this.findViewById(R.id.instabug_attachment_bottom_sheet).setVisibility(0);
            }
        } else if (this.findViewById(R.id.instabug_attachment_bottom_sheet) != null) {
            this.findViewById(R.id.instabug_attachment_bottom_sheet).setVisibility(8);
        }
        BaseReportingFragment baseReportingFragment2 = this;
        baseReportingFragment2.attachmentsList.post(new Runnable(){

            @Override
            public void run() {
                View view;
                if (this_.BaseReportingFragment.this.attachmentsList != null && this_.BaseReportingFragment.this.attachmentsList.getLayoutManager() != null && (view = this_.BaseReportingFragment.this.attachmentsList.getLayoutManager().findViewByPosition(this_.BaseReportingFragment.this.attachmentsAdapter.getItemCount() - 1)) != null && this_.BaseReportingFragment.this.getActivity() != null) {
                    Rect rect;
                    18 v0 = this_;
                    View view2 = view;
                    view = rect;
                    view2.getGlobalVisibleRect(new Rect());
                    View view3 = view;
                    18 this_ = DeviceStateProvider.getDisplayMetrics((Context)this_.BaseReportingFragment.this.getActivity());
                    float f = (float)(view3.right + view.left) / 2.0f;
                    float f2 = (float)(view3.top + view.bottom) / 2.0f;
                    float f3 = f / (float)((DisplayMetrics)this_).widthPixels;
                    v0.BaseReportingFragment.this.listener.loadBitmapAnimation(f3, f2 / (float)((DisplayMetrics)this_).heightPixels);
                }
            }
        });
        baseReportingFragment2.startPostponedEnterTransition();
    }

    public boolean isVideoProgressBarVisible() {
        return this.attachmentsAdapter.getVideoProgressBar() != null && this.attachmentsAdapter.getVideoProgressBar().getVisibility() == 0;
    }

    public boolean isVideoPlayImageViewVisible() {
        return this.attachmentsAdapter.getVideoPlayImageView() != null && this.attachmentsAdapter.getVideoPlayImageView().getVisibility() == 0;
    }

    public void setVideoProgressBarVisibility(boolean bl) {
        if (this.attachmentsAdapter.getVideoProgressBar() != null) {
            if (bl) {
                this.attachmentsAdapter.getVideoProgressBar().setVisibility(0);
            } else {
                this.attachmentsAdapter.getVideoProgressBar().setVisibility(8);
            }
        }
    }

    public void setVideoPlayImageViewVisibility(boolean bl) {
        if (this.attachmentsAdapter.getVideoPlayImageView() != null) {
            if (bl) {
                this.attachmentsAdapter.getVideoPlayImageView().setVisibility(0);
            } else {
                this.attachmentsAdapter.getVideoPlayImageView().setVisibility(8);
            }
        }
    }

    public void openActivityForResult(Intent intent, int n) {
        this.startActivityForResult(intent, n);
    }

    @Override
    public void notifyFragmentVisibilityChanged(boolean bl) {
        if (this.getFragmentManager() != null && this.getFragmentManager().findFragmentById(R.id.instabug_fragment_container) instanceof FragmentVisibilityChangedListener) {
            ((FragmentVisibilityChangedListener)this.getFragmentManager().findFragmentById(R.id.instabug_fragment_container)).onVisibilityChanged(bl);
        }
    }

    public void startVideo(Attachment object) {
        BaseContract.Presenter presenter = this.presenter;
        if (presenter != null && !((IBaseReportingView$Presenter)presenter).isAttachmentBeingRemoved((Attachment)object)) {
            if ((object = object.getLocalPath()) != null && this.getFragmentManager() != null) {
                int n = R.id.instabug_fragment_container;
                this.getFragmentManager().beginTransaction().add(n, (Fragment)VideoPlayerFragment.newInstance((String)object), "video_player").addToBackStack("play video").commitAllowingStateLoss();
            } else {
                if (!this.isVideoProgressBarVisible()) {
                    this.setVideoProgressBarVisibility(true);
                }
                if (this.isVideoPlayImageViewVisible()) {
                    this.setVideoPlayImageViewVisibility(false);
                }
            }
        }
    }

    @Override
    public void navigateToSuccessFragment() {
        Runnable runnable;
        this.hidKeyboard();
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                if (BugSettings.getInstance().successDialogEnabled() && !ServiceLocator.getConfigurationsProvider().isBugReportingUsageExceeded()) {
                    19 this_ = this_.BaseReportingFragment.this.getActivity();
                    if (this_ != null) {
                        Intent intent;
                        Intent intent2 = intent;
                        intent = new Intent((Context)this_, InstabugThanksActivity.class);
                        this_.startActivityForResult(intent2, 3940);
                    }
                } else if (this_.BaseReportingFragment.this.activityCallback != null) {
                    this_.BaseReportingFragment.this.listener.onFeedbackFragmentDismissed();
                }
            }
        };
        new Handler().postDelayed(runnable2, 200L);
    }

    @Override
    public void navigateToExtraFieldsFragment() {
        IBaseReportingView$Presenter iBaseReportingView$Presenter = (IBaseReportingView$Presenter)this.presenter;
        if (iBaseReportingView$Presenter != null && this.getFragmentManager() != null) {
            String string2 = iBaseReportingView$Presenter.getTitle();
            ReportingNavigator.navigateToExtraFields(this.getFragmentManager(), string2);
        }
        this.presenter = iBaseReportingView$Presenter;
    }

    @Override
    public void startGalleryPicker() {
        ReportingNavigator.navigateToPhotoPicker(this);
    }

    @Override
    public void showPreparingDialog() {
        IBGProgressDialog iBGProgressDialog = this.preparingProgressDialog;
        if (iBGProgressDialog != null) {
            if (!iBGProgressDialog.isShowing() && this.getFragmentManager() != null && !this.getFragmentManager().isStateSaved()) {
                this.preparingProgressDialog.show();
            }
        } else if (this.getActivity() != null && this.getFragmentManager() != null) {
            this.preparingProgressDialog = new IBGProgressDialog.Builder().setMessage(this.getLocalizedString(R.string.instabug_str_dialog_message_preparing)).build((Context)this.getActivity());
            if (!this.getFragmentManager().isStateSaved()) {
                this.preparingProgressDialog.show();
            }
        }
    }

    @Override
    public void showMediaFileSizeAlert() {
        if (this.getActivity() != null) {
            Long l = 50L;
            new InstabugAlertDialog.Builder((Activity)this.getActivity()).setTitle(this.getLocalizedString(R.string.instabug_str_bugreport_file_size_limit_warning_title)).setMessage(this.getLocalizedString(R.string.instabug_str_bugreport_file_size_limit_warning_message, l)).setPositiveButton(this.getLocalizedString(R.string.instabug_str_ok), (dialogInterface, n) -> dialogInterface.dismiss()).show();
        }
    }

    @Override
    public void showVideoLengthAlert() {
        if (this.getActivity() != null) {
            new InstabugAlertDialog.Builder((Activity)this.getActivity()).setTitle(this.getLocalizedString(R.string.instabug_str_video_length_limit_warning_title)).setMessage(this.getLocalizedString(R.string.instabug_str_video_length_limit_warning_message)).setPositiveButton(this.getLocalizedString(R.string.instabug_str_ok), (dialogInterface, n) -> dialogInterface.dismiss()).show();
        }
    }

    @Override
    public void dismissPreparingDialog() {
        IBGProgressDialog iBGProgressDialog = this.preparingProgressDialog;
        if (iBGProgressDialog != null && iBGProgressDialog.isShowing()) {
            this.preparingProgressDialog.dismiss();
        }
    }

    @Override
    public void notifyAttachmentRemoved(Attachment attachment) {
        AttachmentsAdapter attachmentsAdapter = this.attachmentsAdapter;
        if (attachmentsAdapter != null) {
            attachmentsAdapter.removeAttachment(attachment);
            this.attachmentsAdapter.notifyDataSetChanged();
        }
    }

    @Override
    public void showEmailError(String string2) {
        BaseReportingFragment baseReportingFragment = this;
        baseReportingFragment.emailEditText.requestFocus();
        baseReportingFragment.emailEditText.setError((CharSequence)string2);
    }

    @Override
    public void showCommentError(String string2) {
        BaseReportingFragment baseReportingFragment = this;
        baseReportingFragment.messageEditText.requestFocus();
        baseReportingFragment.messageEditText.setError((CharSequence)string2);
    }

    @Override
    public String getEnteredEmail() {
        return this.emailEditText.getText().toString();
    }

    @Override
    public void showVisualUserStepDisclaimer(Spanned spanned, final String string2) {
        BaseReportingFragment baseReportingFragment = this;
        baseReportingFragment.reproStepsDisclaimerTextView.setVisibility(0);
        baseReportingFragment.reproStepsDisclaimerTextView.setText((CharSequence)spanned);
        if (AccessibilityUtils.isTalkbackEnabled()) {
            ViewCompat.setAccessibilityDelegate((View)this.reproStepsDisclaimerTextView, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

                public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                    AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = accessibilityNodeInfoCompat;
                    20 v1 = this;
                    super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                    accessibilityNodeInfoCompat2.setContentDescription((CharSequence)v1.string2);
                    accessibilityNodeInfoCompat2.addAction(new AccessibilityNodeInfoCompat.AccessibilityActionCompat(16, (CharSequence)BaseReportingFragment.this.getLocalizedString(R.string.ibg_bug_report_visual_steps_disclaimer_action_description)));
                }
            });
        }
    }

    @Override
    public void hideVisualUserStepDisclaimer() {
        this.reproStepsDisclaimerTextView.setVisibility(8);
    }

    @Override
    public void showInstabugDisclaimer(Spanned spanned) {
        BaseReportingFragment baseReportingFragment = this;
        baseReportingFragment.disclaimerTextView.setVisibility(0);
        baseReportingFragment.disclaimerTextView.setText((CharSequence)spanned);
        baseReportingFragment.disclaimerTextView.setMovementMethod(LinkMovementMethod.getInstance());
    }

    @Override
    public void hideInstabugDisclaimer() {
        this.disclaimerTextView.setVisibility(8);
    }

    public void onDestroyView() {
        BaseReportingFragment baseReportingFragment = this;
        super.onDestroyView();
        LinearLayout linearLayout = baseReportingFragment.bugReportingInputsContainer;
        if (linearLayout != null) {
            linearLayout.clearFocus();
            this.bugReportingInputsContainer.removeAllViews();
        }
        BaseReportingFragment baseReportingFragment2 = this;
        baseReportingFragment2.enabledAttachmentCount = 0;
        baseReportingFragment2.disclaimerTextView = null;
        baseReportingFragment2.emailEditText = null;
        baseReportingFragment2.messageEditText = null;
        baseReportingFragment2.reproStepsDisclaimerTextView = null;
        baseReportingFragment2.scrollView = null;
        baseReportingFragment2.arrowHandler = null;
        baseReportingFragment2.attachmentsList = null;
        baseReportingFragment2.attachmentBottomSheetBehavior = null;
        baseReportingFragment2.attachmentsAdapter = null;
        baseReportingFragment2.addAttachments = null;
        baseReportingFragment2.bugReportingInputsContainer = null;
        baseReportingFragment2.focusedView = null;
        baseReportingFragment2.consentsRecyclerView = null;
        baseReportingFragment2.submitMenuItem = null;
    }

    public void onDestroy() {
        Handler handler;
        Runnable runnable = this.attachmentClickRunnable;
        if (runnable != null && (handler = this.attachmentClickHandler) != null) {
            handler.removeCallbacks(runnable);
            this.attachmentClickRunnable = null;
        }
        super.onDestroy();
        BaseReportingFragment.teardown();
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        menuInflater.inflate(R.menu.instabug_bug_reporting, menu2);
        boolean bl = false;
        BaseContract.Presenter presenter = this.presenter;
        if (presenter != null) {
            bl = ((IBaseReportingView$Presenter)presenter).hasExtendedReport();
        }
        Menu menu3 = menu2;
        presenter = menu3.findItem(R.id.instabug_bugreporting_next);
        MenuItem menuItem = menu3.findItem(R.id.instabug_bugreporting_send);
        Object object = bl ? presenter : menuItem;
        this.submitMenuItem = object;
        this.setSubmitEnabledState();
        if (bl) {
            if (menuItem != null) {
                menuItem.setVisible(false);
            }
            if (presenter != null) {
                presenter.setVisible(true);
                if (AccessibilityUtils.isTalkbackEnabled()) {
                    presenter.setTitle(R.string.ibg_bug_report_next_btn_content_description);
                }
                menu2 = presenter.getIcon();
                if (this.getContext() != null && menu2 != null && LocaleUtils.isRTL((Locale)InstabugCore.getLocale((Context)this.getContext()))) {
                    presenter.setIcon(DrawableUtils.getRotateDrawable((Drawable)menu2, (float)180.0f));
                }
            }
        } else {
            MenuItem menuItem2 = menuItem;
            presenter.setVisible(false);
            menuItem.setVisible(true);
            menuItem2.setTitle(this.getSendButtonContentDescriptionTitle());
            Drawable drawable2 = menuItem2.getIcon();
            if (this.getContext() != null && drawable2 != null && LocaleUtils.isRTL((Locale)InstabugCore.getLocale((Context)this.getContext()))) {
                menu2.findItem(R.id.instabug_bugreporting_send).setIcon(DrawableUtils.getRotateDrawable((Drawable)drawable2, (float)180.0f));
            }
        }
    }

    protected abstract int getSendButtonContentDescriptionTitle();

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        IBaseReportingView$Presenter iBaseReportingView$Presenter = (IBaseReportingView$Presenter)this.presenter;
        if (SystemClock.elapsedRealtime() - this.lastClickTime < 1000L) {
            return false;
        }
        this.lastClickTime = SystemClock.elapsedRealtime();
        if (menuItem.getItemId() == R.id.instabug_bugreporting_next && iBaseReportingView$Presenter != null) {
            iBaseReportingView$Presenter.onSendClicked();
        } else if (menuItem.getItemId() == R.id.instabug_bugreporting_send && iBaseReportingView$Presenter != null) {
            if (this.getFragmentManager() != null) {
                Iterator iterator = this.getFragmentManager().getFragments().iterator();
                while (iterator.hasNext()) {
                    if (!((Fragment)iterator.next() instanceof ExtraFieldsFragment)) continue;
                    return super.onOptionsItemSelected(menuItem);
                }
            }
            iBaseReportingView$Presenter.onSendClicked();
        } else if (menuItem.getItemId() == 16908332 && this.getActivity() != null) {
            this.getActivity().onBackPressed();
        }
        this.presenter = iBaseReportingView$Presenter;
        return false;
    }

    @Override
    public void requestMediaProjectionPermission() {
        if (this.getActivity() != null) {
            RequestPermissionActivityLauncher.start((Activity)this.getActivity(), (boolean)false, (boolean)false, null);
        }
    }

    public void openVideoRecorder() {
        BaseReportingFragment baseReportingFragment = baseReportingFragment.presenter;
        if (baseReportingFragment == null) {
            return;
        }
        ((IBaseReportingView$Presenter)((Object)baseReportingFragment)).openVideoRecorder();
    }

    public void onFocusChange(View view, boolean bl) {
        if (bl) {
            this.focusedView = view;
        }
    }

    @Override
    public String getLocalizedString(@StringRes int n) {
        return LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)this.getContext()), (int)n, (Context)this.getContext());
    }

    @Override
    public void showUserConsents(@Nullable List<UserConsent> list) {
        if (list != null && ((BaseReportingFragment)((Object)onMandatoryCheckStateChanged)).consentsRecyclerView != null) {
            ConsentsRecyclerViewAdapter consentsRecyclerViewAdapter;
            BaseReportingFragment baseReportingFragment = onMandatoryCheckStateChanged;
            ConsentsRecyclerViewAdapter consentsRecyclerViewAdapter2 = consentsRecyclerViewAdapter;
            BaseReportingFragment baseReportingFragment2 = onMandatoryCheckStateChanged;
            OnMandatoryCheckStateChanged onMandatoryCheckStateChanged = baseReportingFragment2::setSubmitEnabledState;
            consentsRecyclerViewAdapter = new ConsentsRecyclerViewAdapter(list, onMandatoryCheckStateChanged, baseReportingFragment2.theme);
            baseReportingFragment.consentsRecyclerView.setAdapter((RecyclerView.Adapter)consentsRecyclerViewAdapter2);
            return;
        }
    }

    public String getLocalizedString(@StringRes int n, Object ... objectArray) {
        return LocaleUtils.getLocaleStringResource((Locale)InstabugCore.getLocale((Context)this.getContext()), (int)n, (Context)this.getContext(), (Object[])objectArray);
    }

    public static interface Callbacks {
        public void onFeedbackFragmentDismissed();

        public void loadBitmapAnimation(float var1, float var2);
    }
}

