/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.instabug.bug.R;
import org.jetbrains.annotations.NotNull;

public class CorneredImageView
extends AppCompatImageView {
    private final RectF cornerRect = new RectF();
    private final Path path = new Path();
    private int cornerRadius;
    private int roundedCorners;

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public CorneredImageView(Context context) {
        this(context, null);
    }

    public CorneredImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CorneredImageView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        context = context.obtainStyledAttributes(attributeSet, R.styleable.CorneredImageView);
        this.cornerRadius = context.getDimensionPixelSize(R.styleable.CorneredImageView_ib_bug_cornerRadius, 0);
        this.roundedCorners = context.getInt(R.styleable.CorneredImageView_ib_bug_roundedCorners, 0);
        context.recycle();
    }

    private void setPath() {
        this.path.rewind();
        if ((float)this.cornerRadius >= 1.0f && this.roundedCorners != 0) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = this.cornerRadius;
            float f = n3 * 2;
            int n4 = n3;
            float f2 = -n4;
            float f3 = -n4;
            float f4 = n4;
            float f5 = n4;
            this.cornerRect.set(f2, f3, f4, f5);
            if (this.isRounded(1)) {
                this.cornerRect.offsetTo(0.0f, 0.0f);
                this.path.arcTo(this.cornerRect, 180.0f, 90.0f);
            } else {
                this.path.moveTo(0.0f, 0.0f);
            }
            if (this.isRounded(2)) {
                this.cornerRect.offsetTo((float)n - f, 0.0f);
                this.path.arcTo(this.cornerRect, 270.0f, 90.0f);
            } else {
                this.path.lineTo((float)n, 0.0f);
            }
            if (this.isRounded(4)) {
                this.cornerRect.offsetTo((float)n - f, (float)n2 - f);
                this.path.arcTo(this.cornerRect, 0.0f, 90.0f);
            } else {
                float f6 = n;
                this.path.lineTo(f6, (float)n2);
            }
            if (this.isRounded(8)) {
                this.cornerRect.offsetTo(0.0f, (float)n2 - f);
                this.path.arcTo(this.cornerRect, 90.0f, 90.0f);
            } else {
                this.path.lineTo(0.0f, (float)n2);
            }
            this.path.close();
        }
    }

    private boolean isRounded(int n) {
        return (this.roundedCorners & n) == n;
    }

    public void setCornerRadius(int n) {
        CorneredImageView corneredImageView = this;
        corneredImageView.cornerRadius = n;
        corneredImageView.setPath();
        corneredImageView.invalidate();
    }

    public int getRadius() {
        return this.cornerRadius;
    }

    public int getRoundedCorners() {
        return this.roundedCorners;
    }

    public void setRoundedCorners(int n) {
        Border border;
        CorneredImageView corneredImageView = object;
        corneredImageView.roundedCorners = n;
        corneredImageView.setPath();
        Object object = border;
        border = new Border(0, 10);
        corneredImageView.setBackgroundDrawable((Drawable)object);
        corneredImageView.invalidate();
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        CorneredImageView corneredImageView = this;
        super.onSizeChanged(n, n2, n3, n4);
        corneredImageView.setPath();
    }

    protected void onDraw(Canvas canvas) {
        if (!this.path.isEmpty() && Build.VERSION.SDK_INT >= 16) {
            canvas.clipPath(this.path);
        }
        super.onDraw(canvas);
    }

    public static class Border
    extends Drawable {
        public Paint paint;
        @Nullable
        public Rect bounds_rect;

        public Border(int n, int n2) {
            Paint paint;
            Paint paint2;
            Border border = this;
            Paint paint3 = paint2 = paint;
            paint3();
            this.paint = paint3;
            paint.setColor(n);
            border.paint.setStrokeWidth((float)n2);
            border.paint.setStyle(Paint.Style.STROKE);
        }

        public void onBoundsChange(Rect rect) {
            this.bounds_rect = rect;
        }

        public void draw(@NotNull Canvas canvas) {
            Rect rect = this.bounds_rect;
            if (rect != null) {
                canvas.drawRect(rect, this.paint);
            }
        }

        public void setAlpha(int n) {
        }

        public void setColorFilter(@Nullable ColorFilter colorFilter) {
        }

        public int getOpacity() {
            return -1;
        }
    }
}

