/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.screenshot;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import com.instabug.bug.LiveBugManager;
import com.instabug.bug.model.Bug;
import com.instabug.bug.screenshot.ActivityViewInspectorTask;
import com.instabug.bug.screenshot.viewhierarchy.ViewHierarchy;
import com.instabug.bug.screenshot.viewhierarchy.ViewHierarchyInspector;
import com.instabug.bug.screenshot.viewhierarchy.utilities.BitmapUtils;
import com.instabug.bug.screenshot.viewhierarchy.utilities.ViewHierarchyDiskUtils;
import com.instabug.bug.screenshot.viewhierarchy.utilities.ViewHierarchyInspectorEventBus;
import com.instabug.library.R;
import com.instabug.library.instacapture.screenshot.FieldHelper;
import com.instabug.library.instacapture.screenshot.RootViewInfo;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.utils.stability.execution.ReturnableExecutable;
import com.instabug.library.model.Attachment;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.memory.MemoryUtils;
import com.instabug.library.util.threading.PoolProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ,\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000fH\u0002JV\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\"\u0010\u0018\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u001a0\u0019j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u001a`\u001b2\u0006\u0010\u0016\u001a\u00020\u000f2\u0018\u0010\u001c\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00070\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010 \u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010!\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0002J&\u0010\"\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/instabug/bug/screenshot/ActivityViewInspectorTask;", "", "()V", "isCanceled", "", "isRunning", "cancelViewHierarchyInspection", "", "context", "Landroid/content/Context;", "captureViewHierarchiesBitmaps", "activity", "Landroid/app/Activity;", "flatViewHierarchies", "", "Lcom/instabug/bug/screenshot/viewhierarchy/ViewHierarchy;", "onTaskCompletedCallback", "Lkotlin/Function0;", "convertViewHierarchyToJson", "Lorg/json/JSONObject;", "viewHierarchy", "finalizeViewHierarchyInspection", "rootViewHierarchy", "flattenViewHierarchy", "rootViewsReturnableExecutables", "Ljava/util/ArrayList;", "Lcom/instabug/library/internal/utils/stability/execution/ReturnableExecutable;", "Lkotlin/collections/ArrayList;", "callback", "Lkotlin/Function1;", "getProperScaleFactor", "", "inspectActivityView", "persistViewHierarchyImage", "zipViewHierarchyImages", "seedViewHierarchy", "Companion", "instabug-bug_defaultUiRelease"})
public final class ActivityViewInspectorTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isCanceled;
    private boolean isRunning = true;

    private final void finalizeViewHierarchyInspection(ViewHierarchy viewHierarchy) {
        PoolProvider.postIOTask(() -> ActivityViewInspectorTask.finalizeViewHierarchyInspection$lambda$1(this, viewHierarchy));
    }

    private final void zipViewHierarchyImages(Activity activity, ViewHierarchy viewHierarchy, Function0<Unit> function0) {
        PoolProvider.postIOTask(() -> ActivityViewInspectorTask.zipViewHierarchyImages$lambda$2(viewHierarchy, activity, function0));
    }

    private final void flattenViewHierarchy(Activity activity, ArrayList<ReturnableExecutable<ViewHierarchy>> arrayList, ViewHierarchy viewHierarchy, Function1<? super List<? extends ViewHierarchy>, Unit> function1) {
        PoolProvider.postIOTask(() -> ActivityViewInspectorTask.flattenViewHierarchy$lambda$3(this, arrayList, viewHierarchy, activity, function1));
    }

    private final void captureViewHierarchiesBitmaps(Activity activity, List<? extends ViewHierarchy> list, Function0<Unit> function0) {
        PoolProvider.postMainThreadTask(() -> ActivityViewInspectorTask.captureViewHierarchiesBitmaps$lambda$4(this, list, activity, function0));
    }

    private final void persistViewHierarchyImage(ViewHierarchy viewHierarchy, Function0<Unit> function0) {
        PoolProvider.postIOTask(() -> ActivityViewInspectorTask.persistViewHierarchyImage$lambda$5(this, viewHierarchy, function0));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final JSONObject convertViewHierarchyToJson(ViewHierarchy viewHierarchy) {
        Object object;
        JSONObject jSONObject;
        block15: {
            JSONArray jSONArray;
            JSONException jSONException2;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                JSONObject jSONObject2;
                                jSONObject = jSONObject2;
                                jSONObject2 = new JSONObject();
                                try {
                                    if (viewHierarchy.getId() == null) break block10;
                                    object = "id";
                                    jSONObject.put((String)object, (Object)viewHierarchy.getId());
                                }
                                catch (JSONException jSONException2) {}
                            }
                            if (viewHierarchy.getIconIdentifier() == null) break block11;
                            object = "icon";
                            jSONObject.put((String)object, (Object)viewHierarchy.getIconIdentifier());
                        }
                        if (viewHierarchy.getType() == null) break block12;
                        object = "type";
                        jSONObject.put((String)object, (Object)viewHierarchy.getType());
                    }
                    if (viewHierarchy.getProperties() == null) break block13;
                    object = "properties";
                    jSONObject.put((String)object, (Object)viewHierarchy.getProperties());
                }
                if (viewHierarchy.getFrame() == null) break block14;
                object = "frame";
                jSONObject.put((String)object, (Object)viewHierarchy.getFrame());
            }
            if (viewHierarchy.getNodes() == null) return jSONObject;
            if (!viewHierarchy.hasChildren()) return jSONObject;
            ViewHierarchy viewHierarchy2 = viewHierarchy;
            viewHierarchy = jSONArray;
            jSONArray = new JSONArray();
            object = viewHierarchy2.getNodes().iterator();
            break block15;
            InstabugSDKLogger.e((String)"IBG-BR", (String)("Converting view hierarchy to json got json exception: " + jSONException2.getMessage()), (Throwable)jSONException2);
            return jSONObject;
        }
        while (object.hasNext()) {
            ViewHierarchy viewHierarchy3 = (ViewHierarchy)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)viewHierarchy3, (String)"child");
            viewHierarchy.put(this.convertViewHierarchyToJson(viewHierarchy3));
        }
        {
            jSONObject.put("nodes", (Object)viewHierarchy);
        }
        return jSONObject;
    }

    private final int getProperScaleFactor(Activity activity) {
        ActivityViewInspectorTask activityViewInspectorTask = activity.getWindow().getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)activityViewInspectorTask, (String)"activity.window.decorView");
        int n = Math.max(activityViewInspectorTask.getHeight(), activityViewInspectorTask.getWidth());
        return n > 640 ? n / 640 : 1;
    }

    private static final void inspectActivityView$lambda$0(Activity activity) {
        Activity activity2 = activity;
        Intrinsics.checkNotNullParameter((Object)activity2, (String)"$activity");
        DiskUtils.cleanDirectory((File)ViewHierarchyDiskUtils.getViewHierarchyImagesDirectory((Context)activity2));
    }

    private static final void finalizeViewHierarchyInspection$lambda$1(ActivityViewInspectorTask activityViewInspectorTask, ViewHierarchy viewHierarchy) {
        Intrinsics.checkNotNullParameter((Object)activityViewInspectorTask, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)viewHierarchy, (String)"$rootViewHierarchy");
        InstabugSDKLogger.v((String)"IBG-BR", (String)"Activity view inspection done successfully");
        if (LiveBugManager.getInstance().getBug() == null) {
            return;
        }
        Bug bug = LiveBugManager.getInstance().getBug();
        Intrinsics.checkNotNull((Object)bug);
        bug.setViewHierarchy(activityViewInspectorTask.convertViewHierarchyToJson(viewHierarchy).toString());
        if (LiveBugManager.getInstance().getBug() == null) {
            return;
        }
        Bug bug2 = LiveBugManager.getInstance().getBug();
        Intrinsics.checkNotNull((Object)bug2);
        bug2.setViewHierarchyInspectionState(Bug.ViewHierarchyInspectionState.DONE);
        ViewHierarchyInspectorEventBus.getInstance().post((Object)ViewHierarchyInspector.Action.COMPLETED);
        activityViewInspectorTask.isRunning = false;
    }

    private static final void zipViewHierarchyImages$lambda$2(ViewHierarchy viewHierarchy, Activity activity, Function0 function0) {
        Bug bug;
        Intrinsics.checkNotNullParameter((Object)viewHierarchy, (String)"$seedViewHierarchy");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"$activity");
        Intrinsics.checkNotNullParameter((Object)function0, (String)"$onTaskCompletedCallback");
        viewHierarchy = ViewHierarchyDiskUtils.zipViewHierarchyImages(viewHierarchy);
        if (viewHierarchy != null) {
            InstabugSDKLogger.v((String)"IBG-BR", (String)("viewHierarchy images zipped successfully, zip file uri: " + viewHierarchy + ", time in MS: " + System.currentTimeMillis()));
        }
        if (LiveBugManager.getInstance().getBug() != null && viewHierarchy != null && (bug = LiveBugManager.getInstance().getBug()) != null) {
            bug.addAttachment((Uri)viewHierarchy, Attachment.Type.VIEW_HIERARCHY);
        }
        DiskUtils.cleanDirectory((File)ViewHierarchyDiskUtils.getViewHierarchyImagesDirectory((Context)activity));
        function0.invoke();
    }

    private static final void flattenViewHierarchy$lambda$3(ActivityViewInspectorTask object, ArrayList object2, ViewHierarchy viewHierarchy, Activity activity, Function1 function1) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter((Object)object, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"$rootViewsReturnableExecutables");
        Intrinsics.checkNotNullParameter((Object)viewHierarchy, (String)"$rootViewHierarchy");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"$activity");
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$callback");
        if (((ActivityViewInspectorTask)object).isCanceled) {
            return;
        }
        object = arrayList;
        arrayList = new ArrayList();
        object2 = ((ArrayList)object2).iterator();
        while (object2.hasNext()) {
            Object object3 = null;
            try {
                object3 = (ViewHierarchy)((ReturnableExecutable)object2.next()).execute();
            }
            catch (Exception exception) {}
            viewHierarchy.addNode((ViewHierarchy)object3);
            if (MemoryUtils.isLowMemory((Context)activity)) continue;
            object3 = ViewHierarchyInspector.convertViewHierarchyToList((ViewHierarchy)object3);
            Intrinsics.checkNotNullExpressionValue(object3, (String)"convertViewHierarchyToLi\u2026                        )");
            object.addAll(object3);
        }
        function1.invoke(object);
    }

    private static final void captureViewHierarchiesBitmaps$lambda$4(ActivityViewInspectorTask activityViewInspectorTask, List list, Activity activity, Function0 function0) {
        Intrinsics.checkNotNullParameter((Object)activityViewInspectorTask, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)list, (String)"$flatViewHierarchies");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"$activity");
        Intrinsics.checkNotNullParameter((Object)function0, (String)"$onTaskCompletedCallback");
        if (activityViewInspectorTask.isCanceled) {
            return;
        }
        if (!list.isEmpty()) {
            ViewHierarchy viewHierarchy = (ViewHierarchy)list.get(0);
            if (!MemoryUtils.isLowMemory((Context)activity)) {
                Function0<Unit> function02;
                viewHierarchy = BitmapUtils.captureViewHierarchy(viewHierarchy);
                Intrinsics.checkNotNullExpressionValue((Object)viewHierarchy, (String)"captureViewHierarchy(\n  \u2026chy\n                    )");
                Function0<Unit> function03 = function02;
                function02 = new Function0<Unit>(activityViewInspectorTask, activity, (List<? extends ViewHierarchy>)list, (Function0<Unit>)function0){
                    final /* synthetic */ ActivityViewInspectorTask this$0;
                    final /* synthetic */ Activity $activity;
                    final /* synthetic */ List<ViewHierarchy> $flatViewHierarchies;
                    final /* synthetic */ Function0<Unit> $onTaskCompletedCallback;
                    {
                        this.this$0 = activityViewInspectorTask;
                        this.$activity = activity;
                        this.$flatViewHierarchies = list;
                        this.$onTaskCompletedCallback = function0;
                        super(0);
                    }

                    public final void invoke() {
                        captureViewHierarchiesBitmaps.1.1 v0 = this_;
                        captureViewHierarchiesBitmaps.1.1 this_ = v0.$activity;
                        List<ViewHierarchy> list = v0.$flatViewHierarchies;
                        List<ViewHierarchy> list2 = list.subList(1, list.size());
                        Function0<Unit> function0 = v0.$onTaskCompletedCallback;
                        ActivityViewInspectorTask.access$captureViewHierarchiesBitmaps(this_.this$0, (Activity)this_, list2, function0);
                    }
                };
                activityViewInspectorTask.persistViewHierarchyImage(viewHierarchy, function03);
            }
        } else {
            function0.invoke();
        }
    }

    private static final void persistViewHierarchyImage$lambda$5(ActivityViewInspectorTask activityViewInspectorTask, ViewHierarchy viewHierarchy, Function0 function0) {
        Intrinsics.checkNotNullParameter((Object)activityViewInspectorTask, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)viewHierarchy, (String)"$viewHierarchy");
        Intrinsics.checkNotNullParameter((Object)function0, (String)"$onTaskCompletedCallback");
        if (activityViewInspectorTask.isCanceled) {
            return;
        }
        if (viewHierarchy.getImage() != null) {
            ViewHierarchy viewHierarchy2 = viewHierarchy;
            InstabugSDKLogger.v((String)"ActivityViewInspectorTask", (String)("Started saving image on disk, viewHierarchyId: " + viewHierarchy.getId()));
            ViewHierarchyDiskUtils.saveViewHierarchyImage(viewHierarchy2);
            viewHierarchy2.removeImage();
            InstabugSDKLogger.v((String)"ActivityViewInspectorTask", (String)("view hierarchy image saved successfully, uri: " + viewHierarchy.getImageUriOnDisk()));
        }
        function0.invoke();
    }

    private static final void cancelViewHierarchyInspection$lambda$6(Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"$context");
        DiskUtils.cleanDirectory((File)ViewHierarchyDiskUtils.getViewHierarchyImagesDirectory(context2));
    }

    public static final /* synthetic */ void access$captureViewHierarchiesBitmaps(ActivityViewInspectorTask activityViewInspectorTask, Activity activity, List list, Function0 function0) {
        activityViewInspectorTask.captureViewHierarchiesBitmaps(activity, list, (Function0<Unit>)function0);
    }

    public static final /* synthetic */ void access$zipViewHierarchyImages(ActivityViewInspectorTask activityViewInspectorTask, Activity activity, ViewHierarchy viewHierarchy, Function0 function0) {
        activityViewInspectorTask.zipViewHierarchyImages(activity, viewHierarchy, (Function0<Unit>)function0);
    }

    public static final /* synthetic */ void access$finalizeViewHierarchyInspection(ActivityViewInspectorTask activityViewInspectorTask, ViewHierarchy viewHierarchy) {
        activityViewInspectorTask.finalizeViewHierarchyInspection(viewHierarchy);
    }

    public final void inspectActivityView(@NotNull Activity activity) {
        Function1<List<? extends ViewHierarchy>, Unit> function1;
        ArrayList<ReturnableExecutable<ViewHierarchy>> arrayList;
        ViewHierarchy viewHierarchy;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (LiveBugManager.getInstance().getBug() != null) {
            Bug bug = LiveBugManager.getInstance().getBug();
            Intrinsics.checkNotNull((Object)bug);
            bug.setViewHierarchyInspectionState(Bug.ViewHierarchyInspectionState.IN_PROGRESS);
        }
        ViewHierarchyInspectorEventBus.getInstance().post((Object)ViewHierarchyInspector.Action.STARTED);
        ViewHierarchy viewHierarchy2 = viewHierarchy;
        viewHierarchy2();
        viewHierarchy2.setView(activity.getWindow().getDecorView());
        try {
            viewHierarchy.setFrame(ViewHierarchyInspector.inspectRootViewFrame(activity, this.getProperScaleFactor(activity)));
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e((String)"IBG-BR", (String)("inspect activity frame got error" + jSONException.getMessage()), (Throwable)jSONException);
        }
        Object object = FieldHelper.getRootViews((Activity)activity, (int[])new int[]{R.id.instabug_decor_view, R.id.instabug_in_app_notification, R.id.instabug_intro_dialog});
        if (object.size() > 0) {
            viewHierarchy2.setHasChildren(true);
        }
        ArrayList<ReturnableExecutable<ViewHierarchy>> arrayList2 = arrayList;
        arrayList = new ArrayList<ReturnableExecutable<ViewHierarchy>>(object.size());
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            ViewHierarchy viewHierarchy3;
            ViewHierarchy viewHierarchy4;
            ViewHierarchy viewHierarchy5 = viewHierarchy4 = viewHierarchy3;
            viewHierarchy4();
            viewHierarchy4.setId(String.valueOf(i));
            viewHierarchy5.setView(((RootViewInfo)object.get(i)).getView());
            viewHierarchy5.setRoot(true);
            viewHierarchy3.setScale(this.getProperScaleFactor(activity));
            arrayList2.add(ViewHierarchyInspector.getInspectRootViewExecutable(viewHierarchy3));
        }
        ActivityViewInspectorTask activityViewInspectorTask = this;
        object = function1;
        try {
            function1 = new Function1<List<? extends ViewHierarchy>, Unit>(this, activity, viewHierarchy2){
                final /* synthetic */ ActivityViewInspectorTask this$0;
                final /* synthetic */ Activity $activity;
                final /* synthetic */ ViewHierarchy $rootViewHierarchy;
                {
                    this.this$0 = activityViewInspectorTask;
                    this.$activity = activity;
                    this.$rootViewHierarchy = viewHierarchy;
                    super(1);
                }

                public final void invoke(@NotNull List<? extends ViewHierarchy> list) {
                    Function0<Unit> function0;
                    Intrinsics.checkNotNullParameter(list, (String)"it");
                    ActivityViewInspectorTask activityViewInspectorTask = object.this$0;
                    Activity activity = object.$activity;
                    Function0<Unit> function02 = function0;
                    Object object = object.$rootViewHierarchy;
                    function0 = new Function0<Unit>(activityViewInspectorTask, activity, (ViewHierarchy)object){
                        final /* synthetic */ ActivityViewInspectorTask this$0;
                        final /* synthetic */ Activity $activity;
                        final /* synthetic */ ViewHierarchy $rootViewHierarchy;
                        {
                            this.this$0 = activityViewInspectorTask;
                            this.$activity = activity;
                            this.$rootViewHierarchy = viewHierarchy;
                            super(0);
                        }

                        public final void invoke() {
                            Function0<Unit> function0;
                            ActivityViewInspectorTask activityViewInspectorTask = this_.this$0;
                            inspectActivityView.1 v0 = this_;
                            inspectActivityView.1 this_ = v0.$activity;
                            ViewHierarchy viewHierarchy = v0.$rootViewHierarchy;
                            Function0<Unit> function02 = function0;
                            function0 = new Function0<Unit>(activityViewInspectorTask, viewHierarchy){
                                final /* synthetic */ ActivityViewInspectorTask this$0;
                                final /* synthetic */ ViewHierarchy $rootViewHierarchy;
                                {
                                    this.this$0 = activityViewInspectorTask;
                                    this.$rootViewHierarchy = viewHierarchy;
                                    super(0);
                                }

                                public final void invoke() {
                                    ActivityViewInspectorTask.access$finalizeViewHierarchyInspection(this.this$0, this.$rootViewHierarchy);
                                }
                            };
                            ActivityViewInspectorTask.access$zipViewHierarchyImages(activityViewInspectorTask, (Activity)this_, viewHierarchy, (Function0)function02);
                        }
                    };
                    ActivityViewInspectorTask.access$captureViewHierarchiesBitmaps(activityViewInspectorTask, activity, list, (Function0)function02);
                }
            };
            activityViewInspectorTask.flattenViewHierarchy(activity, arrayList2, viewHierarchy2, (Function1<? super List<? extends ViewHierarchy>, Unit>)object);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e((String)"IBG-BR", (String)("activity view inspection got error: " + exception.getMessage()), (Throwable)exception);
            Bug bug = LiveBugManager.getInstance().getBug();
            if (bug != null) {
                bug.setViewHierarchyInspectionState(Bug.ViewHierarchyInspectionState.FAILED);
            }
            ViewHierarchyInspectorEventBus.getInstance().post((Object)ViewHierarchyInspector.Action.FAILED);
            PoolProvider.postIOTask(() -> ActivityViewInspectorTask.inspectActivityView$lambda$0(activity));
        }
    }

    public final void cancelViewHierarchyInspection(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.isRunning) {
            InstabugSDKLogger.d((String)"IBG-BR", (String)"CancelViewInspection called");
            this.isCanceled = true;
            PoolProvider.postIOTask(() -> ActivityViewInspectorTask.cancelViewHierarchyInspection$lambda$6(context));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/instabug/bug/screenshot/ActivityViewInspectorTask$Companion;", "", "()V", "DEFAULT_SCALE_FACTOR", "", "KEY_FRAME", "", "KEY_ICON", "KEY_ID", "KEY_NODES", "KEY_PROPERTIES", "KEY_TYPE", "MAX_EDGE_SIZE", "TAG", "instabug-bug_defaultUiRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

