/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.proactivereporting;

import android.app.Activity;
import android.content.Context;
import com.instabug.bug.LiveBugManager;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.model.Bug;
import com.instabug.bug.network.ProactiveReportsBugsUploaderJob;
import com.instabug.bug.proactivereporting.FrustratingExperienceEventsHandler;
import com.instabug.bug.proactivereporting.configs.ProactiveReportingConfigProvider;
import com.instabug.bug.proactivereporting.ui.ProactiveReportingDialogActivity;
import com.instabug.library.PresentationManager;
import com.instabug.library.frustratingexperience.FrustratingExperienceEvent;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.TimeUtils;
import com.instabug.library.util.threading.PoolProvider;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R.\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00188\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u0012\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lcom/instabug/bug/proactivereporting/FrustratingExperienceEventsHandlerImpl;", "Lcom/instabug/bug/proactivereporting/FrustratingExperienceEventsHandler;", "Lcom/instabug/bug/proactivereporting/configs/ProactiveReportingConfigProvider;", "configsProvider", "<init>", "(Lcom/instabug/bug/proactivereporting/configs/ProactiveReportingConfigProvider;)V", "Lcom/instabug/library/frustratingexperience/FrustratingExperienceEvent$Detected;", "event", "", "handleFrustratingExperienceDetected", "(Lcom/instabug/library/frustratingexperience/FrustratingExperienceEvent$Detected;)V", "", "shouldShow", "()Z", "Lcom/instabug/library/frustratingexperience/FrustratingExperienceEvent$Synced;", "handleFrustratingExperienceSynced", "(Lcom/instabug/library/frustratingexperience/FrustratingExperienceEvent$Synced;)V", "Lcom/instabug/library/frustratingexperience/FrustratingExperienceEvent$BugReportSaved;", "handleFrustratingExperienceSaved", "(Lcom/instabug/library/frustratingexperience/FrustratingExperienceEvent$BugReportSaved;)V", "Lcom/instabug/library/frustratingexperience/FrustratingExperienceEvent;", "handle", "(Lcom/instabug/library/frustratingexperience/FrustratingExperienceEvent;)V", "Lcom/instabug/bug/proactivereporting/configs/ProactiveReportingConfigProvider;", "", "", "", "pendingFrustratingExperienceReportsIds", "Ljava/util/Map;", "getPendingFrustratingExperienceReportsIds", "()Ljava/util/Map;", "getPendingFrustratingExperienceReportsIds$annotations", "()V", "instabug-bug_defaultUiRelease"}, xi=48)
public final class FrustratingExperienceEventsHandlerImpl
implements FrustratingExperienceEventsHandler {
    @NotNull
    private final ProactiveReportingConfigProvider configsProvider;
    @NotNull
    private final Map<Long, String> pendingFrustratingExperienceReportsIds;

    public FrustratingExperienceEventsHandlerImpl(@NotNull ProactiveReportingConfigProvider proactiveReportingConfigProvider) {
        LinkedHashMap linkedHashMap;
        Intrinsics.checkNotNullParameter((Object)proactiveReportingConfigProvider, (String)"configsProvider");
        ((FrustratingExperienceEventsHandlerImpl)((Object)linkedHashMap2)).configsProvider = proactiveReportingConfigProvider;
        LinkedHashMap linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        v1.pendingFrustratingExperienceReportsIds = linkedHashMap2;
    }

    private final void handleFrustratingExperienceDetected(FrustratingExperienceEvent.Detected detected) {
        if (this.shouldShow()) {
            PoolProvider.postDelayedTask(() -> FrustratingExperienceEventsHandlerImpl.handleFrustratingExperienceDetected$lambda$3(detected), (long)TimeUnit.SECONDS.toMillis(this.configsProvider.getDetectionGap()));
        }
    }

    private final boolean shouldShow() {
        return this.configsProvider.isEnabled() && TimeUtils.hasXHoursPassed((long)this.configsProvider.getLastModalTime(), (long)TimeUnit.SECONDS.toMillis(this.configsProvider.getModalsGap()));
    }

    private final void handleFrustratingExperienceSynced(FrustratingExperienceEvent.Synced synced) {
        if (synced.getExternalId() != null) {
            Object object;
            Serializable serializable;
            if (LiveBugManager.getInstance().getBug() != null && (serializable = LiveBugManager.getInstance().getBug()) != null && serializable.getFrustratingExperienceInternalId() == synced.getInternalId()) {
                object = LiveBugManager.getInstance().getBug();
                if (object != null) {
                    ((Bug)object).setFrustratingExperienceExternalId(synced.getExternalId());
                }
            } else {
                FrustratingExperienceEvent.Synced synced2 = synced;
                serializable = Long.valueOf(synced2.getInternalId());
                if (!ServiceLocator.getBugReportsDbHelper().updateFrustratingExperienceExternalId((Long)serializable, synced2.getExternalId())) {
                    FrustratingExperienceEvent.Synced synced3 = synced;
                    object = synced3.getInternalId();
                    ((FrustratingExperienceEventsHandlerImpl)object).pendingFrustratingExperienceReportsIds.put((Long)object, synced3.getExternalId());
                } else {
                    ProactiveReportsBugsUploaderJob.Companion.getInstance().start();
                }
            }
        }
    }

    private final void handleFrustratingExperienceSaved(FrustratingExperienceEvent.BugReportSaved bugReportSaved) {
        String string2;
        if (this.pendingFrustratingExperienceReportsIds.containsKey(bugReportSaved.getInternalId()) && (string2 = this.pendingFrustratingExperienceReportsIds.get(bugReportSaved.getInternalId())) != null) {
            ServiceLocator.getBugReportsDbHelper().updateFrustratingExperienceExternalId(bugReportSaved.getInternalId(), string2);
            this.pendingFrustratingExperienceReportsIds.remove(bugReportSaved.getInternalId());
            ProactiveReportsBugsUploaderJob.Companion.getInstance().start();
        }
    }

    private static final void handle$lambda$0(FrustratingExperienceEvent frustratingExperienceEvent, FrustratingExperienceEventsHandlerImpl frustratingExperienceEventsHandlerImpl) {
        Intrinsics.checkNotNullParameter((Object)frustratingExperienceEvent, (String)"$event");
        Intrinsics.checkNotNullParameter((Object)frustratingExperienceEventsHandlerImpl, (String)"this$0");
        if (frustratingExperienceEvent instanceof FrustratingExperienceEvent.Detected) {
            frustratingExperienceEventsHandlerImpl.handleFrustratingExperienceDetected((FrustratingExperienceEvent.Detected)frustratingExperienceEvent);
        } else if (frustratingExperienceEvent instanceof FrustratingExperienceEvent.Synced) {
            frustratingExperienceEventsHandlerImpl.handleFrustratingExperienceSynced((FrustratingExperienceEvent.Synced)frustratingExperienceEvent);
        } else if (frustratingExperienceEvent instanceof FrustratingExperienceEvent.BugReportSaved) {
            frustratingExperienceEventsHandlerImpl.handleFrustratingExperienceSaved((FrustratingExperienceEvent.BugReportSaved)frustratingExperienceEvent);
        }
    }

    private static final void handleFrustratingExperienceDetected$lambda$3$lambda$2(FrustratingExperienceEvent.Detected object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"$event");
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity != null) {
            FrustratingExperienceEvent.Detected detected = object;
            object = detected.getType();
            long l = detected.getInternalId();
            activity.startActivity(ProactiveReportingDialogActivity.Companion.getIntent((Context)activity, (String)object, l));
        }
    }

    private static final void handleFrustratingExperienceDetected$lambda$3(FrustratingExperienceEvent.Detected detected) {
        Intrinsics.checkNotNullParameter((Object)detected, (String)"$event");
        PresentationManager.getInstance().show(() -> FrustratingExperienceEventsHandlerImpl.handleFrustratingExperienceDetected$lambda$3$lambda$2(detected));
    }

    @Override
    public void handle(@NotNull FrustratingExperienceEvent frustratingExperienceEvent) {
        Intrinsics.checkNotNullParameter((Object)frustratingExperienceEvent, (String)"event");
        PoolProvider.postIOTask(() -> FrustratingExperienceEventsHandlerImpl.handle$lambda$0(frustratingExperienceEvent, this));
    }
}

