/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.invocation.invoker;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.provider.MediaStore;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.instabug.bug.invocation.InvocationListener;
import com.instabug.bug.invocation.invoker.ScreenshotObserverHelper;
import com.instabug.library.Instabug;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.io.File;

public class ScreenshotObserver
extends ContentObserver {
    private final String[] PROJECTION = new String[]{"_id", "_display_name", "_data"};
    private final String MEDIA_EXTERNAL_URI_STRING = MediaStore.Images.Media.EXTERNAL_CONTENT_URI.toString();
    private final InvocationListener invocationListener;
    private ContentResolver contentResolver;
    int screenshotState = 0;

    public ScreenshotObserver(Handler handler, ContentResolver contentResolver, InvocationListener invocationListener) {
        super(handler);
        this.contentResolver = contentResolver;
        this.invocationListener = invocationListener;
    }

    private void updateScreenshotState(int n) {
        if (Build.VERSION.SDK_INT < 30) {
            return;
        }
        if (this.isUpdateNotification(n) && !this.hasReceivedInsertionNotification()) {
            this.resetScreenshotState();
            return;
        }
        this.screenshotState |= n;
    }

    private boolean isValidScreenshotState() {
        if (Build.VERSION.SDK_INT < 30) {
            return true;
        }
        int n = this.screenshotState;
        return (n & 4) != 0 && (n & 8) != 0;
    }

    private void resetScreenshotState() {
        this.screenshotState = 0;
    }

    @RequiresApi(api=30)
    private boolean isUpdateNotification(int n) {
        return (n & 8) != 0;
    }

    @RequiresApi(api=30)
    private boolean hasReceivedInsertionNotification() {
        return (this.screenshotState & 4) != 0;
    }

    public void onChange(boolean bl, @Nullable Uri object, int n) {
        if (object != null && object.toString().matches(this.MEDIA_EXTERNAL_URI_STRING + "/[0-9]+")) {
            Cursor cursor;
            block13: {
                ScreenshotObserver screenshotObserver = this;
                screenshotObserver.updateScreenshotState(n);
                if (!screenshotObserver.isValidScreenshotState()) {
                    return;
                }
                ScreenshotObserver screenshotObserver2 = this;
                screenshotObserver2.resetScreenshotState();
                cursor = screenshotObserver2.contentResolver.query(object, this.PROJECTION, null, null, null);
                if (cursor != null) {
                    try {
                        if (!cursor.moveToFirst()) break block13;
                    }
                    catch (Throwable throwable) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    Cursor cursor2 = cursor;
                    Cursor cursor3 = cursor2;
                    Cursor cursor4 = cursor2;
                    object = cursor2.getString(cursor2.getColumnIndexOrThrow("_display_name"));
                    final String string2 = cursor4.getString(cursor3.getColumnIndexOrThrow("_data"));
                    if (!ScreenshotObserverHelper.isScreenshotDir(string2)) break block13;
                    if (!ScreenshotObserverHelper.isScreenshotFile((String)object)) break block13;
                    PoolProvider.postIOTask((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            File file;
                            Context context = Instabug.getApplicationContext();
                            File file2 = file;
                            file = new File(string2);
                            InstabugSDKLogger.d((String)"IBG-Core", (String)("Creating new Uri for screenshot: " + file2 + " {" + file2.getPath() + "}"));
                            file2 = AttachmentsUtility.getNewFileAttachmentUri((Context)context, (Uri)Uri.fromFile((File)file));
                            if (ScreenshotObserver.this.invocationListener != null) {
                                ScreenshotObserver.this.invocationListener.onInvocationRequested((Uri)file2);
                            }
                        }
                    });
                }
            }
            if (cursor != null) {
                cursor.close();
            }
        }
    }
}

