/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.invocation.invocationdialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PorterDuff;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.instabug.bug.R;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogItem;
import com.instabug.library.Instabug;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.ThemeApplier;
import java.util.ArrayList;

public class InstabugDialogAdapter
extends BaseAdapter {
    private ArrayList<InstabugDialogItem> dialogListItems;
    @Nullable
    private IBGTheme theme;

    public InstabugDialogAdapter(@Nullable IBGTheme iBGTheme) {
        ArrayList arrayList;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.dialogListItems = object;
        v1.theme = iBGTheme;
    }

    public static void setMargins(View view, int n, int n2, int n3, int n4) {
        if (view != null && view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            View view2 = view;
            ((ViewGroup.MarginLayoutParams)view2.getLayoutParams()).setMargins(n, n2, n3, n4);
            view2.requestLayout();
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private void bind(ViewHolder viewHolder, final InstabugDialogItem instabugDialogItem) {
        TextView textView = viewHolder.title;
        if (textView != null) {
            textView.setText((CharSequence)instabugDialogItem.getTitle());
        }
        if (viewHolder.description != null) {
            if (TextUtils.isEmpty((CharSequence)instabugDialogItem.getDescription())) {
                viewHolder.description.setVisibility(8);
            } else {
                ViewHolder viewHolder2 = viewHolder;
                viewHolder2.description.setVisibility(0);
                viewHolder2.description.setText((CharSequence)instabugDialogItem.getDescription());
                ViewCompat.setAccessibilityDelegate((View)viewHolder2.description, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

                    public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                        1 v0 = this;
                        super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                        accessibilityNodeInfoCompat.setContentDescription((CharSequence)v0.InstabugDialogAdapter.this.getItemDescription(instabugDialogItem));
                    }
                });
            }
        }
        if (viewHolder.icon != null) {
            if (instabugDialogItem.getResDrawable() != 0) {
                ViewHolder viewHolder3 = viewHolder;
                viewHolder3.icon.setImageResource(instabugDialogItem.getResDrawable());
                viewHolder3.icon.setVisibility(0);
                viewHolder3.icon.getDrawable().setColorFilter(SettingsManager.getInstance().getPrimaryColor(), PorterDuff.Mode.SRC_IN);
            } else {
                ViewHolder viewHolder4 = viewHolder;
                viewHolder4.icon.setVisibility(8);
                InstabugDialogAdapter.setMargins((View)viewHolder4.title, 0, 0, 0, 0);
                InstabugDialogAdapter.setMargins((View)viewHolder4.description, 0, 4, 0, 0);
            }
        }
        this.applyTheme(viewHolder);
    }

    private void applyTheme(ViewHolder viewHolder) {
        ViewHolder viewHolder2 = viewHolder;
        ThemeApplier.applyPrimaryTextStyle((TextView)viewHolder2.title, (IBGTheme)this.theme);
        ThemeApplier.applySecondaryTextStyle((TextView)viewHolder2.description, (IBGTheme)this.theme);
    }

    private String getItemDescription(InstabugDialogItem instabugDialogItem) {
        block6: {
            block5: {
                block4: {
                    block3: {
                        InstabugDialogAdapter instabugDialogAdapter = Instabug.getApplicationContext();
                        int n = instabugDialogItem.getIdentifier();
                        if (n == 0) break block3;
                        if (n == 1) break block4;
                        if (n == 3) break block5;
                        break block6;
                    }
                    if (instabugDialogAdapter != null) {
                        return instabugDialogAdapter.getString(R.string.ib_bug_report_bug_description);
                    }
                }
                if (instabugDialogAdapter != null) {
                    return instabugDialogAdapter.getString(R.string.ib_bug_report_feedback_description);
                }
            }
            if (instabugDialogAdapter != null) {
                return instabugDialogAdapter.getString(R.string.ib_bug_report_question_description);
            }
        }
        return "";
    }

    public boolean hasStableIds() {
        return true;
    }

    public int getCount() {
        return this.dialogListItems.size();
    }

    public InstabugDialogItem getItem(int n) {
        return this.dialogListItems.get(n);
    }

    public long getItemId(int n) {
        return n;
    }

    @SuppressLint(value={"ERADICATE_INCONSISTENT_SUBCLASS_RETURN_ANNOTATION"})
    @Nullable
    public View getView(int n, View view, ViewGroup viewGroup) {
        if (viewGroup != null) {
            ViewHolder viewHolder;
            if (view == null) {
                ViewHolder viewHolder2;
                view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.ib_dialog_list_item, viewGroup, false);
                viewHolder = viewHolder2;
                view.setTag((Object)new ViewHolder(view));
            } else {
                viewHolder = (ViewHolder)view.getTag();
            }
            if (viewGroup instanceof AbsListView && AccessibilityUtils.isTalkbackEnabled()) {
                viewGroup = view2 -> {
                    long l = this.getItemId(n);
                    ((AbsListView)viewGroup).performItemClick(view, n, l);
                };
                View view3 = viewHolder.root;
                if (view3 != null) {
                    view3.setOnClickListener((View.OnClickListener)viewGroup);
                    ViewCompat.setImportantForAccessibility((View)viewHolder.root, (int)1);
                }
            }
            InstabugDialogAdapter instabugDialogAdapter = this;
            instabugDialogAdapter.bind(viewHolder, instabugDialogAdapter.getItem(n));
            return view;
        }
        return null;
    }

    public void setPluginPromptOptions(ArrayList<InstabugDialogItem> arrayList) {
        this.dialogListItems = arrayList;
    }

    private static class ViewHolder {
        @Nullable
        public View root;
        @Nullable
        public ImageView icon;
        @Nullable
        public TextView title;
        @Nullable
        public TextView description;

        ViewHolder(View view) {
            this.root = view.findViewById(R.id.instabug_prompt_option_container);
            this.icon = (ImageView)view.findViewById(R.id.instabug_prompt_option_icon);
            this.title = (TextView)view.findViewById(R.id.instabug_prompt_option_title);
            this.description = (TextView)view.findViewById(R.id.instabug_prompt_option_description);
        }
    }
}

