/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.internal.video.customencoding;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.AudioRecord;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.bug.internal.video.customencoding.AudioEncodeConfig;
import com.instabug.bug.internal.video.customencoding.AudioEncoder;
import com.instabug.bug.internal.video.customencoding.BaseEncoder;
import com.instabug.bug.internal.video.customencoding.Encoder;
import com.instabug.library.util.InstabugSDKLogger;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=16)
class MicRecorder
implements Encoder {
    private final AudioEncoder mEncoder;
    private final HandlerThread mRecordThread;
    @Nullable
    private RecordHandler mRecordHandler;
    @Nullable
    private AudioRecord mMic;
    private int mSampleRate;
    private int mChannelConfig;
    private int mFormat = 2;
    private AtomicBoolean mForceStop = new AtomicBoolean(false);
    @Nullable
    private BaseEncoder.Callback mCallback;
    @Nullable
    private CallbackDelegate mCallbackDelegate;
    private int mChannelsSampleRate;
    private LinkedHashMap<Integer, Long> mFramesUsCache = new LinkedHashMap(2);

    MicRecorder(AudioEncodeConfig audioEncodeConfig) {
        HandlerThread handlerThread;
        int n;
        micRecorder2.mEncoder = new AudioEncoder(audioEncodeConfig);
        micRecorder2.mSampleRate = n = audioEncodeConfig.getSamplingRate();
        micRecorder2.mChannelsSampleRate = n * audioEncodeConfig.getChannelCount();
        int n2 = audioEncodeConfig.getChannelCount() == 2 ? 12 : 16;
        MicRecorder micRecorder = micRecorder2;
        micRecorder.mChannelConfig = n2;
        MicRecorder micRecorder2 = handlerThread;
        handlerThread = new HandlerThread("MicRecorder");
        micRecorder.mRecordThread = micRecorder2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private AudioRecord createAudioRecord(int n, int n2, int n3) {
        SecurityException securityException2;
        block7: {
            AudioRecord audioRecord;
            block6: {
                Object[] objectArray;
                Object[] objectArray2;
                Integer n4;
                Integer n5;
                Integer n6;
                Object[] objectArray3;
                Locale locale;
                String string2;
                AudioRecord audioRecord2;
                int n7 = AudioRecord.getMinBufferSize((int)n, (int)n2, (int)n3);
                if (n7 <= 0) {
                    Integer n8 = n;
                    Integer n9 = n2;
                    Integer n10 = n3;
                    Object[] objectArray4 = new Object[3];
                    Object[] objectArray5 = objectArray4;
                    objectArray4[0] = n8;
                    objectArray4[1] = n9;
                    objectArray4[2] = n10;
                    InstabugSDKLogger.e((String)"IBG-Core", (String)String.format(Locale.US, "Bad arguments: getMinBufferSize(%d, %d, %d)", objectArray5));
                    return null;
                }
                audioRecord = audioRecord2;
                n7 *= 2;
                try {
                    if (new AudioRecord(1, n, n2, n3, n7).getState() != 0) break block6;
                    string2 = "IBG-Core";
                    locale = Locale.US;
                    objectArray3 = "Bad arguments to new AudioRecord %d, %d, %d";
                    n6 = n;
                    n5 = n2;
                    n4 = n3;
                    objectArray2 = objectArray3;
                    objectArray = new Object[3];
                }
                catch (SecurityException securityException2) {}
                objectArray3 = objectArray;
                objectArray[0] = n6;
                objectArray[1] = n5;
                objectArray[2] = n4;
                InstabugSDKLogger.e((String)string2, (String)String.format(locale, (String)objectArray2, objectArray3));
                return null;
                break block7;
            }
            if (Build.VERSION.SDK_INT >= 24) {
                InstabugSDKLogger.d((String)"IBG-Core", (String)(" size in frame " + audioRecord.getBufferSizeInFrames()));
            }
            return audioRecord;
        }
        InstabugSDKLogger.e((String)"IBG-Core", (String)("RECORD_AUDIO permission not granted " + securityException2.getMessage()));
        return null;
    }

    private void feedAudioEncoder(int n) {
        if (n >= 0 && !this.mForceStop.get()) {
            AudioRecord audioRecord = this.mMic;
            if (audioRecord != null) {
                boolean bl = audioRecord.getRecordingState() == 1;
                ByteBuffer byteBuffer = this.mEncoder.getInputBuffer(n);
                int n2 = 0;
                int n3 = 0;
                if (byteBuffer != null && !bl) {
                    ByteBuffer byteBuffer2 = byteBuffer;
                    byteBuffer2.position();
                    n3 = audioRecord.read(byteBuffer, byteBuffer2.limit());
                    if (n3 < 0) {
                        n3 = 0;
                    }
                }
                long l = this.calculateFrameTimestamp(n3 << 3);
                int n4 = 0;
                if (Build.VERSION.SDK_INT >= 21) {
                    n4 = 1;
                }
                if (bl) {
                    n4 = 4;
                }
                this.mEncoder.queueInputBuffer(n, n2, n3, l, n4);
                return;
            }
            throw new NullPointerException("maybe release");
        }
    }

    private long calculateFrameTimestamp(int n) {
        if (((MicRecorder)((Object)n3)).mFramesUsCache == null) {
            LinkedHashMap linkedHashMap;
            LinkedHashMap linkedHashMap2 = linkedHashMap;
            linkedHashMap = new LinkedHashMap(2);
            ((MicRecorder)((Object)n3)).mFramesUsCache = linkedHashMap2;
        }
        long l = -1L;
        if (((MicRecorder)((Object)n3)).mFramesUsCache.get(n >>= 4) != null) {
            l = ((MicRecorder)((Object)n3)).mFramesUsCache.get(n);
        }
        if (l == -1L) {
            l = n * 1000000 / ((MicRecorder)((Object)n3)).mChannelsSampleRate;
            Integer n2 = n;
            ((AbstractMap)((MicRecorder)((Object)n3)).mFramesUsCache).put(n2, l);
        }
        long l2 = SystemClock.elapsedRealtime() / 1000000L - l;
        long l3 = -1L;
        if (((MicRecorder)((Object)n3)).mFramesUsCache.get(-1) != null) {
            l3 = ((MicRecorder)((Object)n3)).mFramesUsCache.get(-1);
        }
        if (l3 == -1L) {
            l3 = l2;
        }
        if (l2 - l3 < l << 1) {
            l2 = l3;
        }
        Integer n3 = -1;
        ((AbstractMap)((MicRecorder)((Object)n3)).mFramesUsCache).put(n3, l2 + l);
        return l2;
    }

    static /* synthetic */ AudioRecord access$502(MicRecorder micRecorder, AudioRecord audioRecord) {
        micRecorder.mMic = audioRecord;
        return audioRecord;
    }

    public void setCallback(BaseEncoder.Callback callback) {
        this.mCallback = callback;
    }

    public void prepare() {
        Looper looper = Looper.myLooper();
        if (looper != null) {
            this.mCallbackDelegate = new CallbackDelegate(looper, this.mCallback);
            this.mRecordThread.start();
            MicRecorder micRecorder = this;
            this.mRecordHandler = micRecorder.new RecordHandler(micRecorder.mRecordThread.getLooper());
            this.mRecordHandler.sendEmptyMessage(0);
            return;
        }
        throw new NullPointerException("Should prepare in HandlerThread");
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void stop() {
        CallbackDelegate callbackDelegate = object.mCallbackDelegate;
        if (callbackDelegate != null) {
            callbackDelegate.removeCallbacksAndMessages(null);
        }
        MicRecorder micRecorder = object;
        micRecorder.mForceStop.set(true);
        Object object = micRecorder.mRecordHandler;
        if (object != null) {
            object.sendEmptyMessage(4);
        }
    }

    public void release() {
        RecordHandler recordHandler = this.mRecordHandler;
        if (recordHandler != null) {
            recordHandler.sendEmptyMessage(5);
        }
        this.mRecordThread.quit();
    }

    void releaseOutputBuffer(int n) {
        Object object = object.mRecordHandler;
        if (object != null) {
            Message.obtain((Handler)object, (int)3, (int)n, (int)0).sendToTarget();
        }
    }

    @Nullable
    ByteBuffer getOutputBuffer(int n) {
        return this.mEncoder.getOutputBuffer(n);
    }

    private static class CallbackDelegate
    extends Handler {
        @Nullable
        private BaseEncoder.Callback mCallback;

        CallbackDelegate(@NonNull Looper looper, @Nullable BaseEncoder.Callback callback) {
            super(looper);
            this.mCallback = callback;
        }

        void onError(Encoder encoder, Exception exception) {
            CallbackDelegate callbackDelegate = this;
            Message.obtain((Handler)callbackDelegate, () -> {
                BaseEncoder.Callback callback = ((CallbackDelegate)((Object)((Object)callback))).mCallback;
                if (callback != null) {
                    callback.onError(encoder, exception);
                }
            }).sendToTarget();
        }

        void onOutputFormatChanged(BaseEncoder baseEncoder, MediaFormat mediaFormat) {
            CallbackDelegate callbackDelegate = this;
            Message.obtain((Handler)callbackDelegate, () -> {
                BaseEncoder.Callback callback = ((CallbackDelegate)((Object)((Object)callback))).mCallback;
                if (callback != null) {
                    callback.onOutputFormatChanged(baseEncoder, mediaFormat);
                }
            }).sendToTarget();
        }

        void onOutputBufferAvailable(BaseEncoder baseEncoder, int n, MediaCodec.BufferInfo bufferInfo) {
            CallbackDelegate callbackDelegate = this;
            Message.obtain((Handler)callbackDelegate, () -> {
                BaseEncoder.Callback callback = ((CallbackDelegate)((Object)((Object)callback))).mCallback;
                if (callback != null) {
                    callback.onOutputBufferAvailable(baseEncoder, n, bufferInfo);
                }
            }).sendToTarget();
        }
    }

    private class RecordHandler
    extends Handler {
        private LinkedList<MediaCodec.BufferInfo> mCachedInfos;
        private LinkedList<Integer> mMuxingOutputBufferIndices;
        private int mPollRate;

        RecordHandler(Looper looper) {
            super(looper);
            this.mCachedInfos = new LinkedList();
            this.mMuxingOutputBufferIndices = new LinkedList();
            this.mPollRate = 2048000 / MicRecorder.this.mSampleRate;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void offerOutput() {
            while (true) {
                try {
                    if (MicRecorder.access$700(MicRecorder.this).get() != false) return;
                    var1_2 = this.mCachedInfos.poll();
                    if (var1_2 == null) {
                    }
                    ** GOTO lbl-1000
                }
                catch (Exception var0_1) {
                    break;
                }
                var1_2 = v0;
                v0 = new MediaCodec.BufferInfo();
lbl-1000:
                // 2 sources

                {
                    if ((var2_3 = MicRecorder.access$600(MicRecorder.this).getEncoder().dequeueOutputBuffer(var1_2, 1L)) == -2 && MicRecorder.access$400(MicRecorder.this) != null) {
                        MicRecorder.access$400(MicRecorder.this).onOutputFormatChanged(MicRecorder.access$600(MicRecorder.this), MicRecorder.access$600(MicRecorder.this).getEncoder().getOutputFormat());
                    }
                    if (var2_3 >= 0) ** GOTO lbl-1000
                    var1_2.set(0, 0, 0L, 0);
                    this.mCachedInfos.offer(var1_2);
                }
                return;
lbl-1000:
                // 1 sources

                {
                    v1 = this;
                    v2 = v1;
                    v1.mMuxingOutputBufferIndices.offer(var2_3);
                }
                {
                    if (MicRecorder.access$400(v2.MicRecorder.this) == null) continue;
                    MicRecorder.access$400(MicRecorder.this).onOutputBufferAvailable(MicRecorder.access$600(MicRecorder.this), var2_3, var1_2);
                    continue;
                }
                break;
            }
            InstabugSDKLogger.e((String)"IBG-Core", (String)("Something went wrong while calling offerOutput. " + var0_1.getMessage()), (Throwable)var0_1);
        }

        private int pollInput() {
            try {
                return MicRecorder.this.mEncoder.getEncoder().dequeueInputBuffer(0L);
            }
            catch (Exception exception) {
                InstabugSDKLogger.e((String)"IBG-Core", (String)("Something went wrong while calling dequeueInputBuffer. " + exception.getMessage()), (Throwable)exception);
                return -1;
            }
        }

        private void pollInputIfNeed() {
            if (this.mMuxingOutputBufferIndices.size() <= 1 && !MicRecorder.this.mForceStop.get()) {
                RecordHandler recordHandler = this;
                recordHandler.removeMessages(1);
                recordHandler.sendEmptyMessageDelayed(1, 0L);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 5: {
                    if (MicRecorder.this.mMic != null) {
                        MicRecorder.this.mMic.release();
                        MicRecorder.access$502(MicRecorder.this, null);
                    }
                    MicRecorder.this.mEncoder.release();
                    return;
                }
                case 4: {
                    if (MicRecorder.this.mMic != null) {
                        MicRecorder.this.mMic.stop();
                    }
                    MicRecorder.this.mEncoder.stop();
                    return;
                }
                case 3: {
                    MicRecorder.this.mEncoder.releaseOutputBuffer(message.arg1);
                    this.mMuxingOutputBufferIndices.poll();
                    this.pollInputIfNeed();
                    return;
                }
                case 2: {
                    this.offerOutput();
                    this.pollInputIfNeed();
                    return;
                }
                case 0: {
                    MicRecorder micRecorder = MicRecorder.this;
                    message = micRecorder.createAudioRecord(micRecorder.mSampleRate, MicRecorder.this.mChannelConfig, MicRecorder.this.mFormat);
                    if (message == null) {
                        InstabugSDKLogger.e((String)"IBG-Core", (String)"create audio record failure");
                        if (MicRecorder.this.mCallbackDelegate == null) return;
                        MicRecorder.this.mCallbackDelegate.onError(MicRecorder.this, new IllegalArgumentException());
                        return;
                    }
                    message.startRecording();
                    MicRecorder.access$502(MicRecorder.this, (AudioRecord)message);
                    try {
                        MicRecorder.this.mEncoder.prepare();
                    }
                    catch (Exception exception) {
                        if (MicRecorder.this.mCallbackDelegate == null) return;
                        MicRecorder.this.mCallbackDelegate.onError(MicRecorder.this, exception);
                        return;
                    }
                }
                case 1: {
                    if (MicRecorder.this.mForceStop.get()) return;
                    int n = this.pollInput();
                    if (n >= 0) {
                        MicRecorder.this.feedAudioEncoder(n);
                        if (MicRecorder.this.mForceStop.get()) return;
                        this.sendEmptyMessage(2);
                        return;
                    }
                    long l = this.mPollRate;
                    this.sendEmptyMessageDelayed(1, l);
                    return;
                }
            }
        }
    }
}

