/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.internal.video;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.MediaController;
import android.widget.VideoView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import com.instabug.bug.R;
import com.instabug.bug.internal.video.InstabugMediaController;
import com.instabug.library.InstabugBaseFragment;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.view.IBGProgressDialog;

public class VideoPlayerFragment
extends InstabugBaseFragment
implements InstabugMediaController.OnVisibilityChangedListener {
    @Nullable
    private View videoViewToolbar;
    @Nullable
    private VideoView videoView;
    private int position = 0;
    @Nullable
    private IBGProgressDialog progressDialog;
    @Nullable
    private InstabugMediaController mediaControls;
    @Nullable
    private String videoUri;

    public static VideoPlayerFragment newInstance(String string2) {
        Bundle bundle;
        VideoPlayerFragment videoPlayerFragment = new VideoPlayerFragment();
        Bundle bundle2 = bundle;
        new Bundle().putString("video.uri", string2);
        videoPlayerFragment.setArguments(bundle2);
        return videoPlayerFragment;
    }

    private void showToolbar(boolean bl) {
        if ((this = this.getActivity()) != null && (this = ((AppCompatActivity)this).getSupportActionBar()) != null) {
            if (bl) {
                this.show();
            } else {
                this.hide();
            }
        }
    }

    protected int getLayout() {
        return R.layout.instabug_lyt_video_view;
    }

    public void onViewCreated(@NonNull View view2, @Nullable Bundle bundle) {
        super.onViewCreated(view2, bundle);
        this.videoView = (VideoView)view2.findViewById(R.id.video_view);
        this.videoViewToolbar = view2 = view2.findViewById(R.id.ib_bg_toolbar_video);
        if (view2 != null) {
            view2.setOnClickListener(view -> {
                if (this.getActivity() != null) {
                    this.getActivity().onBackPressed();
                }
            });
        }
    }

    public void onResume() {
        VideoPlayerFragment videoPlayerFragment = this;
        super.onResume();
        videoPlayerFragment.showToolbar(false);
    }

    public void onActivityCreated(@Nullable Bundle bundle) {
        VideoPlayerFragment videoPlayerFragment = this;
        super.onActivityCreated(bundle);
        bundle = videoPlayerFragment.getActivity();
        if (bundle != null) {
            block7: {
                if (this.mediaControls == null) {
                    InstabugMediaController instabugMediaController;
                    InstabugMediaController instabugMediaController2 = instabugMediaController;
                    instabugMediaController = new InstabugMediaController((Context)bundle, this);
                    this.mediaControls = instabugMediaController2;
                }
                this.progressDialog = new IBGProgressDialog.Builder().setMessage("Loading...").build((Context)bundle);
                this.progressDialog.show();
                bundle = this.videoView;
                if (bundle == null) break block7;
                if (this.videoUri == null) break block7;
                try {
                    bundle.setMediaController((MediaController)this.mediaControls);
                    this.videoView.setVideoURI(Uri.parse((String)this.videoUri));
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e((String)"IBG-Core", (String)"Couldn't play video due to: ", (Throwable)exception);
                }
            }
            if ((bundle = this.videoView) != null) {
                VideoPlayerFragment videoPlayerFragment2 = this;
                bundle.requestFocus();
                videoPlayerFragment2.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                    @SuppressLint(value={"NULL_DEREFERENCE"})
                    public void onPrepared(MediaPlayer mediaPlayer) {
                        if (VideoPlayerFragment.this.progressDialog != null) {
                            VideoPlayerFragment.this.progressDialog.dismiss();
                        }
                        if (VideoPlayerFragment.this.videoView != null) {
                            1 v0 = this;
                            v0.VideoPlayerFragment.this.videoView.seekTo(VideoPlayerFragment.this.position);
                            if (v0.VideoPlayerFragment.this.position == 0) {
                                1 v1 = this;
                                v1.VideoPlayerFragment.this.videoView.start();
                                if (v1.VideoPlayerFragment.this.mediaControls != null) {
                                    VideoPlayerFragment.this.mediaControls.show();
                                }
                            } else {
                                VideoPlayerFragment.this.videoView.pause();
                            }
                        }
                    }
                });
                videoPlayerFragment2.videoView.setOnErrorListener((mediaPlayer, n, n2) -> {
                    VideoPlayerFragment videoPlayerFragment = videoPlayerFragment.progressDialog;
                    if (videoPlayerFragment != null) {
                        videoPlayerFragment.dismiss();
                    }
                    return false;
                });
            }
        }
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    protected String getTitle() {
        return this.getLocalizedString(R.string.instabug_str_video_player);
    }

    public void onDestroy() {
        VideoPlayerFragment videoPlayerFragment = this;
        super.onDestroy();
        videoPlayerFragment.showToolbar(true);
    }

    protected void consumeNewInstanceSavedArguments() {
        String string2 = this.getArguments() == null ? null : this.getArguments().getString("video.uri");
        this.videoUri = string2;
    }

    protected void restoreState(Bundle bundle) {
        int n;
        this.position = n = bundle.getInt("Position");
        bundle = this.videoView;
        if (bundle != null) {
            bundle.seekTo(n);
        }
    }

    protected void saveState(Bundle bundle) {
        VideoView videoView = this.videoView;
        if (videoView != null) {
            bundle.putInt("Position", videoView.getCurrentPosition());
            this.videoView.pause();
        }
    }

    public void onDestroyView() {
        this.mediaControls = null;
        this.videoView = null;
        this.videoViewToolbar = null;
        super.onDestroyView();
    }

    @Override
    public void isVisible(boolean n) {
        VideoPlayerFragment videoPlayerFragment = videoPlayerFragment.videoViewToolbar;
        if (videoPlayerFragment != null) {
            n = n != 0 ? 0 : 8;
            videoPlayerFragment.setVisibility(n);
        }
    }
}

