/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug;

import android.content.Context;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.instabug.bug.BugReportingWrapper;
import com.instabug.bug.ProactiveReportingConfigs;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.extendedbugreport.ExtendedBugReport;
import com.instabug.bug.invocation.InvocationManager;
import com.instabug.bug.onboardingbugreporting.utils.WelcomeMessageHelperApiContract;
import com.instabug.bug.onboardingbugreporting.utils.WelcomeMessageHelperApiImp;
import com.instabug.bug.settings.BugSettings;
import com.instabug.chat.ChatsDelegate;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.OnSdkDismissCallback;
import com.instabug.library.OnUsageExceededReady;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.apichecker.VoidRunnable;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.extendedbugreport.ExtendedBugReport;
import com.instabug.library.internal.video.MediaProjectionHelper;
import com.instabug.library.internal.video.customencoding.VideoEncoderConfig;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.OnInvokeCallback;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.invocation.util.InstabugVideoRecordingButtonPosition;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BugReporting {
    public static void setInvocationEvents(final InstabugInvocationEvent ... instabugInvocationEventArray) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                if (!BugSettings.getInstance().isBugReportingStateEnabled()) {
                    return;
                }
                InvocationManager.getInstance().setInstabugInvocationEvent(instabugInvocationEventArray);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"BugReporting.setInvocationEvents", (VoidRunnable)voidRunnable2);
    }

    public static void setOptions(final int ... nArray) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                BugReportingWrapper.setOptions(nArray);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"BugReporting.NonNull", (VoidRunnable)voidRunnable2);
    }

    public static void setOnInvokeCallback(final OnInvokeCallback onInvokeCallback) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                InstabugSDKLogger.d((String)"IBG-BR", (String)"Setting invoke callback");
                SettingsManager.getInstance().setOnInvokeCallback(onInvokeCallback);
            }
        };
        APIChecker.checkAndRunInExecutorThenPostOnMain((String)"BugReporting.setOnInvokeCallback", (VoidRunnable)voidRunnable2);
    }

    public static void setOnDismissCallback(final OnSdkDismissCallback onSdkDismissCallback) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                InstabugSDKLogger.d((String)"IBG-BR", (String)"Setting OnSdkDismissCallback");
                ChatsDelegate.setOnSdkDismissCallback(onSdkDismissCallback);
                BugSettings.getInstance().setOnSdkDismissCallback(onSdkDismissCallback);
                SettingsManager.getInstance().setOnSdkDismissCallback(onSdkDismissCallback);
            }
        };
        APIChecker.checkAndRunInExecutorThenPostOnMain((String)"BugReporting.setOnDismissCallback", (VoidRunnable)voidRunnable2);
    }

    public static void setShakingThreshold(final int n) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                InstabugSDKLogger.d((String)"IBG-BR", (String)("Setting ShakingThreshold to: " + n));
                InvocationManager.getInstance().getCurrentInvocationSettings().setShakingThreshold(n);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"BugReporting.setShakingThreshold", (VoidRunnable)voidRunnable2);
    }

    public static void setFloatingButtonEdge(final @NonNull InstabugFloatingButtonEdge instabugFloatingButtonEdge) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                if (!BugSettings.getInstance().isBugReportingStateEnabled()) {
                    return;
                }
                InstabugSDKLogger.d((String)"IBG-BR", (String)("Setting FloatingButtonEdge to: " + instabugFloatingButtonEdge));
                InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(instabugFloatingButtonEdge);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"BugReporting.setFloatingButtonEdge", (VoidRunnable)voidRunnable2);
    }

    public static void setFloatingButtonOffset(final @IntRange(from=0L) int n) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                if (!BugSettings.getInstance().isBugReportingStateEnabled()) {
                    return;
                }
                InstabugSDKLogger.d((String)"IBG-BR", (String)("Seetting FloatingButtonOffset: " + n));
                InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(n);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"BugReporting.setFloatingButtonOffset", (VoidRunnable)voidRunnable2);
    }

    public static void setVideoRecordingFloatingButtonPosition(final @NonNull InstabugVideoRecordingButtonPosition instabugVideoRecordingButtonPosition) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                if (!BugSettings.getInstance().isBugReportingStateEnabled()) {
                    return;
                }
                InstabugSDKLogger.d((String)"IBG-BR", (String)("setVideoRecordingFloatingButtonPosition: " + instabugVideoRecordingButtonPosition));
                InstabugCore.setVideoRecordingButtonPosition((InstabugVideoRecordingButtonPosition)instabugVideoRecordingButtonPosition);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"BugReporting.setVideoRecordingFloatingButtonPosition", (VoidRunnable)voidRunnable2);
    }

    public static void setExtendedBugReportState(final @NonNull ExtendedBugReport.State state) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                if (state == null) {
                    InstabugSDKLogger.w((String)"IBG-BR", (String)"state object passed to BugReporting.setExtendedBugReportState() is null");
                    return;
                }
                if (!BugSettings.getInstance().isBugReportingStateEnabled()) {
                    return;
                }
                InstabugSDKLogger.d((String)"IBG-BR", (String)("setExtendedBugReportState: " + state));
                int n = 19.$SwitchMap$com$instabug$library$extendedbugreport$ExtendedBugReport$State[state.ordinal()];
                ExtendedBugReport.State state2 = n != 1 ? (n != 2 ? ExtendedBugReport.State.DISABLED : ExtendedBugReport.State.ENABLED_WITH_OPTIONAL_FIELDS) : ExtendedBugReport.State.ENABLED_WITH_REQUIRED_FIELDS;
                BugSettings.getInstance().setExtendedBugReportState(state2);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"BugReporting.setExtendedBugReportState", (VoidRunnable)voidRunnable2);
    }

    public static void setExtendedBugReportHints(@Nullable String string2, @Nullable String string3, @Nullable String string4) {
        APIChecker.checkAndRunInExecutor((String)"BugReporting.setExtendedBugReportHints", () -> {
            InstabugSDKLogger.v((String)"IBG-BR", (String)("setExtendedBugReportHints: Hint1 = " + string2 + ", Hint2 = " + string3 + ", Hint3 = " + string4));
            if (BugSettings.getInstance().isBugReportingStateEnabled()) {
                BugSettings.getInstance().setExtendedBugReportHints(string2, string3, string4);
            }
        });
    }

    @RequiresApi(value=21)
    public static void setAutoScreenRecordingEnabled(final boolean bl) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                if (!BugSettings.getInstance().isBugReportingStateEnabled()) {
                    return;
                }
                InstabugSDKLogger.d((String)"IBG-BR", (String)("setAutoScreenRecordingEnabled: " + bl));
                BugReportingWrapper.setAutoScreenRecordingEnabled(bl);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"BugReporting.setAutoScreenRecordingEnabled", (VoidRunnable)voidRunnable2);
    }

    public static void setReportTypes(int ... nArray) {
        APIChecker.checkAndRunInExecutor((String)"BugReporting.setReportTypes", () -> PoolProvider.postIOTaskWithCheck(() -> BugReportingWrapper.setReportTypes(nArray)));
    }

    public static void show(final @ReportType int n) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                BugReportingWrapper.show(n);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"BugReporting.show", (VoidRunnable)voidRunnable2);
    }

    public static void show(final @ReportType int n, final int ... nArray) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                BugReportingWrapper.show(n, nArray);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"BugReporting.show", (VoidRunnable)voidRunnable2);
    }

    public static void setState(final @NonNull Feature.State state) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                PoolProvider.postIOTaskWithCheck((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        1 this_ = this_.state;
                        if (this_ == null) {
                            InstabugSDKLogger.w((String)"IBG-BR", (String)"state object passed to BugReporting.setState() is null");
                            return;
                        }
                        BugReportingWrapper.setState((Feature.State)this_);
                    }
                });
            }
        };
        APIChecker.checkAndRunInExecutor((String)"BugReporting.setState", (VoidRunnable)voidRunnable2);
    }

    public static void setViewHierarchyState(final @NonNull Feature.State state) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                InstabugSDKLogger.d((String)"IBG-BR", (String)("setViewHierarchyState: " + state));
                InstabugCore.setFeatureState((String)"VIEW_HIERARCHY_V2", (Feature.State)state);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"BugReporting.setViewHierarchyState", (VoidRunnable)voidRunnable2);
    }

    public static void setDisclaimerText(final String string2) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                InstabugSDKLogger.d((String)"IBG-BR", (String)("setDisclaimerText: " + string2));
                BugReportingWrapper.setDisclaimerText(string2);
            }
        };
        APIChecker.checkAndRun((String)"BugReporting.setDisclaimerText", (VoidRunnable)voidRunnable2);
    }

    public static void setAttachmentTypesEnabled(final boolean bl, final boolean bl2, final boolean bl3, final boolean bl4) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                16 v0 = this;
                InstabugCore.setInitialScreenShotAllowed((boolean)v0.bl);
                16 v1 = this;
                boolean bl5 = v1.bl2;
                boolean bl22 = v1.bl3;
                boolean bl32 = v1.bl4;
                BugReportingWrapper.setAttachmentTypesEnabled(v0.bl, bl5, bl22, bl32);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"BugReporting.setAttachmentTypesEnabled", (VoidRunnable)voidRunnable2);
    }

    @RequiresApi(value=21)
    public static void setScreenshotByMediaProjectionEnabled(final boolean bl) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                InstabugSDKLogger.d((String)"IBG-BR", (String)("setScreenshotByMediaProjectionEnabled: " + bl));
                Context context = Instabug.getApplicationContext();
                if (context != null && bl && !MediaProjectionHelper.INSTANCE.isMediaProjectionServiceAvailable(context)) {
                    InstabugSDKLogger.e((String)"IBG-BR", (String)"Initial screenshot won't be displayed in your bug reports as FOREGROUND_SERVICE_MEDIA_PROJECTION permission is missing from the app's manifest file.");
                }
                SettingsManager.getInstance().setScreenshotByMediaProjectionEnabled(bl);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"BugReporting.setScreenshotByMediaProjectionEnabled", (VoidRunnable)voidRunnable2);
    }

    protected static void setScreenshotRequired(final boolean bl) {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                InstabugSDKLogger.d((String)"IBG-BR", (String)("setScreenshotRequired: " + bl));
                BugSettings.getInstance().setScreenshotRequired(bl);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"BugReporting.setScreenshotRequired", (VoidRunnable)voidRunnable2);
    }

    @Deprecated
    public static void setCommentMinimumCharacterCount(int n, int ... nArray) {
        APIChecker.checkAndRunInExecutor((String)"BugReporting.setCommentMinimumCharacterCount", () -> {
            if (n < 2) {
                InstabugSDKLogger.e((String)"IBG-BR", (String)"Description minimum limit can\u2019t be less than 2");
            } else {
                if (nArray.length <= 0) {
                    int[] nArray2 = new int[3];
                    nArray = nArray2;
                    nArray2[0] = 0;
                    nArray2[1] = 1;
                    nArray2[2] = 2;
                }
                BugReportingWrapper.setCommentMinimumCharacterCount(n, nArray);
            }
        });
    }

    public static void setCommentMinimumCharacterCountForBugReportType(int n, int ... nArray) {
        APIChecker.checkAndRunInExecutor((String)"BugReporting.setCommentMinimumCharacterCountForBugReportType", () -> {
            if (n < 2) {
                InstabugSDKLogger.e((String)"IBG-BR", (String)"Description minimum limit can\u2019t be less than 2");
            } else {
                if (nArray.length <= 0) {
                    int[] nArray2 = new int[4];
                    nArray = nArray2;
                    nArray2[0] = 0;
                    nArray2[1] = 1;
                    nArray2[2] = 2;
                    nArray2[3] = 3;
                }
                BugReportingWrapper.setCommentMinimumCharacterCount(n, nArray);
            }
        });
    }

    public static void getUsageExceeded(@NonNull OnUsageExceededReady onUsageExceededReady) {
        block2: {
            try {
                APIChecker.checkAndRunOrThrow((String)"BugReporting.getUsageExceeded", () -> PoolProvider.postMainThreadTaskWithoutCheck(() -> BugReporting.lambda$getUsageExceeded$5(onUsageExceededReady, ServiceLocator.getConfigurationsProvider().isBugReportingUsageExceeded())));
            }
            catch (Exception exception) {
                if (onUsageExceededReady == null) break block2;
                onUsageExceededReady.onReady(false);
            }
        }
    }

    private static void setWelcomeMessageState(@NonNull int n) {
        APIChecker.checkAndRunInExecutor((String)"Instabug.setWelcomeMessageState", () -> PoolProvider.postIOTaskWithCheck(() -> {
            BugSettings.getInstance().setWelcomeMessageState(n);
            InstabugSDKLogger.v((String)"IBG-Core", (String)("setWelcomeMessageState: " + n));
        }));
    }

    private static void showWelcomeMessage(@NonNull int n) {
        APIChecker.checkAndRunInExecutor((String)"Instabug.showWelcomeMessage", () -> BugReporting.lambda$showWelcomeMessage$9(new WelcomeMessageHelperApiImp(), n));
    }

    public static void addUserConsent(@Nullable String string2, @Nullable String string3, boolean bl, boolean bl2) {
        APIChecker.checkAndRunInExecutor((String)"BugReporting.addUserConsent", () -> BugReportingWrapper.addUserConsent(string2, string3, bl, bl2, null));
    }

    public static void addUserConsent(@Nullable String string2, @Nullable String string3, boolean bl, boolean bl2, @Nullable String string4) {
        APIChecker.checkAndRunInExecutor((String)"BugReporting.addUserConsent", () -> BugReportingWrapper.addUserConsent(string2, string3, bl, bl2, string4));
    }

    public static void setProactiveReportingConfigurations(ProactiveReportingConfigs proactiveReportingConfigs) {
        APIChecker.checkAndRunInExecutor((String)"BugReporting.setProactiveReportingConfigurations", () -> BugReportingWrapper.setProactiveReportingConfigurations(proactiveReportingConfigs));
    }

    @RequiresApi(value=18)
    public static void setVideoEncoderConfig(@NonNull VideoEncoderConfig videoEncoderConfig) {
        BugSettings.setVideoEncoderConfig(videoEncoderConfig);
    }

    private static /* synthetic */ void lambda$showWelcomeMessage$9(WelcomeMessageHelperApiContract welcomeMessageHelperApiContract, int n) {
        if (!InstabugCore.isForegroundBusy() && BugSettings.getInstance().isBugReportingStateEnabled()) {
            welcomeMessageHelperApiContract.showWelcomeMessage(n);
        }
    }

    private static /* synthetic */ void lambda$getUsageExceeded$5(OnUsageExceededReady onUsageExceededReady, boolean bl) {
        if (onUsageExceededReady != null) {
            onUsageExceededReady.onReady(bl);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ReportType {
        public static final int BUG = 0;
        public static final int FEEDBACK = 1;
        public static final int QUESTION = 2;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IBGBugReportingType {
        public static final int BUG = 0;
        public static final int FEEDBACK = 1;
        public static final int QUESTION = 2;
        public static final int FRUSTRATING_EXPERIENCE = 3;
    }
}

