package com.instabug.chat.network;

import com.instabug.chat.network.service.MessagingService;
import com.instabug.library.InstabugNetworkJob;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.networkv2.request.Request;

/**
 * Created by mohamednagy on 1/25/18.
 */

public class InstabugPushNotificationTokenJob extends InstabugNetworkJob {

    private static final String TAG = "InstabugPushNotificationTokenService";

    private static InstabugPushNotificationTokenJob INSTANCE;

    public synchronized static InstabugPushNotificationTokenJob getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstabugPushNotificationTokenJob();
        }

        return INSTANCE;
    }

    private InstabugPushNotificationTokenJob() {
    }

    @Override
    public synchronized void start() {
        enqueueJob(TAG, new Runnable() {
            @Override
            public void run() {
                sendPushNotificationToken();
            }
        });
    }

    private void sendPushNotificationToken() {
        if (InstabugCore.isPushNotificationTokenSent())
            return;
        String token = InstabugCore.getPushNotificationToken();
        MessagingService.getInstance().sendPushNotificationToken(token, new Request.Callbacks<Boolean, Throwable>() {
            @Override
            public void onSucceeded(Boolean response) {
                InstabugCore.setPushNotificationTokenSent(response);
            }

            @Override
            public void onFailed(Throwable error) {
                InstabugCore.setPushNotificationTokenSent(false);
            }
        });
    }
}
