package com.instabug.chat.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.ArrayList;

/**
 * @author mesbah
 */
public class FlatMessage {

    @Nullable
    private String body;
    @Nullable
    private String senderAvatarUrl;
    @Nullable
    private String url;
    @Nullable
    private String path;
    @Nullable
    private Type type;
    @Nullable
    private Mode mode;

    private long messagedAt;
    private boolean isInbound;
    @Nullable
    private ArrayList<MessageAction> messageActions;

    @Nullable
    public String getBody() {
        return body;
    }

    public FlatMessage setBody(@Nullable String body) {
        this.body = body;
        return this;
    }

    @Nullable
    public String getSenderAvatarUrl() {
        return senderAvatarUrl;
    }

    public FlatMessage setSenderAvatarUrl(@Nullable String senderAvatarUrl) {
        this.senderAvatarUrl = senderAvatarUrl;
        return this;
    }

    public long getMessagedAt() {
        return messagedAt;
    }

    public FlatMessage setMessagedAt(long messagedAt) {
        this.messagedAt = messagedAt;
        return this;
    }

    @Nullable
    public String getUrl() {
        return url;
    }

    public FlatMessage setUrl(@Nullable String url) {
        this.url = url;
        return this;
    }

    @Nullable
    public Type getType() {
        return type;
    }

    public FlatMessage setType(Type type) {
        this.type = type;
        return this;
    }

    @Nullable
    public Mode getMode() {
        return mode;
    }

    public FlatMessage setMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public boolean isInbound() {
        return isInbound;
    }

    public FlatMessage setInbound(boolean inbound) {
        isInbound = inbound;
        return this;
    }

    @Nullable
    public String getPath() {
        return path;
    }

    public FlatMessage setPath(@Nullable String path) {
        this.path = path;
        return this;
    }

    public boolean hasActions() {
        return this.messageActions != null && messageActions.size() > 0;
    }

    @Nullable
    public ArrayList<MessageAction> getMessageActions() {
        return messageActions;
    }

    public void setMessageActions(@Nullable ArrayList<MessageAction> messageActions) {
        this.messageActions = messageActions;
    }

    @Override
    @NonNull
    public String toString() {
        return "Body: " + getBody() + "URL: " + getUrl() + "has actions: " + hasActions() +
                "type: " + getType() + "actions: " + getMessageActions();
    }

    public enum Type {
        MESSAGE, IMAGE, AUDIO, VIDEO
    }

    public enum Mode {
        NONE, PLAYING
    }
}
