package com.instabug.bug.invocation.invocationdialog;

import android.net.Uri;

import com.instabug.library.core.ui.BaseContract;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.AnimRes;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

public interface InstabugDialogActivityContract {

    interface View extends BaseContract.View<AppCompatActivity> {

        List<InstabugDialogItem> getDialogItems();

        void onInitialScreenShotNotRequired();

        void setContent(String title, boolean shouldOverrideTitleContentDescription, ArrayList<InstabugDialogItem> items);

        @AnimRes
        int getSlidInLeftAnimation();

        @AnimRes
        int getSlidInRightAnimation();

        @AnimRes
        int getSlidOutLeftAnimation();

        @AnimRes
        int getSlidOutRightAnimation();

        @AnimRes
        int getFadeInAnimation();
    }

    interface Presenter extends BaseContract.Presenter {

        void onViewStarted();

        void onViewStopped();

        void onItemClicked(@Nullable InstabugDialogItem item, Uri screenshotUri);

        int getContentEnterAnimation();

        int getContentExitAnimation();

        void onBackPressed();

        void resetPromptOptionsSelection();

        boolean isPromptOptionSelected();
    }

    interface AnimationProvider {

        @AnimRes
        int getEnterAnimation();

        @AnimRes
        int getExitAnimation();
    }
}