package com.instabug.bug;

import android.content.Context;

import com.instabug.library.internal.orchestrator.Action;
import com.instabug.library.model.State;
import com.instabug.library.util.InstabugSDKLogger;

public class StateAction implements Action {
    private final Context context;

    public StateAction(Context context) {
        this.context = context;
    }

    @Override
    public void run() throws Exception {
        if (context == null)
            return;

        InstabugSDKLogger.v(Constants.LOG_TAG, "Start Building state");
        if (LiveBugManager.getInstance().getBug() != null) {
            LiveBugManager.getInstance().getBug().setState(State.getState(context));
        }
        InstabugSDKLogger.v(Constants.LOG_TAG, "State Building finished, sending event");
        StateCreatorEventBus.getInstance().post(State.Action.FINISHED);
    }
}
