package com.instabug.chat.annotation.recognition;


/**
 * Created by Tarek360 on 12/28/16.
 */
public class Weight implements Comparable<Weight> {

    int value;
    int angle;
    float probability;
    float averageProbability;
    float rectPaddingPercent;
    float pathNotConsumedPercent;
    float originalPathNotConsumedPercent;
    int leftWeight;
    int topWeight;
    int rightWeight;
    int bottomWeight;
    float pathLength;

    public enum DIRECTION {
        LEFT, TOP, RIGHT, BOTTOM
    }

    public DIRECTION getVerticalWeight() {
        if (bottomWeight > topWeight) {
            return Weight.DIRECTION.BOTTOM;
        } else {
            return Weight.DIRECTION.TOP;
        }
    }

    public DIRECTION getHorizontalWeight() {
        if (leftWeight > rightWeight) {
            return Weight.DIRECTION.LEFT;
        } else {
            return Weight.DIRECTION.RIGHT;
        }
    }

    @Override
    public int compareTo(Weight w) {

        if (w.value > this.value) {
            return -1;
        } else if (w.value < this.value) {
            return 1;
        } else {
            return 0;
        }
    }
}