package com.instabug.bug.di;

import android.content.ContentValues;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;

import com.instabug.bug.cache.BugReportsDbHelper;
import com.instabug.bug.cache.BugReportsDbHelperImpl;
import com.instabug.bug.cache.BugReportsDbMigrationHelper;
import com.instabug.bug.cache.BugReportsPlainDbHelperImpl;
import com.instabug.bug.configurations.BugReportingConfigurationsHandler;
import com.instabug.bug.configurations.BugReportingConfigurationsHandlerImpl;
import com.instabug.bug.configurations.BugReportingConfigurationsProvider;
import com.instabug.bug.configurations.BugReportingConfigurationsProviderImpl;
import com.instabug.bug.invocation.InvocationManager;
import com.instabug.bug.invocation.invoker.IBGRegistryScreenCaptureCallback;
import com.instabug.bug.invocation.invoker.ScreenshotCaptorRegistry;
import com.instabug.bug.invocation.invoker.ScreenshotCaptorRegistryImp;
import com.instabug.bug.proactivereporting.FrustratingExperienceEventsHandler;
import com.instabug.bug.proactivereporting.FrustratingExperienceEventsHandlerImpl;
import com.instabug.bug.proactivereporting.configs.ProactiveReportingConfigHandler;
import com.instabug.bug.proactivereporting.configs.ProactiveReportingConfigHandlerImpl;
import com.instabug.bug.proactivereporting.configs.ProactiveReportingConfigProvider;
import com.instabug.bug.proactivereporting.configs.ProactiveReportingConfigProviderImpl;
import com.instabug.bug.userConsent.ConsentsActionHandler;
import com.instabug.bug.userConsent.ConsentsActionHandlerImpl;
import com.instabug.bug.userConsent.ConsentsActionHandler;
import com.instabug.bug.userConsent.ConsentsActionHandlerImpl;
import com.instabug.bug.userConsent.UserConsentRepository;
import com.instabug.bug.userConsent.UserConsentRepositoryImpl;
import com.instabug.bug.userConsent.UserConsentValidatorImpl;
import com.instabug.bug.userConsent.UserConsentsManager;
import com.instabug.bug.userConsent.UserConsentsManagerImpl;
import com.instabug.bug.view.reporting.BaseReportingPresenter;
import com.instabug.bug.view.reporting.IBaseReportingView;
import com.instabug.bug.view.reporting.ReportingPresenterFactory;
import com.instabug.bug.view.reporting.ReportingPresenterFactoryImpl;
import com.instabug.library.BuildFieldsProvider;
import com.instabug.library.WatchableSpansCacheDirectory;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.storage.cache.dbv2.IBGContentValues;
import com.instabug.library.logscollection.DataWatcher;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.screenshot.analytics.ProductAnalyticsCollector;
import com.instabug.library.util.TaskDebouncer;
import com.instabug.library.visualusersteps.ReproCapturingProxy;


public class ServiceLocator {
    private static final long DEBOUNCED_TIMEOUT_MILLIS = 3000;
    private static BugReportsDbHelper<IBGContentValues> bugReportsDbHelper;
    private static BugReportsDbHelper<ContentValues> bugReportsPlainDbHelper;
    private static BugReportsDbMigrationHelper bugReportsDbMigrationHelper;
    private static UserConsentRepository userConsentRepository;
    private static ReportingPresenterFactory reportingPresenterFactory;
    private static ProductAnalyticsCollector bugsProductAnalyticsCollector;

    private static UserConsentsManager userConsentsManager;

    private static FrustratingExperienceEventsHandler frustratingExperienceEventsHandler;

    @Nullable
    private static ScreenshotCaptorRegistry screenshotCaptorRegistry;

    public static BugReportsDbMigrationHelper getBugReportsDbMigrationHelper() {
        if (bugReportsDbMigrationHelper == null) {
            bugReportsDbMigrationHelper = new BugReportsDbMigrationHelper();
        }
        return bugReportsDbMigrationHelper;
    }

    /**
     * Get an instance of the <b>ENCRYPTED</b> database helper class
     */
    public static BugReportsDbHelper<IBGContentValues> getBugReportsDbHelper() {
        if (bugReportsDbHelper == null) {
            bugReportsDbHelper = new BugReportsDbHelperImpl();
        }
        return bugReportsDbHelper;
    }

    /**
     * Get an instance of the <b>UNENCRYPTED</b> database helper class
     */
    public static BugReportsDbHelper<ContentValues> getBugReportsPlainDbHelper() {
        if (bugReportsPlainDbHelper == null) {
            bugReportsPlainDbHelper = new BugReportsPlainDbHelperImpl();
        }
        return bugReportsPlainDbHelper;
    }

    public static BugReportingConfigurationsHandler getConfigurationsHandler() {
        return BugReportingConfigurationsHandlerImpl.INSTANCE;
    }

    public static BugReportingConfigurationsProvider getConfigurationsProvider() {
        return BugReportingConfigurationsProviderImpl.INSTANCE;
    }

    public static ReproCapturingProxy getReproProxy() {
        return CoreServiceLocator.getReproCompositeProxy();
    }

    public static WatchableSpansCacheDirectory getReproScreenshotsCacheDir() {
        return CoreServiceLocator.getReproScreenshotsCacheDir();
    }



    public static ProductAnalyticsCollector getBugsProductAnalyticsCollector() {
        if (bugsProductAnalyticsCollector == null) {
            bugsProductAnalyticsCollector = new ProductAnalyticsCollector(CoreServiceLocator.getCommonAnalyticsCollector(), getConfigurationsProvider());
        }
        return bugsProductAnalyticsCollector;
    }


    @NonNull
    @VisibleForTesting
    public static UserConsentRepository getUserConsentRepository() {
        if (userConsentRepository == null) {
            userConsentRepository = new UserConsentRepositoryImpl(
                    getConfigurationsProvider()
            );
        }
        return userConsentRepository;
    }

    @NonNull
    public static UserConsentsManager getUserConsentsManager() {
        if (userConsentsManager == null) {
            userConsentsManager = new UserConsentsManagerImpl(
                    getUserConsentRepository(),
                    new UserConsentValidatorImpl(getConfigurationsProvider()),
                    getConfigurationsProvider()
            );
        }

        return userConsentsManager;
    }

    @Nullable
    public static BaseReportingPresenter getReportingPresenter(IBaseReportingView.View view) {
        return getReportingPresenterFactory().create(view);
    }

    private static ReportingPresenterFactory getReportingPresenterFactory() {
        if (reportingPresenterFactory == null)
            reportingPresenterFactory = new ReportingPresenterFactoryImpl(getUserConsentsManager());
        return reportingPresenterFactory;
    }

    @NonNull
    public static NetworkManager getNetworkManager() {
        return new NetworkManager();
    }

    @NonNull
    public static TaskDebouncer getTaskDebouncer() {
        return new TaskDebouncer(DEBOUNCED_TIMEOUT_MILLIS);
    }

    public static DataWatcher getHubDataWatcher() {
        return CoreServiceLocator.getHubDataWatcher();
    }

    @Nullable
    public static ScreenshotCaptorRegistry getScreenshotCaptorRegistry() {
        if (screenshotCaptorRegistry == null && BuildFieldsProvider.INSTANCE.isAtleastVersion34OrAbove() && InvocationManager.getInstance().isInvocationEventScreenShot()) {
            screenshotCaptorRegistry = new ScreenshotCaptorRegistryImp(new IBGRegistryScreenCaptureCallback(InvocationManager.getInstance()));
        }

        return screenshotCaptorRegistry;
    }

    public static ConsentsActionHandler getConsentsActionHandler() {
        return new ConsentsActionHandlerImpl();
    }

    public static ProactiveReportingConfigHandler getProactiveReportingConfigHandler() {
        return ProactiveReportingConfigHandlerImpl.INSTANCE;
    }

    public static ProactiveReportingConfigProvider getProactiveReportingConfigProvider() {
        return ProactiveReportingConfigProviderImpl.INSTANCE;
    }

    public static FrustratingExperienceEventsHandler getFrustratingExperienceEventsHandler() {
        if (frustratingExperienceEventsHandler == null) {
            frustratingExperienceEventsHandler = new FrustratingExperienceEventsHandlerImpl(getProactiveReportingConfigProvider());
        }
        return frustratingExperienceEventsHandler;
    }
}
