/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug;

import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.bug.f;
import com.instabug.bug.internal.video.ScreenRecordingService;
import com.instabug.bug.invocation.b;
import com.instabug.bug.network.d;
import com.instabug.bug.utils.c;
import com.instabug.bug.view.actionList.service.a;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventSubscriber;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.eventbus.eventpublisher.IBGCompositeDisposable;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.frustratingexperience.FrustratingExperienceEvent;
import com.instabug.library.frustratingexperience.FrustratingExperienceEventBus;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.video.ScreenRecordingServiceData;
import com.instabug.library.internal.video.ScreenRecordingServiceEventBus;
import com.instabug.library.invocation.InvocationManagerContract;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tokenmapping.MappedTokenChangedEventBus;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.visualusersteps.ReproConfigurationsProvider;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Locale;

public class BugPlugin
extends Plugin {
    public static final String SCREEN_RECORDING_EVENT_NAME = "SendDataToRecordingService";
    @Nullable
    private IBGCompositeDisposable disposables;
    @Nullable
    @VisibleForTesting
    IBGDisposable mappedTokenChangedDisposable;

    private void initInvocationManager() {
        CoreServiceLocator.setInvocationManagerContract((InvocationManagerContract)b.g());
        b.g().d().a(InstabugFloatingButtonEdge.RIGHT);
        b.g().notifyPrimaryColorChanged();
        b.g().b(InstabugCore.getInvocationEvents());
    }

    private void subscribeOnCoreEvents() {
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            this.getOrCreateCompositeDisposables().add(this.subscribeToCoreEvents());
        }
    }

    @NonNull
    private IBGDisposable subscribeToCoreEvents() {
        return IBGCoreEventSubscriber.subscribe(iBGSdkCoreEvent -> {
            WeakReference weakReference = ((Plugin)weakReference).contextWeakReference;
            if (weakReference != null) {
                com.instabug.bug.b.a((Context)weakReference.get(), iBGSdkCoreEvent);
            }
        });
    }

    private void subscribeOnMappedTokenChangedEvent() {
        if (this.mappedTokenChangedDisposable == null) {
            this.mappedTokenChangedDisposable = MappedTokenChangedEventBus.INSTANCE.subscribe(bl -> {
                a.b().d();
                a.b().start();
            });
        }
    }

    private void subscribeOnFrustratingExperienceEventBus() {
        this.getOrCreateCompositeDisposables().add(FrustratingExperienceEventBus.INSTANCE.subscribe(frustratingExperienceEvent -> com.instabug.bug.di.a.h().a((FrustratingExperienceEvent)frustratingExperienceEvent)));
    }

    private void unsubscribeFromMappedTokenChangedEvents() {
        IBGDisposable iBGDisposable = this.mappedTokenChangedDisposable;
        if (iBGDisposable != null) {
            iBGDisposable.dispose();
            this.mappedTokenChangedDisposable = null;
        }
    }

    private void loadAndApplyCachedReproConfigurations() {
        SettingsManager settingsManager = SettingsManager.getInstance();
        if (settingsManager != null) {
            settingsManager = settingsManager.getReproConfigurations();
            WeakReference weakReference = ((Plugin)weakReference).contextWeakReference;
            if (settingsManager != null && weakReference != null) {
                com.instabug.bug.b.a((Context)weakReference.get(), (IBGSdkCoreEvent)new IBGSdkCoreEvent.ReproState(settingsManager.getModesMap()));
            }
        }
    }

    private void unSubscribeFromEvents() {
        BugPlugin bugPlugin = bugPlugin.disposables;
        if (bugPlugin != null) {
            bugPlugin.dispose();
        }
    }

    private IBGCompositeDisposable getOrCreateCompositeDisposables() {
        IBGCompositeDisposable iBGCompositeDisposable = this.disposables;
        if (iBGCompositeDisposable == null) {
            IBGCompositeDisposable iBGCompositeDisposable2;
            iBGCompositeDisposable = iBGCompositeDisposable2;
            iBGCompositeDisposable2 = new IBGCompositeDisposable();
            this.disposables = iBGCompositeDisposable;
        }
        return iBGCompositeDisposable;
    }

    public void init(Context context) {
        Context context2 = context;
        this.initInvocationManager();
        com.instabug.bug.di.a.f().b();
        com.instabug.bug.di.a.n().evaluate((ReproConfigurationsProvider)com.instabug.bug.di.a.f());
        com.instabug.bug.di.a.o().addWatcher(4);
        com.instabug.bug.di.a.i().addWatcher(4);
        c.c(context2);
        super.init(context2);
    }

    public void wake() {
        com.instabug.bug.di.a.o().consentOnCleansing(4);
        com.instabug.bug.di.a.i().consentOnCleansing(4);
    }

    public void sleep() {
    }

    public void initDefaultPromptOptionAvailabilityState() {
        f.c();
    }

    public ArrayList<PluginPromptOption> getPromptOptions() {
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            return f.a((Context)this.contextWeakReference.get());
        }
        return new ArrayList<PluginPromptOption>();
    }

    @Nullable
    public ArrayList<PluginPromptOption> getPluginOptions(boolean bl) {
        InstabugSDKLogger.d((String)"IBG-BR", (String)"[BugPlugin#getPluginOptions] Getting plugin options");
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            return f.a(bl, (Context)this.contextWeakReference.get());
        }
        InstabugSDKLogger.d((String)"IBG-BR", (String)"[BugPlugin#getPluginOptions] No options, returning null");
        return null;
    }

    public boolean isFeatureEnabled() {
        return InstabugCore.isFeatureEnabled((String)"BUG_REPORTING");
    }

    public void stop() {
        BugPlugin bugPlugin = this;
        f.g();
        bugPlugin.unSubscribeFromEvents();
        bugPlugin.unsubscribeFromMappedTokenChangedEvents();
        b.g().p();
        ScreenRecordingServiceEventBus.unregisterHandler((String)SCREEN_RECORDING_EVENT_NAME);
        com.instabug.bug.b.h();
    }

    public void start(Context context) {
        if (Instabug.isEnabled() && com.instabug.bug.settings.b.h().q() && com.instabug.bug.settings.b.h().o() != 2) {
            new com.instabug.bug.onboardingbugreporting.utils.b().a();
        }
        BugPlugin bugPlugin = this;
        this.loadAndApplyCachedReproConfigurations();
        f.b(context);
        bugPlugin.subscribeOnCoreEvents();
        bugPlugin.subscribeOnMappedTokenChangedEvent();
        com.instabug.bug.network.c.f().start();
        d.f().start();
        b.g().m();
        bugPlugin.retrieveIntentFromPermissionsActivity();
        bugPlugin.subscribeOnFrustratingExperienceEventBus();
        com.instabug.bug.b.g();
    }

    public void retrieveIntentFromPermissionsActivity() {
        ScreenRecordingServiceEventBus.registerHandler((String)SCREEN_RECORDING_EVENT_NAME, screenRecordingServiceData -> {
            Context context = screenRecordingServiceData.getContext();
            if (context != null && screenRecordingServiceData.getResultOk() != null && screenRecordingServiceData.isSent() != null && screenRecordingServiceData.getMediaProjectionIntent() != null) {
                ScreenRecordingServiceData screenRecordingServiceData2 = screenRecordingServiceData;
                int n2 = screenRecordingServiceData2.getResultOk();
                Intent intent = screenRecordingServiceData2.getMediaProjectionIntent();
                ScreenRecordingService.a(context, ScreenRecordingService.a(screenRecordingServiceData.getContext(), n2, intent, screenRecordingServiceData.isSent()));
            }
        });
    }

    public long getLastActivityTime() {
        return com.instabug.bug.settings.b.h().i();
    }

    public void onLocaleChanged(Locale locale, Locale locale2) {
        super.onLocaleChanged(locale, locale2);
        a.b().start();
    }
}

