package com.instabug.bug.view.visualusersteps.steppreview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;

import androidx.annotation.Nullable;


import com.instabug.bug.R;
import com.instabug.bug.view.BugReportingActivityCallback;
import com.instabug.bug.view.reporting.ReportingContainerActivity;
import com.instabug.library.core.ui.InstabugBaseFragment;

/**
 * Created by Barakat on 12/05/2019
 */
@SuppressLint("ERADICATE_FIELD_NOT_INITIALIZED")
public class VisualUserStepPreviewFragment extends InstabugBaseFragment<VisualUserStepPreviewPresenter>
        implements View.OnClickListener, VisualUserStepPreviewContract.View {
    public static final String TAG = "visual_user_step_preview";


    @Nullable
    private BugReportingActivityCallback activityCallback;
    @Nullable
    private String currentTitle;
    private ImageView imageView;
    private ProgressBar progressBar;
    @Nullable
    private VisualUserStepArgs args;

    public static VisualUserStepPreviewFragment newInstance(VisualUserStepArgs args) {
        VisualUserStepPreviewFragment fragment = new VisualUserStepPreviewFragment();
        fragment.setArguments(args.toBundle());
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);
        presenter = new VisualUserStepPreviewPresenter(this);
        if (getArguments() != null) {
            args = VisualUserStepArgs.argsFromBundle(getArguments());
        }
        if (activityCallback != null) {
            currentTitle = activityCallback.getToolbarTitle();
            if (args != null) {
                activityCallback.setToolbarTitle(args.getTitle());
            }
            activityCallback.setToolbarUpIconBack();
        }
    }

    @Override
    protected int getLayout() {
        return R.layout.ibg_bug_fragment_repro_step_preview;
    }

    @Override
    protected void initViews(View rootView, @Nullable Bundle savedInstanceState) {
        if (getActivity() instanceof ReportingContainerActivity) {
            ((ReportingContainerActivity) getActivity()).setToolbarNavigationContentDescription(R.string.feature_request_go_back);

        }
        rootView.setOnClickListener(this);
        imageView = findViewById(R.id.step_preview);
        progressBar = findViewById(R.id.step_preview_prgressbar);
        VisualUserStepPreviewPresenter presenter = this.presenter;
        if (imageView != null) {
            imageView.setVisibility(View.INVISIBLE);
            if (args != null)
                imageView.setContentDescription(args.getScreenName().replace("Image", ""));
        }
        if (args != null && presenter != null) {
            String path = args.getScreenShotUri();
            presenter.loadPreviewBitmap(path);

        }
        this.presenter = presenter;
    }

    @Override
    public void onResume() {
        super.onResume();
        requestImageFocus();
    }

    private void requestImageFocus() {
        if (imageView != null) imageView.requestFocus();
    }


    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (getActivity() instanceof BugReportingActivityCallback) {
            try {
                activityCallback = (BugReportingActivityCallback) getActivity();
            } catch (Exception e) {
                throw new RuntimeException("Must implement BugReportingActivityCallBack");
            }
        }
    }

    @Override
    public void onDestroy() {
        if (activityCallback != null) {
            if (presenter != null) {
                presenter.release();
            }
            if (currentTitle != null) {
                activityCallback.setToolbarTitle(currentTitle);
            }
        }
        super.onDestroy();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == android.R.id.home) {
            if (getActivity() != null) {
                getActivity().onBackPressed();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onClick(View v) {

    }

    @Override
    public void toggleProgress(boolean show) {
        progressBar.setVisibility(show ? View.VISIBLE : View.INVISIBLE);
    }

    @Override
    public void onBitmapLoaded(Bitmap bitmap) {
        imageView.setVisibility(View.VISIBLE);
        imageView.setImageBitmap(bitmap);
        imageView.requestFocusFromTouch();
    }

    @Override
    public void close() {
        if (getActivity() != null) {
            getActivity().onBackPressed();
        }
    }
}
