package com.instabug.bug.view.floatingactionbutton;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.Style;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.view.Gravity;

import androidx.annotation.Nullable;

import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.view.IconViewUtils;


public class MuteFloatingActionButton extends FloatingActionButton {

    private boolean enable;

    public MuteFloatingActionButton(Context context) {
        this(context, null);
    }

    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public MuteFloatingActionButton(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public MuteFloatingActionButton(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    void init(Context context, @Nullable AttributeSet attributeSet) {
        super.init(context, attributeSet);
        setSize(SIZE_MINI);
        setId(R.id.instabug_video_mute_button);
        setNextFocusForwardId(R.id.instabug_video_stop_button);
        //set mic icon
        setText(IconViewUtils.getIconUnicode(1));
        setGravity(Gravity.CENTER);
        disable();
    }

    @Override
    public int getButtonContentDescription() {
        return enable ? R.string.ibg_screen_recording_unmute_btn_content_description :
                R.string.ibg_screen_recording_mute_btn_content_description;
    }

    @Override
    Drawable getIconDrawable() {

        final float iconSize = getDimension(R.dimen.instabug_fab_icon_size_mini);
        final float fabSize = getDimension(R.dimen.instabug_fab_size_mini);

        final float iconHalfSize = iconSize / 2f;

        final float strokeWidth = getDimension(R.dimen.instabug_fab_circle_icon_stroke);

        //final float iconOffset = (iconSize - stopSize) / 2f;

        final Shape shape = new Shape() {
            @Override
            public void draw(Canvas canvas, Paint paint) {

                if (enable) {
                    paint.setColor(Color.RED);
                    paint.setStyle(Style.FILL_AND_STROKE);
                    paint.setStrokeWidth(strokeWidth);
                    canvas.drawCircle(iconHalfSize, iconHalfSize, fabSize / 2, paint);
                } else {
                    paint.setColor(Color.BLACK);
                    paint.setStrokeWidth(strokeWidth);
                    paint.setStyle(Style.STROKE);
                    canvas.drawCircle(iconHalfSize, iconHalfSize, fabSize / 2, paint);

                    paint.setColor(Color.BLACK);
                    paint.setStrokeWidth(strokeWidth);
                    canvas.drawLine(0, strokeWidth, iconSize, iconSize + strokeWidth, paint);
                }
            }
        };

        ShapeDrawable drawable = new ShapeDrawable(shape);

        final Paint paint = drawable.getPaint();
        paint.setAntiAlias(true);

        return drawable;
    }

    public boolean toggle() {
        if (enable) {
            disable();
        } else {
            enable();
        }
        return enable;
    }

    public void enable() {
        enable = true;
        updateBackground();
        setTextColor(Color.WHITE);
        setContentDescription(
                LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(getContext()),
                        R.string.ibg_screen_recording_mute_btn_content_description, getContext()));
    }

    public void disable() {
        enable = false;
        updateBackground();
        setTextColor(Color.BLACK);
        setContentDescription(
                LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(getContext()),
                        R.string.ibg_screen_recording_unmute_btn_content_description, getContext()));
    }
}
